/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.stubindex.IndexUtilsKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFilePartClassIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileStubForIde;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinMultifileClassPartIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyNothingFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyNothingPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinScriptFqnIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSuperClassIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.util.TypeIndexUtilKt;

public class IdeStubIndexService
extends StubIndexService {
    @Override
    public void indexFile(KotlinFileStub stub, IndexSink sink) {
        List<StringRef> partNames;
        FqName partFqName;
        FqName packageFqName = stub.getPackageFqName();
        sink.occurrence(KotlinExactPackagesIndex.getInstance().getKey(), (Object)packageFqName.asString());
        if (stub.isScript()) {
            return;
        }
        FqName facadeFqName = ((KotlinFileStubForIde)stub).getFacadeFqName();
        if (facadeFqName != null) {
            sink.occurrence(KotlinFileFacadeFqNameIndex.INSTANCE.getKey(), (Object)facadeFqName.asString());
            sink.occurrence(KotlinFileFacadeShortNameIndex.INSTANCE.getKey(), (Object)facadeFqName.shortName().asString());
            sink.occurrence(KotlinFileFacadeClassByPackageIndex.INSTANCE.getKey(), (Object)packageFqName.asString());
        }
        if ((partFqName = ((KotlinFileStubForIde)stub).getPartFqName()) != null) {
            sink.occurrence(KotlinFilePartClassIndex.INSTANCE.getKey(), (Object)partFqName.asString());
        }
        if ((partNames = ((KotlinFileStubForIde)stub).getFacadePartSimpleNames()) != null) {
            for (StringRef partName : partNames) {
                String partSimpleName = StringRef.toString((StringRef)partName);
                if (partSimpleName == null) continue;
                FqName multifileClassPartFqName = packageFqName.child(Name.identifier(partSimpleName));
                sink.occurrence(KotlinMultifileClassPartIndex.INSTANCE.getKey(), (Object)multifileClassPartFqName.asString());
            }
        }
    }

    @Override
    public void indexClass(KotlinClassStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(KotlinClassShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        if ((fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (stub.isTopLevel()) {
                sink.occurrence(KotlinTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
        if (stub.isInterface()) {
            sink.occurrence(KotlinClassShortNameIndex.getInstance().getKey(), (Object)"DefaultImpls");
        }
        IdeStubIndexService.indexSuperNames(stub, sink);
    }

    @Override
    public void indexObject(KotlinObjectStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(KotlinClassShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        if ((fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (stub.isTopLevel()) {
                sink.occurrence(KotlinTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
        IdeStubIndexService.indexSuperNames(stub, sink);
    }

    private static void indexSuperNames(KotlinClassOrObjectStub<? extends KtClassOrObject> stub, IndexSink sink) {
        for (String superName : stub.getSuperNames()) {
            sink.occurrence(KotlinSuperClassIndex.getInstance().getKey(), (Object)superName);
        }
        if (!(stub instanceof KotlinClassStub)) {
            return;
        }
        KotlinModifierListStub modifierListStub = IdeStubIndexService.getModifierListStub(stub);
        if (modifierListStub == null) {
            return;
        }
        if (modifierListStub.hasModifier(KtTokens.ENUM_KEYWORD)) {
            sink.occurrence(KotlinSuperClassIndex.getInstance().getKey(), (Object)Enum.class.getSimpleName());
        }
        if (modifierListStub.hasModifier(KtTokens.ANNOTATION_KEYWORD)) {
            sink.occurrence(KotlinSuperClassIndex.getInstance().getKey(), (Object)Annotation.class.getSimpleName());
        }
    }

    @Nullable
    private static KotlinModifierListStub getModifierListStub(@NotNull KotlinClassOrObjectStub<? extends KtClassOrObject> stub) {
        StubElement childStub = stub.findChildStubByType(KtStubElementTypes.MODIFIER_LIST);
        if (!(childStub instanceof KotlinModifierListStub)) {
            return null;
        }
        return (KotlinModifierListStub)childStub;
    }

    @Override
    public void indexFunction(KotlinFunctionStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(KotlinFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            if (TypeIndexUtilKt.isProbablyNothing(((KtNamedFunction)stub.getPsi()).getTypeReference())) {
                sink.occurrence(KotlinProbablyNothingFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelFunctionFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelFunctionByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            IndexUtilsKt.indexTopLevelExtension(stub, sink);
        }
        IndexUtilsKt.indexInternals(stub, sink);
    }

    @Override
    public void indexTypeAlias(KotlinTypeAliasStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(KotlinTypeAliasShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        IndexUtilsKt.indexTypeAliasExpansion(stub, sink);
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelTypeAliasFqNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelTypeAliasByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
        }
    }

    @Override
    public void indexProperty(KotlinPropertyStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(KotlinPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            if (TypeIndexUtilKt.isProbablyNothing(((KtProperty)stub.getPsi()).getTypeReference())) {
                sink.occurrence(KotlinProbablyNothingPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelPropertyFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelPropertyByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            IndexUtilsKt.indexTopLevelExtension(stub, sink);
        }
        IndexUtilsKt.indexInternals(stub, sink);
    }

    @Override
    public void indexParameter(@NotNull KotlinParameterStub stub, @NotNull IndexSink sink) {
        String name2 = stub.getName();
        if (name2 != null && stub.hasValOrVar()) {
            sink.occurrence(KotlinPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
        }
    }

    @Override
    public void indexAnnotation(KotlinAnnotationEntryStub stub, IndexSink sink) {
        sink.occurrence(KotlinAnnotationsIndex.getInstance().getKey(), (Object)stub.getShortName());
        KotlinFileStub fileStub = IdeStubIndexService.getContainingFileStub(stub);
        if (fileStub != null) {
            List<KotlinImportDirectiveStub> aliasImportStubs = fileStub.findImportsByAlias(stub.getShortName());
            for (KotlinImportDirectiveStub importStub : aliasImportStubs) {
                sink.occurrence(KotlinAnnotationsIndex.getInstance().getKey(), (Object)importStub.getImportedFqName().shortName().asString());
            }
        }
    }

    private static KotlinFileStub getContainingFileStub(StubElement stub) {
        for (StubElement parent2 = stub.getParentStub(); parent2 != null; parent2 = parent2.getParentStub()) {
            if (!(parent2 instanceof KotlinFileStub)) continue;
            return (KotlinFileStub)parent2;
        }
        return null;
    }

    @Override
    public void indexScript(@NotNull KotlinScriptStub stub, @NotNull IndexSink sink) {
        sink.occurrence(KotlinScriptFqnIndex.getInstance().getKey(), (Object)stub.getFqName().asString());
    }

    @Override
    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file2) {
        StringRef packageFqName = StringRef.fromString((String)file2.getPackageFqNameByTree().asString());
        boolean isScript = file2.isScriptByTree();
        if (file2.hasTopLevelCallables()) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(file2);
            StringRef facadeSimpleName = StringRef.fromString((String)fileClassInfo.getFacadeClassFqName().shortName().asString());
            StringRef partSimpleName = StringRef.fromString((String)fileClassInfo.getFileClassFqName().shortName().asString());
            return new KotlinFileStubForIde(file2, packageFqName, isScript, facadeSimpleName, partSimpleName, null);
        }
        return new KotlinFileStubForIde(file2, packageFqName, isScript, null, null, null);
    }

    @Override
    public void serializeFileStub(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        KotlinFileStubForIde fileStub = (KotlinFileStubForIde)stub;
        dataStream.writeName(fileStub.getPackageFqName().asString());
        dataStream.writeBoolean(fileStub.isScript());
        dataStream.writeName(StringRef.toString((StringRef)fileStub.getFacadeSimpleName()));
        dataStream.writeName(StringRef.toString((StringRef)fileStub.getPartSimpleName()));
        List<StringRef> facadePartNames = fileStub.getFacadePartSimpleNames();
        if (facadePartNames == null) {
            dataStream.writeInt(0);
        } else {
            dataStream.writeInt(facadePartNames.size());
            for (StringRef partName : facadePartNames) {
                dataStream.writeName(StringRef.toString((StringRef)partName));
            }
        }
    }

    @Override
    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        StringRef packageFqNameAsString = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        StringRef facadeSimpleName = dataStream.readName();
        StringRef partSimpleName = dataStream.readName();
        int numPartNames = dataStream.readInt();
        ArrayList<StringRef> facadePartNames = new ArrayList<StringRef>();
        for (int i = 0; i < numPartNames; ++i) {
            StringRef partNameRef = dataStream.readName();
            facadePartNames.add(partNameRef);
        }
        return new KotlinFileStubForIde(null, packageFqNameAsString, isScript, facadeSimpleName, partSimpleName, facadePartNames);
    }
}

