/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverrideAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasActualMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinOverridingDialog;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinSafeDeleteOverrideAnnotation;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinSafeDeleteOverridingUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinSafeDeleteProcessor;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.SafeDeleteImportDirectiveUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.SafeDeleteSuperTypeUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.SafeDeleteTypeArgumentListUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.SafeDeleteValueArgumentListUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.UtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchParameters;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.NotNullableUserDataProperty;
import org.jetbrains.kotlin.psi.UserDataProperty;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nJ3\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J-\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\tH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/safeDelete/KotlinSafeDeleteProcessor;", "Lcom/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor;", "()V", "findConflicts", "", "", "element", "Lcom/intellij/psi/PsiElement;", "allElementsToDelete", "", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiElement;)Ljava/util/Collection;", "findUsages", "Lcom/intellij/refactoring/safeDelete/NonCodeUsageSearchInfo;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiElement;Ljava/util/List;)Lcom/intellij/refactoring/safeDelete/NonCodeUsageSearchInfo;", "getElementsToSearch", "", "module", "Lcom/intellij/openapi/module/Module;", "handlesElement", "", "prepareForDeletion", "", "preprocessUsages", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/usageView/UsageInfo;)[Lcom/intellij/usageView/UsageInfo;", "shouldAllowPropagationToExpected", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Companion", "idea"})
public final class KotlinSafeDeleteProcessor
extends JavaSafeDeleteProcessor {
    private static final NotNullableUserDataProperty ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$delegate;
    private static final UserDataProperty dropActualModifier$delegate;
    public static final Companion Companion;

    public boolean handlesElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return UtilsKt.canDeleteElement(element3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element3, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> usages2) {
        KtLightClass ktLightClass;
        KtLightClass ktLightClass2;
        Function1<PsiElement, NonCodeUsageSearchInfo> getSearchInfo$;
        block22: {
            PsiElement psiElement2;
            Function1<KtTypeParameter, Unit> findTypeParameterUsages$;
            Function1<KtDeclaration, NonCodeUsageSearchInfo> findUsagesByJavaProcessor$;
            Function2<PsiElement, Boolean, NonCodeUsageSearchInfo> findUsagesByJavaProcessor$2;
            Function1<KtDeclaration, NonCodeUsageSearchInfo> findKotlinDeclarationUsages$;
            block23: {
                block24: {
                    KtLightClass ktLightClass3;
                    Function1<PsiElement, Unit> findDelegationCallUsages$;
                    block20: {
                        block21: {
                            KtLightClass ktLightClass4;
                            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                            Intrinsics.checkParameterIsNotNull((Object)allElementsToDelete, (String)"allElementsToDelete");
                            Intrinsics.checkParameterIsNotNull(usages2, (String)"usages");
                            SmartSet deleteSet = SmartSet.Companion.create();
                            CollectionsKt.addAll((Collection)deleteSet, (Object[])allElementsToDelete);
                            Function0<Condition<PsiElement>> getIgnoranceCondition$ = new Function0<Condition<PsiElement>>(deleteSet){
                                final /* synthetic */ SmartSet $deleteSet;

                                @NotNull
                                public final Condition<PsiElement> invoke() {
                                    return (Condition)new Condition<PsiElement>(this){
                                        final /* synthetic */ findUsages.1 this$0;

                                        public final boolean value(PsiElement it) {
                                            boolean bl;
                                            block4: {
                                                if (it instanceof KtFile) {
                                                    return false;
                                                }
                                                Iterable $receiver$iv = this.this$0.$deleteSet;
                                                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                                    bl = false;
                                                } else {
                                                    for (T element$iv : $receiver$iv) {
                                                        PsiElement element3;
                                                        PsiElement psiElement2 = element3 = (PsiElement)element$iv;
                                                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
                                                        if (!JavaSafeDeleteProcessor.isInside((PsiElement)it, (PsiElement)LightClassUtilsKt.getUnwrapped(psiElement2))) continue;
                                                        bl = true;
                                                        break block4;
                                                    }
                                                    bl = false;
                                                }
                                            }
                                            return bl;
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    };
                                }
                                {
                                    this.$deleteSet = smartSet;
                                    super(0);
                                }
                            };
                            getSearchInfo$ = new Function1<PsiElement, NonCodeUsageSearchInfo>(getIgnoranceCondition$){
                                final /* synthetic */ findUsages.1 $getIgnoranceCondition;

                                @NotNull
                                public final NonCodeUsageSearchInfo invoke(@NotNull PsiElement element3) {
                                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                    return new NonCodeUsageSearchInfo(this.$getIgnoranceCondition.invoke(), element3);
                                }
                                {
                                    this.$getIgnoranceCondition = var1_1;
                                    super(1);
                                }
                            };
                            Function1<KtDeclaration, Sequence<? extends PsiReference>> searchKotlinDeclarationReferences$ = new Function1<KtDeclaration, Sequence<? extends PsiReference>>(getIgnoranceCondition$){
                                final /* synthetic */ findUsages.1 $getIgnoranceCondition;

                                @NotNull
                                public final Sequence<PsiReference> invoke(@NotNull KtDeclaration declaration2) {
                                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                    List elementsToSearch = declaration2 instanceof KtParameter ? KotlinRefactoringUtilKt.withExpectedActuals(declaration2) : CollectionsKt.listOf((Object)declaration2);
                                    return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)elementsToSearch), (Function1)((Function1)new Function1<KtDeclaration, Sequence<? extends PsiReference>>(this){
                                        final /* synthetic */ findUsages.3 this$0;

                                        @NotNull
                                        public final Sequence<PsiReference> invoke(@NotNull KtDeclaration it) {
                                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                            PsiElement psiElement2 = it;
                                            SearchScope searchScope2 = it.getUseScope();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"it.useScope");
                                            KotlinReferencesSearchParameters searchParameters = new KotlinReferencesSearchParameters(psiElement2, searchScope2, false, null, new KotlinReferencesSearchOptions(true, false, false, false, false, false, false, 126, null), 12, null);
                                            Query query = ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(searchParameters)");
                                            return SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)query)), (Function1)((Function1)new Function1<PsiReference, Boolean>(this){
                                                final /* synthetic */ findUsages.1 this$0;

                                                public final boolean invoke(PsiReference reference2) {
                                                    Condition<PsiElement> condition2 = this.this$0.this$0.$getIgnoranceCondition.invoke();
                                                    PsiReference psiReference = reference2;
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"reference");
                                                    return condition2.value((Object)psiReference.getElement());
                                                }
                                                {
                                                    this.this$0 = var1_1;
                                                    super(1);
                                                }
                                            }));
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(1);
                                        }
                                    }));
                                }
                                {
                                    this.$getIgnoranceCondition = var1_1;
                                    super(1);
                                }
                            };
                            Function1<KtParameter, Unit> findKotlinParameterUsages$ = new Function1<KtParameter, Unit>(searchKotlinDeclarationReferences$, usages2){
                                final /* synthetic */ findUsages.3 $searchKotlinDeclarationReferences;
                                final /* synthetic */ List $usages;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull KtParameter parameter) {
                                    Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                                    KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
                                    if (!(ktDeclarationWithBody instanceof KtFunction)) {
                                        ktDeclarationWithBody = null;
                                    }
                                    KtFunction ktFunction = (KtFunction)ktDeclarationWithBody;
                                    if (ktFunction == null) {
                                        return;
                                    }
                                    KtFunction ownerFunction = ktFunction;
                                    int index2 = KtPsiUtilKt.parameterIndex(parameter);
                                    for (PsiReference reference2 : this.$searchKotlinDeclarationReferences.invoke(ownerFunction)) {
                                        void $receiver$iv$iv;
                                        Iterable $receiver$iv;
                                        ResolvedValueArgument resolvedArgument;
                                        ValueParameterDescriptor parameterDescriptor;
                                        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                                        KtExpression callee;
                                        PsiElement psiElement2 = reference2.getElement();
                                        if (!(psiElement2 instanceof KtExpression)) {
                                            psiElement2 = null;
                                        }
                                        if ((KtExpression)psiElement2 == null) {
                                            continue;
                                        }
                                        if (CallUtilKt.getResolvedCall(callee, ResolutionUtils.analyze$default(callee, null, 1, null)) == null) {
                                            continue;
                                        }
                                        List<ValueParameterDescriptor> list2 = resolvedCall2.getCandidateDescriptor().getValueParameters();
                                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.candidateDescriptor.valueParameters");
                                        if ((ValueParameterDescriptor)CollectionsKt.getOrNull(list2, (int)index2) == null) {
                                            continue;
                                        }
                                        if (resolvedCall2.getValueArguments().get(parameterDescriptor) == null) {
                                            continue;
                                        }
                                        List<ValueArgument> list3 = resolvedArgument.getArguments();
                                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"resolvedArgument.arguments");
                                        Iterable iterable = $receiver$iv = (Iterable)list3;
                                        Collection destination$iv$iv = new ArrayList<E>();
                                        for (T element$iv$iv : $receiver$iv$iv) {
                                            if (!(element$iv$iv instanceof KtValueArgument)) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        List arguments2 = (List)destination$iv$iv;
                                        if (arguments2.isEmpty()) continue;
                                        Iterable thisCollection$iv = $receiver$iv = (Collection)arguments2;
                                        KtValueArgument[] ktValueArgumentArray = thisCollection$iv.toArray(new KtValueArgument[thisCollection$iv.size()]);
                                        if (ktValueArgumentArray == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                                        }
                                        this.$usages.add(new SafeDeleteValueArgumentListUsageInfo(parameter, Arrays.copyOf(ktValueArgumentArray, ktValueArgumentArray.length)));
                                    }
                                }
                                {
                                    this.$searchKotlinDeclarationReferences = var1_1;
                                    this.$usages = list2;
                                    super(1);
                                }
                            };
                            findKotlinDeclarationUsages$ = new Function1<KtDeclaration, NonCodeUsageSearchInfo>(searchKotlinDeclarationReferences$, usages2, element3, findKotlinParameterUsages$, getSearchInfo$){
                                final /* synthetic */ findUsages.3 $searchKotlinDeclarationReferences;
                                final /* synthetic */ List $usages;
                                final /* synthetic */ PsiElement $element;
                                final /* synthetic */ findUsages.4 $findKotlinParameterUsages;
                                final /* synthetic */ findUsages.2 $getSearchInfo;

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final NonCodeUsageSearchInfo invoke(@NotNull KtDeclaration declaration2) {
                                    void $receiver$iv;
                                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                    Sequence<PsiReference> sequence2 = this.$searchKotlinDeclarationReferences.invoke(declaration2);
                                    Collection destination$iv = this.$usages;
                                    void $receiver$iv$iv = $receiver$iv;
                                    for (E element$iv$iv : $receiver$iv$iv) {
                                        UsageInfo usageInfo;
                                        UsageInfo usageInfo2;
                                        E element$iv = element$iv$iv;
                                        PsiReference reference2 = (PsiReference)element$iv;
                                        if (reference2.getElement() == null) {
                                            usageInfo2 = null;
                                        } else {
                                            PsiElement refElement;
                                            PsiElement $receiver$iv2 = refElement;
                                            if ((KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtImportDirective.class, (boolean)false) != null) {
                                                KtImportDirective ktImportDirective;
                                                KtImportDirective importDirective = ktImportDirective;
                                                usageInfo2 = (UsageInfo)new SafeDeleteImportDirectiveUsageInfo(importDirective, this.$element);
                                            } else {
                                                usageInfo2 = (UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo(refElement, (PsiElement)declaration2, false);
                                            }
                                        }
                                        if (usageInfo2 == null) continue;
                                        UsageInfo it$iv = usageInfo = usageInfo2;
                                        destination$iv.add(it$iv);
                                    }
                                    if (declaration2 instanceof KtParameter) {
                                        this.$findKotlinParameterUsages.invoke((KtParameter)declaration2);
                                    }
                                    return this.$getSearchInfo.invoke(declaration2);
                                }
                                {
                                    this.$searchKotlinDeclarationReferences = var1_1;
                                    this.$usages = list2;
                                    this.$element = psiElement2;
                                    this.$findKotlinParameterUsages = var4_4;
                                    this.$getSearchInfo = var5_5;
                                    super(1);
                                }
                            };
                            findUsagesByJavaProcessor$2 = new Function2<PsiElement, Boolean, NonCodeUsageSearchInfo>(this, allElementsToDelete, deleteSet, getIgnoranceCondition$, usages2){
                                final /* synthetic */ KotlinSafeDeleteProcessor this$0;
                                final /* synthetic */ PsiElement[] $allElementsToDelete;
                                final /* synthetic */ SmartSet $deleteSet;
                                final /* synthetic */ findUsages.1 $getIgnoranceCondition;
                                final /* synthetic */ List $usages;

                                /*
                                 * WARNING - void declaration
                                 */
                                @Nullable
                                public final NonCodeUsageSearchInfo invoke(@NotNull PsiElement element3, boolean forceReferencedElementUnwrapping) {
                                    void $receiver$iv;
                                    PsiElement psiElement2;
                                    void $receiver$iv$iv;
                                    Iterable $receiver$iv2;
                                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                    ArrayList<E> javaUsages = new ArrayList<E>();
                                    NonCodeUsageSearchInfo searchInfo = KotlinSafeDeleteProcessor.access$findUsages$s229615865(this.this$0, element3, this.$allElementsToDelete, javaUsages);
                                    Iterable iterable = $receiver$iv2 = (Iterable)javaUsages;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    for (T element$iv$iv : $receiver$iv$iv) {
                                        if (!(element$iv$iv instanceof SafeDeleteOverridingMethodUsageInfo)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $receiver$iv2 = (List)destination$iv$iv;
                                    Iterable<PsiElement> destination$iv = this.$deleteSet;
                                    Iterable $receiver$iv$iv2 = $receiver$iv2;
                                    for (T element$iv$iv : $receiver$iv$iv2) {
                                        T element$iv = element$iv$iv;
                                        SafeDeleteOverridingMethodUsageInfo it = (SafeDeleteOverridingMethodUsageInfo)element$iv;
                                        if (it.getElement() == null) continue;
                                        PsiElement it$iv = psiElement2;
                                        destination$iv.add(it$iv);
                                    }
                                    Condition<PsiElement> ignoranceCondition = this.$getIgnoranceCondition.invoke();
                                    destination$iv = javaUsages;
                                    Collection destination$iv2 = this.$usages;
                                    void $receiver$iv$iv3 = $receiver$iv;
                                    for (T element$iv$iv : $receiver$iv$iv3) {
                                        UsageInfo usageInfo;
                                        Object $receiver$iv3;
                                        UsageInfo usageInfo2;
                                        PsiElement usageElement;
                                        PsiElement psiElement3;
                                        T element$iv = element$iv$iv;
                                        UsageInfo usageInfo3 = (UsageInfo)element$iv;
                                        psiElement2 = usageInfo3;
                                        if (psiElement2 instanceof SafeDeleteOverridingMethodUsageInfo) {
                                            KotlinSafeDeleteOverridingUsageInfo kotlinSafeDeleteOverridingUsageInfo;
                                            SmartPsiElementPointer smartPsiElementPointer = ((SafeDeleteOverridingMethodUsageInfo)usageInfo3).getSmartPointer();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"usageInfo.smartPointer");
                                            if (smartPsiElementPointer.getElement() != null) {
                                                usageElement = psiElement3;
                                                PsiElement psiElement4 = ((SafeDeleteOverridingMethodUsageInfo)usageInfo3).getReferencedElement();
                                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"usageInfo.referencedElement");
                                                kotlinSafeDeleteOverridingUsageInfo = new KotlinSafeDeleteOverridingUsageInfo(usageElement, psiElement4);
                                            } else {
                                                kotlinSafeDeleteOverridingUsageInfo = null;
                                            }
                                            usageInfo2 = (UsageInfo)kotlinSafeDeleteOverridingUsageInfo;
                                        } else if (psiElement2 instanceof SafeDeleteOverrideAnnotation) {
                                            KotlinSafeDeleteOverrideAnnotation kotlinSafeDeleteOverrideAnnotation;
                                            SmartPsiElementPointer smartPsiElementPointer = ((SafeDeleteOverrideAnnotation)usageInfo3).getSmartPointer();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"usageInfo.smartPointer");
                                            if (smartPsiElementPointer.getElement() != null) {
                                                boolean bl;
                                                block29: {
                                                    usageElement = psiElement3;
                                                    $receiver$iv3 = LightClassUtilsKt.toLightMethods(usageElement);
                                                    if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                                                        bl = true;
                                                    } else {
                                                        Iterator<T> $i$f$forEach = $receiver$iv3.iterator();
                                                        while ($i$f$forEach.hasNext()) {
                                                            T element$iv2 = $i$f$forEach.next();
                                                            PsiMethod method = (PsiMethod)element$iv2;
                                                            PsiMethod[] psiMethodArray = method.findSuperMethods();
                                                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"method.findSuperMethods()");
                                                            Object[] objectArray = psiMethodArray;
                                                            if (objectArray.length == 0) continue;
                                                            bl = false;
                                                            break block29;
                                                        }
                                                        bl = true;
                                                    }
                                                }
                                                if (bl) {
                                                    PsiElement psiElement5 = ((SafeDeleteOverrideAnnotation)usageInfo3).getReferencedElement();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"usageInfo.referencedElement");
                                                    kotlinSafeDeleteOverrideAnnotation = new KotlinSafeDeleteOverrideAnnotation(usageElement, psiElement5);
                                                } else {
                                                    kotlinSafeDeleteOverrideAnnotation = null;
                                                }
                                            } else {
                                                kotlinSafeDeleteOverrideAnnotation = null;
                                            }
                                            usageInfo2 = (UsageInfo)kotlinSafeDeleteOverrideAnnotation;
                                        } else if (psiElement2 instanceof SafeDeleteReferenceJavaDeleteUsageInfo) {
                                            SafeDeleteReferenceUsageInfo safeDeleteReferenceUsageInfo;
                                            if (((SafeDeleteReferenceJavaDeleteUsageInfo)usageInfo3).getElement() != null) {
                                                usageElement = psiElement3;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)usageElement, (String)"usageElement");
                                                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtValueArgumentName.class, (boolean)false) != null) {
                                                    safeDeleteReferenceUsageInfo = null;
                                                } else if (ignoranceCondition.value((Object)usageElement)) {
                                                    safeDeleteReferenceUsageInfo = null;
                                                } else {
                                                    SafeDeleteReferenceUsageInfo safeDeleteReferenceUsageInfo2;
                                                    $receiver$iv3 = usageElement;
                                                    KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtImportDirective.class, (boolean)false);
                                                    if (ktImportDirective != null) {
                                                        Object importDirective = $receiver$iv3 = ktImportDirective;
                                                        safeDeleteReferenceUsageInfo2 = (SafeDeleteReferenceUsageInfo)new SafeDeleteImportDirectiveUsageInfo((KtImportDirective)importDirective, element3);
                                                    } else {
                                                        $receiver$iv3 = usageElement;
                                                        Function1 branch$iv = findUsages.2.3.2.INSTANCE;
                                                        boolean strict$iv = false;
                                                        Object $receiver$iv$iv4 = $receiver$iv3;
                                                        PsiElement psiElement6 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv4, KtSuperTypeEntry.class, (boolean)strict$iv);
                                                        if ((KtSuperTypeEntry)(psiElement6 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement6, (PsiElement)$receiver$iv3, branch$iv) : null) != null) {
                                                            KtSuperTypeEntry ktSuperTypeEntry;
                                                            KtSuperTypeEntry it = ktSuperTypeEntry;
                                                            safeDeleteReferenceUsageInfo2 = element3 instanceof PsiClass && ((PsiClass)element3).isInterface() ? (SafeDeleteReferenceUsageInfo)new SafeDeleteSuperTypeUsageInfo(it, element3) : (SafeDeleteReferenceUsageInfo)usageInfo3;
                                                        } else {
                                                            safeDeleteReferenceUsageInfo2 = safeDeleteReferenceUsageInfo = null;
                                                        }
                                                    }
                                                    if (safeDeleteReferenceUsageInfo2 == null) {
                                                        safeDeleteReferenceUsageInfo = (SafeDeleteReferenceUsageInfo)(forceReferencedElementUnwrapping ? new SafeDeleteReferenceJavaDeleteUsageInfo(usageElement, LightClassUtilsKt.getUnwrapped(element3), ((SafeDeleteReferenceJavaDeleteUsageInfo)usageInfo3).isSafeDelete()) : (SafeDeleteReferenceJavaDeleteUsageInfo)usageInfo3);
                                                    }
                                                }
                                            } else {
                                                safeDeleteReferenceUsageInfo = null;
                                            }
                                            usageInfo2 = (UsageInfo)safeDeleteReferenceUsageInfo;
                                        } else {
                                            usageInfo2 = usageInfo3;
                                        }
                                        if (usageInfo2 == null) continue;
                                        UsageInfo it$iv = usageInfo = usageInfo2;
                                        destination$iv2.add(it$iv);
                                    }
                                    return searchInfo;
                                }
                                {
                                    this.this$0 = kotlinSafeDeleteProcessor;
                                    this.$allElementsToDelete = psiElementArray;
                                    this.$deleteSet = smartSet;
                                    this.$getIgnoranceCondition = var4_4;
                                    this.$usages = list2;
                                    super(2);
                                }
                            };
                            Function2<Sequence<? extends PsiElement>, Condition<PsiElement>, Condition<PsiElement>> findUsagesByJavaProcessor$3 = new Function2<Sequence<? extends PsiElement>, Condition<PsiElement>, Condition<PsiElement>>(findUsagesByJavaProcessor$2){
                                final /* synthetic */ findUsages.6 $findUsagesByJavaProcessor;

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final Condition<PsiElement> invoke(@NotNull Sequence<? extends PsiElement> elements2, @NotNull Condition<PsiElement> insideDeleted) {
                                    Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
                                    Intrinsics.checkParameterIsNotNull(insideDeleted, (String)"insideDeleted");
                                    Sequence $receiver$iv = SequencesKt.mapNotNull(elements2, (Function1)((Function1)new Function1<PsiElement, Condition<PsiElement>>(this){
                                        final /* synthetic */ findUsages.7 this$0;

                                        @Nullable
                                        public final Condition<PsiElement> invoke(@NotNull PsiElement element3) {
                                            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                            NonCodeUsageSearchInfo nonCodeUsageSearchInfo = this.this$0.$findUsagesByJavaProcessor.invoke(element3, true);
                                            return nonCodeUsageSearchInfo != null ? nonCodeUsageSearchInfo.getInsideDeletedCondition() : null;
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(1);
                                        }
                                    }));
                                    Condition accumulator$iv = insideDeleted;
                                    for (E element$iv : $receiver$iv) {
                                        void condition2;
                                        Condition condition3 = (Condition)element$iv;
                                        Condition condition1 = accumulator$iv;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)Conditions.or(condition1, (Condition)condition2), (String)"Conditions.or(condition1, condition2)");
                                    }
                                    Condition condition4 = accumulator$iv;
                                    Intrinsics.checkExpressionValueIsNotNull(condition4, (String)"elements\n               \u2026condition1, condition2) }");
                                    return condition4;
                                }
                                {
                                    this.$findUsagesByJavaProcessor = var1_1;
                                    super(2);
                                }
                            };
                            findUsagesByJavaProcessor$ = new Function1<KtDeclaration, NonCodeUsageSearchInfo>(findKotlinDeclarationUsages$, findUsagesByJavaProcessor$3, getIgnoranceCondition$){
                                final /* synthetic */ findUsages.5 $findKotlinDeclarationUsages;
                                final /* synthetic */ findUsages.7 $findUsagesByJavaProcessor;
                                final /* synthetic */ findUsages.1 $getIgnoranceCondition;

                                @NotNull
                                public final NonCodeUsageSearchInfo invoke(@NotNull KtDeclaration ktDeclaration) {
                                    Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
                                    List<PsiNamedElement> lightElements = LightClassUtilsKt.toLightElements(ktDeclaration);
                                    if (lightElements.isEmpty()) {
                                        return this.$findKotlinDeclarationUsages.invoke(ktDeclaration);
                                    }
                                    return new NonCodeUsageSearchInfo(this.$findUsagesByJavaProcessor.invoke((Sequence<? extends PsiElement>)CollectionsKt.asSequence((Iterable)lightElements), this.$getIgnoranceCondition.invoke()), (PsiElement)ktDeclaration);
                                }
                                {
                                    this.$findKotlinDeclarationUsages = var1_1;
                                    this.$findUsagesByJavaProcessor = var2_2;
                                    this.$getIgnoranceCondition = var3_3;
                                    super(1);
                                }
                            };
                            findTypeParameterUsages$ = new Function1<KtTypeParameter, Unit>(usages2){
                                final /* synthetic */ List $usages;

                                public final void invoke(@NotNull KtTypeParameter parameter) {
                                    Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                                    PsiElement $receiver$iv = parameter;
                                    KtTypeParameterListOwner ktTypeParameterListOwner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtTypeParameterListOwner.class, (boolean)false);
                                    if (ktTypeParameterListOwner == null) {
                                        return;
                                    }
                                    KtTypeParameterListOwner owner = ktTypeParameterListOwner;
                                    List<KtTypeParameter> parameterList2 = owner.getTypeParameters();
                                    int parameterIndex2 = parameterList2.indexOf(parameter);
                                    for (PsiReference reference2 : ReferencesSearch.search((PsiElement)owner)) {
                                        List<KtTypeProjection> projections;
                                        KtElementImplStub argList;
                                        if (!(reference2 instanceof KtReference)) continue;
                                        KtElement referencedElement = ((KtReference)reference2).getElement();
                                        PsiElement $receiver$iv2 = (PsiElement)referencedElement;
                                        KtElementImplStub ktElementImplStub = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtUserType.class, (boolean)false);
                                        if (ktElementImplStub == null || (ktElementImplStub = ((KtUserType)ktElementImplStub).getTypeArgumentList()) == null) {
                                            $receiver$iv2 = (PsiElement)referencedElement;
                                            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtCallExpression.class, (boolean)false);
                                            ktElementImplStub = ktCallExpression != null ? ktCallExpression.getTypeArgumentList() : null;
                                        }
                                        if ((argList = ktElementImplStub) == null || parameterIndex2 >= (projections = ((KtTypeArgumentList)argList).getArguments()).size()) continue;
                                        KtTypeProjection ktTypeProjection = projections.get(parameterIndex2);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeProjection, (String)"projections[parameterIndex]");
                                        this.$usages.add(new SafeDeleteTypeArgumentListUsageInfo(ktTypeProjection, parameter));
                                    }
                                }
                                {
                                    this.$usages = list2;
                                    super(1);
                                }
                            };
                            findDelegationCallUsages$ = new Function1<PsiElement, Unit>(getIgnoranceCondition$, usages2){
                                final /* synthetic */ findUsages.1 $getIgnoranceCondition;
                                final /* synthetic */ List $usages;

                                public final void invoke(@NotNull PsiElement element3) {
                                    PsiMethod[] psiMethodArray;
                                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                    PsiElement psiElement2 = element3;
                                    if (psiElement2 instanceof PsiClass) {
                                        PsiMethod[] psiMethodArray2 = ((PsiClass)element3).getConstructors();
                                        psiMethodArray = psiMethodArray2;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray2, (String)"element.constructors");
                                    } else if (psiElement2 instanceof PsiMethod) {
                                        PsiMethod[] psiMethodArray3 = new PsiMethod[1];
                                        psiMethodArray = psiMethodArray3;
                                        psiMethodArray3[0] = (PsiMethod)element3;
                                    } else {
                                        return;
                                    }
                                    PsiMethod[] constructors2 = psiMethodArray;
                                    for (int i = 0; i < constructors2.length; ++i) {
                                        PsiMethod constructor2;
                                        PsiMethod psiMethod = constructor2 = constructors2[i];
                                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"constructor");
                                        PsiElement psiElement3 = (PsiElement)psiMethod;
                                        SearchScope searchScope2 = constructor2.getUseScope();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"constructor.useScope");
                                        org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt.processDelegationCallConstructorUsages(psiElement3, searchScope2, (Function1<? super KtCallElement, Boolean>)((Function1)new Function1<KtCallElement, Boolean>(this, element3){
                                            final /* synthetic */ findUsages.10 this$0;
                                            final /* synthetic */ PsiElement $element;

                                            public final boolean invoke(@NotNull KtCallElement it) {
                                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                                if (!this.this$0.$getIgnoranceCondition.invoke().value((Object)it)) {
                                                    this.this$0.$usages.add(new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)it, this.$element, false));
                                                }
                                                return true;
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                this.$element = psiElement2;
                                                super(1);
                                            }
                                        }));
                                    }
                                }
                                {
                                    this.$getIgnoranceCondition = var1_1;
                                    this.$usages = list2;
                                    super(1);
                                }
                            };
                            psiElement2 = element3;
                            if (!(psiElement2 instanceof KtClassOrObject)) break block20;
                            ktLightClass2 = LightClassUtilsKt.toLightClass((KtClassOrObject)element3);
                            if (ktLightClass2 == null) break block21;
                            KtLightClass klass2 = ktLightClass4 = ktLightClass2;
                            findDelegationCallUsages$.invoke((PsiElement)klass2);
                            ktLightClass2 = findUsagesByJavaProcessor$2.invoke((PsiElement)klass2, false);
                            if (ktLightClass2 != null) break block22;
                        }
                        ktLightClass2 = findKotlinDeclarationUsages$.invoke((KtDeclaration)element3);
                        break block22;
                    }
                    if (!(psiElement2 instanceof KtSecondaryConstructor)) break block23;
                    ktLightClass2 = LightClassUtilsKt.getRepresentativeLightMethod(element3);
                    if (ktLightClass2 == null) break block24;
                    KtLightClass method = ktLightClass3 = ktLightClass2;
                    findDelegationCallUsages$.invoke((PsiElement)method);
                    ktLightClass2 = findUsagesByJavaProcessor$2.invoke((PsiElement)method, false);
                    if (ktLightClass2 != null) break block22;
                }
                ktLightClass2 = findKotlinDeclarationUsages$.invoke((KtDeclaration)element3);
                break block22;
            }
            if (psiElement2 instanceof KtNamedFunction) {
                if (((KtNamedFunction)element3).isLocal()) {
                    ktLightClass2 = findKotlinDeclarationUsages$.invoke((KtDeclaration)element3);
                } else {
                    List<PsiMethod> lightMethods2 = LightClassUtilsKt.toLightMethods(element3);
                    Collection method = lightMethods2;
                    if (!method.isEmpty()) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Iterable $i$a$12$let = $receiver$iv = (Iterable)lightMethods2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void method2;
                            PsiMethod psiMethod = (PsiMethod)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            NonCodeUsageSearchInfo nonCodeUsageSearchInfo = findUsagesByJavaProcessor$2.invoke((PsiElement)method2, false);
                            collection.add(nonCodeUsageSearchInfo);
                        }
                        ktLightClass2 = (NonCodeUsageSearchInfo)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    } else {
                        ktLightClass2 = findKotlinDeclarationUsages$.invoke((KtDeclaration)element3);
                    }
                }
            } else if (psiElement2 instanceof PsiMethod) {
                ktLightClass2 = findUsagesByJavaProcessor$2.invoke(element3, false);
            } else if (psiElement2 instanceof PsiClass) {
                ktLightClass2 = findUsagesByJavaProcessor$2.invoke(element3, false);
            } else if (psiElement2 instanceof KtProperty) {
                ktLightClass2 = ((KtProperty)element3).isLocal() ? findKotlinDeclarationUsages$.invoke((KtDeclaration)element3) : findUsagesByJavaProcessor$.invoke((KtDeclaration)element3);
            } else if (psiElement2 instanceof KtTypeParameter) {
                findTypeParameterUsages$.invoke((KtTypeParameter)element3);
                ktLightClass2 = findUsagesByJavaProcessor$.invoke((KtDeclaration)element3);
            } else {
                ktLightClass2 = psiElement2 instanceof KtParameter ? findUsagesByJavaProcessor$.invoke((KtDeclaration)element3) : (ktLightClass = psiElement2 instanceof KtTypeAlias ? findKotlinDeclarationUsages$.invoke((KtDeclaration)element3) : null);
            }
        }
        if (ktLightClass2 == null) {
            ktLightClass = getSearchInfo$.invoke(element3);
        }
        return ktLightClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element3, @NotNull PsiElement[] allElementsToDelete) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)allElementsToDelete, (String)"allElementsToDelete");
        if (element3 instanceof KtNamedFunction || element3 instanceof KtProperty) {
            void $receiver$iv;
            PsiElement $receiver$iv2 = element3;
            KtClass jetClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtClass.class, (boolean)false);
            if (jetClass == null || Intrinsics.areEqual((Object)jetClass.getBody(), (Object)element3.getParent()) ^ true) {
                return null;
            }
            KtModifierList modifierList = jetClass.getModifierList();
            if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                return null;
            }
            BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)element3, null, 1, null);
            DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
            if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                declarationDescriptor = null;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
            if (callableMemberDescriptor == null) {
                return null;
            }
            CallableMemberDescriptor declarationDescriptor2 = callableMemberDescriptor;
            Collection<? extends CallableMemberDescriptor> collection = declarationDescriptor2.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"declarationDescriptor.overriddenDescriptors");
            Sequence sequence2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)findConflicts.1.INSTANCE);
            Collection destination$iv = new ArrayList();
            for (Object item$iv : $receiver$iv) {
                void overridenDescriptor;
                CallableMemberDescriptor callableMemberDescriptor2 = (CallableMemberDescriptor)item$iv;
                Collection collection2 = destination$iv;
                Object[] objectArray = new Object[4];
                objectArray[0] = RenderingUtilsKt.formatFunction(declarationDescriptor2, true);
                DeclarationDescriptor declarationDescriptor3 = declarationDescriptor2.getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"declarationDescriptor.containingDeclaration");
                objectArray[1] = RenderingUtilsKt.formatClass(declarationDescriptor3, true);
                void v5 = overridenDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"overridenDescriptor");
                objectArray[2] = RenderingUtilsKt.formatFunction((DeclarationDescriptor)v5, true);
                DeclarationDescriptor declarationDescriptor4 = overridenDescriptor.getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor4, (String)"overridenDescriptor.containingDeclaration");
                objectArray[3] = RenderingUtilsKt.formatClass(declarationDescriptor4, true);
                String string = KotlinBundle.message("x.implements.y", objectArray);
                collection2.add(string);
            }
            return destination$iv;
        }
        return super.findConflicts(element3, allElementsToDelete);
    }

    @Nullable
    public UsageInfo[] preprocessUsages(@NotNull Project project, @NotNull UsageInfo[] usages2) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> overridingMethodUsages = new ArrayList<UsageInfo>();
        for (int i = 0; i < usages2.length; ++i) {
            UsageInfo usage = usages2[i];
            if (usage instanceof KotlinSafeDeleteOverridingUsageInfo) {
                overridingMethodUsages.add(usage);
                continue;
            }
            result2.add(usage);
        }
        if (!overridingMethodUsages.isEmpty()) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (application.isUnitTestMode()) {
                result2.addAll((Collection)overridingMethodUsages);
            } else {
                KotlinOverridingDialog dialog2 = new KotlinOverridingDialog(project, (List<UsageInfo>)overridingMethodUsages);
                dialog2.show();
                if (!dialog2.isOK()) {
                    return null;
                }
                result2.addAll((Collection)dialog2.getSelected());
            }
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)result2;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[thisCollection$iv.size()]);
        if (usageInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return usageInfoArray;
    }

    public void prepareForDeletion(@NotNull PsiElement element3) {
        PsiElement psiElement2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtDeclaration) {
            Iterable $receiver$iv = HasActualMarkerKt.actualsForExpected((KtDeclaration)element3);
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                KtDeclaration it = (KtDeclaration)element$iv;
                if (it instanceof KtParameter) {
                    PsiElement psiElement3 = ((KtParameter)it).getParent();
                    if (!(psiElement3 instanceof KtParameterList)) {
                        psiElement3 = null;
                    }
                    KtParameterList ktParameterList = (KtParameterList)psiElement3;
                    if (ktParameterList != null) {
                        ktParameterList.removeParameter((KtParameter)it);
                    }
                    continue;
                }
                it.removeModifier(KtTokens.IMPL_KEYWORD);
                it.removeModifier(KtTokens.ACTUAL_KEYWORD);
            }
        }
        if ((psiElement2 = element3) instanceof PsiMethod) {
            UtilsKt.cleanUpOverrides((PsiMethod)element3);
        } else if (psiElement2 instanceof KtNamedFunction) {
            if (!((KtNamedFunction)element3).isLocal()) {
                PsiMethod psiMethod = LightClassUtilsKt.getRepresentativeLightMethod(element3);
                if (psiMethod != null) {
                    UtilsKt.cleanUpOverrides(psiMethod);
                }
            }
        } else if (psiElement2 instanceof KtProperty) {
            if (!((KtProperty)element3).isLocal()) {
                Iterable $receiver$iv = LightClassUtilsKt.toLightMethods(element3);
                for (Object element$iv : $receiver$iv) {
                    PsiMethod p1 = (PsiMethod)element$iv;
                    UtilsKt.cleanUpOverrides(p1);
                }
            }
        } else if (psiElement2 instanceof KtTypeParameter) {
            PsiModificationUtilsKt.deleteElementAndCleanParent(element3);
        } else if (psiElement2 instanceof KtParameter) {
            KtDeclarationWithBody ktDeclarationWithBody = ((KtParameter)element3).getOwnerFunction();
            if (ktDeclarationWithBody != null) {
                Object it;
                Object object2 = it = (object = ktDeclarationWithBody);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                if (Intrinsics.areEqual((Object)KotlinSafeDeleteProcessor.Companion.getDropActualModifier((KtDeclaration)object2), (Object)true)) {
                    it.removeModifier(KtTokens.IMPL_KEYWORD);
                    it.removeModifier(KtTokens.ACTUAL_KEYWORD);
                    KotlinSafeDeleteProcessor.Companion.setDropActualModifier((KtDeclaration)it, null);
                }
            }
            PsiElement psiElement4 = ((KtParameter)element3).getParent();
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameterList");
            }
            ((KtParameterList)psiElement4).removeParameter((KtParameter)element3);
        }
    }

    private final boolean shouldAllowPropagationToExpected(KtParameter parameter) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            Project project = parameter.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"parameter.project");
            Boolean bl = Companion.getALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$idea(project);
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"parameter.project.ALLOW_\u2026UAL_PARAMETER_TO_EXPECTED");
            return bl;
        }
        return Messages.showYesNoDialog((String)"Do you want to delete this parameter in expected declaration and all related actual ones?", (String)RefactoringBundle.message((String)"safe.delete.title"), (Icon)Messages.getQuestionIcon()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<PsiElement> getElementsToSearch(@NotNull PsiElement element3, @Nullable Module module, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(allElementsToDelete, (String)"allElementsToDelete");
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof KtParameter) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            KtParameter expectParameter;
            KtDeclaration ktDeclaration = HasExpectedMarkerKt.liftToExpected((KtDeclaration)element3);
            if (!(ktDeclaration instanceof KtParameter)) {
                ktDeclaration = null;
            }
            if ((expectParameter = (KtParameter)ktDeclaration) != null && Intrinsics.areEqual((Object)expectParameter, (Object)element3) ^ true) {
                if (this.shouldAllowPropagationToExpected((KtParameter)element3)) {
                    return CollectionsKt.listOf((Object)expectParameter);
                }
                KtDeclarationWithBody ktDeclarationWithBody = ((KtParameter)element3).getOwnerFunction();
                if (ktDeclarationWithBody != null) {
                    KotlinSafeDeleteProcessor.Companion.setDropActualModifier(ktDeclarationWithBody, true);
                }
                return CollectionsKt.listOf((Object)element3);
            }
            Iterable iterable = $receiver$iv = (Iterable)LightClassUtilsKt.toPsiParameters((KtParameter)element3);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                PsiParameter psiParameter = (PsiParameter)element$iv$iv;
                Collection collection = UtilsKt.checkParametersInMethodHierarchy(psiParameter);
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            return $receiver$iv.isEmpty() ? (Collection)CollectionsKt.listOf((Object)element3) : $receiver$iv;
        }
        if (psiElement2 instanceof PsiParameter) {
            return UtilsKt.checkParametersInMethodHierarchy((PsiParameter)element3);
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (application.isUnitTestMode()) {
            return Collections.singletonList(element3);
        }
        psiElement2 = element3;
        return psiElement2 instanceof KtNamedFunction || psiElement2 instanceof KtProperty ? (Collection)KotlinRefactoringUtilKt.checkSuperMethods((KtDeclaration)element3, allElementsToDelete, "delete (with usage search)") : super.getElementsToSearch(element3, module, allElementsToDelete);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"ALLOW_LIFTIN\u2026L_PARAMETER_TO_EXPECTED\")");
        ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$delegate = new NotNullableUserDataProperty(key, true);
        Key key2 = Key.create((String)"DROP_ACTUAL_MODIFIER");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DROP_ACTUAL_MODIFIER\")");
        dropActualModifier$delegate = new UserDataProperty(key2);
    }

    @Nullable
    public static final /* synthetic */ NonCodeUsageSearchInfo access$findUsages$s229615865(KotlinSafeDeleteProcessor $this, @NotNull PsiElement p0, @NotNull PsiElement[] p1, @NotNull List p2) {
        return super.findUsages(p0, p1, p2);
    }

    public static final /* synthetic */ void access$setALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$cp(@NotNull NotNullableUserDataProperty notNullableUserDataProperty) {
        ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$delegate = notNullableUserDataProperty;
    }

    public static final /* synthetic */ void access$setDropActualModifier$cp(@NotNull UserDataProperty userDataProperty) {
        dropActualModifier$delegate = userDataProperty;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R?\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004*\u00020\u00072\u000e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048@@AX\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR3\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/safeDelete/KotlinSafeDeleteProcessor$Companion;", "", "()V", "<set-?>", "", "kotlin.jvm.PlatformType", "ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED", "Lcom/intellij/openapi/project/Project;", "getALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$idea", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "setALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$idea", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;)V", "ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$delegate", "Lorg/jetbrains/kotlin/psi/NotNullableUserDataProperty;", "dropActualModifier", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getDropActualModifier", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Ljava/lang/Boolean;", "setDropActualModifier", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Ljava/lang/Boolean;)V", "dropActualModifier$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "idea"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED", "getALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$idea(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;")), (KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "dropActualModifier", "getDropActualModifier(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Ljava/lang/Boolean;"))};
        }

        public final Boolean getALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$idea(@NotNull Project $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return (Boolean)ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$delegate.getValue((UserDataHolder)$receiver, $$delegatedProperties[0]);
        }

        public final void setALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$idea(@NotNull Project $receiver, Boolean bl) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            ALLOW_LIFTING_ACTUAL_PARAMETER_TO_EXPECTED$delegate.setValue((UserDataHolder)$receiver, $$delegatedProperties[0], bl);
        }

        private final Boolean getDropActualModifier(@NotNull KtDeclaration $receiver) {
            return (Boolean)dropActualModifier$delegate.getValue((UserDataHolder)$receiver, $$delegatedProperties[1]);
        }

        private final void setDropActualModifier(@NotNull KtDeclaration $receiver, Boolean bl) {
            dropActualModifier$delegate.setValue((UserDataHolder)$receiver, $$delegatedProperties[1], bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

