/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.memberInfo;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapperKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0006\u001a\u0018\u0010\u000b\u001a\u00020\f*\u00020\r2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"getChildrenToAnalyze", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "getClassDescriptorIfAny", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lcom/intellij/psi/PsiNamedElement;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "qualifiedClassNameForRendering", "", "resolveToDescriptorWrapperAware", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "toKtDeclarationWrapperAware", "Lcom/intellij/psi/PsiMember;", "idea"})
public final class MemberInfoUtilsKt {
    @Nullable
    public static final ClassDescriptor getClassDescriptorIfAny(@NotNull PsiNamedElement $receiver, @Nullable ResolutionFacade resolutionFacade) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiNamedElement psiNamedElement = $receiver;
        if (psiNamedElement instanceof KtClassOrObject) {
            ResolutionFacade resolutionFacade2 = resolutionFacade;
            if (resolutionFacade2 == null) {
                resolutionFacade2 = ResolutionUtils.getResolutionFacade((KtElement)$receiver);
            }
            DeclarationDescriptor declarationDescriptor = ResolutionFacade.DefaultImpls.resolveToDescriptor$default(resolutionFacade2, (KtDeclaration)$receiver, null, 2, null);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        } else {
            classDescriptor = psiNamedElement instanceof PsiClass ? JavaResolutionUtils.getJavaClassDescriptor$default((PsiClass)$receiver, null, 1, null) : null;
        }
        return classDescriptor;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ClassDescriptor getClassDescriptorIfAny$default(PsiNamedElement psiNamedElement, ResolutionFacade resolutionFacade, int n, Object object) {
        if ((n & 1) != 0) {
            resolutionFacade = null;
        }
        return MemberInfoUtilsKt.getClassDescriptorIfAny(psiNamedElement, resolutionFacade);
    }

    @NotNull
    public static final String qualifiedClassNameForRendering(@NotNull PsiNamedElement $receiver) {
        String string;
        String fqName2;
        String string2;
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiNamedElement psiNamedElement = $receiver;
        if (psiNamedElement instanceof KtClassOrObject) {
            FqName fqName3 = ((KtClassOrObject)$receiver).getFqName();
            string3 = fqName3 != null ? fqName3.asString() : null;
        } else if (psiNamedElement instanceof PsiClass) {
            string3 = ((PsiClass)$receiver).getQualifiedName();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Not a class: " + PsiUtilsKt.getElementTextWithContext((PsiElement)$receiver))));
        }
        if ((string2 = (fqName2 = string3)) == null) {
            string2 = string = $receiver.getName();
        }
        if (string2 == null) {
            string = "[Anonymous]";
        }
        return string;
    }

    @NotNull
    public static final List<PsiElement> getChildrenToAnalyze(@NotNull KotlinMemberInfo $receiver) {
        KtNamedDeclaration member;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        KtNamedDeclaration ktNamedDeclaration = member = (KtNamedDeclaration)$receiver.getMember();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"member");
        List childrenToCheck = SequencesKt.toMutableList((Sequence)PsiUtilsKt.getAllChildren(ktNamedDeclaration));
        if ($receiver.isToAbstract() && member instanceof KtCallableDeclaration) {
            KtNamedDeclaration ktNamedDeclaration2 = member;
            if (ktNamedDeclaration2 instanceof KtNamedFunction) {
                Collection collection = childrenToCheck;
                PsiElement psiElement2 = (PsiElement)((KtNamedFunction)member).getBodyExpression();
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                TypeIntrinsics.asMutableCollection((Object)collection2).remove(psiElement2);
            } else if (ktNamedDeclaration2 instanceof KtProperty) {
                Collection collection = childrenToCheck;
                PsiElement psiElement3 = (PsiElement)((KtProperty)member).getInitializer();
                Collection collection3 = collection;
                if (collection3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                TypeIntrinsics.asMutableCollection((Object)collection3).remove(psiElement3);
                collection = childrenToCheck;
                psiElement3 = (PsiElement)((KtProperty)member).getDelegateExpression();
                Collection collection4 = collection;
                if (collection4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                TypeIntrinsics.asMutableCollection((Object)collection4).remove(psiElement3);
                List<KtPropertyAccessor> list2 = ((KtProperty)member).getAccessors();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"member.accessors");
                childrenToCheck.removeAll((Collection)list2);
            }
        }
        return childrenToCheck;
    }

    @NotNull
    public static final DeclarationDescriptor resolveToDescriptorWrapperAware(@NotNull KtNamedDeclaration $receiver, @Nullable ResolutionFacade resolutionFacade) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof KtPsiClassWrapper) {
            ClassDescriptor classDescriptor = JavaResolutionUtils.getJavaClassDescriptor(((KtPsiClassWrapper)$receiver).getPsiClass(), resolutionFacade);
            if (classDescriptor == null) {
                Intrinsics.throwNpe();
            }
            return classDescriptor;
        }
        ResolutionFacade resolutionFacade2 = resolutionFacade;
        if (resolutionFacade2 == null) {
            resolutionFacade2 = ResolutionUtils.getResolutionFacade($receiver);
        }
        return ResolutionFacade.DefaultImpls.resolveToDescriptor$default(resolutionFacade2, $receiver, null, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DeclarationDescriptor resolveToDescriptorWrapperAware$default(KtNamedDeclaration ktNamedDeclaration, ResolutionFacade resolutionFacade, int n, Object object) {
        if ((n & 1) != 0) {
            resolutionFacade = null;
        }
        return MemberInfoUtilsKt.resolveToDescriptorWrapperAware(ktNamedDeclaration, resolutionFacade);
    }

    @Nullable
    public static final KtNamedDeclaration toKtDeclarationWrapperAware(@NotNull PsiMember $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof PsiClass && !($receiver instanceof KtLightClass)) {
            return KtPsiClassWrapperKt.KtPsiClassWrapper((PsiClass)$receiver);
        }
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)$receiver);
        if (!(psiNamedElement instanceof KtNamedDeclaration)) {
            psiNamedElement = null;
        }
        return (KtNamedDeclaration)psiNamedElement;
    }
}

