/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001\f\u0018\u0000 62\u00020\u0001:\u00016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010-\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010.\u001a\u00020/H\u0014J\n\u00100\u001a\u0004\u0018\u000101H\u0014J\b\u00102\u001a\u000203H\u0014J\b\u00104\u001a\u00020\u0011H\u0014J\b\u00105\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "defaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/openapi/project/Project;)V", "classNameField", "Lcom/intellij/ui/EditorTextField;", "destinationComboBox", "org/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$destinationComboBox$1", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$destinationComboBox$1;", "informationLabel", "Ljavax/swing/JLabel;", "newName", "", "getNewName", "()Ljava/lang/String;", "openInEditor", "", "getOpenInEditor", "()Z", "openInEditorCheckBox", "Ljavax/swing/JCheckBox;", "kotlin.jvm.PlatformType", "originalFile", "Lcom/intellij/psi/PsiFile;", "packageLabel", "packageNameField", "Lcom/intellij/ui/ReferenceEditorComboWithBrowseButton;", "qualifiedName", "getQualifiedName", "<set-?>", "Lcom/intellij/refactoring/MoveDestination;", "targetDirectory", "getTargetDirectory", "()Lcom/intellij/refactoring/MoveDestination;", "setTargetDirectory", "(Lcom/intellij/refactoring/MoveDestination;)V", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "checkForErrors", "createCenterPanel", "Ljavax/swing/JPanel;", "createNorthPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "getHelpId", "getPreferredFocusedComponent", "Companion", "idea"})
public final class CopyKotlinDeclarationDialog
extends DialogWrapper {
    private final JLabel informationLabel;
    private final EditorTextField classNameField;
    private final JLabel packageLabel;
    private ReferenceEditorComboWithBrowseButton packageNameField;
    private final JCheckBox openInEditorCheckBox;
    private final destinationComboBox.1 destinationComboBox;
    private final PsiFile originalFile;
    @Nullable
    private MoveDestination targetDirectory;
    private final PsiDirectory defaultTargetDirectory;
    private final Project project;
    @NonNls
    private static final String RECENTS_KEY = "CopyKotlinDeclarationDialog.RECENTS_KEY";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final MoveDestination getTargetDirectory() {
        return this.targetDirectory;
    }

    private final void setTargetDirectory(MoveDestination moveDestination) {
        this.targetDirectory = moveDestination;
    }

    @Nullable
    public final VirtualFile getTargetSourceRoot() {
        DirectoryChooser.ItemWrapper itemWrapper;
        JComboBox jComboBox = this.destinationComboBox.getComboBox();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComboBox, (String)"destinationComboBox.comboBox");
        Object object = jComboBox.getSelectedItem();
        if (!(object instanceof DirectoryChooser.ItemWrapper)) {
            object = null;
        }
        PsiFileSystemItem psiFileSystemItem = (itemWrapper = (DirectoryChooser.ItemWrapper)object) != null && (itemWrapper = itemWrapper.getDirectory()) != null ? (PsiFileSystemItem)itemWrapper : (PsiFileSystemItem)this.originalFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileSystemItem, (String)"((destinationComboBox.co\u2026irectory ?: originalFile)");
        return ProjectRootsUtilKt.getSourceRoot(psiFileSystemItem);
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.classNameField;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    @Nullable
    protected JComponent createNorthPanel() {
        String qualifiedName2 = this.getQualifiedName();
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField = (ReferenceEditorComboWithBrowseButton)new PackageNameReferenceEditorCombo(qualifiedName2, this.project, CopyKotlinDeclarationDialog.Companion.getRECENTS_KEY(), RefactoringBundle.message((String)"choose.destination.package"));
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        referenceEditorComboWithBrowseButton.setTextFieldPreferredWidth(Math.max(qualifiedName2.length() + 5, 40));
        this.packageLabel.setText(RefactoringBundle.message((String)"destination.package"));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.packageNameField;
        if (referenceEditorComboWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        this.packageLabel.setLabelFor((Component)referenceEditorComboWithBrowseButton2);
        JLabel label2 = new JLabel(RefactoringBundle.message((String)"target.destination.folder"));
        boolean isMultipleSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.project).size() > 1;
        this.destinationComboBox.setVisible(isMultipleSourceRoots);
        label2.setVisible(isMultipleSourceRoots);
        label2.setLabelFor((Component)((Object)this.destinationComboBox));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.openInEditorCheckBox, "East");
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.informationLabel).addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)this.classNameField, 12);
        JComponent jComponent = this.packageLabel;
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton3 = this.packageNameField;
        if (referenceEditorComboWithBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        FormBuilder formBuilder2 = formBuilder.addLabeledComponent(jComponent, (JComponent)referenceEditorComboWithBrowseButton3).addLabeledComponent((JComponent)label2, (JComponent)((Object)this.destinationComboBox)).addComponent((JComponent)panel);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder2, (String)"FormBuilder.createFormBu\u2026     .addComponent(panel)");
        return formBuilder2.getPanel();
    }

    private final String getQualifiedName() {
        Object object = this.defaultTargetDirectory;
        if (object == null || (object = PackageUtilsKt.getPackage(object)) == null || (object = object.getQualifiedName()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public final String getNewName() {
        return this.classNameField.getText();
    }

    public final boolean getOpenInEditor() {
        JCheckBox jCheckBox = this.openInEditorCheckBox;
        Intrinsics.checkExpressionValueIsNotNull((Object)jCheckBox, (String)"openInEditorCheckBox");
        return jCheckBox.isSelected();
    }

    private final String checkForErrors() {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        String packageName = referenceEditorComboWithBrowseButton.getText();
        String newName2 = this.getNewName();
        PsiManager manager = PsiManager.getInstance((Project)this.project);
        String string = packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageName");
        CharSequence charSequence = string;
        if (charSequence.length() > 0 && !KotlinRefactoringUtilKt.hasIdentifiersOnly(new FqNameUnsafe(packageName))) {
            return RefactoringBundle.message((String)"invalid.target.package.name.specified");
        }
        charSequence = newName2;
        if (charSequence == null || charSequence.length() == 0) {
            return RefactoringBundle.message((String)"no.class.name.specified");
        }
        try {
            this.targetDirectory = this.destinationComboBox.selectDirectory(new PackageWrapper(manager, packageName), false);
        }
        catch (IncorrectOperationException e) {
            return e.getMessage();
        }
        MoveDestination moveDestination = this.targetDirectory;
        if (moveDestination != null && (moveDestination = moveDestination.getTargetIfExists(this.defaultTargetDirectory)) != null) {
            CharSequence it = charSequence = moveDestination;
            StringBuilder stringBuilder = new StringBuilder().append(newName2).append(".");
            PsiFile psiFile = this.originalFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"originalFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"originalFile.virtualFile");
            String targetFileName = stringBuilder.append(virtualFile2.getExtension()).toString();
            if (Intrinsics.areEqual((Object)it.findFile(targetFileName), (Object)this.originalFile)) {
                return "Can't copy class to the containing file";
            }
        }
        return null;
    }

    protected void doOKAction() {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        String packageName = referenceEditorComboWithBrowseButton.getText();
        String errorString = this.checkForErrors();
        if (errorString != null) {
            CharSequence charSequence = errorString;
            if (charSequence.length() > 0) {
                Messages.showMessageDialog((Project)this.project, (String)errorString, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
            this.classNameField.requestFocusInWindow();
            return;
        }
        RecentsManager.getInstance((Project)this.project).registerRecentEntry(CopyKotlinDeclarationDialog.Companion.getRECENTS_KEY(), packageName);
        JCheckBox jCheckBox = this.openInEditorCheckBox;
        Intrinsics.checkExpressionValueIsNotNull((Object)jCheckBox, (String)"openInEditorCheckBox");
        CopyFilesOrDirectoriesDialog.saveOpenInEditorState((boolean)jCheckBox.isSelected());
        super.doOKAction();
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.copyClass";
    }

    public CopyKotlinDeclarationDialog(@NotNull KtNamedDeclaration declaration2, @Nullable PsiDirectory defaultTargetDirectory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project, true);
        this.defaultTargetDirectory = defaultTargetDirectory;
        this.project = project;
        this.informationLabel = new JLabel();
        this.classNameField = new EditorTextField("");
        this.packageLabel = new JLabel();
        this.openInEditorCheckBox = CopyFilesOrDirectoriesDialog.createOpenInEditorCB();
        this.destinationComboBox = new DestinationFolderComboBox(this){
            final /* synthetic */ CopyKotlinDeclarationDialog this$0;

            @NotNull
            public String getTargetPackage() {
                String string;
                String string2 = CopyKotlinDeclarationDialog.access$getPackageNameField$p(this.this$0).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"packageNameField.text");
                String string3 = string = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                return ((Object)StringsKt.trim((CharSequence)string3)).toString();
            }

            protected boolean reportBaseInTestSelectionInSource() {
                return true;
            }
            {
                this.this$0 = $outer;
            }
        };
        this.originalFile = declaration2.getContainingFile();
        this.informationLabel.setText(RefactoringBundle.message((String)"copy.class.copy.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)declaration2), UsageViewUtil.getLongName((PsiElement)declaration2)}));
        this.informationLabel.setFont(this.informationLabel.getFont().deriveFont(1));
        this.init();
        Pass pass = KotlinRefactoringUtilKt.Pass((Function1)new Function1<String, Unit>(){

            public final void invoke(String it) {
                this.setErrorText(it, (JComponent)((Object)destinationComboBox));
            }
        });
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        this.destinationComboBox.setData(this.project, this.defaultTargetDirectory, pass, (EditorComboBox)referenceEditorComboWithBrowseButton.getChildComponent());
        this.classNameField.setText(UsageViewUtil.getShortName((PsiElement)declaration2));
        this.classNameField.selectAll();
    }

    static {
        RECENTS_KEY = RECENTS_KEY;
    }

    @NotNull
    public static final /* synthetic */ ReferenceEditorComboWithBrowseButton access$getPackageNameField$p(CopyKotlinDeclarationDialog $this) {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = $this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
        }
        return referenceEditorComboWithBrowseButton;
    }

    public static final /* synthetic */ void access$setPackageNameField$p(CopyKotlinDeclarationDialog $this, @NotNull ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton) {
        $this.packageNameField = referenceEditorComboWithBrowseButton;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$Companion;", "", "()V", "RECENTS_KEY", "", "getRECENTS_KEY", "()Ljava/lang/String;", "idea"})
    public static final class Companion {
        private final String getRECENTS_KEY() {
            return RECENTS_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

