/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class TargetPlatformDetector {
    public static final TargetPlatformDetector INSTANCE = new TargetPlatformDetector();
    private static final Logger LOG = Logger.getInstance(TargetPlatformDetector.class);

    private TargetPlatformDetector() {
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull KtFile file2) {
        Module moduleForFile;
        KtFile contextFile;
        TargetPlatform explicitPlatform = KtPsiFactoryKt.getTargetPlatform(file2);
        if (explicitPlatform != null) {
            return explicitPlatform;
        }
        if (file2 instanceof KtCodeFragment && (contextFile = ((KtCodeFragment)file2).getContextContainingFile()) != null) {
            return TargetPlatformDetector.getPlatform(contextFile);
        }
        PsiElement context = KtPsiFactoryKt.getAnalysisContext(file2);
        if (context != null) {
            PsiFile contextFile2 = context.getContainingFile();
            return contextFile2 instanceof KtFile ? TargetPlatformDetector.getPlatform((KtFile)contextFile2) : JvmPlatform.INSTANCE;
        }
        VirtualFile virtualFile2 = file2.getOriginalFile().getVirtualFile();
        if (virtualFile2 != null && (moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)file2.getProject()).getModuleForFile(virtualFile2)) != null) {
            return TargetPlatformDetector.getPlatform(moduleForFile);
        }
        LOG.info("Using default platform for file: " + file2.getName());
        return JvmPlatform.INSTANCE;
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Module module) {
        return ProjectStructureUtil.getCachedPlatformForModule(module);
    }
}

