/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.actions;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomExecutions;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomGoals;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.actions.MavenPomActionsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014J(\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/maven/actions/KotlinMavenExecutionProvider;", "Lcom/intellij/util/xml/actions/generate/AbstractDomGenerateProvider;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "phase", "(Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getPhase", "generate", "parent", "Lcom/intellij/util/xml/DomElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getElementToNavigate", "", "t", "getParentDomElement", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailableForElement", "", "contextElement", "idea-maven"})
final class KotlinMavenExecutionProvider
extends AbstractDomGenerateProvider<MavenDomPlugin> {
    @NotNull
    private final String goal;
    @NotNull
    private final String phase;

    @Nullable
    public MavenDomPlugin generate(@Nullable DomElement parent2, @Nullable Editor editor) {
        if (!(parent2 instanceof MavenDomPlugin)) {
            return null;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)parent2);
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlFile, (String)"DomUtil.getFile(parent)");
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
        if (pomFile == null) {
            return null;
        }
        PomFile file2 = pomFile;
        MavenDomPluginExecution execution = file2.addExecution((MavenDomPlugin)parent2, this.goal, this.phase, CollectionsKt.listOf((Object)this.goal));
        if (editor != null) {
            CaretModel caretModel = editor.getCaretModel();
            XmlElement xmlElement = execution.ensureXmlElementExists();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement, (String)"execution.ensureXmlElementExists()");
            caretModel.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)xmlElement));
        }
        return (MavenDomPlugin)parent2;
    }

    @Nullable
    protected Void getElementToNavigate(@Nullable MavenDomPlugin t) {
        return null;
    }

    @Nullable
    protected DomElement getParentDomElement(@Nullable Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        if (project == null || editor == null || file2 == null) {
            return null;
        }
        DomElement domElement = DomUtil.getContextElement((Editor)editor);
        return (DomElement)(domElement != null ? MavenPomActionsKt.access$findPlugin(domElement) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailableForElement(@NotNull DomElement contextElement) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)contextElement, (String)"contextElement");
        MavenDomPlugin plugin = MavenPomActionsKt.access$findPlugin(contextElement);
        if (plugin == null) return false;
        if (!MavenPomActionsKt.access$isKotlinMavenPlugin(plugin)) return false;
        MavenDomExecutions mavenDomExecutions = plugin.getExecutions();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomExecutions, (String)"plugin.executions");
        List list2 = mavenDomExecutions.getExecutions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"plugin.executions.executions");
        Iterable $receiver$iv = list2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            MavenDomPluginExecution it;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            MavenDomPluginExecution mavenDomPluginExecution = it = (MavenDomPluginExecution)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomPluginExecution, (String)"it");
            MavenDomGoals mavenDomGoals = mavenDomPluginExecution.getGoals();
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomGoals, (String)"it.goals");
            List list3 = mavenDomGoals.getGoals();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"it.goals.goals");
            Iterable $receiver$iv2 = list3;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
                continue;
            }
            for (Object element$iv2 : $receiver$iv2) {
                MavenDomGoal it2;
                MavenDomGoal mavenDomGoal = it2 = (MavenDomGoal)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomGoal, (String)"it");
                if (!Intrinsics.areEqual((Object)((String)mavenDomGoal.getValue()), (Object)this.goal)) continue;
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    @NotNull
    public final String getGoal() {
        return this.goal;
    }

    @NotNull
    public final String getPhase() {
        return this.phase;
    }

    public KotlinMavenExecutionProvider(@NotNull String goal, @NotNull String phase) {
        Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        super("kotlin-maven-execution-provider", MavenDomPlugin.class);
        this.goal = goal;
        this.phase = phase;
    }
}

