/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2jsrun;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.k2jsrun.K2JSConfigurationSettings;
import org.jetbrains.kotlin.idea.k2jsrun.K2JSRunConfiguration;

public final class K2JSRunnerUtils {
    private K2JSRunnerUtils() {
    }

    @NotNull
    public static String constructPathToGeneratedFile(@NotNull Project project, @NotNull String outputDirPath) {
        if (project == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(0);
        }
        if (outputDirPath == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(1);
        }
        String string = outputDirPath + "/" + project.getName() + ".js";
        if (string == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static void copyJSFileFromOutputToDestination(@NotNull Project project, @NotNull K2JSConfigurationSettings configurationSettings) {
        VirtualFile outputDir2;
        if (project == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(3);
        }
        if (configurationSettings == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(4);
        }
        if ((outputDir2 = K2JSRunnerUtils.getOutputDir(project)) == null) {
            throw new RuntimeException("Cannot find output dir for project " + project.getName());
        }
        String pathToGeneratedJsFile = K2JSRunnerUtils.constructPathToGeneratedFile(project, outputDir2.getPath());
        try {
            K2JSRunnerUtils.copyFileToDir(new File(pathToGeneratedJsFile), new File(configurationSettings.getGeneratedFilePath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Output JavaScript file was not generated or missing.", e);
        }
    }

    @Nullable
    private static VirtualFile getOutputDir(@NotNull Project project) {
        if (project == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(5);
        }
        Module module = K2JSRunnerUtils.getJsModule(project);
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
    }

    @NotNull
    public static Module getJsModule(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(6);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length != 1) {
            throw new UnsupportedOperationException("Kotlin to JavaScript translator temporarily does not support multiple modules.");
        }
        Module module = modules[0];
        if (module == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(7);
        }
        return module;
    }

    public static void openBrowser(@NotNull K2JSConfigurationSettings configurationSettings) {
        if (configurationSettings == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(8);
        }
        if (!configurationSettings.isShouldOpenInBrowserAfterTranslation()) {
            return;
        }
        String filePath = configurationSettings.getPageToOpenFilePath();
        String url = VirtualFileManager.constructUrl((String)"file", (String)filePath);
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(configurationSettings.getBrowserFamily().getName());
        BrowserLauncher.getInstance().browse(url, browser);
    }

    @NotNull
    public static K2JSConfigurationSettings getSettings(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(9);
        }
        RunProfile profile = env.getRunProfile();
        assert (profile instanceof K2JSRunConfiguration);
        K2JSConfigurationSettings k2JSConfigurationSettings = ((K2JSRunConfiguration)profile).settings();
        if (k2JSConfigurationSettings == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(10);
        }
        return k2JSConfigurationSettings;
    }

    public static void copyFileToDir(@NotNull File file2, @NotNull File dir) throws IOException {
        if (file2 == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            K2JSRunnerUtils.$$$reportNull$$$0(12);
        }
        FileUtil.copy((File)file2, (File)new File(dir, file2.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirPath";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "constructPathToGeneratedFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "constructPathToGeneratedFile";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyJSFileFromOutputToDestination";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDir";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJsModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openBrowser";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

