/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/ElvisToIfThenIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class ElvisToIfThenIntention
extends SelfTargetingRangeIntention<KtBinaryExpression>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtBinaryExpression element3) {
        TextRange textRange;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)((Object)KtTokens.ELVIS)) && element3.getLeft() != null && element3.getRight() != null) {
            KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"element.operationReference");
            textRange = ktOperationReferenceExpression.getTextRange();
        } else {
            textRange = null;
        }
        return textRange;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression left = KtPsiUtil.safeDeparenthesize(ktExpression);
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression right = KtPsiUtil.safeDeparenthesize(ktExpression2);
        KtExpression ktExpression3 = left;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"left");
        boolean leftIsStable = IfThenUtilsKt.isStable$default(ktExpression3, null, 1, null);
        KtIfExpression ifStatement = IfThenUtilsKt.convertToIfNotNullExpression(element3, left, left, right);
        if (!leftIsStable) {
            KtExpression ktExpression4 = ifStatement.getThen();
            if (ktExpression4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"ifStatement.then!!");
            IfThenUtilsKt.introduceValueForCondition(ifStatement, ktExpression4, editor);
        }
    }

    public ElvisToIfThenIntention() {
        super(KtBinaryExpression.class, "Replace elvis expression with 'if' expression", null, 4, null);
    }
}

