/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyAssertNotNullIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findVariableDeclaration", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "isApplicableTo", "", "idea"})
public final class SimplifyAssertNotNullIntention
extends SelfTargetingOffsetIndependentIntention<KtCallExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)"assert") ^ true) {
            return false;
        }
        List<KtValueArgument> arguments2 = element3.getValueArguments();
        if (arguments2.size() != 1 && arguments2.size() != 2) {
            return false;
        }
        List<KtValueArgument> list2 = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"arguments");
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.first(list2)).getArgumentExpression();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression condition2 = ktBinaryExpression;
        if (Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)((Object)KtTokens.EXCLEQ)) ^ true) {
            return false;
        }
        KtExpression ktExpression3 = IfThenUtilsKt.expressionComparedToNull(condition2);
        if (!(ktExpression3 instanceof KtNameReferenceExpression)) {
            ktExpression3 = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression2 = (KtNameReferenceExpression)ktExpression3;
        if (ktNameReferenceExpression2 == null) {
            return false;
        }
        KtNameReferenceExpression value2 = ktNameReferenceExpression2;
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return false;
        }
        KtVariableDeclaration prevDeclaration = ktVariableDeclaration;
        if (Intrinsics.areEqual((Object)value2.getReferencedNameAsName(), (Object)prevDeclaration.getNameAsName()) ^ true) {
            return false;
        }
        if (prevDeclaration.getInitializer() == null) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element3, bindingContext2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        FqName fqName2 = ImportsUtils.getImportableFqName(function2);
        if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)"kotlin.assert") ^ true) {
            return false;
        }
        if (arguments2.size() == 1) {
            this.setText("Replace with '!!' operator");
        } else {
            if (this.extractMessage(element3) == null) {
                return false;
            }
            this.setText("Replace with '?: error(...)'");
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor) {
        KtExpression newInitializer;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            Intrinsics.throwNpe();
        }
        KtVariableDeclaration declaration2 = ktVariableDeclaration;
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression initializer2 = ktExpression;
        KtExpression message2 = this.extractMessage(element3);
        CommentSaver commentSaver = new CommentSaver((PsiElement)element3, false, 2, null);
        if (message2 == null) {
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[1];
            KtExpression ktExpression2 = initializer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
            objectArray[0] = ktExpression2;
            newInitializer = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0!!", objectArray, false, 4, null);
            initializer2.replace((PsiElement)newInitializer);
        } else {
            PsiElement result2;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression3 = initializer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"initializer");
            objectArray[0] = ktExpression3;
            objectArray[1] = message2;
            newInitializer = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0 ?: kotlin.error($1)", objectArray, false, 4, null);
            PsiElement psiElement2 = result2 = initializer2.replace((PsiElement)newInitializer);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            KtExpression ktExpression4 = ((KtBinaryExpression)psiElement2).getRight();
            if (ktExpression4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            }
            KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)ktExpression4;
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
            int n = PsiUtilsKt.getStartOffset((PsiElement)qualifiedExpression);
            KtExpression ktExpression5 = qualifiedExpression.getSelectorExpression();
            if (ktExpression5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            KtExpression ktExpression6 = ((KtCallExpression)ktExpression5).getCalleeExpression();
            if (ktExpression6 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"(qualifiedExpression.sel\u2026ssion).calleeExpression!!");
            ShortenReferences.DEFAULT.process(ktFile, n, PsiUtilsKt.getEndOffset((PsiElement)ktExpression6));
        }
        element3.delete();
        CommentSaver.restore$default(commentSaver, declaration2, false, 2, null);
        if (editor != null) {
            int n;
            PsiElement psiElement3 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)declaration2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"CodeInsightUtilCore.forc\u2026storeElement(declaration)");
            KtExpression ktExpression7 = ((KtVariableDeclaration)psiElement3).getInitializer();
            if (ktExpression7 == null) {
                Intrinsics.throwNpe();
            }
            newInitializer = ktExpression7;
            if (message2 == null) {
                KtExpression ktExpression8 = newInitializer;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression8, (String)"newInitializer");
                n = PsiUtilsKt.getEndOffset((PsiElement)ktExpression8);
            } else {
                KtExpression ktExpression9 = newInitializer;
                if (ktExpression9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)ktExpression9).getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"(newInitializer as KtBin\u2026ssion).operationReference");
                n = PsiUtilsKt.getStartOffset((PsiElement)ktOperationReferenceExpression);
            }
            int offset2 = n;
            GenerateUtilKt.moveCaret$default(editor, offset2, null, 2, null);
        }
    }

    private final KtVariableDeclaration findVariableDeclaration(KtCallExpression element3) {
        Object v1;
        Object v0;
        block3: {
            if (!(element3.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings((PsiElement)element3, false, false);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof KtVariableDeclaration)) {
            v1 = null;
        }
        return v1;
    }

    private final KtExpression extractMessage(KtCallExpression element3) {
        Object object;
        List<KtValueArgument> arguments2 = element3.getValueArguments();
        if (arguments2.size() != 2) {
            return null;
        }
        KtExpression ktExpression = arguments2.get(1).getArgumentExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (object = (KtLambdaExpression)ktExpression) != null && (object = ((KtLambdaExpression)object).getBodyExpression()) != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null;
    }

    public SimplifyAssertNotNullIntention() {
        super(KtCallExpression.class, "Replace assert with '!!' or '?:'", null, 4, null);
    }
}

