/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.AddJvmOverloadsIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddJvmOverloadsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class AddJvmOverloadsIntention
extends SelfTargetingIntention<KtModifierListOwner>
implements LowPriorityAction {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtModifierListOwner element3, int caretOffset) {
        Object element$iv;
        KtParameter it;
        void targetName;
        Pair pair2;
        KtParameterList valueParameterList;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Object object = element3;
        if (object instanceof KtNamedFunction) {
            PsiElement psiElement2 = ((KtNamedFunction)element3).getFunKeyword();
            if (psiElement2 == null) return false;
            PsiElement funKeyword = psiElement2;
            KtParameterList ktParameterList = ((KtNamedFunction)element3).getValueParameterList();
            if (ktParameterList == null) return false;
            valueParameterList = ktParameterList;
            PsiElement psiElement3 = funKeyword;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"funKeyword");
            int n = PsiUtilsKt.getStartOffset(psiElement3);
            KtParameterList ktParameterList2 = valueParameterList;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameterList2, (String)"valueParameterList");
            int n2 = caretOffset;
            if (n > n2) return false;
            if (PsiUtilsKt.getEndOffset((PsiElement)ktParameterList2) < n2) {
                return false;
            }
            pair2 = TuplesKt.to((Object)("function '" + ((KtNamedFunction)element3).getName() + '\''), valueParameterList.getParameters());
        } else if (object instanceof KtSecondaryConstructor) {
            PsiElement constructorKeyword = ((KtSecondaryConstructor)element3).getConstructorKeyword();
            KtParameterList ktParameterList = ((KtSecondaryConstructor)element3).getValueParameterList();
            if (ktParameterList == null) return false;
            valueParameterList = ktParameterList;
            int n = caretOffset;
            if (PsiUtilsKt.getStartOffset(constructorKeyword) > n) return false;
            if (PsiUtilsKt.getEndOffset((PsiElement)valueParameterList) < n) {
                return false;
            }
            pair2 = TuplesKt.to((Object)"secondary constructor", valueParameterList.getParameters());
        } else {
            List<KtParameter> parameters2;
            if (!(object instanceof KtPrimaryConstructor)) return false;
            KtParameterList ktParameterList = ((KtPrimaryConstructor)element3).getValueParameterList();
            if (ktParameterList == null) return false;
            List<KtParameter> list2 = parameters2 = ktParameterList.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
            KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull(list2);
            if (ktParameter != null) {
                if (ktParameter.hasDefaultValue()) {
                    return false;
                }
            }
            pair2 = TuplesKt.to((Object)"primary constructor", parameters2);
        }
        Pair pair3 = pair2;
        String string = (String)pair3.component1();
        List parameters3 = (List)pair3.component2();
        this.setText("Add '@JvmOverloads' annotation to " + (String)targetName);
        if (!Intrinsics.areEqual((Object)TargetPlatformDetector.getPlatform(element3.getContainingKtFile()), (Object)JvmPlatform.INSTANCE)) return false;
        List list3 = parameters3;
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"parameters");
        Iterable $receiver$iv = list3;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        object = $receiver$iv.iterator();
        do {
            if (!object.hasNext()) return false;
        } while (!(it = (KtParameter)(element$iv = object.next())).hasDefaultValue());
        boolean bl = true;
        if (!bl) return false;
        if (ModifierListModifactorKt.findAnnotation(element3, AddJvmOverloadsIntentionKt.access$getAnnotationFqName$p()) != null) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtModifierListOwner element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtPrimaryConstructor) {
            if (((KtPrimaryConstructor)element3).getConstructorKeyword() == null) {
                element3.addBefore(KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createConstructorKeyword(), (PsiElement)((KtPrimaryConstructor)element3).getValueParameterList());
            }
            ModifierListModifactorKt.addAnnotation$default(element3, AddJvmOverloadsIntentionKt.access$getAnnotationFqName$p(), null, " ", null, 10, null);
        } else {
            ModifierListModifactorKt.addAnnotation$default(element3, AddJvmOverloadsIntentionKt.access$getAnnotationFqName$p(), null, null, null, 14, null);
        }
    }

    public AddJvmOverloadsIntention() {
        super(KtModifierListOwner.class, "Add '@JvmOverloads' annotation", null, 4, null);
    }
}

