/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.AbstractChopListIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B)\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019*\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AbstractChopListIntention;", "TList", "Lorg/jetbrains/kotlin/psi/KtElement;", "TElement", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "listClass", "Ljava/lang/Class;", "elementClass", "text", "", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)V", "applyTo", "", "list", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/editor/Editor;)V", "hasLineBreakAfter", "", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "hasLineBreakBefore", "isApplicableTo", "elements", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "idea"})
public abstract class AbstractChopListIntention<TList extends KtElement, TElement extends KtElement>
extends SelfTargetingOffsetIndependentIntention<TList>
implements LowPriorityAction {
    private final Class<TList> listClass;
    private final Class<TElement> elementClass;

    @Override
    public boolean isApplicableTo(@NotNull TList element3) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            List<TElement> elements2 = this.elements(element3);
            if (elements2.size() <= 1) {
                return false;
            }
            Iterable $receiver$iv = CollectionsKt.dropLast(elements2, (int)1);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtElement it = (KtElement)element$iv;
                    if (this.hasLineBreakAfter(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return !bl;
    }

    @Override
    public void applyTo(@NotNull TList list2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        Project project = list2.getProject();
        Editor editor2 = editor;
        if (editor2 == null) {
            Intrinsics.throwNpe();
        }
        Document document = editor2.getDocument();
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)list2);
        List<TElement> elements2 = this.elements(list2);
        if (!this.hasLineBreakAfter((KtElement)CollectionsKt.last(elements2))) {
            PsiElement rpar;
            Sequence $receiver$iv = PsiUtilsKt.getAllChildren((PsiElement)list2);
            Object last$iv = null;
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                ASTNode aSTNode = it.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.RPAR))) continue;
                last$iv = element$iv;
            }
            PsiElement psiElement2 = rpar = (PsiElement)last$iv;
            if (psiElement2 != null) {
                int it = $receiver$iv = PsiUtilsKt.getStartOffset(psiElement2);
                document.insertString(it, (CharSequence)"\n");
            }
        }
        for (KtElement element3 : CollectionsKt.asReversed(elements2)) {
            if (this.hasLineBreakBefore(element3)) continue;
            document.insertString(PsiUtilsKt.getStartOffset((PsiElement)element3), (CharSequence)"\n");
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        PsiFile psiFile2 = psiFile;
        PsiElement psiElement3 = psiFile2.findElementAt(startOffset);
        if (psiElement3 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)psiElement3, this.listClass);
        if (psiElement4 == null) {
            Intrinsics.throwNpe();
        }
        KtElement newList = (KtElement)psiElement4;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        KtElement ktElement = newList;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"newList");
        codeStyleManager.adjustLineIndent(psiFile2, ktElement.getTextRange());
    }

    private final boolean hasLineBreakAfter(TElement element3) {
        boolean bl;
        block1: {
            Sequence $receiver$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)element3, false, false, 1, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ AbstractChopListIntention this$0;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
                }
                {
                    this.this$0 = abstractChopListIntention;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasLineBreakBefore(TElement element3) {
        boolean bl;
        block1: {
            boolean bl2 = false;
            boolean bl3 = false;
            Sequence $receiver$iv = SequencesKt.takeWhile(PsiUtilsKt.siblings((PsiElement)element3, bl2, bl3), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ AbstractChopListIntention this$0;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
                }
                {
                    this.this$0 = abstractChopListIntention;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final List<TElement> elements(@NotNull TList $receiver) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.getAllChildren((PsiElement)$receiver), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ AbstractChopListIntention this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
            }
            {
                this.this$0 = abstractChopListIntention;
                super(1);
            }
        })), (Function1)elements.2.INSTANCE));
    }

    public AbstractChopListIntention(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(listClass, (String)"listClass");
        Intrinsics.checkParameterIsNotNull(elementClass, (String)"elementClass");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        super(listClass, text2, null, 4, null);
        this.listClass = listClass;
        this.elementClass = elementClass;
    }

    @NotNull
    public static final /* synthetic */ Class access$getElementClass$p(AbstractChopListIntention $this) {
        return $this.elementClass;
    }
}

