/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a2\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u00130\u0012\"\b\b\u0000\u0010\u0014*\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"KOTLIN_PLUGIN_CLASSPATH_MARKER", "", "getKOTLIN_PLUGIN_CLASSPATH_MARKER", "()Ljava/lang/String;", "KOTLIN_PLUGIN_PATH_MARKER", "KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO", "findGradleProjectStructure", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "findKotlinPluginVersion", "classpathData", "Lorg/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData;", "getResolvedKotlinGradleVersion", "findAll", "", "Lorg/jetbrains/kotlin/idea/inspections/gradle/NodeWithData;", "T", "", "key", "Lcom/intellij/openapi/externalSystem/model/Key;", "idea-gradle"})
public final class KotlinGradleInspectionVisitorKt {
    @NotNull
    private static final String KOTLIN_PLUGIN_CLASSPATH_MARKER = "org.jetbrains.kotlin:kotlin-gradle-plugin:";
    private static final String KOTLIN_PLUGIN_PATH_MARKER = "org.jetbrains.kotlin/kotlin-gradle-plugin/";
    private static final String KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO;

    @NotNull
    public static final String getKOTLIN_PLUGIN_CLASSPATH_MARKER() {
        return KOTLIN_PLUGIN_CLASSPATH_MARKER;
    }

    @Nullable
    public static final String getResolvedKotlinGradleVersion(@NotNull PsiFile file2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject());
        if (module != null) {
            Module module2;
            Module it;
            Module module3 = it = (module2 = module);
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"it");
            string = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(module3);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getResolvedKotlinGradleVersion(@NotNull Module module) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        DataNode<ProjectData> dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(module);
        if (dataNode == null) {
            return null;
        }
        DataNode<ProjectData> projectStructureNode = dataNode;
        Key key = ProjectKeys.MODULE;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.MODULE");
        Iterable iterable = $receiver$iv = (Iterable)KotlinGradleInspectionVisitorKt.findAll(projectStructureNode, key);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            NodeWithData it = (NodeWithData)element$iv$iv;
            Object t = it.getData();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"it.data");
            if (!Intrinsics.areEqual((Object)((ModuleData)t).getInternalName(), (Object)module.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (NodeWithData moduleData : (List)destination$iv$iv) {
            DataNode<?> dataNode2 = moduleData.getNode();
            Key key2 = BuildScriptClasspathData.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"BuildScriptClasspathData.KEY");
            NodeWithData nodeWithData = (NodeWithData)CollectionsKt.firstOrNull(KotlinGradleInspectionVisitorKt.findAll(dataNode2, key2));
            if (nodeWithData == null || (nodeWithData = (BuildScriptClasspathData)nodeWithData.getData()) == null) {
                continue;
            }
            NodeWithData buildScriptClasspathData = nodeWithData;
            String kotlinPluginVersion = KotlinGradleInspectionVisitorKt.findKotlinPluginVersion((BuildScriptClasspathData)buildScriptClasspathData);
            if (kotlinPluginVersion == null) continue;
            return kotlinPluginVersion;
        }
        return null;
    }

    @Nullable
    public static final String findKotlinPluginVersion(@NotNull BuildScriptClasspathData classpathData) {
        Intrinsics.checkParameterIsNotNull((Object)classpathData, (String)"classpathData");
        List list2 = classpathData.getClasspathEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"classpathData.classpathEntries");
        Iterator iterator2 = CollectionsKt.asReversedMutable((List)list2).iterator();
        while (iterator2.hasNext()) {
            BuildScriptClasspathData.ClasspathEntry classPathEntry;
            BuildScriptClasspathData.ClasspathEntry classpathEntry = classPathEntry = (BuildScriptClasspathData.ClasspathEntry)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)classpathEntry, (String)"classPathEntry");
            Iterator iterator3 = classpathEntry.getClassesFile().iterator();
            while (iterator3.hasNext()) {
                String versionSubstring;
                String path;
                String string = path = (String)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                String uniformedPath = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                if (!(StringsKt.contains$default((CharSequence)uniformedPath, (CharSequence)KOTLIN_PLUGIN_PATH_MARKER, (boolean)false, (int)2, null) ? Intrinsics.areEqual((Object)(versionSubstring = StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)uniformedPath, (String)KOTLIN_PLUGIN_PATH_MARKER, null, (int)2, null), (char)'/', (String)"<error>")), (Object)"<error>") ^ true : StringsKt.contains$default((CharSequence)uniformedPath, (CharSequence)KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(versionSubstring = StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)uniformedPath, (String)KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO, null, (int)2, null), (char)'/', (String)"<error>")), (Object)"<error>") ^ true)) continue;
                return versionSubstring;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<NodeWithData<T>> findAll(@NotNull DataNode<?> $receiver, @NotNull Key<T> key) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection nodes;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Collection collection = nodes = ExternalSystemApiUtil.findAll($receiver, key);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"nodes");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            NodeWithData<Object> nodeWithData;
            NodeWithData<Object> nodeWithData2;
            Object element$iv$iv = element$iv$iv$iv;
            DataNode it = (DataNode)element$iv$iv;
            if (it.getData(key) == null) {
                nodeWithData2 = null;
            } else {
                Object data;
                DataNode dataNode = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"it");
                nodeWithData2 = new NodeWithData<Object>(dataNode, data);
            }
            if (nodeWithData2 == null) continue;
            NodeWithData<Object> it$iv$iv = nodeWithData = nodeWithData2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull PsiFile file2) {
        DataNode<ProjectData> dataNode;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject());
        if (module != null) {
            Module module2;
            Module it;
            Module module3 = it = (module2 = module);
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"it");
            dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(module3);
        } else {
            dataNode = null;
        }
        return dataNode;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull Module module) {
        ExternalProjectInfo projectInfo;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)KotlinLibraryUtilKt.getGRADLE_SYSTEM_ID(), (String)externalProjectPath);
        if (externalProjectInfo == null) {
            return null;
        }
        ExternalProjectInfo externalProjectInfo2 = projectInfo = externalProjectInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)externalProjectInfo2, (String)"projectInfo");
        return externalProjectInfo2.getExternalProjectStructure();
    }

    static {
        KOTLIN_PLUGIN_CLASSPATH_MARKER = "" + KotlinWithGradleConfigurator.Companion.getGROUP_ID() + ':' + KotlinWithGradleConfigurator.Companion.getGRADLE_PLUGIN_ID() + ':';
        KOTLIN_PLUGIN_PATH_MARKER = "" + KotlinWithGradleConfigurator.Companion.getGROUP_ID() + '/' + KotlinWithGradleConfigurator.Companion.getGRADLE_PLUGIN_ID() + '/';
        KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO = "" + StringsKt.replace$default((String)KotlinWithGradleConfigurator.Companion.getGROUP_ID(), (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + KotlinWithGradleConfigurator.Companion.getGRADLE_PLUGIN_ID() + '/';
    }
}

