/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.inspections.collections.AbstractUselessCallInspection;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.RemoveUselessCallFix;
import org.jetbrains.kotlin.idea.inspections.collections.RenameUselessCallFix;
import org.jetbrains.kotlin.idea.inspections.collections.UselessCallOnCollectionInspection;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\u000e*\u00060\u000fR\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0014R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/UselessCallOnCollectionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractUselessCallInspection;", "()V", "uselessFqNames", "", "", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractUselessCallInspection$Companion$Conversion;", "getUselessFqNames", "()Ljava/util/Map;", "uselessNames", "", "getUselessNames", "()Ljava/util/Set;", "suggestConversionIfNeeded", "", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractUselessCallInspection$QualifiedExpressionVisitor;", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "conversion", "idea"})
public final class UselessCallOnCollectionInspection
extends AbstractUselessCallInspection {
    @NotNull
    private final Map<String, AbstractUselessCallInspection.Companion.Conversion> uselessFqNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"kotlin.collections.filterNotNull", (Object)AbstractUselessCallInspection.Companion.getDeleteConversion()), TuplesKt.to((Object)"kotlin.collections.filterIsInstance", (Object)AbstractUselessCallInspection.Companion.getDeleteConversion()), TuplesKt.to((Object)"kotlin.collections.mapNotNull", (Object)new AbstractUselessCallInspection.Companion.Conversion("map")), TuplesKt.to((Object)"kotlin.collections.mapNotNullTo", (Object)new AbstractUselessCallInspection.Companion.Conversion("mapTo")), TuplesKt.to((Object)"kotlin.collections.mapIndexedNotNull", (Object)new AbstractUselessCallInspection.Companion.Conversion("mapIndexed")), TuplesKt.to((Object)"kotlin.collections.mapIndexedNotNullTo", (Object)new AbstractUselessCallInspection.Companion.Conversion("mapIndexedTo"))});
    @NotNull
    private final Set<String> uselessNames = AbstractUselessCallInspection.Companion.toShortNames(this.getUselessFqNames().keySet());

    @Override
    @NotNull
    protected Map<String, AbstractUselessCallInspection.Companion.Conversion> getUselessFqNames() {
        return this.uselessFqNames;
    }

    @Override
    @NotNull
    protected Set<String> getUselessNames() {
        return this.uselessNames;
    }

    @Override
    protected void suggestConversionIfNeeded(@NotNull AbstractUselessCallInspection.QualifiedExpressionVisitor $receiver, @NotNull KtQualifiedExpression expression2, @NotNull KtExpression calleeExpression2, @NotNull BindingContext context, @NotNull AbstractUselessCallInspection.Companion.Conversion conversion) {
        ProblemDescriptor descriptor2;
        String newName2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)calleeExpression2, (String)"calleeExpression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)conversion, (String)"conversion");
        KotlinType kotlinType = CallUtilKt.getType(expression2.getReceiverExpression(), context);
        if (kotlinType == null) {
            return;
        }
        KotlinType receiverType2 = kotlinType;
        Object object = (TypeProjection)CollectionsKt.singleOrNull(receiverType2.getArguments());
        if (object == null || (object = object.getType()) == null) {
            return;
        }
        Object receiverTypeArgument = object;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (Intrinsics.areEqual((Object)calleeExpression2.getText(), (Object)"filterIsInstance")) {
            List<TypeParameterDescriptor> list2 = resolvedCall3.getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.candidateDescriptor.typeParameters");
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.singleOrNull(list2);
            if (typeParameterDescriptor == null) {
                return;
            }
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            KotlinType kotlinType2 = resolvedCall3.getTypeArguments().get(typeParameterDescriptor2);
            if (kotlinType2 == null) {
                return;
            }
            KotlinType argumentType = kotlinType2;
            Object object2 = receiverTypeArgument;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"receiverTypeArgument");
            if (FlexibleTypesKt.isFlexible((KotlinType)object2) || !TypeUtilsKt.isSubtypeOf((KotlinType)receiverTypeArgument, argumentType)) {
                return;
            }
        } else {
            if (TypeUtils.isNullableType((KotlinType)receiverTypeArgument)) {
                return;
            }
            if (Intrinsics.areEqual((Object)calleeExpression2.getText(), (Object)"filterNotNull") ^ true && !FunctionUtilsKt.hasLastFunctionalParameterWithResult(resolvedCall3, context, (Function1<? super KotlinType, Boolean>)((Function1)suggestConversionIfNeeded.1.INSTANCE))) {
                return;
            }
        }
        if ((newName2 = conversion.getReplacementName()) != null) {
            descriptor2 = $receiver.getHolder().getManager().createProblemDescriptor((PsiElement)expression2, new TextRange(expression2.getOperationTokenNode().getStartOffset() - PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)calleeExpression2) - PsiUtilsKt.getStartOffset((PsiElement)expression2)), "Call on collection type may be reduced", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, $receiver.isOnTheFly(), new LocalQuickFix[]{new RenameUselessCallFix(newName2)});
            $receiver.getHolder().registerProblem(descriptor2);
        } else {
            descriptor2 = $receiver.getHolder().getManager().createProblemDescriptor((PsiElement)expression2, new TextRange(expression2.getOperationTokenNode().getStartOffset() - PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)calleeExpression2) - PsiUtilsKt.getStartOffset((PsiElement)expression2)), "Useless call on collection type", ProblemHighlightType.LIKE_UNUSED_SYMBOL, $receiver.isOnTheFly(), new LocalQuickFix[]{new RemoveUselessCallFix()});
            $receiver.getHolder().registerProblem(descriptor2);
        }
    }
}

