/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayOfWithLiteralInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceWithArrayLiteralFix", "idea"})
public final class ReplaceArrayOfWithLiteralInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                KtExpression ktExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitCallExpression(expression2);
                if (!PlatformKt.getLanguageVersionSettings(expression2).supportsFeature(LanguageFeature.ArrayLiteralsInAnnotations)) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode()) {
                        return;
                    }
                }
                if (!((ktExpression = expression2.getCalleeExpression()) instanceof KtNameReferenceExpression)) {
                    ktExpression = null;
                }
                KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                if (ktNameReferenceExpression == null) {
                    return;
                }
                KtNameReferenceExpression calleeExpression2 = ktNameReferenceExpression;
                if (!UtilsKt.isArrayOfMethod(expression2)) {
                    return;
                }
                PsiElement parent2 = expression2.getParent();
                PsiElement psiElement2 = parent2;
                if (psiElement2 instanceof KtValueArgument) {
                    PsiElement psiElement3 = ((KtValueArgument)parent2).getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"parent.parent");
                    PsiElement psiElement4 = psiElement3.getParent();
                    if (!(psiElement4 instanceof KtAnnotationEntry)) {
                        psiElement4 = null;
                    }
                    if ((KtAnnotationEntry)psiElement4 == null) {
                        return;
                    }
                } else if (psiElement2 instanceof KtParameter) {
                    PsiElement psiElement5 = ((KtParameter)parent2).getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"parent.parent");
                    PsiElement psiElement6 = psiElement5.getParent();
                    if (!(psiElement6 instanceof KtPrimaryConstructor)) {
                        psiElement6 = null;
                    }
                    KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)psiElement6;
                    if (ktPrimaryConstructor == null) {
                        return;
                    }
                    KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
                    KtClassOrObject containingClass = constructor2.getContainingClassOrObject();
                    if (!containingClass.isAnnotation()) {
                        return;
                    }
                } else {
                    return;
                }
                String calleeName = calleeExpression2.getReferencedName();
                this.$holder.registerProblem((PsiElement)calleeExpression2, '\'' + calleeName + "' call can be replaced with array literal [...]", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithArrayLiteralFix()});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayOfWithLiteralInspection$ReplaceWithArrayLiteralFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "idea"})
    private static final class ReplaceWithArrayLiteralFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return "Replace with [...]";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression calleeExpression2 = (KtExpression)psiElement2;
            PsiElement psiElement3 = calleeExpression2.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            KtCallExpression callExpression2 = (KtCallExpression)psiElement3;
            PsiElement psiElement4 = (PsiElement)callExpression2;
            boolean strict$iv = false;
            KtValueArgument valueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtValueArgument.class, (boolean)strict$iv);
            KtValueArgument ktValueArgument = valueArgument;
            if (ktValueArgument != null && (ktValueArgument = ktValueArgument.getSpreadElement()) != null) {
                ktValueArgument.delete();
            }
            List<KtValueArgument> arguments2 = callExpression2.getValueArguments();
            KtExpression ktExpression = CreateByPatternKt.buildExpression(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callExpression2, false, 2, null), (Function1<? super BuilderByPattern<KtExpression>, Unit>)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(arguments2){
                final /* synthetic */ List $arguments;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    $receiver.appendFixedText("[");
                    List list2 = this.$arguments;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"arguments");
                    for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)list2)) {
                        int index2 = indexedValue.component1();
                        KtValueArgument argument2 = (KtValueArgument)indexedValue.component2();
                        $receiver.appendExpression(argument2.getArgumentExpression());
                        if (index2 == this.$arguments.size() - 1) continue;
                        $receiver.appendFixedText(", ");
                    }
                    $receiver.appendFixedText("]");
                }
                {
                    this.$arguments = list2;
                    super(1);
                }
            }));
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCollectionLiteralExpression");
            }
            KtCollectionLiteralExpression arrayLiteral2 = (KtCollectionLiteralExpression)ktExpression;
            callExpression2.replace((PsiElement)arrayLiteral2);
        }
    }
}

