/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.NamingConventionOptionsPanel;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "entityName", "", "defaultNamePattern", "(Ljava/lang/String;Ljava/lang/String;)V", "value", "namePattern", "getNamePattern", "()Ljava/lang/String;", "setNamePattern", "(Ljava/lang/String;)V", "nameRegex", "Lkotlin/text/Regex;", "getNameRegex", "()Lkotlin/text/Regex;", "setNameRegex", "(Lkotlin/text/Regex;)V", "createOptionsPanel", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionOptionsPanel;", "verifyName", "", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "idea"})
public abstract class NamingConventionInspection
extends AbstractKotlinInspection {
    @Nullable
    private Regex nameRegex;
    @NotNull
    private String namePattern;
    private final String entityName;

    @Nullable
    protected final Regex getNameRegex() {
        return this.nameRegex;
    }

    protected final void setNameRegex(@Nullable Regex regex) {
        this.nameRegex = regex;
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String value2) {
        String string;
        NamingConventionInspection namingConventionInspection;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.namePattern = value2;
        NamingConventionInspection namingConventionInspection2 = this;
        try {
            namingConventionInspection = namingConventionInspection2;
            string = value2;
            string = new Regex(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            namingConventionInspection = namingConventionInspection2;
            string = null;
        }
        namingConventionInspection.nameRegex = string;
    }

    protected final void verifyName(@NotNull PsiNameIdentifierOwner element3, @NotNull ProblemsHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String name2 = element3.getName();
        PsiElement nameIdentifier = element3.getNameIdentifier();
        if (name2 != null && nameIdentifier != null) {
            Regex regex = this.nameRegex;
            if (regex != null) {
                if (!regex.matches((CharSequence)name2)) {
                    PsiElement psiElement2 = element3.getNameIdentifier();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    holder.registerProblem(psiElement2, "" + this.entityName + " name <code>#ref</code> doesn't match regex '" + this.namePattern + "' #loc", new LocalQuickFix[]{new RenameIdentifierFix()});
                }
            }
        }
    }

    @NotNull
    public NamingConventionOptionsPanel createOptionsPanel() {
        return new NamingConventionOptionsPanel(this);
    }

    public NamingConventionInspection(@NotNull String entityName, @NotNull String defaultNamePattern) {
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        Intrinsics.checkParameterIsNotNull((Object)defaultNamePattern, (String)"defaultNamePattern");
        this.entityName = entityName;
        String string = defaultNamePattern;
        this.nameRegex = new Regex(string);
        this.namePattern = defaultNamePattern;
    }
}

