/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertLambdaToReferenceIntention;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveSuspiciousCallableReferenceIntoParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "MoveIntoParenthesesIntention", "idea"})
public final class MoveSuspiciousCallableReferenceIntoParenthesesInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
                KtCallableReferenceExpression callableReference2;
                KtExpression ktExpression;
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
                Object object = lambdaExpression2.getBodyExpression();
                if (!((object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : (ktExpression = null)) instanceof KtCallableReferenceExpression)) {
                    ktExpression = null;
                }
                if ((callableReference2 = (KtCallableReferenceExpression)ktExpression) != null) {
                    BindingContext context = ResolutionUtils.analyze$default(lambdaExpression2, null, 1, null);
                    ResolvedCall parentResolvedCall = CallUtilKt.getParentResolvedCall$default(lambdaExpression2, context, false, 2, null);
                    if (parentResolvedCall != null) {
                        ValueParameterDescriptor originalParameterDescriptor;
                        PsiElement psiElement2 = lambdaExpression2.getParent();
                        if (!(psiElement2 instanceof ValueArgument)) {
                            psiElement2 = null;
                        }
                        ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(parentResolvedCall, (ValueArgument)psiElement2);
                        ValueParameterDescriptor valueParameterDescriptor2 = originalParameterDescriptor = valueParameterDescriptor != null ? valueParameterDescriptor.getOriginal() : null;
                        if (originalParameterDescriptor != null) {
                            KotlinType returnType2;
                            KotlinType expectedType2;
                            KotlinType kotlinType = expectedType2 = originalParameterDescriptor.getType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"expectedType");
                            if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType) && FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(returnType2 = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType2))) {
                                return;
                            }
                        }
                    }
                    this.$holder.registerProblem((PsiElement)lambdaExpression2, "Suspicious callable reference as the only lambda element", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new MoveIntoParenthesesIntention(), lambdaExpression2.getContainingFile())});
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveSuspiciousCallableReferenceIntoParenthesesInspection$MoveIntoParenthesesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertLambdaToReferenceIntention;", "()V", "buildReferenceText", "", "element", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isApplicableTo", "", "idea"})
    public static final class MoveIntoParenthesesIntention
    extends ConvertLambdaToReferenceIntention {
        @Override
        @Nullable
        public String buildReferenceText(@NotNull KtLambdaExpression element3) {
            Object object;
            StringBuilder stringBuilder;
            KtSimpleNameExpression callableReference2;
            block10: {
                block9: {
                    ReceiverValue receiverValue;
                    Object it;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                    KtExpression ktExpression;
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    Object object2 = element3.getBodyExpression();
                    if (!((object2 != null && (object2 = ((KtBlockExpression)object2).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object2) : (ktExpression = null)) instanceof KtCallableReferenceExpression)) {
                        ktExpression = null;
                    }
                    KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)ktExpression;
                    if (ktCallableReferenceExpression == null) {
                        return null;
                    }
                    KtCallableReferenceExpression callableReferenceExpression = ktCallableReferenceExpression;
                    callableReference2 = callableReferenceExpression.getCallableReference();
                    KtElement ktElement = callableReference2;
                    KtSimpleNameExpression ktSimpleNameExpression = callableReference2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"callableReference");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall4 = resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, ResolutionUtils.analyze$default(ktSimpleNameExpression, null, 1, null));
                    if (resolvedCall4 != null) {
                        resolvedCall2 = resolvedCall4;
                        it = resolvedCall2;
                        receiverValue = it.getExtensionReceiver();
                        if (receiverValue == null) {
                            receiverValue = it.getDispatchReceiver();
                        }
                    } else {
                        receiverValue = null;
                    }
                    ReceiverValue receiverValue2 = receiverValue;
                    stringBuilder = new StringBuilder();
                    object = receiverValue2;
                    if (object == null) break block9;
                    it = resolvedCall2 = object;
                    StringBuilder stringBuilder2 = stringBuilder;
                    String string = "" + it.getType();
                    stringBuilder = stringBuilder2;
                    object = string;
                    if (object != null) break block10;
                }
                object = "";
            }
            return stringBuilder.append((String)object).append("::").append(callableReference2.getText()).toString();
        }

        @Override
        public boolean isApplicableTo(@NotNull KtLambdaExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            return true;
        }

        public MoveIntoParenthesesIntention() {
            super("Move suspicious callable reference into parentheses '()'");
        }
    }
}

