/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/HasPlatformTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "publicAPIOnly", "", "reportPlatformArguments", "(ZZ)V", "problemText", "", "getProblemText", "()Ljava/lang/String;", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "createOptionsPanel", "Ljavax/swing/JComponent;", "inspectionTarget", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class HasPlatformTypeInspection
extends IntentionBasedInspection<KtCallableDeclaration> {
    @NotNull
    private final String problemText = "Declaration has type inferred from a platform call, which can lead to unchecked nullability issues. Specify type explicitly as nullable or non-nullable.";
    @JvmField
    public boolean publicAPIOnly;
    @JvmField
    public boolean reportPlatformArguments;

    @Override
    @NotNull
    protected String getProblemText() {
        return this.problemText;
    }

    @Override
    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtCallableDeclaration element3) {
        block4: {
            PsiElement expression2;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KotlinType kotlinType = SpecifyTypeExplicitlyIntention.Companion.dangerousFlexibleTypeOrNull(element3, this.publicAPIOnly, this.reportPlatformArguments);
                if (kotlinType == null) {
                    return null;
                }
                KotlinType type2 = kotlinType;
                if (!TypeUtils.isNullableType(type2)) break block4;
                ASTNode aSTNode = element3.getNode().findChildByType((IElementType)KtTokens.EQ);
                PsiElement psiElement2 = aSTNode != null && (aSTNode = aSTNode.getPsi()) != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)aSTNode, false, 1, null) : (expression2 = null);
                if (expression2 == null) break block4;
                if (!this.reportPlatformArguments) break block5;
                KotlinType kotlinType2 = TypeUtils.makeNotNullable(type2);
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"TypeUtils.makeNotNullable(type)");
                if (UtilsKt.isFlexibleRecursive(kotlinType2)) break block4;
            }
            return CollectionsKt.listOf((Object)new IntentionWrapper((IntentionAction)new AddExclExclCallFix(expression2), element3.getContainingFile()));
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement inspectionTarget(@NotNull KtCallableDeclaration element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3.getNameIdentifier();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Apply only to public or protected members", "publicAPIOnly");
        panel.addCheckbox("Report for types with platform arguments", "reportPlatformArguments");
        return (JComponent)panel;
    }

    public HasPlatformTypeInspection(boolean publicAPIOnly, boolean reportPlatformArguments) {
        super(Reflection.getOrCreateKotlinClass(SpecifyTypeExplicitlyIntention.class), 1.INSTANCE, null, 4, null);
        this.publicAPIOnly = publicAPIOnly;
        this.reportPlatformArguments = reportPlatformArguments;
        this.problemText = "Declaration has type inferred from a platform call, which can lead to unchecked nullability issues. Specify type explicitly as nullable or non-nullable.";
    }

    public /* synthetic */ HasPlatformTypeInspection(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public HasPlatformTypeInspection() {
        this(false, false, 3, null);
    }
}

