/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;

public class KotlinHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<IElementType, TextAttributesKey> keys2 = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new KotlinHighlightingLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        return KotlinHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
    }

    static {
        KotlinHighlighter.fillMap(keys1, (TokenSet)KtTokens.KEYWORDS, (TextAttributesKey)KotlinHighlightingColors.KEYWORD);
        keys1.put(KtTokens.AS_SAFE, KotlinHighlightingColors.KEYWORD);
        keys1.put(KtTokens.INTEGER_LITERAL, KotlinHighlightingColors.NUMBER);
        keys1.put(KtTokens.FLOAT_LITERAL, KotlinHighlightingColors.NUMBER);
        KotlinHighlighter.fillMap(keys1, (TokenSet)TokenSet.andNot((TokenSet)KtTokens.OPERATIONS, (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.AT}), KtTokens.KEYWORDS})), (TextAttributesKey)KotlinHighlightingColors.OPERATOR_SIGN);
        keys1.put(KtTokens.LPAR, KotlinHighlightingColors.PARENTHESIS);
        keys1.put(KtTokens.RPAR, KotlinHighlightingColors.PARENTHESIS);
        keys1.put(KtTokens.LBRACE, KotlinHighlightingColors.BRACES);
        keys1.put(KtTokens.RBRACE, KotlinHighlightingColors.BRACES);
        keys1.put(KtTokens.LBRACKET, KotlinHighlightingColors.BRACKETS);
        keys1.put(KtTokens.RBRACKET, KotlinHighlightingColors.BRACKETS);
        keys1.put(KtTokens.COMMA, KotlinHighlightingColors.COMMA);
        keys1.put(KtTokens.SEMICOLON, KotlinHighlightingColors.SEMICOLON);
        keys1.put(KtTokens.COLON, KotlinHighlightingColors.COLON);
        keys1.put(KtTokens.COLONCOLON, KotlinHighlightingColors.DOUBLE_COLON);
        keys1.put(KtTokens.DOT, KotlinHighlightingColors.DOT);
        keys1.put(KtTokens.ARROW, KotlinHighlightingColors.ARROW);
        keys1.put(KtTokens.OPEN_QUOTE, KotlinHighlightingColors.STRING);
        keys1.put(KtTokens.CLOSING_QUOTE, KotlinHighlightingColors.STRING);
        keys1.put(KtTokens.REGULAR_STRING_PART, KotlinHighlightingColors.STRING);
        keys1.put(KtTokens.LONG_TEMPLATE_ENTRY_END, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put(KtTokens.LONG_TEMPLATE_ENTRY_START, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put(KtTokens.SHORT_TEMPLATE_ENTRY_START, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put(KtTokens.ESCAPE_SEQUENCE, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put(KtTokens.CHARACTER_LITERAL, KotlinHighlightingColors.STRING);
        keys1.put(KtTokens.EOL_COMMENT, KotlinHighlightingColors.LINE_COMMENT);
        keys1.put(KtTokens.SHEBANG_COMMENT, KotlinHighlightingColors.LINE_COMMENT);
        keys1.put(KtTokens.BLOCK_COMMENT, KotlinHighlightingColors.BLOCK_COMMENT);
        keys1.put(KtTokens.DOC_COMMENT, KotlinHighlightingColors.DOC_COMMENT);
        KotlinHighlighter.fillMap(keys1, (TokenSet)KDocTokens.KDOC_HIGHLIGHT_TOKENS, (TextAttributesKey)KotlinHighlightingColors.DOC_COMMENT);
        keys1.put(KDocTokens.TAG_NAME, KotlinHighlightingColors.DOC_COMMENT);
        keys2.put(KDocTokens.TAG_NAME, KotlinHighlightingColors.KDOC_TAG);
        keys1.put(TokenType.BAD_CHARACTER, KotlinHighlightingColors.BAD_CHARACTER);
    }
}

