/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class DuplicateJvmSignatureAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
        GlobalSearchScope moduleScope;
        if (!(element3 instanceof KtFile) && !(element3 instanceof KtDeclaration)) {
            return;
        }
        if (!ProjectRootsUtil.isInProjectSource(element3)) {
            return;
        }
        PsiFile file2 = element3.getContainingFile();
        if (!(file2 instanceof KtFile) || TargetPlatformDetector.getPlatform((KtFile)file2) != JvmPlatform.INSTANCE) {
            return;
        }
        Diagnostics otherDiagnostics = ResolutionUtils.analyzeFully((KtElement)element3).getDiagnostics();
        Diagnostics diagnostics = DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics(element3, otherDiagnostics, moduleScope = GetModuleInfoKt.getModuleInfo(element3).contentScope());
        if (diagnostics == null) {
            return;
        }
        new KotlinPsiChecker().annotateElement(element3, holder, diagnostics);
    }
}

