/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.WrappingStrategy;
import org.jetbrains.kotlin.kdoc.lexer.KDocToken;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001e\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a8\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0014\u0010%\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010$H\u0002\u001a\u0014\u0010'\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010$H\u0002\u001a\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u001d2\b\b\u0002\u0010,\u001a\u00020\u001bH\u0002\u001a\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00012\b\b\u0002\u0010,\u001a\u00020\u001bH\u0002\u001a\u0010\u0010.\u001a\u00020)2\u0006\u0010*\u001a\u00020\nH\u0002\u001a\f\u0010/\u001a\u00020\u001b*\u00020$H\u0002\u001a\f\u00100\u001a\u00020\u001b*\u00020$H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"ALIGN_FOR_BINARY_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "ANNOTATIONS", "BINARY_EXPRESSIONS", "CODE_BLOCKS", "INDENT_RULES", "", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "[Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "KDOC_COMMENT_INDENT", "", "KDOC_CONTENT", "QUALIFIED_OPERATION", "kotlinSettings", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getKotlinSettings", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "findNodeBlockIndex", "blocks", "", "Lcom/intellij/formatting/Block;", "tokenSet", "getAlignmentForChildInParenthesis", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "shouldAlignChild", "", "parameter", "Lcom/intellij/psi/tree/IElementType;", "delimiter", "shouldAlignParenthesis", "openBracket", "closeBracket", "getOperationType", "node", "Lcom/intellij/lang/ASTNode;", "getPrevWithoutWhitespace", "pNode", "getPrevWithoutWhitespaceAndComments", "getWrappingStrategyForItemList", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "wrapType", "itemType", "wrapFirstElement", "itemTypes", "wrapAfterAnnotation", "isFirstParameter", "startsWithAnnotation", "formatter"})
public final class KotlinCommonBlockKt {
    private static final TokenSet QUALIFIED_OPERATION = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS});
    private static final int KDOC_COMMENT_INDENT = 1;
    private static final TokenSet BINARY_EXPRESSIONS;
    private static final TokenSet KDOC_CONTENT;
    private static final TokenSet CODE_BLOCKS;
    private static final TokenSet ALIGN_FOR_BINARY_OPERATIONS;
    private static final TokenSet ANNOTATIONS;
    private static final NodeIndentStrategy[] INDENT_RULES;

    public static final KotlinCodeStyleSettings getKotlinSettings(@NotNull CodeStyleSettings $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (KotlinCodeStyleSettings)$receiver.getCustomSettings(KotlinCodeStyleSettings.class);
    }

    private static final boolean startsWithAnnotation(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getFirstChildNode();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.ANNOTATION_ENTRY);
    }

    private static final boolean isFirstParameter(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getTreePrev();
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.LPAR));
    }

    private static final WrappingStrategy wrapAfterAnnotation(int wrapType) {
        return new WrappingStrategy(wrapType){
            final /* synthetic */ int $wrapType;

            @Nullable
            public Wrap getWrap(@NotNull ASTNode childElement) {
                ASTNode aSTNode;
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                if (KtTokens.COMMENTS.contains(childElement.getElementType())) {
                    return null;
                }
                ASTNode prevLeaf2 = childElement.getTreePrev();
                while (true) {
                    ASTNode aSTNode2 = prevLeaf2;
                    if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)TokenType.WHITE_SPACE)) break;
                    ASTNode aSTNode3 = prevLeaf2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"prevLeaf");
                    prevLeaf2 = aSTNode3.getTreePrev();
                }
                ASTNode aSTNode4 = prevLeaf2;
                if (Intrinsics.areEqual((Object)(aSTNode4 != null ? aSTNode4.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST) && KotlinCommonBlockKt.access$getANNOTATIONS$p().contains((aSTNode = prevLeaf2) != null && (aSTNode = aSTNode.getLastChildNode()) != null ? aSTNode.getElementType() : null)) {
                    return Wrap.createWrap((int)this.$wrapType, (boolean)true);
                }
                return null;
            }
            {
                this.$wrapType = $captured_local_variable$0;
            }
        };
    }

    private static final IElementType getOperationType(ASTNode node) {
        ASTNode aSTNode = node.findChildByType((IElementType)KtNodeTypes.OPERATION_REFERENCE);
        return aSTNode != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null;
    }

    private static final CommonAlignmentStrategy getAlignmentForChildInParenthesis(boolean shouldAlignChild, IElementType parameter, IElementType delimiter, boolean shouldAlignParenthesis, IElementType openBracket, IElementType closeBracket) {
        Alignment parameterAlignment = shouldAlignChild ? Alignment.createAlignment() : null;
        Alignment bracketsAlignment = shouldAlignParenthesis ? Alignment.createAlignment() : null;
        return new CommonAlignmentStrategy(parameterAlignment, openBracket, closeBracket, bracketsAlignment, parameter, delimiter){
            final /* synthetic */ Alignment $parameterAlignment;
            final /* synthetic */ IElementType $openBracket;
            final /* synthetic */ IElementType $closeBracket;
            final /* synthetic */ Alignment $bracketsAlignment;
            final /* synthetic */ IElementType $parameter;
            final /* synthetic */ IElementType $delimiter;

            @Nullable
            public Alignment getAlignment(@NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                IElementType childNodeType = node.getElementType();
                ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                    return this.$parameterAlignment;
                }
                if (childNodeType == this.$openBracket || childNodeType == this.$closeBracket) {
                    return this.$bracketsAlignment;
                }
                if (childNodeType == this.$parameter || childNodeType == this.$delimiter) {
                    return this.$parameterAlignment;
                }
                return null;
            }
            {
                this.$parameterAlignment = $captured_local_variable$0;
                this.$openBracket = $captured_local_variable$1;
                this.$closeBracket = $captured_local_variable$2;
                this.$bracketsAlignment = $captured_local_variable$3;
                this.$parameter = $captured_local_variable$4;
                this.$delimiter = $captured_local_variable$5;
            }
        };
    }

    private static final ASTNode getPrevWithoutWhitespace(ASTNode pNode) {
        ASTNode node = pNode;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        for (node = (v651282).getTreePrev(); node != null && node.getElementType() == TokenType.WHITE_SPACE; node = node.getTreePrev()) {
        }
        return node;
    }

    private static final ASTNode getPrevWithoutWhitespaceAndComments(ASTNode pNode) {
        ASTNode node = pNode;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        for (node = (v651297).getTreePrev(); node != null && (node.getElementType() == TokenType.WHITE_SPACE || KtTokens.COMMENTS.contains(node.getElementType())); node = node.getTreePrev()) {
        }
        return node;
    }

    private static final WrappingStrategy getWrappingStrategyForItemList(int wrapType, IElementType itemType, boolean wrapFirstElement) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)wrapFirstElement);
        return new WrappingStrategy(itemType, itemWrap){
            final /* synthetic */ IElementType $itemType;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public Wrap getWrap(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                return childElement.getElementType() == this.$itemType ? this.$itemWrap : null;
            }
            {
                this.$itemType = $captured_local_variable$0;
                this.$itemWrap = $captured_local_variable$1;
            }
        };
    }

    static /* bridge */ /* synthetic */ WrappingStrategy getWrappingStrategyForItemList$default(int n, IElementType iElementType, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(n, iElementType, bl);
    }

    private static final WrappingStrategy getWrappingStrategyForItemList(int wrapType, TokenSet itemTypes, boolean wrapFirstElement) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)wrapFirstElement);
        return new WrappingStrategy(itemTypes, itemWrap){
            final /* synthetic */ TokenSet $itemTypes;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public Wrap getWrap(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                return this.$itemTypes.contains(childElement.getElementType()) ? this.$itemWrap : null;
            }
            {
                this.$itemTypes = $captured_local_variable$0;
                this.$itemWrap = $captured_local_variable$1;
            }
        };
    }

    static /* bridge */ /* synthetic */ WrappingStrategy getWrappingStrategyForItemList$default(int n, TokenSet tokenSet, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(n, tokenSet, bl);
    }

    private static final int findNodeBlockIndex(List<? extends Block> blocks, TokenSet tokenSet) {
        int n;
        block2: {
            List<? extends Block> $receiver$iv = blocks;
            int index$iv = 0;
            for (Block block : $receiver$iv) {
                ASTNode node;
                Block block2 = block;
                boolean bl = !(block2 instanceof ASTBlock) ? false : (node = ((ASTBlock)block2).getNode()) != null && tokenSet.contains(node.getElementType());
                if (bl) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    static {
        KDOC_COMMENT_INDENT = 1;
        BINARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.IS_EXPRESSION});
        KDOC_CONTENT = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KDocTokens.KDOC, KDocElementTypes.KDOC_SECTION, KDocElementTypes.KDOC_TAG});
        CODE_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL});
        ALIGN_FOR_BINARY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.PLUS, KtTokens.MINUS, KtTokens.ELVIS, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.ANDAND, KtTokens.OROR});
        ANNOTATIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATION});
        NodeIndentStrategy[] nodeIndentStrategyArray = new NodeIndentStrategy[21];
        NodeIndentStrategy.PositionStrategy positionStrategy = NodeIndentStrategy.Companion.strategy("No indent for braces in blocks");
        KtNodeType ktNodeType = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType = ktNodeType;
        IElementType[] iElementTypeArray = new IElementType[2];
        IElementType iElementType2 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"KtNodeTypes.CLASS_BODY");
        iElementTypeArray[0] = iElementType2;
        KtNodeType ktNodeType2 = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType2), (String)"KtNodeTypes.FUNCTION_LITERAL");
        iElementTypeArray[1] = ktNodeType2;
        NodeIndentStrategy.PositionStrategy positionStrategy2 = positionStrategy.within(iElementType, iElementTypeArray);
        KtSingleValueToken ktSingleValueToken = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"RBRACE");
        IElementType iElementType3 = ktSingleValueToken;
        IElementType[] iElementTypeArray2 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken2 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"LBRACE");
        iElementTypeArray2[0] = ktSingleValueToken2;
        NodeIndentStrategy.PositionStrategy positionStrategy3 = positionStrategy2.forType(iElementType3, iElementTypeArray2);
        Indent indent = Indent.getNoneIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent, (String)"Indent.getNoneIndent()");
        nodeIndentStrategyArray[0] = positionStrategy3.set(indent);
        NodeIndentStrategy.PositionStrategy positionStrategy4 = NodeIndentStrategy.Companion.strategy("Indent for block content");
        KtNodeType ktNodeType3 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType3), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType4 = ktNodeType3;
        IElementType[] iElementTypeArray3 = new IElementType[2];
        IElementType iElementType5 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType5, (String)"KtNodeTypes.CLASS_BODY");
        iElementTypeArray3[0] = iElementType5;
        KtNodeType ktNodeType4 = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType4), (String)"KtNodeTypes.FUNCTION_LITERAL");
        iElementTypeArray3[1] = ktNodeType4;
        NodeIndentStrategy.PositionStrategy positionStrategy5 = positionStrategy4.within(iElementType4, iElementTypeArray3);
        KtSingleValueToken ktSingleValueToken3 = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"RBRACE");
        IElementType iElementType6 = ktSingleValueToken3;
        IElementType[] iElementTypeArray4 = new IElementType[2];
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken4), (String)"LBRACE");
        iElementTypeArray4[0] = ktSingleValueToken4;
        KtNodeType ktNodeType5 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType5), (String)"KtNodeTypes.BLOCK");
        iElementTypeArray4[1] = ktNodeType5;
        NodeIndentStrategy.PositionStrategy positionStrategy6 = positionStrategy5.notForType(iElementType6, iElementTypeArray4);
        Indent indent2 = Indent.getNormalIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent2, (String)"Indent.getNormalIndent(false)");
        nodeIndentStrategyArray[1] = positionStrategy6.set(indent2);
        NodeIndentStrategy.PositionStrategy positionStrategy7 = NodeIndentStrategy.Companion.strategy("Indent for property accessors");
        IElementType iElementType7 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType7, (String)"KtNodeTypes.PROPERTY");
        NodeIndentStrategy.PositionStrategy positionStrategy8 = positionStrategy7.within(iElementType7, new IElementType[0]);
        IElementType iElementType8 = KtNodeTypes.PROPERTY_ACCESSOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType8, (String)"KtNodeTypes.PROPERTY_ACCESSOR");
        NodeIndentStrategy.PositionStrategy positionStrategy9 = positionStrategy8.forType(iElementType8, new IElementType[0]);
        Indent indent3 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent3, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[2] = positionStrategy9.set(indent3);
        NodeIndentStrategy.PositionStrategy positionStrategy10 = NodeIndentStrategy.Companion.strategy("For a single statement in 'for'");
        KtNodeType ktNodeType6 = KtNodeTypes.BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType6), (String)"KtNodeTypes.BODY");
        NodeIndentStrategy.PositionStrategy positionStrategy11 = positionStrategy10.within(ktNodeType6, new IElementType[0]);
        KtNodeType ktNodeType7 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType7), (String)"KtNodeTypes.BLOCK");
        NodeIndentStrategy.PositionStrategy positionStrategy12 = positionStrategy11.notForType(ktNodeType7, new IElementType[0]);
        Indent indent4 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent4, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[3] = positionStrategy12.set(indent4);
        NodeIndentStrategy.PositionStrategy positionStrategy13 = NodeIndentStrategy.Companion.strategy("For the entry in when");
        KtNodeType ktNodeType8 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType8), (String)"KtNodeTypes.WHEN_ENTRY");
        NodeIndentStrategy.PositionStrategy positionStrategy14 = positionStrategy13.forType(ktNodeType8, new IElementType[0]);
        Indent indent5 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent5, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[4] = positionStrategy14.set(indent5);
        NodeIndentStrategy.PositionStrategy positionStrategy15 = NodeIndentStrategy.Companion.strategy("For single statement in THEN and ELSE");
        KtNodeType ktNodeType9 = KtNodeTypes.THEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType9), (String)"KtNodeTypes.THEN");
        IElementType iElementType9 = ktNodeType9;
        IElementType[] iElementTypeArray5 = new IElementType[1];
        KtNodeType ktNodeType10 = KtNodeTypes.ELSE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType10), (String)"KtNodeTypes.ELSE");
        iElementTypeArray5[0] = ktNodeType10;
        NodeIndentStrategy.PositionStrategy positionStrategy16 = positionStrategy15.within(iElementType9, iElementTypeArray5);
        KtNodeType ktNodeType11 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType11), (String)"KtNodeTypes.BLOCK");
        NodeIndentStrategy.PositionStrategy positionStrategy17 = positionStrategy16.notForType(ktNodeType11, new IElementType[0]);
        Indent indent6 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent6, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[5] = positionStrategy17.set(indent6);
        NodeIndentStrategy.PositionStrategy positionStrategy18 = NodeIndentStrategy.Companion.strategy("Expression body");
        IElementType iElementType10 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType10, (String)"KtNodeTypes.FUN");
        nodeIndentStrategyArray[6] = positionStrategy18.within(iElementType10, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.1.INSTANCE)).set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)INDENT_RULES.2.INSTANCE));
        NodeIndentStrategy.PositionStrategy positionStrategy19 = NodeIndentStrategy.Companion.strategy("Property accessor expression body");
        IElementType iElementType11 = KtNodeTypes.PROPERTY_ACCESSOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType11, (String)"KtNodeTypes.PROPERTY_ACCESSOR");
        NodeIndentStrategy.PositionStrategy positionStrategy20 = positionStrategy19.within(iElementType11, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.3.INSTANCE));
        Indent indent7 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent7, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[7] = positionStrategy20.set(indent7);
        NodeIndentStrategy.PositionStrategy positionStrategy21 = NodeIndentStrategy.Companion.strategy("Indent for parts");
        IElementType iElementType12 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType12, (String)"KtNodeTypes.PROPERTY");
        IElementType[] iElementTypeArray6 = new IElementType[3];
        IElementType iElementType13 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType13, (String)"KtNodeTypes.FUN");
        iElementTypeArray6[0] = iElementType13;
        IElementType iElementType14 = KtNodeTypes.DESTRUCTURING_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType14, (String)"KtNodeTypes.DESTRUCTURING_DECLARATION");
        iElementTypeArray6[1] = iElementType14;
        IElementType iElementType15 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType15, (String)"KtNodeTypes.SECONDARY_CONSTRUCTOR");
        iElementTypeArray6[2] = iElementType15;
        NodeIndentStrategy.PositionStrategy positionStrategy22 = positionStrategy21.within(iElementType12, iElementTypeArray6);
        KtNodeType ktNodeType12 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType12), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType16 = ktNodeType12;
        IElementType[] iElementTypeArray7 = new IElementType[4];
        KtKeywordToken ktKeywordToken = KtTokens.FUN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"FUN_KEYWORD");
        iElementTypeArray7[0] = ktKeywordToken;
        KtKeywordToken ktKeywordToken2 = KtTokens.VAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken2), (String)"VAL_KEYWORD");
        iElementTypeArray7[1] = ktKeywordToken2;
        KtKeywordToken ktKeywordToken3 = KtTokens.VAR_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken3), (String)"VAR_KEYWORD");
        iElementTypeArray7[2] = ktKeywordToken3;
        KtKeywordToken ktKeywordToken4 = KtTokens.CONSTRUCTOR_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken4), (String)"CONSTRUCTOR_KEYWORD");
        iElementTypeArray7[3] = ktKeywordToken4;
        NodeIndentStrategy.PositionStrategy positionStrategy23 = positionStrategy22.notForType(iElementType16, iElementTypeArray7);
        Indent indent8 = Indent.getContinuationWithoutFirstIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent8, (String)"Indent.getContinuationWithoutFirstIndent()");
        nodeIndentStrategyArray[8] = positionStrategy23.set(indent8);
        NodeIndentStrategy.PositionStrategy positionStrategy24 = NodeIndentStrategy.Companion.strategy("Chained calls");
        IElementType iElementType17 = KtNodeTypes.DOT_QUALIFIED_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType17, (String)"KtNodeTypes.DOT_QUALIFIED_EXPRESSION");
        IElementType[] iElementTypeArray8 = new IElementType[1];
        KtNodeType ktNodeType13 = KtNodeTypes.SAFE_ACCESS_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType13), (String)"KtNodeTypes.SAFE_ACCESS_EXPRESSION");
        iElementTypeArray8[0] = ktNodeType13;
        NodeIndentStrategy.PositionStrategy positionStrategy25 = positionStrategy24.within(iElementType17, iElementTypeArray8);
        KtSingleValueToken ktSingleValueToken5 = KtTokens.DOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken5), (String)"KtTokens.DOT");
        IElementType iElementType18 = ktSingleValueToken5;
        IElementType[] iElementTypeArray9 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken6 = KtTokens.SAFE_ACCESS;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken6), (String)"KtTokens.SAFE_ACCESS");
        iElementTypeArray9[0] = ktSingleValueToken6;
        nodeIndentStrategyArray[9] = positionStrategy25.notForType(iElementType18, iElementTypeArray9).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.4.INSTANCE)).set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)INDENT_RULES.5.INSTANCE));
        NodeIndentStrategy.PositionStrategy positionStrategy26 = NodeIndentStrategy.Companion.strategy("Colon of delegation list");
        IElementType iElementType19 = KtNodeTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType19, (String)"KtNodeTypes.CLASS");
        IElementType[] iElementTypeArray10 = new IElementType[1];
        IElementType iElementType20 = KtNodeTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType20, (String)"KtNodeTypes.OBJECT_DECLARATION");
        iElementTypeArray10[0] = iElementType20;
        NodeIndentStrategy.PositionStrategy positionStrategy27 = positionStrategy26.within(iElementType19, iElementTypeArray10);
        KtSingleValueToken ktSingleValueToken7 = KtTokens.COLON;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken7), (String)"KtTokens.COLON");
        NodeIndentStrategy.PositionStrategy positionStrategy28 = positionStrategy27.forType(ktSingleValueToken7, new IElementType[0]);
        Indent indent9 = Indent.getNormalIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent9, (String)"Indent.getNormalIndent(false)");
        nodeIndentStrategyArray[10] = positionStrategy28.set(indent9);
        NodeIndentStrategy.PositionStrategy positionStrategy29 = NodeIndentStrategy.Companion.strategy("Delegation list");
        IElementType iElementType21 = KtNodeTypes.SUPER_TYPE_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType21, (String)"KtNodeTypes.SUPER_TYPE_LIST");
        IElementType[] iElementTypeArray11 = new IElementType[1];
        IElementType iElementType22 = KtNodeTypes.INITIALIZER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType22, (String)"KtNodeTypes.INITIALIZER_LIST");
        iElementTypeArray11[0] = iElementType22;
        NodeIndentStrategy.PositionStrategy positionStrategy30 = positionStrategy29.within(iElementType21, iElementTypeArray11);
        Indent indent10 = Indent.getContinuationIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent10, (String)"Indent.getContinuationIndent(false)");
        nodeIndentStrategyArray[11] = positionStrategy30.set(indent10);
        NodeIndentStrategy.PositionStrategy positionStrategy31 = NodeIndentStrategy.Companion.strategy("Indices");
        KtNodeType ktNodeType14 = KtNodeTypes.INDICES;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType14), (String)"KtNodeTypes.INDICES");
        NodeIndentStrategy.PositionStrategy positionStrategy32 = positionStrategy31.within(ktNodeType14, new IElementType[0]);
        Indent indent11 = Indent.getContinuationIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent11, (String)"Indent.getContinuationIndent(false)");
        nodeIndentStrategyArray[12] = positionStrategy32.set(indent11);
        NodeIndentStrategy.PositionStrategy positionStrategy33 = NodeIndentStrategy.Companion.strategy("Binary expressions");
        TokenSet tokenSet = BINARY_EXPRESSIONS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"BINARY_EXPRESSIONS");
        NodeIndentStrategy.PositionStrategy positionStrategy34 = positionStrategy33.within(tokenSet);
        Indent indent12 = Indent.getContinuationWithoutFirstIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent12, (String)"Indent.getContinuationWithoutFirstIndent(false)");
        nodeIndentStrategyArray[13] = positionStrategy34.set(indent12);
        NodeIndentStrategy.PositionStrategy positionStrategy35 = NodeIndentStrategy.Companion.strategy("Parenthesized expression");
        KtNodeType ktNodeType15 = KtNodeTypes.PARENTHESIZED;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType15), (String)"KtNodeTypes.PARENTHESIZED");
        NodeIndentStrategy.PositionStrategy positionStrategy36 = positionStrategy35.within(ktNodeType15, new IElementType[0]);
        Indent indent13 = Indent.getContinuationWithoutFirstIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent13, (String)"Indent.getContinuationWithoutFirstIndent(false)");
        nodeIndentStrategyArray[14] = positionStrategy36.set(indent13);
        NodeIndentStrategy.PositionStrategy positionStrategy37 = NodeIndentStrategy.Companion.strategy("Round Brackets around conditions");
        KtSingleValueToken ktSingleValueToken8 = KtTokens.LPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken8), (String)"LPAR");
        IElementType iElementType23 = ktSingleValueToken8;
        IElementType[] iElementTypeArray12 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken9 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken9), (String)"RPAR");
        iElementTypeArray12[0] = ktSingleValueToken9;
        NodeIndentStrategy.PositionStrategy positionStrategy38 = positionStrategy37.forType(iElementType23, iElementTypeArray12);
        KtNodeType ktNodeType16 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType16), (String)"KtNodeTypes.IF");
        IElementType iElementType24 = ktNodeType16;
        IElementType[] iElementTypeArray13 = new IElementType[3];
        KtNodeType ktNodeType17 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType17), (String)"KtNodeTypes.WHEN_ENTRY");
        iElementTypeArray13[0] = ktNodeType17;
        KtNodeType ktNodeType18 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType18), (String)"KtNodeTypes.WHILE");
        iElementTypeArray13[1] = ktNodeType18;
        KtNodeType ktNodeType19 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType19), (String)"KtNodeTypes.DO_WHILE");
        iElementTypeArray13[2] = ktNodeType19;
        NodeIndentStrategy.PositionStrategy positionStrategy39 = positionStrategy38.within(iElementType24, iElementTypeArray13);
        Indent indent14 = Indent.getContinuationWithoutFirstIndent((boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent14, (String)"Indent.getContinuationWithoutFirstIndent(true)");
        nodeIndentStrategyArray[15] = positionStrategy39.set(indent14);
        NodeIndentStrategy.PositionStrategy positionStrategy40 = NodeIndentStrategy.Companion.strategy("KDoc comment indent");
        TokenSet tokenSet2 = KDOC_CONTENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"KDOC_CONTENT");
        NodeIndentStrategy.PositionStrategy positionStrategy41 = positionStrategy40.within(tokenSet2);
        KDocToken kDocToken = KDocTokens.LEADING_ASTERISK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kDocToken), (String)"KDocTokens.LEADING_ASTERISK");
        IElementType iElementType25 = kDocToken;
        IElementType[] iElementTypeArray14 = new IElementType[1];
        KDocToken kDocToken2 = KDocTokens.END;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kDocToken2), (String)"KDocTokens.END");
        iElementTypeArray14[0] = kDocToken2;
        NodeIndentStrategy.PositionStrategy positionStrategy42 = positionStrategy41.forType(iElementType25, iElementTypeArray14);
        Indent indent15 = Indent.getSpaceIndent((int)KDOC_COMMENT_INDENT);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent15, (String)"Indent.getSpaceIndent(KDOC_COMMENT_INDENT)");
        nodeIndentStrategyArray[16] = positionStrategy42.set(indent15);
        NodeIndentStrategy.PositionStrategy positionStrategy43 = NodeIndentStrategy.Companion.strategy("Block in when entry");
        KtNodeType ktNodeType20 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType20), (String)"KtNodeTypes.WHEN_ENTRY");
        NodeIndentStrategy.PositionStrategy positionStrategy44 = positionStrategy43.within(ktNodeType20, new IElementType[0]);
        KtNodeType ktNodeType21 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType21), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType26 = ktNodeType21;
        IElementType[] iElementTypeArray15 = new IElementType[5];
        KtNodeType ktNodeType22 = KtNodeTypes.WHEN_CONDITION_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType22), (String)"KtNodeTypes.WHEN_CONDITION_EXPRESSION");
        iElementTypeArray15[0] = ktNodeType22;
        KtNodeType ktNodeType23 = KtNodeTypes.WHEN_CONDITION_IN_RANGE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType23), (String)"KtNodeTypes.WHEN_CONDITION_IN_RANGE");
        iElementTypeArray15[1] = ktNodeType23;
        KtNodeType ktNodeType24 = KtNodeTypes.WHEN_CONDITION_IS_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType24), (String)"KtNodeTypes.WHEN_CONDITION_IS_PATTERN");
        iElementTypeArray15[2] = ktNodeType24;
        KtKeywordToken ktKeywordToken5 = KtTokens.ELSE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken5), (String)"ELSE_KEYWORD");
        iElementTypeArray15[3] = ktKeywordToken5;
        KtSingleValueToken ktSingleValueToken10 = KtTokens.ARROW;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken10), (String)"ARROW");
        iElementTypeArray15[4] = ktSingleValueToken10;
        NodeIndentStrategy.PositionStrategy positionStrategy45 = positionStrategy44.notForType(iElementType26, iElementTypeArray15);
        Indent indent16 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent16, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[17] = positionStrategy45.set(indent16);
        NodeIndentStrategy.PositionStrategy positionStrategy46 = NodeIndentStrategy.Companion.strategy("Parameter list");
        IElementType iElementType27 = KtNodeTypes.VALUE_PARAMETER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType27, (String)"KtNodeTypes.VALUE_PARAMETER_LIST");
        nodeIndentStrategyArray[18] = positionStrategy46.within(iElementType27, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.6.INSTANCE)).set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)INDENT_RULES.7.INSTANCE));
        NodeIndentStrategy.PositionStrategy positionStrategy47 = NodeIndentStrategy.Companion.strategy("Where clause");
        IElementType iElementType28 = KtNodeTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType28, (String)"KtNodeTypes.CLASS");
        IElementType[] iElementTypeArray16 = new IElementType[2];
        IElementType iElementType29 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType29, (String)"KtNodeTypes.FUN");
        iElementTypeArray16[0] = iElementType29;
        IElementType iElementType30 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType30, (String)"KtNodeTypes.PROPERTY");
        iElementTypeArray16[1] = iElementType30;
        NodeIndentStrategy.PositionStrategy positionStrategy48 = positionStrategy47.within(iElementType28, iElementTypeArray16);
        KtKeywordToken ktKeywordToken6 = KtTokens.WHERE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken6), (String)"KtTokens.WHERE_KEYWORD");
        NodeIndentStrategy.PositionStrategy positionStrategy49 = positionStrategy48.forType(ktKeywordToken6, new IElementType[0]);
        Indent indent17 = Indent.getContinuationIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent17, (String)"Indent.getContinuationIndent()");
        nodeIndentStrategyArray[19] = positionStrategy49.set(indent17);
        NodeIndentStrategy.PositionStrategy positionStrategy50 = NodeIndentStrategy.Companion.strategy("Array literals");
        KtNodeType ktNodeType25 = KtNodeTypes.COLLECTION_LITERAL_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType25), (String)"KtNodeTypes.COLLECTION_LITERAL_EXPRESSION");
        NodeIndentStrategy.PositionStrategy positionStrategy51 = positionStrategy50.within(ktNodeType25, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken11 = KtTokens.LBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken11), (String)"LBRACKET");
        IElementType iElementType31 = ktSingleValueToken11;
        IElementType[] iElementTypeArray17 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken12 = KtTokens.RBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken12), (String)"RBRACKET");
        iElementTypeArray17[0] = ktSingleValueToken12;
        NodeIndentStrategy.PositionStrategy positionStrategy52 = positionStrategy51.notForType(iElementType31, iElementTypeArray17);
        Indent indent18 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent18, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[20] = positionStrategy52.set(indent18);
        INDENT_RULES = nodeIndentStrategyArray;
    }

    public static final /* synthetic */ int access$findNodeBlockIndex(@NotNull List blocks, @NotNull TokenSet tokenSet) {
        return KotlinCommonBlockKt.findNodeBlockIndex(blocks, tokenSet);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getQUALIFIED_OPERATION$p() {
        return QUALIFIED_OPERATION;
    }

    @Nullable
    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespace(@Nullable ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespace(pNode);
    }

    @Nullable
    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespaceAndComments(@Nullable ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespaceAndComments(pNode);
    }

    @NotNull
    public static final /* synthetic */ NodeIndentStrategy[] access$getINDENT_RULES$p() {
        return INDENT_RULES;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getCODE_BLOCKS$p() {
        return CODE_BLOCKS;
    }

    public static final /* synthetic */ int access$getKDOC_COMMENT_INDENT$p() {
        return KDOC_COMMENT_INDENT;
    }

    @NotNull
    public static final /* synthetic */ CommonAlignmentStrategy access$getAlignmentForChildInParenthesis(boolean shouldAlignChild, @NotNull IElementType parameter, @NotNull IElementType delimiter, boolean shouldAlignParenthesis, @NotNull IElementType openBracket, @NotNull IElementType closeBracket) {
        return KotlinCommonBlockKt.getAlignmentForChildInParenthesis(shouldAlignChild, parameter, delimiter, shouldAlignParenthesis, openBracket, closeBracket);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getBINARY_EXPRESSIONS$p() {
        return BINARY_EXPRESSIONS;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getALIGN_FOR_BINARY_OPERATIONS$p() {
        return ALIGN_FOR_BINARY_OPERATIONS;
    }

    @Nullable
    public static final /* synthetic */ IElementType access$getOperationType(@NotNull ASTNode node) {
        return KotlinCommonBlockKt.getOperationType(node);
    }

    public static final /* synthetic */ boolean access$startsWithAnnotation(@NotNull ASTNode $receiver) {
        return KotlinCommonBlockKt.startsWithAnnotation($receiver);
    }

    @NotNull
    public static final /* synthetic */ WrappingStrategy access$getWrappingStrategyForItemList(int wrapType, @NotNull TokenSet itemTypes, boolean wrapFirstElement) {
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(wrapType, itemTypes, wrapFirstElement);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getANNOTATIONS$p() {
        return ANNOTATIONS;
    }

    public static final /* synthetic */ boolean access$isFirstParameter(@NotNull ASTNode $receiver) {
        return KotlinCommonBlockKt.isFirstParameter($receiver);
    }

    @NotNull
    public static final /* synthetic */ WrappingStrategy access$wrapAfterAnnotation(int wrapType) {
        return KotlinCommonBlockKt.wrapAfterAnnotation(wrapType);
    }
}

