/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinLastLambdaParameterFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinLastLambdaParameterFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtCallExpression)) {
            return;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)element3, bindingContext2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> valueParameters = resolvedCall3.getCandidateDescriptor().getValueParameters();
        if (resolvedCall3.getValueArguments().size() == valueParameters.size() - 1) {
            KotlinType type2;
            List<ValueParameterDescriptor> list2 = valueParameters;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueParameters");
            Object object = CollectionsKt.last(list2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"valueParameters.last()");
            KotlinType kotlinType = type2 = ((ValueParameterDescriptor)object).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
            if (FunctionTypesKt.isFunctionType(kotlinType)) {
                Document doc = editor.getDocument();
                int offset2 = PsiUtilsKt.getEndOffset(element3);
                KtValueArgumentList ktValueArgumentList = ((KtCallExpression)element3).getValueArgumentList();
                if ((ktValueArgumentList != null ? ktValueArgumentList.getRightParenthesis() : null) == null) {
                    doc.insertString(offset2, (CharSequence)")");
                    ++offset2;
                }
                doc.insertString(offset2, (CharSequence)"{ }");
                processor2.registerUnresolvedError(offset2 + 2);
                processor2.commit(editor);
            }
        }
    }
}

