/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.idea.decompiler.common.FileWithMetadata;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile;", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata$Compatible;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$PackageFragment;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "isMetadata", "", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$PackageFragment;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "classesToDecompile", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "getClassesToDecompile", "()Ljava/util/List;", "()Z", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "shouldDecompileBuiltInClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Companion", "idea-core"})
public final class BuiltInDefinitionFile
extends FileWithMetadata.Compatible {
    @NotNull
    private final VirtualFile packageDirectory;
    private final boolean isMetadata;
    private static boolean FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProtoBuf.Class> getClassesToDecompile() {
        List list2;
        List list3;
        List classes2 = list3 = super.getClassesToDecompile();
        if (this.isMetadata || !Companion.getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES()) {
            list2 = classes2;
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)classes2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv$iv;
                if (!this.shouldDecompileBuiltInClass(this.getNameResolver().getClassId(classProto.getFqName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    private final boolean shouldDecompileBuiltInClass(ClassId classId) {
        StringBuilder stringBuilder = new StringBuilder().append(classId.getShortClassName().asString()).append(".");
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaClassFileType, (String)"JavaClassFileType.INSTANCE");
        String realJvmClassFileName = stringBuilder.append(javaClassFileType.getDefaultExtension()).toString();
        return this.packageDirectory.findChild(realJvmClassFileName) == null;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    public final boolean isMetadata() {
        return this.isMetadata;
    }

    public BuiltInDefinitionFile(@NotNull ProtoBuf.PackageFragment proto, @NotNull VirtualFile packageDirectory, boolean isMetadata) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)packageDirectory, (String)"packageDirectory");
        super(proto, BuiltInSerializerProtocol.INSTANCE);
        this.packageDirectory = packageDirectory;
        this.isMetadata = isMetadata;
    }

    static {
        Companion = new Companion(null);
        FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = true;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile$Companion;", "", "()V", "<set-?>", "", "FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "()Z", "setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "(Z)V", "read", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;", "contents", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-core"})
    public static final class Companion {
        public final boolean getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES() {
            return FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
        }

        public final void setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES(boolean bl) {
            FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = bl;
        }

        @Nullable
        public final FileWithMetadata read(@NotNull byte[] contents, @NotNull VirtualFile file2) {
            ProtoBuf.PackageFragment proto;
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            ByteArrayInputStream stream2 = new ByteArrayInputStream(contents);
            BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream2);
            if (!version.isCompatible()) {
                return new FileWithMetadata.Incompatible(version);
            }
            ProtoBuf.PackageFragment packageFragment = proto = ProtoBuf.PackageFragment.parseFrom(stream2, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
            Intrinsics.checkExpressionValueIsNotNull((Object)packageFragment, (String)"proto");
            VirtualFile virtualFile2 = file2.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.parent");
            BuiltInDefinitionFile result2 = new BuiltInDefinitionFile(packageFragment, virtualFile2, Intrinsics.areEqual((Object)file2.getExtension(), (Object)MetadataPackageFragment.Companion.getMETADATA_FILE_EXTENSION()));
            ProtoBuf.Package packageProto = result2.getProto().getPackage();
            if (result2.getClassesToDecompile().isEmpty()) {
                ProtoBuf.Package package_ = packageProto;
                Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageProto");
                if (package_.getTypeAliasCount() == 0 && packageProto.getFunctionCount() == 0 && packageProto.getPropertyCount() == 0) {
                    return null;
                }
            }
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

