/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineCallableUsagesSearcher;", "", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "scopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/debugger/engine/DebugProcess;Ljava/util/List;)V", "getScopes", "()Ljava/util/List;", "checkIfInline", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findInlinedCalls", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "transformer", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "getScopeForInlineDeclarationUsages", "inlineDeclaration", "idea"})
public final class InlineCallableUsagesSearcher {
    private final DebugProcess myDebugProcess;
    @NotNull
    private final List<GlobalSearchScope> scopes;

    @NotNull
    public final KotlinDebuggerCaches.ComputedClassNames findInlinedCalls(@NotNull KtDeclaration declaration2, @NotNull BindingContext bindingContext2, @NotNull Function1<? super PsiElement, KotlinDebuggerCaches.ComputedClassNames> transformer) {
        boolean bl;
        boolean bl2;
        List list2;
        block9: {
            KotlinDebuggerCaches.ComputedClassNames it;
            Iterable $receiver$iv$iv;
            ApplicationEx applicationEx;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
            if (!this.checkIfInline(declaration2, bindingContext2)) {
                return KotlinDebuggerCaches.ComputedClassNames.Companion.getEMPTY();
            }
            HashSet searchResult = new HashSet();
            String declarationName2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(declaration2){
                final /* synthetic */ KtDeclaration $declaration;

                @Nullable
                public final String invoke() {
                    return this.$declaration.getName();
                }
                {
                    this.$declaration = ktDeclaration;
                    super(0);
                }
            });
            Runnable task2 = new Runnable(this, declaration2, searchResult){
                final /* synthetic */ InlineCallableUsagesSearcher this$0;
                final /* synthetic */ KtDeclaration $declaration;
                final /* synthetic */ HashSet $searchResult;

                public final void run() {
                    Query query = ReferencesSearch.search((PsiElement)this.$declaration, (SearchScope)((SearchScope)InlineCallableUsagesSearcher.access$getScopeForInlineDeclarationUsages(this.this$0, this.$declaration)));
                    Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(\u2026ationUsages(declaration))");
                    Iterable $receiver$iv = (Iterable)query;
                    for (T element$iv : $receiver$iv) {
                        PsiElement usage;
                        PsiElement psiElement2;
                        PsiReference it = (PsiReference)element$iv;
                        if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(it){
                            final /* synthetic */ PsiReference $it;

                            public final boolean invoke() {
                                PsiReference psiReference = this.$it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                                return UtilsKt.isImportUsage(psiReference);
                            }
                            {
                                this.$it = psiReference;
                                super(0);
                            }
                        })).booleanValue()) continue;
                        PsiReference psiReference = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                        PsiElement psiElement3 = psiReference.getElement();
                        if (!(psiElement3 instanceof KtElement)) {
                            psiElement3 = null;
                        }
                        if ((KtElement)psiElement3 != null) {
                            KtElement ktElement;
                            PsiElement p1 = (PsiElement)ktElement;
                            psiElement2 = DebuggerClassNameProvider.Companion.getRelevantElement$idea(p1);
                        } else {
                            psiElement2 = null;
                        }
                        if ((usage = psiElement2) == null) continue;
                        this.$searchResult.add(usage);
                    }
                }
                {
                    this.this$0 = inlineCallableUsagesSearcher;
                    this.$declaration = ktDeclaration;
                    this.$searchResult = hashSet;
                }
            };
            boolean isSuccess = true;
            ApplicationEx applicationEx2 = applicationEx = ApplicationManagerEx.getApplicationEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationEx2, (String)"applicationEx");
            if (applicationEx2.isDispatchThread()) {
                isSuccess = ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, "Compute class names for declaration " + declarationName2, true, this.myDebugProcess.getProject());
            } else {
                ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            if (!isSuccess) {
                XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Debugger can skip some executions of " + declarationName2 + " because the computation of class names was interrupted", MessageType.WARNING).notify(this.myDebugProcess.getProject());
            }
            Iterable $receiver$iv = searchResult;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                PsiElement psiElement2 = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                KotlinDebuggerCaches.ComputedClassNames computedClassNames = (KotlinDebuggerCaches.ComputedClassNames)transformer.invoke((Object)it);
                collection.add(computedClassNames);
            }
            List results2 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)results2;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (KotlinDebuggerCaches.ComputedClassNames)element$iv$iv;
                Iterable list$iv$iv = it.getClassNames();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            $receiver$iv = results2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KotlinDebuggerCaches.ComputedClassNames it2 = (KotlinDebuggerCaches.ComputedClassNames)element$iv;
                    if (it2.getShouldBeCached()) continue;
                    bl2 = false;
                    break block9;
                }
                bl2 = true;
            }
        }
        boolean bl3 = bl = bl2;
        List list3 = list2;
        return new KotlinDebuggerCaches.ComputedClassNames(list3, bl3);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinDebuggerCaches.ComputedClassNames findInlinedCalls$default(InlineCallableUsagesSearcher inlineCallableUsagesSearcher, KtDeclaration ktDeclaration, BindingContext bindingContext2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            BindingContext bindingContext3 = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(ktDeclaration).getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"KotlinDebuggerCaches.get\u2026claration).bindingContext");
            bindingContext2 = bindingContext3;
        }
        return inlineCallableUsagesSearcher.findInlinedCalls(ktDeclaration, bindingContext2, (Function1<? super PsiElement, KotlinDebuggerCaches.ComputedClassNames>)function1);
    }

    private final boolean checkIfInline(KtDeclaration declaration2, BindingContext bindingContext2) {
        DeclarationDescriptor descriptor2;
        DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration2);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
        return declarationDescriptor2 instanceof FunctionDescriptor ? InlineUtil.isInline(descriptor2) : (declarationDescriptor2 instanceof PropertyDescriptor ? InlineUtil.hasInlineAccessors((PropertyDescriptor)descriptor2) : false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final GlobalSearchScope getScopeForInlineDeclarationUsages(KtDeclaration inlineDeclaration) {
        GlobalSearchScope globalSearchScope;
        VirtualFile virtualFile2 = (VirtualFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<VirtualFile>(inlineDeclaration){
            final /* synthetic */ KtDeclaration $inlineDeclaration;

            public final VirtualFile invoke() {
                PsiFile psiFile = this.$inlineDeclaration.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"inlineDeclaration.containingFile");
                return psiFile.getVirtualFile();
            }
            {
                this.$inlineDeclaration = ktDeclaration;
                super(0);
            }
        });
        if (virtualFile2 != null) {
            Project project = this.myDebugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
            if (ProjectRootsUtil.isLibraryFile(project, virtualFile2)) {
                Collection $receiver$iv;
                Collection collection = $receiver$iv = (Collection)this.scopes;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[thisCollection$iv.size()]);
                if (globalSearchScopeArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray);
                globalSearchScope = globalSearchScope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"GlobalSearchScope.union(scopes.toTypedArray())");
                return globalSearchScope;
            }
        }
        GlobalSearchScope globalSearchScope3 = this.myDebugProcess.getSearchScope();
        globalSearchScope = globalSearchScope3;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope3, (String)"myDebugProcess.searchScope");
        return globalSearchScope;
    }

    @NotNull
    public final List<GlobalSearchScope> getScopes() {
        return this.scopes;
    }

    public InlineCallableUsagesSearcher(@NotNull DebugProcess myDebugProcess, @NotNull List<? extends GlobalSearchScope> scopes) {
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        this.myDebugProcess = myDebugProcess;
        this.scopes = scopes;
    }

    @NotNull
    public static final /* synthetic */ GlobalSearchScope access$getScopeForInlineDeclarationUsages(InlineCallableUsagesSearcher $this, @NotNull KtDeclaration inlineDeclaration) {
        return $this.getScopeForInlineDeclarationUsages(inlineDeclaration);
    }
}

