/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.GroovyBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 B2\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J*\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u001c\u0010+\u001a\u00020\f*\u00020,2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\fH\u0002J\u0014\u0010/\u001a\u00020\f*\u00020,2\u0006\u0010-\u001a\u00020\u0010H\u0002J\u0014\u00100\u001a\u00020\f*\u00020,2\u0006\u0010-\u001a\u00020\u0010H\u0002J\f\u00101\u001a\u00020\f*\u00020,H\u0002J(\u00102\u001a\u00020\u0006*\u00020,2\u0006\u00103\u001a\u00020\u00102\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\f05H\u0002J\u0014\u00107\u001a\u00020\f*\u00020,2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u00108\u001a\u0004\u0018\u00010,*\u00020\u000e2\u0006\u00109\u001a\u00020\u0010H\u0002J\u0014\u0010:\u001a\u00020,*\u00020;2\u0006\u00109\u001a\u00020\u0010H\u0002J\f\u0010<\u001a\u00020,*\u00020;H\u0002J\f\u0010=\u001a\u00020,*\u00020;H\u0002J\f\u0010>\u001a\u00020,*\u00020;H\u0002J\f\u0010?\u001a\u00020,*\u00020;H\u0002J\f\u0010@\u001a\u00020,*\u00020;H\u0002J\u0014\u0010A\u001a\u000206*\u0002062\u0006\u00103\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GroovyBuildScriptManipulator;", "Lorg/jetbrains/kotlin/idea/configuration/GradleBuildScriptManipulator;", "groovyScript", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "(Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;)V", "addKotlinLibraryToModuleBuildScript", "", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "isAndroidModule", "", "changeApiVersion", "Lcom/intellij/psi/PsiElement;", "version", "", "forTests", "changeCoroutineConfiguration", "coroutineOption", "changeKotlinTaskParameter", "gradleFile", "parameterName", "parameterValue", "changeLanguageVersion", "configureModuleBuildScript", "kotlinPluginName", "stdlibArtifactName", "jvmTarget", "configureProjectBuildScript", "containsDirective", "fileText", "directive", "getApplyPluginDirective", "pluginName", "getApplyStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrApplicationStatement;", "file", "getGroovyApplyPluginDirective", "getGroovyDependencySnippet", "artifactName", "getKotlinStdlibVersion", "isConfigured", "addExpressionInBlockIfNeeded", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "expressionText", "isFirst", "addFirstExpressionInBlockIfNeeded", "addLastExpressionInBlockIfNeeded", "addMavenCentralIfMissing", "addOrReplaceExpression", "snippet", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "addRepository", "getBlockByName", "name", "getBlockOrCreate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/util/GrStatementOwner;", "getBuildScriptBlock", "getBuildScriptDependenciesBlock", "getBuildScriptRepositoriesBlock", "getDependenciesBlock", "getRepositoriesBlock", "replaceWithStatementFromText", "Companion", "idea-gradle"})
public final class GroovyBuildScriptManipulator
implements GradleBuildScriptManipulator {
    private final GroovyFile groovyScript;
    private static final String VERSION_TEMPLATE = "$VERSION$";
    private static final String VERSION;
    private static final String GRADLE_PLUGIN_ID = "kotlin-gradle-plugin";
    private static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    public static final Companion Companion;

    @Override
    public boolean isConfigured(@NotNull String kotlinPluginName) {
        String fileText;
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginName, (String)"kotlinPluginName");
        String string = fileText = this.groovyScript.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileText");
        return this.containsDirective(string, this.getApplyPluginDirective(kotlinPluginName)) && StringsKt.contains$default((CharSequence)fileText, (CharSequence)"org.jetbrains.kotlin", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)fileText, (CharSequence)"kotlin-stdlib", (boolean)false, (int)2, null);
    }

    @Override
    public boolean configureModuleBuildScript(@NotNull String kotlinPluginName, @NotNull String stdlibArtifactName, @NotNull String version, @Nullable String jvmTarget) {
        GrClosableBlock grClosableBlock;
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginName, (String)"kotlinPluginName");
        Intrinsics.checkParameterIsNotNull((Object)stdlibArtifactName, (String)"stdlibArtifactName");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        String oldText = this.groovyScript.getText();
        String applyPluginDirective = this.getGroovyApplyPluginDirective(kotlinPluginName);
        String string = this.groovyScript.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"groovyScript.text");
        if (!this.containsDirective(string, applyPluginDirective)) {
            GrExpression apply2 = GroovyPsiElementFactory.getInstance((Project)this.groovyScript.getProject()).createExpressionFromText((CharSequence)applyPluginDirective);
            GrApplicationStatement applyStatement = this.getApplyStatement(this.groovyScript);
            if (applyStatement != null) {
                this.groovyScript.addAfter((PsiElement)apply2, (PsiElement)applyStatement);
            } else {
                GrClosableBlock buildScriptBlock = this.getBlockByName((PsiElement)this.groovyScript, "buildscript");
                if (buildScriptBlock != null) {
                    this.groovyScript.addAfter((PsiElement)apply2, buildScriptBlock.getParent());
                } else {
                    PsiElement psiElement2 = (PsiElement)apply2;
                    GrStatement[] grStatementArray = this.groovyScript.getStatements();
                    Intrinsics.checkExpressionValueIsNotNull((Object)grStatementArray, (String)"groovyScript.statements");
                    GrStatement grStatement = (GrStatement)ArraysKt.lastOrNull((Object[])grStatementArray);
                    this.groovyScript.addAfter(psiElement2, grStatement != null ? (PsiElement)grStatement : this.groovyScript.getFirstChild());
                }
            }
        }
        GrClosableBlock $receiver = grClosableBlock = this.getRepositoriesBlock((GrStatementOwner)this.groovyScript);
        this.addRepository($receiver, version);
        this.addMavenCentralIfMissing($receiver);
        $receiver = grClosableBlock = this.getDependenciesBlock((GrStatementOwner)this.groovyScript);
        this.addExpressionInBlockIfNeeded($receiver, this.getGroovyDependencySnippet(stdlibArtifactName), false);
        if (jvmTarget != null) {
            this.changeKotlinTaskParameter(this.groovyScript, "jvmTarget", jvmTarget, false);
            this.changeKotlinTaskParameter(this.groovyScript, "jvmTarget", jvmTarget, true);
        }
        return Intrinsics.areEqual((Object)this.groovyScript.getText(), (Object)oldText) ^ true;
    }

    @Override
    public boolean configureProjectBuildScript(@NotNull String version) {
        GrClosableBlock grClosableBlock;
        GroovyFile groovyFile;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        String oldText = this.groovyScript.getText();
        GroovyFile $receiver = groovyFile = this.groovyScript;
        GrClosableBlock $receiver2 = grClosableBlock = this.getBuildScriptBlock((GrStatementOwner)$receiver);
        this.addFirstExpressionInBlockIfNeeded($receiver2, StringsKt.replace$default((String)GroovyBuildScriptManipulator.Companion.getVERSION(), (String)GroovyBuildScriptManipulator.Companion.getVERSION_TEMPLATE(), (String)version, (boolean)false, (int)4, null));
        $receiver2 = grClosableBlock = this.getBuildScriptRepositoriesBlock((GrStatementOwner)$receiver);
        this.addRepository($receiver2, version);
        this.addMavenCentralIfMissing($receiver2);
        $receiver2 = grClosableBlock = this.getBuildScriptDependenciesBlock((GrStatementOwner)$receiver);
        this.addLastExpressionInBlockIfNeeded($receiver2, GroovyBuildScriptManipulator.Companion.getCLASSPATH());
        return Intrinsics.areEqual((Object)oldText, (Object)this.groovyScript.getText()) ^ true;
    }

    @Override
    @Nullable
    public PsiElement changeCoroutineConfiguration(@NotNull String coroutineOption) {
        GrClosableBlock grClosableBlock;
        Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
        String snippet = "coroutines \"" + coroutineOption + '\"';
        GrClosableBlock kotlinBlock = this.getBlockOrCreate((GrStatementOwner)this.groovyScript, "kotlin");
        GrClosableBlock $receiver = grClosableBlock = this.getBlockOrCreate((GrStatementOwner)kotlinBlock, "experimental");
        this.addOrReplaceExpression($receiver, snippet, (Function1<? super GrStatement, Boolean>)((Function1)changeCoroutineConfiguration.1.1.INSTANCE));
        return kotlinBlock.getParent();
    }

    @Override
    @Nullable
    public PsiElement changeLanguageVersion(@NotNull String version, boolean forTests) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.changeKotlinTaskParameter(this.groovyScript, "languageVersion", version, forTests);
    }

    @Override
    @Nullable
    public PsiElement changeApiVersion(@NotNull String version, boolean forTests) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.changeKotlinTaskParameter(this.groovyScript, "apiVersion", version, forTests);
    }

    @Override
    public void addKotlinLibraryToModuleBuildScript(@NotNull DependencyScope scope2, @NotNull ExternalLibraryDescriptor libraryDescriptor, boolean isAndroidModule) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)libraryDescriptor, (String)"libraryDescriptor");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s \"%s:%s:%s\"";
        Object[] objectArray = new Object[]{ConfigureKotlinInProjectUtilsKt.toGradleCompileScope(scope2, isAndroidModule), libraryDescriptor.getLibraryGroupId(), libraryDescriptor.getLibraryArtifactId(), libraryDescriptor.getMaxVersion()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String dependencyString = string2;
        StringCompanionObject $receiver = stringCompanionObject = this.getDependenciesBlock((GrStatementOwner)this.groovyScript);
        this.addLastExpressionInBlockIfNeeded((GrClosableBlock)$receiver, dependencyString);
    }

    @Override
    @Nullable
    public String getKotlinStdlibVersion() {
        String versionProperty = "$kotlin_version";
        GrClosableBlock grClosableBlock = this.getBlockByName((PsiElement)this.groovyScript, "buildScript");
        if (grClosableBlock != null) {
            GrClosableBlock grClosableBlock2;
            GrClosableBlock it = grClosableBlock2 = grClosableBlock;
            String string = it.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ext.kotlin_version = ", (boolean)false, (int)2, null)) {
                return versionProperty;
            }
        }
        GrClosableBlock grClosableBlock3 = this.getBlockByName((PsiElement)this.groovyScript, "dependencies");
        GrStatement[] dependencies2 = grClosableBlock3 != null ? grClosableBlock3.getStatements() : null;
        String stdlibArtifactPrefix = "org.jetbrains.kotlin:kotlin-stdlib:";
        if (dependencies2 != null) {
            Object[] $receiver$iv = dependencies2;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                String dependencyText;
                GrStatement dependency;
                Object element$iv = $receiver$iv[i];
                GrStatement grStatement = dependency = (GrStatement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)grStatement, (String)"dependency");
                String string = dependencyText = grStatement.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependencyText");
                int startIndex = StringsKt.indexOf$default((CharSequence)string, (String)stdlibArtifactPrefix, (int)0, (boolean)false, (int)6, null) + stdlibArtifactPrefix.length();
                int endIndex = dependencyText.length() - 1;
                if (startIndex == -1 || endIndex == -1) continue;
                String string2 = dependencyText;
                String string3 = string2.substring(startIndex, endIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
        }
        return null;
    }

    private final PsiElement changeKotlinTaskParameter(GroovyFile gradleFile, String parameterName, String parameterValue, boolean forTests) {
        GrClosableBlock grClosableBlock;
        String snippet = "" + parameterName + " = \"" + parameterValue + '\"';
        GrClosableBlock kotlinBlock = this.getBlockOrCreate((GrStatementOwner)gradleFile, forTests ? "compileTestKotlin" : "compileKotlin");
        GrStatement[] grStatementArray = kotlinBlock.getStatements();
        for (int i = 0; i < grStatementArray.length; ++i) {
            GrAssignmentExpression grAssignmentExpression;
            GrStatement stmt = grStatementArray[i];
            GrStatement grStatement = stmt;
            if (!(grStatement instanceof GrAssignmentExpression)) {
                grStatement = null;
            }
            if (!Intrinsics.areEqual((Object)((grAssignmentExpression = (GrAssignmentExpression)grStatement) != null && (grAssignmentExpression = grAssignmentExpression.getLValue()) != null ? grAssignmentExpression.getText() : null), (Object)("kotlinOptions." + parameterName))) continue;
            return (PsiElement)this.replaceWithStatementFromText(stmt, "kotlinOptions." + snippet);
        }
        GrClosableBlock $receiver = grClosableBlock = this.getBlockOrCreate((GrStatementOwner)kotlinBlock, "kotlinOptions");
        this.addOrReplaceExpression($receiver, snippet, (Function1<? super GrStatement, Boolean>)((Function1)new Function1<GrStatement, Boolean>(this, snippet, parameterName){
            final /* synthetic */ GroovyBuildScriptManipulator this$0;
            final /* synthetic */ String $snippet$inlined;
            final /* synthetic */ String $parameterName$inlined;
            {
                this.this$0 = groovyBuildScriptManipulator;
                this.$snippet$inlined = string;
                this.$parameterName$inlined = string2;
                super(1);
            }

            public final boolean invoke(@NotNull GrStatement stmt) {
                GrAssignmentExpression grAssignmentExpression;
                Intrinsics.checkParameterIsNotNull((Object)stmt, (String)"stmt");
                GrStatement grStatement = stmt;
                if (!(grStatement instanceof GrAssignmentExpression)) {
                    grStatement = null;
                }
                return Intrinsics.areEqual((Object)((grAssignmentExpression = (GrAssignmentExpression)grStatement) != null && (grAssignmentExpression = grAssignmentExpression.getLValue()) != null ? grAssignmentExpression.getText() : null), (Object)this.$parameterName$inlined);
            }
        }));
        return kotlinBlock.getParent();
    }

    private final String getGroovyDependencySnippet(String artifactName) {
        return "compile \"org.jetbrains.kotlin:" + artifactName + ":$kotlin_version\"";
    }

    private final String getApplyPluginDirective(String pluginName) {
        return "apply plugin: '" + pluginName + '\'';
    }

    private final boolean containsDirective(String fileText, String directive) {
        return StringsKt.contains$default((CharSequence)fileText, (CharSequence)directive, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fileText, (CharSequence)StringsKt.replace$default((String)directive, (String)"\"", (String)"'", (boolean)false, (int)4, null), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fileText, (CharSequence)StringsKt.replace$default((String)directive, (String)"'", (String)"\"", (boolean)false, (int)4, null), (boolean)false, (int)2, null);
    }

    private final GrApplicationStatement getApplyStatement(GroovyFile file2) {
        Object object;
        block2: {
            Object[] objectArray;
            PsiElement $receiver$iv = (PsiElement)file2;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrApplicationStatement.class);
            if (psiElementArray == null) {
                psiElementArray = new GrApplicationStatement[]{};
            }
            Object[] objectArray2 = objectArray = (Object[])psiElementArray;
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = objectArray2[i];
                GrApplicationStatement it = (GrApplicationStatement)object2;
                GrExpression grExpression = it.getInvokedExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"it.invokedExpression");
                if (!Intrinsics.areEqual((Object)grExpression.getText(), (Object)"apply")) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (GrApplicationStatement)object;
    }

    private final GrClosableBlock getBlockByName(@NotNull PsiElement $receiver, String name2) {
        GrClosableBlock grClosableBlock;
        Object v3;
        Iterable iterable;
        block5: {
            Iterable $receiver$iv$iv;
            Object[] $receiver$iv = $receiver;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrMethodCallExpression.class);
            if (psiElementArray == null) {
                psiElementArray = new GrMethodCallExpression[]{};
            }
            $receiver$iv = psiElementArray;
            Object[] $i$f$getChildrenOfType = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                Object[] objectArray;
                void element$iv$iv = $receiver$iv$iv[i];
                GrMethodCallExpression it = (GrMethodCallExpression)element$iv$iv;
                GrClosableBlock[] grClosableBlockArray = it.getClosureArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)grClosableBlockArray, (String)"it.closureArguments");
                Object[] objectArray2 = objectArray = (Object[])grClosableBlockArray;
                if (!(!(objectArray2.length == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv$iv = iterable = (Iterable)((List)destination$iv$iv);
            for (Object e : $receiver$iv$iv) {
                GrMethodCallExpression it = (GrMethodCallExpression)e;
                GrExpression grExpression = it.getInvokedExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"it.invokedExpression");
                if (!Intrinsics.areEqual((Object)grExpression.getText(), (Object)name2)) continue;
                v3 = e;
                break block5;
            }
            v3 = null;
        }
        GrMethodCallExpression grMethodCallExpression = v3;
        if (grMethodCallExpression != null) {
            Iterable it = iterable = grMethodCallExpression;
            grClosableBlock = it.getClosureArguments()[0];
        } else {
            grClosableBlock = null;
        }
        return grClosableBlock;
    }

    private final boolean addRepository(@NotNull GrClosableBlock $receiver, String version) {
        String string;
        RepositoryDescription repository = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version);
        if (repository != null) {
            string = ConfigureKotlinInProjectUtilsKt.toGroovyRepositorySnippet(repository);
        } else {
            String string2 = $receiver.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
            if (!ConfigureKotlinInProjectUtilsKt.isRepositoryConfigured(string2)) {
                string = "" + ConfigureKotlinInProjectUtilsKt.getMAVEN_CENTRAL() + '\n';
            } else {
                return false;
            }
        }
        String snippet = string;
        return this.addLastExpressionInBlockIfNeeded($receiver, snippet);
    }

    private final boolean addMavenCentralIfMissing(@NotNull GrClosableBlock $receiver) {
        String string = $receiver.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
        return !ConfigureKotlinInProjectUtilsKt.isRepositoryConfigured(string) ? this.addLastExpressionInBlockIfNeeded($receiver, ConfigureKotlinInProjectUtilsKt.getMAVEN_CENTRAL()) : false;
    }

    private final GrClosableBlock getRepositoriesBlock(@NotNull GrStatementOwner $receiver) {
        return this.getBlockOrCreate($receiver, "repositories");
    }

    private final GrClosableBlock getDependenciesBlock(@NotNull GrStatementOwner $receiver) {
        return this.getBlockOrCreate($receiver, "dependencies");
    }

    private final GrClosableBlock getBuildScriptBlock(@NotNull GrStatementOwner $receiver) {
        return this.getBlockOrCreate($receiver, "buildscript");
    }

    private final GrClosableBlock getBuildScriptRepositoriesBlock(@NotNull GrStatementOwner $receiver) {
        return this.getBlockOrCreate((GrStatementOwner)this.getBuildScriptBlock($receiver), "repositories");
    }

    private final GrClosableBlock getBuildScriptDependenciesBlock(@NotNull GrStatementOwner $receiver) {
        return this.getBlockOrCreate((GrStatementOwner)this.getBuildScriptBlock($receiver), "dependencies");
    }

    private final GrClosableBlock getBlockOrCreate(@NotNull GrStatementOwner $receiver, String name2) {
        GrClosableBlock block = this.getBlockByName((PsiElement)$receiver, name2);
        if (block == null) {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)$receiver.getProject());
            GrExpression newBlock = factory2.createExpressionFromText((CharSequence)("" + name2 + "{\n}\n"));
            PsiElement psiElement2 = (PsiElement)newBlock;
            GrStatement[] grStatementArray = $receiver.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)grStatementArray, (String)"statements");
            GrStatement grStatement = (GrStatement)ArraysKt.lastOrNull((Object[])grStatementArray);
            $receiver.addAfter(psiElement2, grStatement != null ? (PsiElement)grStatement : $receiver.getFirstChild());
            GrClosableBlock grClosableBlock = this.getBlockByName((PsiElement)$receiver, name2);
            if (grClosableBlock == null) {
                Intrinsics.throwNpe();
            }
            block = grClosableBlock;
        }
        return block;
    }

    private final void addOrReplaceExpression(@NotNull GrClosableBlock $receiver, String snippet, Function1<? super GrStatement, Boolean> predicate2) {
        Object object;
        block2: {
            GrStatement[] grStatementArray = $receiver.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)grStatementArray, (String)"statements");
            Object[] $receiver$iv = grStatementArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        GrStatement grStatement = (GrStatement)object;
        if (grStatement != null) {
            GrStatement grStatement2;
            GrStatement stmt = grStatement2 = grStatement;
            this.replaceWithStatementFromText(stmt, snippet);
            return;
        }
        this.addLastExpressionInBlockIfNeeded($receiver, snippet);
    }

    private final boolean addLastExpressionInBlockIfNeeded(@NotNull GrClosableBlock $receiver, String expressionText2) {
        return this.addExpressionInBlockIfNeeded($receiver, expressionText2, false);
    }

    private final boolean addFirstExpressionInBlockIfNeeded(@NotNull GrClosableBlock $receiver, String expressionText2) {
        return this.addExpressionInBlockIfNeeded($receiver, expressionText2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean addExpressionInBlockIfNeeded(@NotNull GrClosableBlock $receiver, String expressionText2, boolean isFirst) {
        String string = $receiver.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)expressionText2, (boolean)false, (int)2, null)) {
            return false;
        }
        GrExpression newStatement = GroovyPsiElementFactory.getInstance((Project)$receiver.getProject()).createExpressionFromText((CharSequence)expressionText2);
        CodeStyleManager.getInstance((Project)$receiver.getProject()).reformat((PsiElement)newStatement);
        if (!isFirst) {
            Object[] objectArray;
            GrStatement[] grStatementArray = $receiver.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)grStatementArray, (String)"statements");
            Object[] objectArray2 = objectArray = (Object[])grStatementArray;
            if (!(objectArray2.length == 0)) {
                GrStatement lastStatement = $receiver.getStatements()[((Object[])$receiver.getStatements()).length - 1];
                if (lastStatement == null) return true;
                $receiver.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
                return true;
            }
        }
        if ($receiver.getFirstChild() == null) return true;
        $receiver.addAfter((PsiElement)newStatement, $receiver.getFirstChild());
        return true;
    }

    private final String getGroovyApplyPluginDirective(String pluginName) {
        return "apply plugin: '" + pluginName + '\'';
    }

    private final GrStatement replaceWithStatementFromText(@NotNull GrStatement $receiver, String snippet) {
        GrExpression newStatement = GroovyPsiElementFactory.getInstance((Project)$receiver.getProject()).createExpressionFromText((CharSequence)snippet);
        CodeStyleManager.getInstance((Project)$receiver.getProject()).reformat((PsiElement)newStatement);
        GrStatement grStatement = $receiver.replaceWithStatement((GrStatement)newStatement);
        Intrinsics.checkExpressionValueIsNotNull((Object)grStatement, (String)"replaceWithStatement(newStatement)");
        return grStatement;
    }

    public GroovyBuildScriptManipulator(@NotNull GroovyFile groovyScript) {
        Intrinsics.checkParameterIsNotNull((Object)groovyScript, (String)"groovyScript");
        this.groovyScript = groovyScript;
    }

    static {
        Companion = new Companion(null);
        VERSION_TEMPLATE = VERSION_TEMPLATE;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "ext.kotlin_version = '%s'";
        Object[] objectArray = new Object[]{GroovyBuildScriptManipulator.Companion.getVERSION_TEMPLATE()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        VERSION = string2;
        GRADLE_PLUGIN_ID = GRADLE_PLUGIN_ID;
        CLASSPATH = "classpath \"" + ConfigureKotlinInProjectUtilsKt.getKOTLIN_GROUP_ID() + ':' + GroovyBuildScriptManipulator.Companion.getGRADLE_PLUGIN_ID() + ":$kotlin_version\"";
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GroovyBuildScriptManipulator$Companion;", "", "()V", "CLASSPATH", "", "getCLASSPATH", "()Ljava/lang/String;", "GRADLE_PLUGIN_ID", "getGRADLE_PLUGIN_ID", "VERSION", "getVERSION", "VERSION_TEMPLATE", "getVERSION_TEMPLATE", "idea-gradle"})
    public static final class Companion {
        private final String getVERSION_TEMPLATE() {
            return VERSION_TEMPLATE;
        }

        private final String getVERSION() {
            return VERSION;
        }

        private final String getGRADLE_PLUGIN_ID() {
            return GRADLE_PLUGIN_ID;
        }

        private final String getCLASSPATH() {
            return CLASSPATH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

