/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class SamType {
    private final KotlinType type;

    public static SamType create(@NotNull KotlinType originalType) {
        if (!SingleAbstractMethodUtils.isSamType(originalType)) {
            return null;
        }
        return new SamType(originalType);
    }

    private SamType(@NotNull KotlinType type2) {
        this.type = type2;
    }

    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    @NotNull
    public JavaClassDescriptor getJavaClassDescriptor() {
        ClassifierDescriptor classifier = this.type.getConstructor().getDeclarationDescriptor();
        assert (classifier instanceof JavaClassDescriptor) : "Sam interface not a Java class: " + classifier;
        return (JavaClassDescriptor)classifier;
    }

    @NotNull
    public KotlinType getKotlinFunctionType() {
        return this.getJavaClassDescriptor().getDefaultFunctionTypeForSamInterface();
    }

    @NotNull
    public SimpleFunctionDescriptor getOriginalAbstractMethod() {
        return (SimpleFunctionDescriptor)SingleAbstractMethodUtils.getAbstractMembers(this.getJavaClassDescriptor()).get(0);
    }

    public boolean equals(Object o) {
        return o instanceof SamType && this.type.equals(((SamType)o).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "SamType(" + this.type + ")";
    }
}

