/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class AccessorForPropertyDescriptor
extends PropertyDescriptorImpl
implements AccessorForCallableDescriptor<PropertyDescriptor> {
    private final PropertyDescriptor calleeDescriptor;
    private final ClassDescriptor superCallTarget;
    private final String nameSuffix;
    private final boolean withSyntheticGetterAccessor;
    private final boolean withSyntheticSetterAccessor;

    public AccessorForPropertyDescriptor(@NotNull PropertyDescriptor property2, @NotNull DeclarationDescriptor containingDeclaration, @Nullable ClassDescriptor superCallTarget, @NotNull String nameSuffix, boolean getterAccessorRequired, boolean setterAccessorRequired) {
        this(property2, property2.getType(), DescriptorUtils.getReceiverParameterType(property2.getExtensionReceiverParameter()), CodegenUtilKt.isJvmStaticInObjectOrClass(property2) ? null : property2.getDispatchReceiverParameter(), containingDeclaration, superCallTarget, nameSuffix, getterAccessorRequired, setterAccessorRequired);
    }

    protected AccessorForPropertyDescriptor(@NotNull PropertyDescriptor original, @NotNull KotlinType propertyType, @Nullable KotlinType receiverType2, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull DeclarationDescriptor containingDeclaration, @Nullable ClassDescriptor superCallTarget, @NotNull String nameSuffix) {
        this(original, propertyType, receiverType2, dispatchReceiverParameter, containingDeclaration, superCallTarget, nameSuffix, true, true);
    }

    private AccessorForPropertyDescriptor(@NotNull PropertyDescriptor original, @NotNull KotlinType propertyType, @Nullable KotlinType receiverType2, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull DeclarationDescriptor containingDeclaration, @Nullable ClassDescriptor superCallTarget, @NotNull String nameSuffix, boolean getterAccessorRequired, boolean setterAccessorRequired) {
        super(containingDeclaration, null, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.LOCAL, original.isVar(), Name.identifier("access$" + nameSuffix), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE, false, false, false, false, false, false);
        this.calleeDescriptor = original;
        this.superCallTarget = superCallTarget;
        this.nameSuffix = nameSuffix;
        this.setType(propertyType, Collections.emptyList(), dispatchReceiverParameter, receiverType2);
        this.withSyntheticGetterAccessor = getterAccessorRequired;
        this.withSyntheticSetterAccessor = setterAccessorRequired;
        PropertyGetterDescriptorImpl getterDescriptor = getterAccessorRequired ? new Getter(this) : (PropertyGetterDescriptorImpl)original.getGetter();
        PropertySetterDescriptor setterDescriptor = setterAccessorRequired ? new Setter(this) : original.getSetter();
        this.initialize(getterDescriptor, setterDescriptor);
    }

    @Override
    @NotNull
    public PropertyDescriptor getCalleeDescriptor() {
        return this.calleeDescriptor;
    }

    @Override
    public ClassDescriptor getSuperCallTarget() {
        return this.superCallTarget;
    }

    @NotNull
    public String getAccessorSuffix() {
        return this.nameSuffix;
    }

    public boolean isWithSyntheticGetterAccessor() {
        return this.withSyntheticGetterAccessor;
    }

    public boolean isWithSyntheticSetterAccessor() {
        return this.withSyntheticSetterAccessor;
    }

    public static class Setter
    extends PropertySetterDescriptorImpl
    implements AccessorForCallableDescriptor<PropertySetterDescriptor> {
        public Setter(AccessorForPropertyDescriptor property2) {
            super(property2, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.LOCAL, false, false, false, CallableMemberDescriptor.Kind.DECLARATION, null, SourceElement.NO_SOURCE);
            this.initializeDefault();
        }

        @Override
        @NotNull
        public PropertySetterDescriptor getCalleeDescriptor() {
            return ((AccessorForPropertyDescriptor)this.getCorrespondingProperty()).getCalleeDescriptor().getSetter();
        }

        @Override
        @Nullable
        public ClassDescriptor getSuperCallTarget() {
            return ((AccessorForPropertyDescriptor)this.getCorrespondingProperty()).getSuperCallTarget();
        }
    }

    public static class Getter
    extends PropertyGetterDescriptorImpl
    implements AccessorForCallableDescriptor<PropertyGetterDescriptor> {
        public Getter(AccessorForPropertyDescriptor property2) {
            super(property2, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.LOCAL, false, false, false, CallableMemberDescriptor.Kind.DECLARATION, null, SourceElement.NO_SOURCE);
            this.initialize(property2.getType());
        }

        @Override
        @NotNull
        public PropertyGetterDescriptor getCalleeDescriptor() {
            return ((AccessorForPropertyDescriptor)this.getCorrespondingProperty()).getCalleeDescriptor().getGetter();
        }

        @Override
        @Nullable
        public ClassDescriptor getSuperCallTarget() {
            return ((AccessorForPropertyDescriptor)this.getCorrespondingProperty()).getSuperCallTarget();
        }
    }
}

