/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.actions;

import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.ide.IdeView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.actions.NewKotlinActivityAction;
import org.jetbrains.kotlin.android.actions.NewKotlinActivityActionKt;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/android/actions/NewKotlinActivityAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "equals", "", "other", "", "getKotlinFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "hashCode", "", "isProjectReady", "facet", "isVisible", "showWizard", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "update", "Companion", "idea-android"})
public final class NewKotlinActivityAction
extends AnAction {
    private static final Logger LOG;
    private static List<? extends PsiJavaFile> javaFilesToKotlin;
    private static final Companion.gradleSyncListener.1 gradleSyncListener;
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent e) {
        LocalHistoryImpl localHistory;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        LocalHistoryImpl.getInstanceImpl().putSystemLabel(project2, NewKotlinActivityActionKt.access$getNEW_KOTLIN_ACTIVITY_START_LABEL$p());
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        boolean isSuccess = this.showWizard(dataContext);
        LocalHistoryImpl.getInstanceImpl().putSystemLabel(project2, NewKotlinActivityActionKt.access$getNEW_KOTLIN_ACTIVITY_END_LABEL$p());
        if (!isSuccess) {
            return;
        }
        LocalHistoryImpl localHistoryImpl = localHistory = LocalHistoryImpl.getInstanceImpl();
        Intrinsics.checkExpressionValueIsNotNull((Object)localHistoryImpl, (String)"localHistory");
        IdeaGateway ideaGateway = localHistoryImpl.getGateway();
        if (ideaGateway == null) {
            Intrinsics.throwNpe();
        }
        IdeaGateway gateway = ideaGateway;
        LocalHistoryFacade localHistoryFacade = localHistory.getFacade();
        RootEntry rootEntry = gateway.createTransientRootEntry();
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        VirtualFile virtualFile2 = project3.getBaseDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"project.baseDir");
        RevisionsCollector revisionsCollector = new RevisionsCollector(localHistoryFacade, rootEntry, virtualFile2.getPath(), project2.getLocationHash(), null);
        List revisions = revisionsCollector.getResult();
        Revision endRevision = null;
        Iterator iterator2 = revisions.iterator();
        while (iterator2.hasNext()) {
            GradleSyncState syncState;
            Collection difference2;
            String label2;
            Revision rev;
            Revision revision = rev = (Revision)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"rev");
            if (revision.getLabel() == null) {
                continue;
            }
            if (Intrinsics.areEqual((Object)label2, (Object)NewKotlinActivityActionKt.access$getNEW_KOTLIN_ACTIVITY_END_LABEL$p())) {
                endRevision = rev;
            }
            if (!Intrinsics.areEqual((Object)label2, (Object)NewKotlinActivityActionKt.access$getNEW_KOTLIN_ACTIVITY_START_LABEL$p()) || endRevision == null) continue;
            ArrayList<PsiJavaFile> javaFiles2 = new ArrayList<PsiJavaFile>();
            List differences = endRevision.getDifferencesWith(rev);
            Iterator iterator3 = differences.iterator();
            while (iterator3.hasNext()) {
                PsiJavaFile psiFile;
                Collection collection = difference2 = (Difference)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"difference");
                if (collection.getRight() != null || !difference2.isFile()) continue;
                Entry entry = difference2.getLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"difference.left");
                File file2 = new File(entry.getPath());
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"java")) continue;
                PsiFile psiFile2 = KotlinRefactoringUtilKt.toPsiFile(file2, project2);
                if (!(psiFile2 instanceof PsiJavaFile)) {
                    psiFile2 = null;
                }
                if ((psiFile = (PsiJavaFile)psiFile2) == null) continue;
                javaFiles2.add(psiFile);
            }
            difference2 = javaFiles2;
            if (!(!difference2.isEmpty())) break;
            GradleSyncState gradleSyncState = syncState = GradleSyncState.getInstance((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleSyncState, (String)"syncState");
            if (gradleSyncState.isSyncInProgress()) {
                NewKotlinActivityAction.Companion.convertFilesAfterProjectSync(javaFiles2);
                break;
            }
            JavaToKotlinAction.Companion.convertFiles((List<? extends PsiJavaFile>)javaFiles2, project2, false);
            break;
        }
    }

    private final boolean showWizard(DataContext dataContext) {
        try {
            Object v3;
            Object wizard;
            block9: {
                Object v1;
                KFunction it;
                Iterable $receiver$iv;
                Class<?> wizardClass;
                block8: {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("com.android.tools.idea.wizard.NewAndroidActivityWizard");
                    }
                    catch (ClassNotFoundException e) {
                        clazz = Class.forName("com.android.tools.idea.npw.NewAndroidActivityWizard");
                    }
                    wizardClass = clazz;
                    Constructor<?> constructor2 = wizardClass.getConstructor(Module.class, VirtualFile.class, File.class);
                    wizard = constructor2.newInstance(LangDataKeys.MODULE.getData(dataContext), CommonDataKeys.VIRTUAL_FILE.getData(dataContext), null);
                    Class<?> clazz2 = wizardClass;
                    Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"wizardClass");
                    $receiver$iv = KClasses.getFunctions((KClass)JvmClassMappingKt.getKotlinClass(clazz2));
                    for (Object element$iv : $receiver$iv) {
                        it = (KFunction)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"init")) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                KFunction kFunction = v1;
                if (kFunction != null) {
                    kFunction.call(new Object[]{wizard});
                }
                $receiver$iv = KClasses.getFunctions((KClass)JvmClassMappingKt.getKotlinClass(wizardClass));
                for (Object element$iv : $receiver$iv) {
                    it = (KFunction)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"showAndGet")) continue;
                    v3 = element$iv;
                    break block9;
                }
                v3 = null;
            }
            KFunction kFunction = v3;
            Object object = kFunction != null ? kFunction.call(new Object[]{wizard}) : null;
            if (!(object instanceof Boolean)) {
                object = null;
            }
            Boolean bl = (Boolean)object;
            return bl != null ? bl : false;
        }
        catch (Throwable e) {
            NewKotlinActivityAction.Companion.getLOG().error(e);
            return false;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
        AndroidFacet facet = this.getKotlinFacet(e);
        Presentation presentation = e.getPresentation();
        boolean isProjectReady = facet != null && this.isProjectReady(facet);
        Presentation presentation2 = presentation;
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"presentation");
        presentation2.setText("Kotlin Activity" + (isProjectReady ? "" : " (Project not ready)"));
        presentation.setVisible(view != null && facet != null && this.isVisible(facet));
    }

    private final AndroidFacet getKotlinFacet(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        return module != null ? AndroidFacet.getInstance((Module)module) : null;
    }

    private final boolean isVisible(AndroidFacet facet) {
        try {
            KFunction shouldSetVisible;
            Object v0;
            block4: {
                Iterable $receiver$iv = KClasses.getMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(AndroidFacet.class));
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    KFunction it = (KFunction)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"isGradleProject") || Intrinsics.areEqual((Object)it.getName(), (Object)"requiresAndroidModel"))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            KFunction kFunction = shouldSetVisible = (KFunction)v0;
            return (kFunction != null ? kFunction.call(new Object[]{facet}) : null) != null;
        }
        catch (Throwable e) {
            NewKotlinActivityAction.Companion.getLOG().error(e);
            return false;
        }
    }

    private final boolean isProjectReady(AndroidFacet facet) {
        try {
            KFunction getAndroidProjectInfoFun;
            Object v0;
            block4: {
                Iterable $receiver$iv = KClasses.getMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(AndroidFacet.class));
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    KFunction it = (KFunction)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getIdeaAndroidProject") || Intrinsics.areEqual((Object)it.getName(), (Object)"getAndroidModel"))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            KFunction kFunction = getAndroidProjectInfoFun = (KFunction)v0;
            return (kFunction != null ? kFunction.call(new Object[]{facet}) : null) != null;
        }
        catch (Throwable e) {
            NewKotlinActivityAction.Companion.getLOG().error(e);
            return false;
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof NewKotlinActivityAction;
    }

    public NewKotlinActivityAction() {
        super(KotlinIcons.ACTIVITY);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(NewKotlinActivityAction.class);
        gradleSyncListener = new GradleSyncListener.Adapter(){

            public void syncSucceeded(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                this.convertFiles(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                this.convertFiles(project);
            }

            private final void convertFiles(Project project) {
                if (org.jetbrains.kotlin.android.actions.NewKotlinActivityAction$Companion.access$getJavaFilesToKotlin$p(NewKotlinActivityAction.Companion) != null) {
                    DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(project){
                        final /* synthetic */ Project $project;

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            void $receiver$iv$iv;
                            Iterable $receiver$iv;
                            List list2 = org.jetbrains.kotlin.android.actions.NewKotlinActivityAction$Companion.access$getJavaFilesToKotlin$p(NewKotlinActivityAction.Companion);
                            if (list2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Iterable iterable = $receiver$iv = (Iterable)list2;
                            Collection destination$iv$iv = new ArrayList<E>();
                            for (T element$iv$iv : $receiver$iv$iv) {
                                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                                if (!it.isValid()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List filesToConvert = (List)destination$iv$iv;
                            Collection collection = filesToConvert;
                            if (!collection.isEmpty()) {
                                JavaToKotlinAction.Companion.convertFiles(filesToConvert, this.$project, false);
                            }
                            org.jetbrains.kotlin.android.actions.NewKotlinActivityAction$Companion.access$setJavaFilesToKotlin$p(NewKotlinActivityAction.Companion, null);
                        }
                        {
                            this.$project = project;
                        }
                    });
                }
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0016\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/android/actions/NewKotlinActivityAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "gradleSyncListener", "org/jetbrains/kotlin/android/actions/NewKotlinActivityAction$Companion$gradleSyncListener$1", "getGradleSyncListener", "()Lorg/jetbrains/kotlin/android/actions/NewKotlinActivityAction$Companion$gradleSyncListener$1;", "Lorg/jetbrains/kotlin/android/actions/NewKotlinActivityAction$Companion$gradleSyncListener$1;", "javaFilesToKotlin", "", "Lcom/intellij/psi/PsiJavaFile;", "getJavaFilesToKotlin", "()Ljava/util/List;", "setJavaFilesToKotlin", "(Ljava/util/List;)V", "attachGradleSyncListener", "", "project", "Lcom/intellij/openapi/project/Project;", "attachGradleSyncListener$idea_android", "convertFilesAfterProjectSync", "files", "subscribe", "listener", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListener;", "willBeConvertedToKotlin", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "willBeConvertedToKotlin$idea_android", "idea-android"})
    public static final class Companion {
        public final void attachGradleSyncListener$idea_android(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.subscribe(project, (GradleSyncListener)this.getGradleSyncListener());
        }

        public final boolean willBeConvertedToKotlin$idea_android(@NotNull VirtualFile file2) {
            boolean bl;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                List<PsiJavaFile> list2 = this.getJavaFilesToKotlin();
                if (list2 != null) {
                    Iterable $receiver$iv = list2;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            PsiJavaFile it = (PsiJavaFile)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)file2)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        private final Logger getLOG() {
            return LOG;
        }

        private final List<PsiJavaFile> getJavaFilesToKotlin() {
            return javaFilesToKotlin;
        }

        private final void setJavaFilesToKotlin(List<? extends PsiJavaFile> list2) {
            javaFilesToKotlin = list2;
        }

        private final void convertFilesAfterProjectSync(List<? extends PsiJavaFile> files2) {
            this.setJavaFilesToKotlin(files2);
        }

        private final gradleSyncListener.1 getGradleSyncListener() {
            return gradleSyncListener;
        }

        private final void subscribe(Project project, GradleSyncListener listener2) {
            try {
                Object v0;
                block6: {
                    Iterable iterable;
                    Iterable iterable2 = iterable = (Iterable)KClasses.getFunctions((KClass)Reflection.getOrCreateKotlinClass(GradleSyncState.class));
                    for (Object t : iterable2) {
                        Collection collection;
                        KFunction it = (KFunction)t;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"subscribe") && (collection = (Collection)it.getParameters()).size() == 2)) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                KFunction subscribeFun = v0;
                if (subscribeFun != null) {
                    subscribeFun.call(new Object[]{project, listener2});
                } else {
                    MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
                    Object object = GradleSyncState.class.getDeclaredField("GRADLE_SYNC_TOPIC").get(null);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.messages.Topic<com.android.tools.idea.gradle.project.sync.GradleSyncListener>");
                    }
                    Topic gradleSyncTopic = (Topic)object;
                    connection.subscribe(gradleSyncTopic, (Object)this.getGradleSyncListener());
                }
            }
            catch (Throwable e) {
                this.getLOG().error(e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Nullable
        public static final /* synthetic */ List access$getJavaFilesToKotlin$p(Companion $this) {
            return $this.getJavaFilesToKotlin();
        }

        public static final /* synthetic */ void access$setJavaFilesToKotlin$p(Companion $this, @Nullable List list2) {
            $this.setJavaFilesToKotlin(list2);
        }
    }
}

