/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.inline;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.sql.refactoring.inline.SqlInlineActionHandler;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCteInlineHandler
extends SqlInlineActionHandler {
    private static final String REFACTORING_NAME = "Inline CTE";
    private static final String HELP_ID = null;

    public boolean canInlineElement(PsiElement element) {
        SqlNamedQueryDefinitionImpl q = SqlCteInlineHandler.resolveToNamedQueryDefinition(element);
        if (q == null) {
            return false;
        }
        SqlWithClause with = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        return with != null && !with.isRecursive();
    }

    public void inlineElement(@NotNull Project project, Editor editor, PsiElement element) {
        SqlNamedQueryDefinitionImpl query;
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(0);
        }
        if ((query = SqlCteInlineHandler.resolveToNamedQueryDefinition(element)) == null) {
            return;
        }
        Collection refs = ReferencesSearch.search((PsiElement)query, (SearchScope)query.getUseScope(), (boolean)false).findAll();
        if (refs.size() < 2) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"No usages found", (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> {
            if (project == null) {
                SqlCteInlineHandler.$$$reportNull$$$0(16);
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_NAME, (String)REFACTORING_NAME, () -> {
                if (project == null) {
                    SqlCteInlineHandler.$$$reportNull$$$0(17);
                }
                SqlCteInlineHandler.inlineOp(project, editor, refs, query);
            }, (PsiFile[])new PsiFile[]{element.getContainingFile()});
        });
    }

    @Nullable
    private static List<PsiElement> inlineSubQuery(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element, @NotNull Collection<PsiElement> alias, @NotNull SqlNamedQueryDefinitionImpl query) {
        SqlAsExpression asExpression;
        SqlWithQueryExpression withEx;
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(3);
        }
        if (alias == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(4);
        }
        if (query == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(5);
        }
        if ((withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query.getParent().getParent(), SqlWithQueryExpression.class)) == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"With clause can not be found", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        if (withEx.getWithClause().isRecursive()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Can not inline recursive CTE", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        if (withEx.getExpression() == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"With clause without query", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        String subQueryAlias = query.getName();
        if (StringUtil.isEmpty((String)subQueryAlias)) {
            subQueryAlias = "cte_alias";
        }
        if ((asExpression = (SqlAsExpression)ObjectUtils.tryCast((Object)element.getParent(), SqlAsExpression.class)) != null) {
            subQueryAlias = asExpression.getName();
            element.replace((PsiElement)SqlSubqueryUtils.parenthesized(query.getExpression()));
            result2.add((PsiElement)asExpression);
        } else {
            result2.add(element.replace((PsiElement)SqlSubqueryUtils.aliased(query.getExpression(), subQueryAlias)));
        }
        for (PsiElement a : alias) {
            SqlReferenceExpression identifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)a, SqlReferenceExpression.class);
            if (identifier == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Alias is not identifier", (String)REFACTORING_NAME, (String)HELP_ID);
                continue;
            }
            identifier.setName(subQueryAlias);
            result2.add((PsiElement)identifier);
        }
        return result2;
    }

    private static void inlineOp(@NotNull Project project, @NotNull Editor editor, @NotNull Collection<PsiReference> refs, @NotNull SqlNamedQueryDefinitionImpl query) {
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(7);
        }
        if (refs == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(8);
        }
        if (query == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(9);
        }
        ArrayList<PsiElement> substitute = new ArrayList<PsiElement>();
        ArrayList<PsiElement> alias = new ArrayList<PsiElement>();
        SqlCteInlineHandler.classifyRefs(project, editor, (PsiElement)query, refs, substitute, alias);
        if (substitute.size() != 1) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(substitute.isEmpty() ? "Nothing to inline" : "Too many places to inline"), (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        List<PsiElement> res = SqlCteInlineHandler.inlineSubQuery(project, editor, (PsiElement)substitute.get(0), alias, query);
        if (res == null || res.size() < 1) {
            return;
        }
        SqlExpression ex = SqlCteInlineHandler.getQueryExpression(project, editor, query);
        if (ex == null) {
            return;
        }
        int offset = res.get(0).getTextOffset() - ex.getTextRange().getStartOffset();
        ex = SqlSubqueryUtils.removeCteDefinition(query);
        ex = SqlCteInlineHandler.getExpressionFromExOrWithEx(ex);
        int caretOffset = ex.getTextRange().getStartOffset() + offset;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(caretOffset);
    }

    private static SqlExpression getExpressionFromExOrWithEx(SqlExpression ex) {
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class);
        SqlExpression ex2 = withEx != null ? withEx.getExpression() : null;
        return ex2 != null ? ex2 : ex;
    }

    private static SqlExpression getQueryExpression(Project project, Editor editor, SqlNamedQueryDefinitionImpl el) {
        SqlWithQueryExpression with = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent().getParent(), SqlWithQueryExpression.class);
        if (with == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Failed to find with expression", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        return with.getExpression();
    }

    private static void classifyRefs(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement exclude, @NotNull Collection<PsiReference> refs, @NotNull Collection<PsiElement> substitute, @NotNull Collection<PsiElement> alias) {
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(11);
        }
        if (exclude == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(12);
        }
        if (refs == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(13);
        }
        if (substitute == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(14);
        }
        if (alias == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(15);
        }
        for (PsiReference ref : refs) {
            PsiElement el = ref.getElement();
            if (el == exclude) continue;
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || el.getNode().getElementType() == SqlCompositeElementTypes.SQL_REFERENCE) {
                alias.add(el);
                continue;
            }
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                substitute.add(el);
                continue;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Unexpected reference type", (String)REFACTORING_NAME, (String)HELP_ID);
        }
    }

    @Nullable
    private static SqlNamedQueryDefinitionImpl resolveToNamedQueryDefinition(@Nullable PsiElement element) {
        return (SqlNamedQueryDefinitionImpl)ObjectUtils.tryCast((Object)element, SqlNamedQueryDefinitionImpl.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclude";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitute";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/refactoring/inline/SqlCteInlineHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineSubQuery";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineOp";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "classifyRefs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$inlineElement$1";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

