/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLeafTokenPattern
extends InitialPatternCondition<PsiElement>
implements ElementPattern<PsiElement>,
Cloneable {
    private final List<String[]> mySequences = ContainerUtil.newArrayList();

    protected SqlLeafTokenPattern() {
        super(PsiElement.class);
    }

    public SqlLeafTokenPattern or(String ... names) {
        ContainerUtil.addIfNotNull(this.mySequences, (Object)names);
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        SqlLeafTokenPattern clone = (SqlLeafTokenPattern)super.clone();
        clone.mySequences.addAll(this.mySequences);
        return clone;
    }

    public boolean accepts(@Nullable Object o) {
        return this.accepts(o, new ProcessingContext());
    }

    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        if (this.mySequences.isEmpty() || !(o instanceof PsiElement)) {
            return false;
        }
        PsiElement t = (PsiElement)o;
        int end = t.getTextRange().getEndOffset();
        PsiElement e = PsiTreeUtil.getDeepestVisibleFirst((PsiElement)t);
        if (e != null && !SqlLeafTokenPattern.isInside(e, end)) {
            e = null;
        }
        if (e != null && !SqlLeafTokenPattern.isOk(e)) {
            e = SqlLeafTokenPattern.nextOk(e, end);
        }
        ArrayList variants = ContainerUtil.newArrayList(this.mySequences);
        int i2 = 0;
        while (true) {
            IElementType type = PsiUtilCore.getElementType((PsiElement)e);
            boolean unmatched = false;
            Iterator it = variants.iterator();
            while (it.hasNext()) {
                String[] variant = (String[])it.next();
                if (i2 >= variant.length) {
                    it.remove();
                    continue;
                }
                if (SqlLeafTokenPattern.isToken(type, variant[i2])) continue;
                unmatched = true;
                it.remove();
            }
            if (variants.isEmpty() && !unmatched) break;
            if (e == null) {
                return false;
            }
            if (variants.isEmpty() && unmatched) {
                return false;
            }
            ++i2;
            e = SqlLeafTokenPattern.nextOk(e, end);
        }
        return e == null;
    }

    private static boolean isToken(IElementType token, String value) {
        return token instanceof SqlTokenType && token == SqlTokenRegistry.findTokenType((String)value);
    }

    private static boolean isOk(@NotNull PsiElement e) {
        if (e == null) {
            SqlLeafTokenPattern.$$$reportNull$$$0(0);
        }
        if (e instanceof PsiComment) {
            return false;
        }
        return !SqlTokens.COMMENT_TOKENS.contains(PsiUtilCore.getElementType((PsiElement)e));
    }

    private static boolean isInside(@NotNull PsiElement e, int end) {
        if (e == null) {
            SqlLeafTokenPattern.$$$reportNull$$$0(1);
        }
        return e.getTextRange().getEndOffset() <= end;
    }

    @Nullable
    private static PsiElement nextOk(@Nullable PsiElement e, int end) {
        while (e != null) {
            if ((e = PsiTreeUtil.nextVisibleLeaf((PsiElement)e)) == null || !SqlLeafTokenPattern.isInside(e, end)) {
                return null;
            }
            if (!SqlLeafTokenPattern.isOk(e)) continue;
            return e;
        }
        return null;
    }

    public ElementPatternCondition<PsiElement> getCondition() {
        return new ElementPatternCondition((InitialPatternCondition)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/sql/psi/patterns/SqlLeafTokenPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isOk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInside";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

