/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasOwner;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAsExpressionImpl
extends SqlDefinitionImpl
implements SqlAsExpression,
SqlLocalDefinition,
SqlColumnAliasOwner {
    public SqlAsExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public SqlType getSqlType() {
        SqlExpression expression = this.getExpression();
        SqlType type = expression.getSqlType();
        List<SqlColumnAliasDefinition> aliases = this.getColumnAliasList();
        if (aliases.isEmpty()) {
            if (type instanceof SqlTableType) {
                if (this.getParent() instanceof SqlSelectClause) {
                    SqlTableType tableType = (SqlTableType)type;
                    SqlType sqlType = tableType.getColumnCount() == 1 ? tableType.getColumnType(0) : type;
                    if (sqlType == null) {
                        SqlAsExpressionImpl.$$$reportNull$$$0(1);
                    }
                    return sqlType;
                }
                SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(type, (SqlElement)expression, (PsiElement)this).alias(this.getName(), (PsiElement)this, aliases);
                if (sqlTableType == null) {
                    SqlAsExpressionImpl.$$$reportNull$$$0(2);
                }
                return sqlTableType;
            }
            SqlType sqlType = type;
            if (sqlType == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(3);
            }
            return sqlType;
        }
        SqlTableType tableType = SqlTableTypeBase.ensureTableType(type, (SqlElement)expression, (PsiElement)this);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).getFamilyId().isPostgres()) {
            aliases = SqlTableTypeBase.expand(aliases, tableType.getColumnCount());
        }
        SqlTableType sqlTableType = tableType.alias(this.getName(), (PsiElement)this, aliases);
        if (sqlTableType == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    @Nullable
    public PsiElement getDefinitionScope() {
        PsiElement context = this.getContext();
        if (context instanceof SqlDeclareStatement) {
            return this.getTopmostBlockStatement();
        }
        if (PsiUtilCore.getElementType((PsiElement)context) == SqlCompositeElementTypes.SQL_REFERENCING_CLAUSE && SqlImplUtil.getSqlDialectSafe((PsiElement)this).getFamilyId().isPostgres()) {
            return this.getTopmostBlockStatement();
        }
        if (context instanceof SqlSelectClause && SqlAsExpressionImpl.areAnyContextEnlargersUpwards(context)) {
            return this.getTopmostBlockStatement();
        }
        return PsiTreeUtil.getContextOfType((PsiElement)this, SqlStatement.class, (boolean)true);
    }

    private static boolean areAnyContextEnlargersUpwards(@NotNull PsiElement element) {
        if (element == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(5);
        }
        for (PsiElement tmp = element; tmp != null; tmp = tmp.getContext()) {
            if (tmp instanceof SqlSelectClause || tmp instanceof SqlSetOperatorExpression || tmp instanceof SqlJoinExpression) continue;
            if (tmp instanceof SqlQueryExpression && PsiTreeUtil.getNextSiblingOfType((PsiElement)((SqlQueryExpression)tmp).getSelectClause(), SqlSelectIntoNewTableClauseImpl.class) != null) {
                return true;
            }
            if (tmp instanceof SqlCreateTableStatement) {
                return true;
            }
            if (tmp instanceof SqlStatement) {
                return false;
            }
            if (tmp instanceof SqlFunctionCallExpression) {
                return false;
            }
            if (!(tmp instanceof SqlBinaryExpression)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement scope = this.getDefinitionScope();
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(scope == null ? this.getContainingFile() : scope));
        if (localSearchScope == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(6);
        }
        return localSearchScope;
    }

    protected SqlBlockStatementImpl getTopmostBlockStatement() {
        SqlBlockStatementImpl next;
        SqlBlockStatementImpl answer = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{SqlBlockStatementImpl.class});
        while ((next = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)answer, (Class[])new Class[]{SqlBlockStatementImpl.class})) != null) {
            answer = next;
        }
        return answer;
    }

    @NotNull
    public List<SqlColumnAliasDefinition> getColumnAliasList() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlColumnAliasDefinition.class);
        if (list == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlAsExpression((SqlAsExpression)this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        SqlIdentifier sqlIdentifier = this.getNameElement();
        if (sqlIdentifier == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(8);
        }
        return sqlIdentifier;
    }

    @NotNull
    public SqlIdentifier getNameElement() {
        SqlIdentifier sqlIdentifier = (SqlIdentifier)this.findNotNullChildByClass(SqlIdentifier.class);
        if (sqlIdentifier == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(9);
        }
        return sqlIdentifier;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
        if (objectKind == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(10);
        }
        return objectKind;
    }

    @NotNull
    public PsiReference getReference() {
        SqlIdentifier nameElement = this.getNameElement();
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)this);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        PsiReferenceBase psiReferenceBase = ref;
        if (psiReferenceBase == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(11);
        }
        return psiReferenceBase;
    }

    @NotNull
    public SqlExpression getExpression() {
        List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlExpression.class);
        if (expressions.isEmpty()) {
            SqlDialectImplUtil.LOG.error(String.format("%s: no alias in [%s]", SqlImplUtil.getSqlDialectSafe((PsiElement)this).getID(), this.getParent().getText()));
        }
        SqlExpression sqlExpression = (SqlExpression)expressions.get(0);
        if (sqlExpression == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(12);
        }
        return sqlExpression;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Variable;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        SqlReferenceExpression asExpression;
        boolean isChild;
        if (processor == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(13);
        }
        if (state == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(15);
        }
        if (isChild = PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)place, (boolean)true)) {
            if (place.getParent() instanceof SqlReferenceList && this.getLastChild() == place.getParent()) {
                return processor.execute(place, state);
            }
            if (this.getNode().getElementType() == SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION && !processor.execute((PsiElement)this, state)) {
                return false;
            }
        }
        return !((asExpression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getExpression(), SqlReferenceExpression.class)) != null && this.getColumnAliasList().isEmpty() ? asExpression != lastParent && !SqlImplUtil.processQualifier(asExpression, processor, state, place) : !isChild && !SqlImplUtil.processDeclarationsInType((SqlExpression)this, processor, state, place));
    }

    @Override
    @NotNull
    public SqlType getAliasedSqlType(@NotNull SqlColumnAliasDefinition alias) {
        int index;
        if (alias == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(16);
        }
        if ((index = this.getColumnAliasList().indexOf(alias)) == -1) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(17);
            }
            return sqlPrimitiveType;
        }
        SqlType type = this.getExpression().getSqlType();
        SqlTableType tableType = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
        if (tableType != null) {
            Object object = index < tableType.getColumnCount() ? tableType.getColumnType(index) : SqlType.UNKNOWN;
            if (object == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(18);
            }
            return object;
        }
        Object object = index == 0 ? type : SqlType.UNKNOWN;
        if (object == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(19);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlAsExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlAsExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliasList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasedSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areAnyContextEnlargersUpwards";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

