/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final boolean sourcePlain;
    public final SqlLanguageDialectEx dialect;
    public final CasingProvider casingProvider;
    public final String[] actualCache;

    public NameChecker(@NotNull DasObject object, SqlLanguageDialectEx dialect) {
        if (object == null) {
            NameChecker.$$$reportNull$$$0(0);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourcePlain = !DbSqlUtil.isQuoted(object);
        this.sourceText = object.getName();
        this.casingProvider = dialect;
    }

    public NameChecker(@NotNull SqlReferenceExpression ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(1);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourcePlain = !DbSqlUtil.isQuoted((SqlNameElement)ref);
        this.sourceText = ref.getName();
        this.casingProvider = provider;
    }

    NameChecker(@NotNull SqlReferenceImpl ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(2);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourceText = ref.getReferenceName();
        this.sourcePlain = !DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)ref.getElement(), SqlNameElement.class));
        this.casingProvider = provider;
    }

    @Nullable
    private static DasObject getDasContext(@Nullable SqlExpression qualifier) {
        PsiReference reference = qualifier == null ? null : qualifier.getReference();
        PsiElement target2 = reference == null ? null : reference.resolve();
        return target2 instanceof DasObject ? (DasObject)target2 : null;
    }

    @Nullable
    private static String getName(@NotNull Object target2) {
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(3);
        }
        if (target2 instanceof DasObject) {
            return ((DasObject)target2).getName();
        }
        if (target2 instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)target2).getName();
        }
        return null;
    }

    private static boolean isQuoted(@NotNull Object target2) {
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(4);
        }
        if (target2 instanceof DasObject) {
            return DbSqlUtil.isQuoted((DasObject)target2);
        }
        if (target2 instanceof SqlReferenceExpression) {
            return DbSqlUtil.isQuoted((SqlNameElement)((SqlReferenceExpression)target2));
        }
        return false;
    }

    public boolean checkName(@Nullable Object target2, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        if (target2 == null) {
            return false;
        }
        String name = NameChecker.getName(target2);
        if (name == null) {
            throw new IllegalArgumentException(target2.getClass().getName());
        }
        if (!Comparing.strEqual((String)name, (String)this.sourceText, (boolean)false) && (name = this.getAltName(target2)) == null) {
            return false;
        }
        DatabaseDialectEx databaseDialect = this.dialect.getDatabaseDialect();
        boolean isBuiltInFunction = target2 instanceof BuiltinFunction;
        if (isBuiltInFunction && databaseDialect.getFamilyId().isSybase()) {
            return true;
        }
        if (isBuiltInFunction && databaseDialect.getFamilyId().isTransactSql() && ((BuiltinFunction)target2).getPostfixType() == null) {
            return this.sourcePlain;
        }
        boolean targetIsPlain = !NameChecker.isQuoted(target2);
        Casing inPlaceCasing = NameChecker.getCasing(target2, this.casingProvider);
        Case targetCase = inPlaceCasing.choose(targetIsPlain);
        Case sourceCase = inPlaceCasing.choose(this.sourcePlain);
        String targetActual = SqlImplUtil.getActualName(target2, name, targetIsPlain, this.casingProvider);
        if (forcedCaseSens != null) {
            return this.compareWithSource(targetActual, sourceCase, forcedCaseSens == Boolean.TRUE);
        }
        if (isBuiltInFunction) {
            return this.compareWithSource(targetActual, sourceCase, sourceCase == Case.EXACT && !this.sourcePlain);
        }
        boolean targetCaseSensitive = targetCase != Case.MIXED;
        boolean sourceCaseSensitive = sourceCase != Case.MIXED;
        boolean bl = caseSensitive = sourceCaseSensitive && targetCaseSensitive;
        return this.compareWithSource(targetActual, sourceCase, caseSensitive);
    }

    @Nullable
    protected String getAltName(@NotNull Object target2) {
        SqlAltNamesProvider altNames;
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(5);
        }
        if ((altNames = (SqlAltNamesProvider)ObjectUtils.tryCast((Object)target2, SqlAltNamesProvider.class)) == null) {
            return null;
        }
        for (String text2 : altNames.getAltNames()) {
            if (!Comparing.strEqual((String)text2, (String)this.sourceText, (boolean)false)) continue;
            return text2;
        }
        return null;
    }

    @NotNull
    private static Casing getCasing(@NotNull Object target2, CasingProvider casingProvider) {
        DasObject object;
        if (target2 == null) {
            NameChecker.$$$reportNull$$$0(6);
        }
        if ((object = (DasObject)ObjectUtils.tryCast((Object)target2, DasObject.class)) != null) {
            Casing casing = casingProvider.getCasing(object.getKind(), object);
            if (casing == null) {
                NameChecker.$$$reportNull$$$0(7);
            }
            return casing;
        }
        ObjectKind kind = ((SqlReferenceExpression)target2).getReferenceElementType().getTargetKind();
        DasObject context = NameChecker.getDasContext(((SqlReferenceExpression)target2).getQualifierExpression());
        Casing casing = casingProvider.getCasing(kind, context);
        if (casing == null) {
            NameChecker.$$$reportNull$$$0(8);
        }
        return casing;
    }

    private boolean compareWithSource(String targetActual, Case sourceCase, boolean caseSensitive) {
        if (!caseSensitive) {
            return Comparing.strEqual((String)targetActual, (String)this.sourceText, (boolean)false);
        }
        return Comparing.strEqual((String)targetActual, (String)this.getSourceActual(sourceCase), (boolean)true);
    }

    private String getSourceActual(Case sourceCase) {
        if (sourceCase == Case.EXACT || sourceCase == Case.MIXED) {
            return this.sourceText;
        }
        int i2 = sourceCase == Case.LOWER ? 0 : 1;
        return this.actualCache[i2] == null ? sourceCase.apply(this.sourceText) : this.actualCache[i2];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/NameChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/NameChecker";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAltName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

