/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.ObjectUtils;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlInsertValuesInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.insert.values", new Object[0]);
        if (string == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(3);
        }
        final DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlValuesExpression(SqlValuesExpression o) {
                super.visitSqlValuesExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlDmlInstruction insertStatement = (SqlDmlInstruction)ObjectUtils.tryCast((Object)o.getParent(), SqlDmlInstruction.class);
                if (insertStatement != null) {
                    SqlTableType targetType = insertStatement.getTargetType();
                    Pair<Integer, Integer> minMax = this.minMaxColumnCount(targetType);
                    if ((Integer)minMax.second <= 0) {
                        return;
                    }
                    int counter = 0;
                    for (SqlExpression expression : o.getExpressions()) {
                        int actual;
                        ++counter;
                        if (this.shouldNotCheckElement((SqlElement)expression)) continue;
                        SqlType type = expression.getSqlType();
                        int n = type instanceof SqlTableType ? ((SqlTableType)type).getColumnCount() : (actual = type == SqlType.UNKNOWN ? 0 : 1);
                        if (actual == 0) continue;
                        this.checkElement(expression, (Integer)minMax.second, (Integer)minMax.first, actual);
                    }
                    if (counter == 0) {
                        this.checkElement((SqlExpression)o, (Integer)minMax.second, (Integer)minMax.first, 0);
                    }
                }
            }

            @NotNull
            private Pair<Integer, Integer> minMaxColumnCount(@NotNull SqlTableType targetType) {
                int max;
                if (targetType == null) {
                    1.$$$reportNull$$$0(0);
                }
                int min = max = targetType.getColumnCount();
                for (int i2 = 0; i2 < max; ++i2) {
                    boolean hasDefaultOrNullable;
                    PsiElement element = targetType.getColumnElement(i2);
                    if (!(element instanceof DasColumn)) continue;
                    DasColumn column = (DasColumn)element;
                    boolean isPostgres = familyId.isPostgres();
                    boolean supportsAutoInc = familyId.isTransactSql() || isPostgres;
                    boolean isAutoInc = DasUtil.isAutoGenerated((DasColumn)column);
                    boolean isComputed = DasUtil.isComputed((DasColumn)column);
                    boolean bl = hasDefaultOrNullable = column.getDefault() != null || !column.isNotNull();
                    if (supportsAutoInc && isAutoInc || isPostgres && hasDefaultOrNullable || isComputed) {
                        --min;
                    }
                    if (!isComputed) continue;
                    --max;
                }
                Pair pair = Pair.create((Object)min, (Object)max);
                if (pair == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pair;
            }

            public void visitSqlExpression(SqlExpression o) {
                super.visitSqlExpression(o);
                if (o instanceof SqlSetOperatorExpression) {
                    int i2;
                    SqlSetOperatorExpression setExpr = (SqlSetOperatorExpression)o;
                    List operands = setExpr.getOperands();
                    if (operands.size() < 2) {
                        return;
                    }
                    TIntArrayList counts = new TIntArrayList(operands.size());
                    for (SqlExpression operand : operands) {
                        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)operand.getSqlType(), SqlTableType.class);
                        int size = type == null ? -1 : type.getColumnCount();
                        counts.add(size);
                    }
                    TIntArrayList errors = new TIntArrayList(operands.size());
                    int sz = -1;
                    for (i2 = 0; i2 < counts.size(); ++i2) {
                        int cur = counts.get(i2);
                        if (cur == -1) {
                            counts.set(i2, sz);
                            continue;
                        }
                        if (sz == -1) {
                            sz = cur;
                        }
                        if (cur != sz) {
                            errors.add(i2 - 1);
                        }
                        sz = cur;
                    }
                    if (!errors.isEmpty()) {
                        for (i2 = 0; i2 < errors.size(); ++i2) {
                            int k = errors.get(i2);
                            PsiElement sign = setExpr.getOpSignElement(k);
                            this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ObjectUtils.chooseNotNull((Object)sign, (Object)o), "Left and right operands should have the same number of columns, got " + counts.get(k) + " and " + counts.get(k + 1), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        }
                    }
                }
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                super.visitSqlQueryExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlDmlInstruction insertStatement = (SqlDmlInstruction)ObjectUtils.tryCast((Object)o.getParent(), SqlDmlInstruction.class);
                SqlInsertStatement insert = (SqlInsertStatement)ObjectUtils.tryCast((Object)(insertStatement == null ? null : insertStatement.getParent()), SqlInsertStatement.class);
                if (insert != null) {
                    assert (insertStatement != null);
                    SqlTableType exprType = (SqlTableType)ObjectUtils.tryCast((Object)o.getSqlType(), SqlTableType.class);
                    if (exprType == null) {
                        return;
                    }
                    SqlTableType targetType = insertStatement.getTargetType();
                    Pair<Integer, Integer> targetMinMax = this.minMaxColumnCount(targetType);
                    if ((Integer)targetMinMax.second <= 0) {
                        return;
                    }
                    this.checkElement((SqlExpression)o, (Integer)targetMinMax.second, (Integer)targetMinMax.first, exprType.getColumnCount());
                }
            }

            private void checkElement(SqlExpression anchor, int max, int min, int actual) {
                if (actual > max || actual < min) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)anchor, SqlMessages.message("incorrect.values.number", max == min ? Integer.valueOf(max) : "from " + min + " to " + max, actual), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/inspections/SqlInsertValuesInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/inspections/SqlInsertValuesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "minMaxColumnCount";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "minMaxColumnCount";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlInsertValuesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlInsertValuesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

