/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.postgres.psi.FunctionBodyInjector;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDeepSyntaxHighlighter
extends SqlSyntaxHighlighter {
    private final Map<Language, SyntaxHighlighter> myHighlighters;
    private final IElementType myInjectionTokenType;
    private final Factory<Lexer> myBaseLexerFactory;

    public SqlDeepSyntaxHighlighter(@NotNull SqlLanguageDialect dialect, @Nullable Project project, @Nullable VirtualFile file, @NotNull Factory<Lexer> factory, @Nullable IElementType injectionTokenType) {
        if (dialect == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        super(dialect, project, file);
        this.myHighlighters = ConcurrentFactoryMap.createMap(l -> SyntaxHighlighterFactory.getSyntaxHighlighter((Language)l, (Project)this.getProject(), null));
        this.myBaseLexerFactory = factory;
        this.myInjectionTokenType = (IElementType)ObjectUtils.notNull((Object)injectionTokenType, (Object)SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        PsiLanguageInjectionHost host = this.findInjectionHost();
        Language hostLanguage = SqlPreprocessingLexer.getHostLanguage((PsiElement)host);
        MyLayeredLexer myLayeredLexer = new MyLayeredLexer((Lexer)this.myBaseLexerFactory.create(), (SqlLanguageDialect)ObjectUtils.notNull((Object)this.getDialect()), hostLanguage, new LayersCache());
        if (myLayeredLexer == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        return myLayeredLexer;
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType instanceof SqlTokenType.SqlInjectionMark) {
            TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(this.myInjectionTokenType);
            if (textAttributesKeyArray == null) {
                SqlDeepSyntaxHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        if (tokenType != null && !(tokenType.getLanguage() instanceof SqlLanguageDialect) && tokenType.getLanguage() != SqlLanguage.INSTANCE && tokenType.getLanguage() != Language.ANY) {
            SyntaxHighlighter highlighter = this.myHighlighters.get(tokenType.getLanguage());
            TextAttributesKey[] textAttributesKeyArray = highlighter == null ? SqlDeepSyntaxHighlighter.pack(null) : highlighter.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                SqlDeepSyntaxHighlighter.$$$reportNull$$$0(4);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(5);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/highlighting/SqlDeepSyntaxHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/highlighting/SqlDeepSyntaxHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLayeredLexer
    extends SqlSyntaxHighlighter.MyLayeredLexer {
        private final LayersCache myCache;

        public MyLayeredLexer(@NotNull Lexer lexer, @NotNull SqlLanguageDialect dialect, @Nullable Language hostLanguage, @NotNull LayersCache cache) {
            if (lexer == null) {
                MyLayeredLexer.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                MyLayeredLexer.$$$reportNull$$$0(1);
            }
            if (cache == null) {
                MyLayeredLexer.$$$reportNull$$$0(2);
            }
            super(SqlPreprocessingLexer.withPreprocessingIfNeeded(lexer, (Language)dialect, hostLanguage, DatabaseSettings.getSettings()), dialect.getDatabaseDialect());
            this.myCache = cache;
        }

        @Nullable
        protected Lexer findLayerLexer(IElementType baseTokenType) {
            if (baseTokenType instanceof SqlTokenType.SqlInjectionMark) {
                String injection = ((SqlTokenType.SqlInjectionMark)baseTokenType).getInjection();
                if (injection.equals("sql") || injection.equals("pgsql")) {
                    return (Lexer)this.myCache.recursiveLexers.get((Object)this);
                }
                return this.myCache.terminalLexers.get(injection);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cache";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/highlighting/SqlDeepSyntaxHighlighter$MyLayeredLexer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LayersCache {
        Map<String, Lexer> terminalLexers = FactoryMap.create(inj -> {
            Pair<Language, String> spec = FunctionBodyInjector.getBlockByLangSpec(inj);
            if (spec == null || spec.first == null) {
                return null;
            }
            LightVirtualFile file = spec.second == null ? null : new LightVirtualFile("inj." + (String)spec.second, (Language)spec.first, (CharSequence)"");
            return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)((Language)spec.first), (Project)SqlDeepSyntaxHighlighter.this.getProject(), (VirtualFile)file).getHighlightingLexer();
        });
        Map<MyLayeredLexer, MyLayeredLexer> recursiveLexers = FactoryMap.create(l -> new MyLayeredLexer((Lexer)SqlDeepSyntaxHighlighter.this.myBaseLexerFactory.create(), (SqlLanguageDialect)ObjectUtils.notNull((Object)SqlDeepSyntaxHighlighter.this.getDialect()), (Language)SqlDeepSyntaxHighlighter.this.getDialect(), ((MyLayeredLexer)l).myCache));

        private LayersCache() {
        }
    }
}

