/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SqlEditorOptions", storages={@Storage(value="editor.xml")})
public class SqlEditorOptions
implements PersistentStateComponent<SqlEditorOptions> {
    private boolean myConcatenateStringsOnEnter = true;
    private QualificationType myQualificationType = QualificationType.SMART;
    private QualificationType myTableQualification = QualificationType.SMART;
    private QualificationType myAliasQualification = QualificationType.SMART;

    private SqlEditorOptions load(SqlEditorOptions options) {
        this.myConcatenateStringsOnEnter = options.myConcatenateStringsOnEnter;
        this.myQualificationType = options.myQualificationType;
        this.myTableQualification = options.myTableQualification;
        this.myAliasQualification = options.myAliasQualification;
        return this;
    }

    @Nullable
    public SqlEditorOptions getState() {
        return new SqlEditorOptions().load(this);
    }

    public void loadState(SqlEditorOptions state) {
        if (state != null) {
            this.load(state);
        }
    }

    public boolean isConcatenateStringsOnEnter() {
        return this.myConcatenateStringsOnEnter;
    }

    public void setConcatenateStringsOnEnter(boolean concatenateStringsOnEnter) {
        this.myConcatenateStringsOnEnter = concatenateStringsOnEnter;
    }

    @NotNull
    public QualificationType getNamespaceQualification() {
        QualificationType qualificationType = this.myQualificationType;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(0);
        }
        return qualificationType;
    }

    public void setNamespaceQualification(QualificationType type) {
        this.myQualificationType = type;
    }

    @NotNull
    public QualificationType getTableQualification() {
        QualificationType qualificationType = this.myTableQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(1);
        }
        return qualificationType;
    }

    public void setTableQualification(QualificationType type) {
        this.myTableQualification = type;
    }

    @NotNull
    public QualificationType getAliasQualification() {
        QualificationType qualificationType = this.myAliasQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(2);
        }
        return qualificationType;
    }

    public void setAliasQualification(QualificationType type) {
        this.myAliasQualification = type;
    }

    @NotNull
    public static SqlEditorOptions getInstance() {
        SqlEditorOptions sqlEditorOptions = (SqlEditorOptions)ServiceManager.getService(SqlEditorOptions.class);
        if (sqlEditorOptions == null) {
            SqlEditorOptions.$$$reportNull$$$0(3);
        }
        return sqlEditorOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlEditorOptions options = (SqlEditorOptions)o;
        return this.myConcatenateStringsOnEnter == options.myConcatenateStringsOnEnter && this.myQualificationType == options.myQualificationType && this.myTableQualification == options.myTableQualification && this.myAliasQualification == options.myAliasQualification;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myConcatenateStringsOnEnter, this.myQualificationType, this.myTableQualification, this.myAliasQualification});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/editor/SqlEditorOptions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceQualification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableQualification";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasQualification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum QualificationType {
        ALWAYS{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return true;
            }

            public String toString() {
                return "Always";
            }
        }
        ,
        SMART{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return conflictedObjectsCount > 1;
            }

            public String toString() {
                return "On collisions";
            }
        }
        ,
        NOT_QUALIFY{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return false;
            }

            public String toString() {
                return "Never";
            }
        };


        public abstract boolean shouldQualify(int var1);
    }
}

