/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol.psi;

import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.exasol.ExasolTypes;
import com.intellij.sql.dialects.postgres.psi.FunctionBodyInjector;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlInjectableRawInput;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExaScriptBodyInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            ExaScriptBodyInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ExaScriptBodyInjector.$$$reportNull$$$0(1);
        }
        if (!(context instanceof SqlInjectableRawInput)) {
            return;
        }
        if (!SqlImplUtil.getSqlDialectSafe(context).getFamilyId().isExasol()) {
            return;
        }
        Pair<Language, String> pair = ExaScriptBodyInjector.calcBodyLanguage(context);
        Language language = (Language)Pair.getFirst(pair);
        if (language == null) {
            return;
        }
        String extension = (String)pair.second;
        if (extension != null && registrar instanceof MultiHostRegistrarImpl) {
            ((MultiHostRegistrarImpl)registrar).setFileExtension(extension);
        }
        SqlInjectableRawInput host = (SqlInjectableRawInput)context;
        registrar.startInjecting(language);
        registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, ElementManipulators.getValueTextRange((PsiElement)host));
        registrar.doneInjecting();
    }

    @Nullable
    public static Pair<Language, String> calcBodyLanguage(@NotNull PsiElement context) {
        IElementType type;
        PsiElement lang;
        if (context == null) {
            ExaScriptBodyInjector.$$$reportNull$$$0(2);
        }
        Object object = lang = context.getParent() instanceof SqlCreateStatement ? context : null;
        while (lang != null) {
            if (lang instanceof LeafPsiElement && ((type = ((LeafPsiElement)lang).getElementType()) == ExasolTypes.EXA_SET || type == ExasolTypes.EXA_SCALAR || type == ExasolTypes.EXA_ADAPTER)) {
                lang = lang.getPrevSibling();
                break;
            }
            lang = lang.getPrevSibling();
        }
        while (lang != null) {
            type = lang.getNode().getElementType();
            if (type instanceof SqlKeywordTokenType || type == SqlTokens.SQL_IDENT) {
                if (type != ExasolTypes.EXA_CREATE && type != ExasolTypes.EXA_OR && type != ExasolTypes.EXA_REPLACE) break;
                lang = null;
                break;
            }
            lang = lang.getPrevSibling();
        }
        return ExaScriptBodyInjector.getBlockByLangSpec(lang == null ? null : lang.getText());
    }

    @Nullable
    public static Pair<Language, String> getBlockByLangSpec(@Nullable String text2) {
        text2 = text2 == null ? "lua" : Case.LOWER.apply(text2);
        Language language = null;
        String extension = text2;
        if (text2.equals("r")) {
            language = Language.findLanguageByID((String)"R");
            extension = "r";
        } else if (text2.contains("python")) {
            language = Language.findLanguageByID((String)"Python");
            extension = "py";
        } else if (text2.equals("lua")) {
            language = Language.findLanguageByID((String)"Lua");
            extension = "lua";
        } else if (text2.equals("java")) {
            language = Language.findLanguageByID((String)"Java");
            extension = "java";
        }
        return language == null ? FunctionBodyInjector.findLanguage(text2, extension) : Pair.create((Object)language, (Object)extension);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlInjectableRawInput>> list = Collections.singletonList(SqlInjectableRawInput.class);
        if (list == null) {
            ExaScriptBodyInjector.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/exasol/psi/ExaScriptBodyInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/exasol/psi/ExaScriptBodyInjector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcBodyLanguage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

