/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.db2.Db2OptionalKeywords;
import com.intellij.sql.dialects.db2.Db2ReservedKeywords;
import com.intellij.sql.dialects.db2.Db2Tokens;
import com.intellij.sql.dialects.db2.Db2Types;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Dialect
extends SqlLanguageDialectEx {
    public static final Db2Dialect INSTANCE = new Db2Dialect();
    protected static final ReservedEntity RE_PREVVAL = new ReservedEntity("prevval", ObjectKind.COLUMN);

    public Db2Dialect() {
        super("DB2");
    }

    @NotNull
    public String getDisplayName() {
        if ("DB2" == null) {
            Db2Dialect.$$$reportNull$$$0(0);
        }
        return "DB2";
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.Db2Dialect db2Dialect = com.intellij.database.dialects.Db2Dialect.INSTANCE;
        if (db2Dialect == null) {
            Db2Dialect.$$$reportNull$$$0(1);
        }
        return db2Dialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            Db2Dialect.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(Db2Tokens.class);
        if (set == null) {
            Db2Dialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            Db2Dialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            Db2Dialect.$$$reportNull$$$0(6);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, Db2Dialect.RE_PREVVAL.name, resolve) && SqlImplUtil.getQualifierKind(element) == ObjectKind.SEQUENCE && !processor.executeTarget(RE_PREVVAL, element, this.INTEGER, false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            Db2Dialect.$$$reportNull$$$0(7);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "int";
            }
            case BYTES: {
                return "blob";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            Db2Dialect.$$$reportNull$$$0(8);
        }
        if ((name = super.getNormalizedTypeName(name)).equals("INT")) {
            if ("INTEGER" == null) {
                Db2Dialect.$$$reportNull$$$0(9);
            }
            return "INTEGER";
        }
        if (name.equals("DEC")) {
            if ("DECIMAL" == null) {
                Db2Dialect.$$$reportNull$$$0(10);
            }
            return "DECIMAL";
        }
        if (name.equals("NUMERIC")) {
            if ("DECIMAL" == null) {
                Db2Dialect.$$$reportNull$$$0(11);
            }
            return "DECIMAL";
        }
        if (name.equals("NUM")) {
            if ("DECIMAL" == null) {
                Db2Dialect.$$$reportNull$$$0(12);
            }
            return "DECIMAL";
        }
        if (name.equals("FLOAT")) {
            if ("DOUBLE" == null) {
                Db2Dialect.$$$reportNull$$$0(13);
            }
            return "DOUBLE";
        }
        if (name.equals("DOUBLE PRECISION")) {
            if ("DOUBLE" == null) {
                Db2Dialect.$$$reportNull$$$0(14);
            }
            return "DOUBLE";
        }
        if (name.equals("CHARACTER")) {
            if ("CHAR" == null) {
                Db2Dialect.$$$reportNull$$$0(15);
            }
            return "CHAR";
        }
        if (name.equals("CHAR LARGE OBJECT")) {
            if ("CLOB" == null) {
                Db2Dialect.$$$reportNull$$$0(16);
            }
            return "CLOB";
        }
        if (name.equals("CHARACTER LARGE OBJECT")) {
            if ("CLOB" == null) {
                Db2Dialect.$$$reportNull$$$0(17);
            }
            return "CLOB";
        }
        if (name.equals("CHAR VARYING")) {
            if ("VARCHAR" == null) {
                Db2Dialect.$$$reportNull$$$0(18);
            }
            return "VARCHAR";
        }
        if (name.equals("CHARACTER VARYING")) {
            if ("VARCHAR" == null) {
                Db2Dialect.$$$reportNull$$$0(19);
            }
            return "VARCHAR";
        }
        if (name.equals("NCHAR")) {
            if ("GRAPHIC" == null) {
                Db2Dialect.$$$reportNull$$$0(20);
            }
            return "GRAPHIC";
        }
        if (name.equals("NATIONAL CHAR")) {
            if ("GRAPHIC" == null) {
                Db2Dialect.$$$reportNull$$$0(21);
            }
            return "GRAPHIC";
        }
        if (name.equals("NATIONAL CHARACTER")) {
            if ("GRAPHIC" == null) {
                Db2Dialect.$$$reportNull$$$0(22);
            }
            return "GRAPHIC";
        }
        if (name.equals("NVARCHAR")) {
            if ("VARGRAPHIC" == null) {
                Db2Dialect.$$$reportNull$$$0(23);
            }
            return "VARGRAPHIC";
        }
        if (name.equals("NATIONAL CHAR VARYING")) {
            if ("VARGRAPHIC" == null) {
                Db2Dialect.$$$reportNull$$$0(24);
            }
            return "VARGRAPHIC";
        }
        if (name.equals("NATIONAL CHARACTER VARYING")) {
            if ("VARGRAPHIC" == null) {
                Db2Dialect.$$$reportNull$$$0(25);
            }
            return "VARGRAPHIC";
        }
        if (name.equals("NCLOB")) {
            if ("DBCLOB" == null) {
                Db2Dialect.$$$reportNull$$$0(26);
            }
            return "DBCLOB";
        }
        if (name.equals("BINARY LARGE OBJECT")) {
            if ("BLOB" == null) {
                Db2Dialect.$$$reportNull$$$0(27);
            }
            return "BLOB";
        }
        String string = name;
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            Db2Dialect.$$$reportNull$$$0(29);
        }
        if ("GRAPHIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2Dialect.$$$reportNull$$$0(30);
            }
            return category;
        }
        if ("VARGRAPHIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2Dialect.$$$reportNull$$$0(31);
            }
            return category;
        }
        if ("DBCLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2Dialect.$$$reportNull$$$0(32);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            Db2Dialect.$$$reportNull$$$0(33);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/db2/Db2Dialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/db2/Db2Dialect";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(Db2ReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, Db2OptionalKeywords.DB2_CONCAT, SqlElementTypes.SQL_LEFT_BRACKET});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end for;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_FOR, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_ATOMIC, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATIC, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATEMENTS, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "until  end repeat;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end while;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_WHILE, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

