/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.vfs.SearchPath;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.highlighting.QuoteIdentifierQuickFix;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialectEx
extends SqlLanguageDialect
implements CasingProvider {
    public static final SqlType REFERENCE = SqlTypeFactory.of(DataTypeFactory.of("reference"), SqlType.Category.REFERENCE);
    protected final SqlType BOOLEAN;
    protected final SqlType STRING;
    protected final SqlType INTEGER;
    protected final SqlType DATE_TIME;
    protected Map<String, SqlFunctionDefinition.Type> myTypes;
    protected static final ReservedEntity RE_NEXTVAL = new ReservedEntity("nextval", ObjectKind.COLUMN);
    protected static final ReservedEntity RE_CURRVAL = new ReservedEntity("currval", ObjectKind.COLUMN);
    protected static final ReservedEntity RE_DUAL = new ReservedEntity("dual", ObjectKind.TABLE);
    private static final Set<ObjectKind> ourUnresolvableKinds = ContainerUtil.newConcurrentSet();

    public SqlLanguageDialectEx(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(0);
        }
        super(id);
        this.BOOLEAN = SqlTypeFactory.defaultType(SqlType.Category.BOOLEAN, this);
        this.STRING = SqlTypeFactory.defaultType(SqlType.Category.STRING, this);
        this.INTEGER = SqlTypeFactory.defaultType(SqlType.Category.INTEGER, this);
        this.DATE_TIME = SqlTypeFactory.defaultType(SqlType.Category.DATE_TIME, this);
        this.myTypes = ContainerUtil.newHashMap();
        SqlFunctionDefinition.addSimpleTypes(this.myTypes, this);
    }

    @NotNull
    public abstract DatabaseDialectEx getDatabaseDialect();

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = this.getDatabaseDialect().getFamilyId();
        if (databaseFamilyId == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return false;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(3);
        }
        if ((SqlImplUtil.equalsInsensitiveOrTrue(name, SqlLanguageDialectEx.RE_NEXTVAL.name, resolve) || SqlImplUtil.equalsInsensitiveOrTrue(name, SqlLanguageDialectEx.RE_CURRVAL.name, resolve)) && SqlImplUtil.getQualifierKind(element) == ObjectKind.SEQUENCE) {
            if (!processor.executeTarget(RE_NEXTVAL, element, this.INTEGER, false, ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget(RE_CURRVAL, element, this.INTEGER, false, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, false);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (!(type instanceof SqlKeywordTokenType) || !(!pl ? this.isReservedKeyword(type) : this.isReservedKeywordPL(type))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.1.should.be.quoted", o.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text2 = o.getText();
        if (text2.length() <= 0 || Character.isLetter(text2.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    protected static boolean processReservedEntitiesWithTypeDual(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(5);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, SqlFromClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) == null) {
            return true;
        }
        if (element instanceof SqlReferenceExpression && ((SqlReferenceExpression)element).getQualifierExpression() != null) {
            return true;
        }
        return SqlLanguageDialectEx.processReservedEntitiesWithTypeSimple(RE_DUAL, (SqlType)SqlTableTypeBase.EMPTY_TABLE, name, element, resolve, processor, true, false);
    }

    protected static boolean processReservedEntitiesWithTypeSimple(DasObject entity, SqlType result2, @Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor, boolean checkType, Boolean forcedCaseSense) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(7);
        }
        return !SqlImplUtil.equalsInsensitiveOrTrue(name, entity.getName(), resolve) || checkType && !processor.isExpected(entity.getKind()) || processor.executeTarget(entity, element, result2, forcedCaseSense, ResolveState.initial());
    }

    public TokenSet getStatementSeparators() {
        return SqlTokens.STATEMENT_SEPARATORS;
    }

    @NotNull
    public String asStringLiteral(@NotNull String s) {
        if (s == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(8);
        }
        String string = "'" + SqlStringLiteralManipulator.escapeSqlStringCharacters(s, (IElementType)SqlTokens.SQL_STRING_TOKEN) + "'";
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        ASTNode node;
        SqlColumnStub stub;
        if (column == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(10);
        }
        SqlColumnStub sqlColumnStub = stub = column instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)column).getStub() : null;
        if (stub != null) {
            return stub.isAutoVal();
        }
        ASTNode aSTNode = node = column instanceof PsiElement ? ((PsiElement)column).getNode() : null;
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) != null;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type instanceof SqlDbElementType) {
            ContainerUtil.addIfNotNull(result2, (Object)((SqlDbElementType)type).parentType);
        }
        if (type == ObjectKind.VARIABLE) {
            result2.add((ObjectKind)ObjectKind.VARIABLE);
        }
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.TRIGGER) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OBJECT_TYPE) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        for (Couple couple : this.getDatabaseDialect().getMetaModel().getKindCouples()) {
            if (couple.second != type || couple.first == ObjectKind.NONE) continue;
            result2.add((Object)couple.first);
        }
        if (type == SqlDbElementType.USER) {
            result2.add((ObjectKind)SqlDbElementType.USER);
        }
        if (type == SqlDbElementType.SYSTEM_VARIABLE) {
            result2.add((ObjectKind)SqlDbElementType.SYSTEM_VARIABLE);
        }
        return result2;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(11);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "bytes";
            }
            case ARRAY: {
                return "array";
            }
            case TABLE: {
                return "table";
            }
            case RECORD: {
                return "record";
            }
            case COLLECTION: {
                return null;
            }
            case REFERENCE: {
                return null;
            }
            case UNKNOWN: {
                return null;
            }
            case DEFAULT: {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(12);
        }
        if (this.getDatabaseDialect().isQuotedIdentifier(name)) {
            String string = name;
            if (string == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(13);
            }
            return string;
        }
        Case casing = this.getCasing((ObjectKind)ObjectKind.OBJECT_TYPE, null).plain;
        if (casing == Case.MIXED) {
            casing = Case.LOWER;
        }
        String string = casing.apply(name);
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public SqlType.Category getTypeCategory(@NotNull DataType dataType) {
        int type;
        String name;
        SqlType.Category cat;
        if (dataType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(15);
        }
        if ((cat = this.getTypeCategoryByName(name = this.getNormalizedTypeName(dataType.typeName))) != SqlType.Category.UNKNOWN) {
            SqlType.Category category = cat;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(16);
            }
            return category;
        }
        int n = type = dataType.jdbcType == 0 ? this.getDatabaseDialect().getJavaTypeForNativeType(name) : dataType.jdbcType;
        if (type != 1111) {
            SqlType.Category category = SqlType.Category.findByJdbcType((int)type);
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(17);
            }
            return category;
        }
        if (StringUtil.isEmpty((String)name)) {
            SqlType.Category category = SqlType.Category.UNKNOWN;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(18);
            }
            return category;
        }
        SqlType.Category category = cat;
        if (category == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(19);
        }
        return category;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        String fixed;
        if (typeName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(20);
        }
        if ((fixed = StringUtil.toUpperCase((String)typeName)).contains("BINARY")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(21);
            }
            return category;
        }
        if (fixed.contains("BOOL")) {
            SqlType.Category category = SqlType.Category.BOOLEAN;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(22);
            }
            return category;
        }
        if (fixed.equals("DATE")) {
            SqlType.Category category = SqlType.Category.DATE;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(23);
            }
            return category;
        }
        if (fixed.equals("TIME")) {
            SqlType.Category category = SqlType.Category.TIME;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(24);
            }
            return category;
        }
        if (fixed.equals("TIMESTAMP")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(25);
            }
            return category;
        }
        if (fixed.contains("DATE") || fixed.contains("TIME")) {
            SqlType.Category category = SqlType.Category.DATE_TIME;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(26);
            }
            return category;
        }
        if (fixed.contains("REAL") || fixed.contains("DOUBLE") || fixed.contains("FLOAT") || fixed.contains("NUMBER")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(27);
            }
            return category;
        }
        if (fixed.contains("INTERVAL")) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(28);
            }
            return category;
        }
        if (fixed.contains("INT")) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(29);
            }
            return category;
        }
        if (fixed.contains("CHAR")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(30);
            }
            return category;
        }
        if (fixed.contains("TEXT")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(31);
            }
            return category;
        }
        if (fixed.contains("REFERENCE")) {
            SqlType.Category category = SqlType.Category.REFERENCE;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(32);
            }
            return category;
        }
        SqlType.Category category = SqlType.Category.UNKNOWN;
        if (category == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(33);
        }
        return category;
    }

    public boolean canBeCalledWithoutParens(@NotNull SqlFunctionDefinition.Prototype prototype) {
        if (prototype == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(34);
        }
        SqlFunctionDefinition def = prototype.getFunction();
        return prototype.getParams().length == 0 && !"required".equals(def.getDialectAttribute("parens"));
    }

    @NotNull
    public SqlType getDefinitionType(@NotNull SqlTypedDefinition definition, @Nullable PsiElement usage) {
        if (definition == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(35);
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(36);
        }
        return sqlPrimitiveType;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(37);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(38);
        }
        return this.quoteIdentifier(identifier.getProject(), newElementName);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(39);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(40);
        }
        SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        boolean force = settings.QUOTE_IDENTIFIER == 0 || this.isReservedKeyword((IElementType)SqlTokenRegistry.findTokenType((String)newElementName));
        return this.getDatabaseDialect().quoteIdentifier(newElementName, force, !force);
    }

    public JBIterable<? extends SqlDefinition> extractDefinitions(@NotNull SqlElement statement) {
        if (statement == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(41);
        }
        if (statement instanceof SqlSelectStatement) {
            return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)statement).expand(Conditions.notInstanceOf(SqlSelectIntoNewTableClauseImpl.class))).filter(SqlSelectIntoNewTableClauseImpl.class);
        }
        if (statement instanceof SqlBlockStatementImpl) {
            JBIterable children = SqlImplUtil.childrenIt((PsiElement)statement).filter(SqlElement.class);
            return children.filter(SqlDefinition.class).append((Iterable)children.flatten(this::extractDefinitions));
        }
        return JBIterable.empty();
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(42);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(43);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(44);
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(45);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(46);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(47);
        }
        if (qualifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(48);
        }
        return true;
    }

    public boolean processFileDeclarations(@NotNull SqlFile file, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement lastParent, @NotNull PsiElement place) {
        if (file == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(50);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(51);
        }
        if (lastParent == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(52);
        }
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(53);
        }
        return true;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return !ourUnresolvableKinds.contains(type);
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(54);
        }
        return true;
    }

    @NotNull
    public abstract Map<String, SqlFunctionDefinition> getSupportedFunctions();

    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Map<String, SqlFunctionDefinition.Type> map2 = this.myTypes;
        if (map2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(55);
        }
        return map2;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(56);
        }
        Casing casing = this.getDatabaseDialect().getCasing(kind, context);
        if (casing == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(57);
        }
        return casing;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(58);
        }
        return false;
    }

    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(59);
        }
        return ";";
    }

    public boolean mayContainExternalPsi() {
        return false;
    }

    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(60);
        }
        return kind == ObjectKind.TRIGGER || kind == ObjectKind.INDEX;
    }

    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(61);
        }
        return kind == ObjectKind.TABLE;
    }

    @NotNull
    public TreePattern getDefaultImports(@Nullable DbDataSource dataSource) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        TreePattern imports = this.getBaseImports(dataSource, dsNames);
        TreePattern treePattern = this.applyImplicitImports(dsNames, imports);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(62);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectKind kind;
        JBIterable kinds = this.getDatabaseDialect().getMetaModel().getRootNamespaceKinds();
        if (kinds.contains((Object)ObjectKind.DATABASE)) {
            kind = ObjectKind.DATABASE;
        } else if (kinds.contains((Object)ObjectKind.SCHEMA)) {
            kind = ObjectKind.SCHEMA;
        } else {
            throw new AssertionError((Object)"Unexpected root kind");
        }
        ObjectName userName = ObjectName.plain((String)SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource)));
        DasNamespace namespace = SqlLanguageDialectEx.getDefaultNamespace(dataSource, userName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNodeIfNotNull(userName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(63);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(userName, kind, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(64);
        }
        return treePattern;
    }

    @Nullable
    protected static DasNamespace getDefaultNamespace(@Nullable DbDataSource dataSource, @Nullable ObjectName fallback) {
        DasModel model;
        LocalDataSource ds = dataSource == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
        DasModel dasModel = model = ds == null ? null : ds.getModel();
        if (model == null) {
            return null;
        }
        DasNamespace cur = model.getCurrentRootNamespace();
        if (cur == null && fallback != null) {
            cur = (DasNamespace)model.getModelRoots().filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
        }
        if (cur == null || cur.getKind() == ObjectKind.SCHEMA) {
            return cur;
        }
        DasNamespace sc = SqlLanguageDialectEx.getCurrentSchema(cur);
        return (DasNamespace)ObjectUtils.chooseNotNull((Object)sc, (Object)cur);
    }

    @Nullable
    protected static DasNamespace getCurrentSchema(@Nullable DasNamespace cur) {
        return cur == null ? null : (DasNamespace)cur.getDasChildren(ObjectKind.SCHEMA).filter(BasicNamespace.class).filter(BasicNamespace::isCurrent).first();
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(65);
        }
        TreePattern treePattern = pattern;
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(66);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        List elements = SearchPath.getElements((SearchPath)searchPath);
        TreePattern treePattern = this.applyImplicitImports(dsNames, !elements.isEmpty() ? TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)elements).transform(n -> SqlDialectImplUtil.createObjectPattern(dsNames, this.getDatabaseDialect(), n, (TreePatternNode.Group[])null))) : (dsNames == null ? TreePattern.EMPTY : this.getBaseImports(dataSource, dsNames)));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(67);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath object) {
        if (object == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(68);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, object);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(69);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern processImports(@NotNull SqlUseDatabaseStatement stmt, @NotNull TreePattern prev) {
        int k;
        if (stmt == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(70);
        }
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(71);
        }
        List refs = ContainerUtil.newSmartList();
        ObjectKind kind = null;
        boolean reset = false;
        for (SqlReferenceExpression ref : ContainerUtil.iterateBackward((List)stmt.getUseReferences())) {
            if (ref == null) {
                reset = true;
                break;
            }
            refs.add(ref);
            ObjectKind k2 = ref.getReferenceElementType().getTargetKind();
            assert (kind == null || kind == k2);
            kind = k2;
        }
        if (reset) {
            TreePattern treePattern = SqlDialectImplUtil.getDefaultInitialPattern((SqlFile)stmt.getContainingFile());
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(72);
            }
            return treePattern;
        }
        boolean empty = refs.isEmpty();
        if (empty || kind == null) {
            if (!this.canBeWithoutCurrentSchema()) {
                TreePattern treePattern = prev;
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(73);
                }
                return treePattern;
            }
            List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDatabaseDialect());
            if (path == null) {
                TreePattern treePattern = this.applyImplicitImports(null, TreePattern.EMPTY);
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(74);
                }
                return treePattern;
            }
            ObjectKind[] kinds = ContainerUtil.reverse(path.subList(1, path.size())).toArray(new ObjectKind[path.size() - 1]);
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            TreePattern treePattern = this.applyImplicitImports(null, TreePatternUtils.mask(prev, kinds, mask, false));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(75);
            }
            return treePattern;
        }
        TreePattern state = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)refs).transform(r -> SqlImportUtil.createRefPattern(r, this.getDatabaseDialect())).filter(x -> x != null));
        List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDatabaseDialect());
        int n = k = path == null ? -1 : path.indexOf(kind);
        if (k != -1 && path.size() > 0) {
            ObjectKind[] kinds = ContainerUtil.reverse(path).toArray(new ObjectKind[path.size()]);
            k = kinds.length - 1 - k;
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            mask[k] = false;
            TreePattern masked = TreePatternUtils.mask(prev, kinds, mask, false);
            for (int i2 = k; i2 < mask.length; ++i2) {
                mask[i2] = i2 == k;
            }
            TreePattern maskedState = k == mask.length - 1 ? state : TreePatternUtils.mask(state, kinds, mask, false);
            state = TreePatternUtils.union(stmt.isInclusive() ? prev : TreePatternUtils.minus(prev, masked), TreePatternUtils.intersect(maskedState, masked));
        }
        TreePattern treePattern = this.applyImplicitImports(null, state);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(76);
        }
        return treePattern;
    }

    protected boolean canBeWithoutCurrentSchema() {
        return false;
    }

    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element, @Nullable PsiElement object) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(77);
        }
        SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(78);
        }
        return sqlTableType;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target2) {
        if (target2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(79);
        }
        Set<ObjectKind> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(80);
        }
        return set;
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(81);
        }
        IFileElementType unused = SqlCompositeElementTypes.SQL_FILE;
        return SqlTokenRegistry.findCompositeType((String)("SQL_" + name));
    }

    static {
        ourUnresolvableKinds.add(SqlDbElementType.CHARSET);
        ourUnresolvableKinds.add(ObjectKind.COLLATION);
        ourUnresolvableKinds.add(SqlDbElementType.TABLESPACE);
        ourUnresolvableKinds.add(ObjectKind.DB_LINK);
        ourUnresolvableKinds.add(SqlDbElementType.GENERIC_AT_LINK);
        ourUnresolvableKinds.add(SqlDbElementType.USER);
        ourUnresolvableKinds.add(SqlDbElementType.SYSTEM_VARIABLE);
        ourUnresolvableKinds.add(SqlDbElementType.ROLE);
        ourUnresolvableKinds.add(ObjectKind.OPERATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 55: 
            case 57: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 55: 
            case 57: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 55: 
            case 57: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 58: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 42: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 12: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 43: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 44: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastParent";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 56: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asStringLiteral";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategory";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionType";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInTypes";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImports";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "processImports";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequenceType";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 55: 
            case 57: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeDual";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeSimple";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asStringLiteral";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategory";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "canBeCalledWithoutParens";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionType";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "extractDefinitions";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processFileDeclarations";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createSequenceType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 55: 
            case 57: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

