/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.openapi.util.Key;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.SeparatorWithText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiSeparatorListCellRenderer
extends CellRendererPanel
implements ListCellRenderer {
    private final List<SeparatorWithText> mySeparators = ContainerUtil.newArrayList();
    private final Container myValidationParent = new CellRendererPane();

    public MultiSeparatorListCellRenderer(JList list) {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        list.add(this.myValidationParent);
    }

    protected abstract JComponent getItemCellRendererComponent(JList var1, Object var2, int var3, boolean var4, boolean var5);

    protected abstract Collection<Object> querySeparators(@Nullable Object var1, @NotNull Object var2);

    protected abstract void configureSeparator(@NotNull SeparatorWithText var1, @NotNull Object var2);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Collection<Object> separators = this.querySeparators(index == 0 ? null : list.getModel().getElementAt(index - 1), value);
        JComponent itemComponent = this.getItemCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.rebuildChildren(separators, itemComponent);
        this.setPreferredSize(null);
        this.validate();
        boolean forExpansion = UIUtil.isClientPropertyTrue((Object)list, (Object)ExpandableItemsHandler.EXPANDED_RENDERER);
        UIUtil.putClientProperty((JComponent)itemComponent, (Key)ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)(forExpansion ? Boolean.valueOf(true) : null));
        if (forExpansion) {
            Rectangle bounds = list.getCellBounds(index, index);
            bounds.setSize(this.getPreferredSize().width, bounds.height);
            AbstractExpandableItemsHandler.setRelativeBounds((Component)((Object)this), (Rectangle)bounds, (Component)itemComponent, (Container)this.myValidationParent);
            return itemComponent;
        }
        return this;
    }

    @NotNull
    protected SeparatorWithText createSeparator() {
        SeparatorWithText separator = new SeparatorWithText();
        separator.setCaptionCentered(false);
        SeparatorWithText separatorWithText = separator;
        if (separatorWithText == null) {
            MultiSeparatorListCellRenderer.$$$reportNull$$$0(0);
        }
        return separatorWithText;
    }

    private void rebuildChildren(@NotNull Collection<Object> separators, @NotNull JComponent itemComponent) {
        if (separators == null) {
            MultiSeparatorListCellRenderer.$$$reportNull$$$0(1);
        }
        if (itemComponent == null) {
            MultiSeparatorListCellRenderer.$$$reportNull$$$0(2);
        }
        int separatorCount = separators.size();
        while (this.mySeparators.size() < separatorCount) {
            this.mySeparators.add(this.createSeparator());
        }
        int i2 = 0;
        for (Object object : separators) {
            this.configureSeparator(this.mySeparators.get(i2), object);
            ++i2;
        }
        if (separators.isEmpty() && this.getComponentCount() == 1 && this.getComponent(0) == itemComponent) {
            return;
        }
        this.removeAll();
        for (SeparatorWithText separatorWithText : this.mySeparators.subList(0, separatorCount)) {
            this.add((Component)separatorWithText);
        }
        this.add(itemComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/MultiSeparatorListCellRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/MultiSeparatorListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rebuildChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

