/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableColumnsEditor
extends DatabaseTableEditor.TabProvider {
    private static final DataKey<DatabaseTableEditor> TABLE_EDITOR = DataKey.create((String)"TABLE_EDITOR");
    private static final DataKey<DatabaseEditorCapabilities.TableEditorCaps> TABLE_CAPS = DataKey.create((String)"TABLE_CAPS");
    private static final DataKey<ListTableModel<DatabaseTableColumnEditor>> TABLE_COLUMNS = DataKey.create((String)"TABLE_COLUMNS");
    private static final String EMPTY_TABLE = "Empty table is not allowed";
    protected final DatabaseTableEditor myTableEditor;
    protected final ListTableModel<DatabaseTableColumnEditor> myColumnModel;
    private final DatabaseEditorUtil.DbListTableWithEditor myTable;
    private final JPanel myPanel;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;

    public DatabaseTableColumnsEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator decorator) {
        if (tableEditor == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(1);
        }
        if (decorator == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(2);
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myColumnModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), this.getHelper(), true);
        this.myTable = this.getTableWithEditor();
        this.myTable.getTable().getEmptyText().setText("No columns");
        DataManager.registerDataProvider((JComponent)this.myTable.getTable(), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (TABLE_EDITOR.is(dataId)) {
                    return DatabaseTableColumnsEditor.this.myTableEditor;
                }
                if (TABLE_CAPS.is(dataId)) {
                    return DatabaseTableColumnsEditor.this.myCaps;
                }
                if (TABLE_COLUMNS.is(dataId)) {
                    return DatabaseTableColumnsEditor.this.myColumnModel;
                }
                return null;
            }
        });
        ToolbarDecorator toolbarDecorator = decorator.decorateColumns(this.myCaps, tableEditor, (JTable)this.myTable.getTable());
        this.myPanel = toolbarDecorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myPanel, (JTable)this.myTable.getTable());
        this.myPanel.setBorder(this.myTableEditor.getTabComponentBorder());
        this.getTableModel().addListener(() -> {
            this.myTable.getTable().revalidate();
            this.myTable.getTable().repaint();
        }, tableEditor);
    }

    @NotNull
    protected DatabaseEditorUtil.DbListTableWithEditor getTableWithEditor() {
        DatabaseEditorUtil.DbListTableWithEditor dbListTableWithEditor = DatabaseEditorUtil.createTableWithEditor(this.myColumnModel, this.myTableEditor, 4, JBUI.scale((int)500), (ActionGroup)new DefaultActionGroup(new AnAction[]{NewAltKeyAction.INSTANCE, NewIndexAction.INSTANCE, NewForeignKeyAction.INSTANCE}));
        if (dbListTableWithEditor == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(3);
        }
        return dbListTableWithEditor;
    }

    @Override
    public void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (caps == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(4);
        }
        this.setTabEnabled(caps.getColumns().isSupported());
    }

    @NotNull
    private DatabaseEditorUtil.EditorModelHelper<DatabaseTableColumnEditor> getHelper() {
        DatabaseEditorUtil.EditorModelHelper<DatabaseTableColumnEditor> editorModelHelper = new DatabaseEditorUtil.EditorModelHelper<DatabaseTableColumnEditor>(){

            @Override
            @Nullable
            public DatabaseTableColumnEditor createRow() {
                if (!DatabaseTableColumnsEditor.this.myCaps.getColumns().canAdd()) {
                    return null;
                }
                DatabaseTableColumnsEditor.this.myColumnModel.getItems().forEach(DatabaseTableColumnEditor::dropCache);
                int idx = DatabaseTableColumnsEditor.this.getTableModel().getColumnsCount();
                DeColumn column = DatabaseTableColumnsEditor.this.getTableModel().createColumn("column_" + (idx + 1));
                DatabaseTableColumnsEditor.this.getTableModel().insertColumn(column, idx);
                return DatabaseTableColumnsEditor.this.createColumnEditor(column);
            }

            @Override
            public boolean removeRow(DatabaseTableColumnEditor item, int idx) {
                if (!DatabaseTableColumnsEditor.this.myCaps.getColumns().canRemove()) {
                    return false;
                }
                DatabaseTableColumnsEditor.this.getTableModel().removeColumn(DatabaseTableColumnsEditor.this.getTableModel().getColumns().get(idx));
                Disposer.dispose((Disposable)item);
                return true;
            }

            @Override
            public boolean exchangeRows(DatabaseTableColumnEditor item0, int idx0, DatabaseTableColumnEditor item1, int idx1) {
                if (!DatabaseTableColumnsEditor.this.myCaps.getColumns().canReorder()) {
                    return false;
                }
                if (idx0 > idx1) {
                    int tmp = idx0;
                    idx0 = idx1;
                    idx1 = tmp;
                }
                List<DeColumn> columns2 = DatabaseTableColumnsEditor.this.getTableModel().getColumns();
                DeColumn col1 = columns2.get(idx0);
                DeColumn col2 = columns2.get(idx1);
                DatabaseTableColumnsEditor.this.getTableModel().removeColumn(col2);
                DatabaseTableColumnsEditor.this.getTableModel().removeColumn(col1);
                DatabaseTableColumnsEditor.this.getTableModel().insertColumn(col2, idx0);
                DatabaseTableColumnsEditor.this.getTableModel().insertColumn(col1, idx1);
                return true;
            }
        };
        if (editorModelHelper == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(5);
        }
        return editorModelHelper;
    }

    @Override
    @Nullable
    public DatabaseTableColumnEditor startItemEditing(@NotNull DeObject column) {
        if (column == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(6);
        }
        return DatabaseEditorUtil.startItemEditing(column, this.myTable, this.myColumnModel);
    }

    public int getMaxLength(@NotNull Function<DatabaseTableColumnEditor, Iterable<Pair<String, TextAttributesKey>>> textProvider) {
        if (textProvider == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(7);
        }
        int max = Integer.MIN_VALUE;
        for (DatabaseTableColumnEditor editor : this.myColumnModel.getItems()) {
            Iterable result2 = (Iterable)textProvider.fun((Object)editor);
            int length = DatabaseEditorUtil.computeLength(result2);
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (!this.myTableEditor.getContext().getDialect().supportsEmptyTables() && this.getTableModel().getColumns().isEmpty()) {
            return new ValidationInfo(EMPTY_TABLE, this.getComponent());
        }
        return null;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(9);
        }
        return tableEditorModel;
    }

    @NotNull
    public List<ColumnEditorModel> getSelectedRows() {
        int[] selected = this.myTable.getTable().getSelectedRows();
        List<ColumnEditorModel> list = Arrays.stream(selected).filter(index -> index >= 0 && index < this.myColumnModel.getRowCount()).mapToObj(index -> ((DatabaseTableColumnEditor)this.myColumnModel.getItem(index)).getColumnEditor().getColumnModel()).collect(Collectors.toList());
        if (list == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected DatabaseTableColumnEditor createColumnEditor(@NotNull DeColumn column) {
        if (column == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(11);
        }
        DatabaseTableColumnEditor databaseTableColumnEditor = this.subscribeAndRegister(new DatabaseTableColumnEditor(this.myTableEditor.getState(), this.getTableModel(), this.getTableModel().modelsCache.get(column, ColumnEditorModel.class), this.getTableColumnCaps(column), this));
        if (databaseTableColumnEditor == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(12);
        }
        return databaseTableColumnEditor;
    }

    @NotNull
    protected final <T extends DatabaseTableColumnEditor> T subscribeAndRegister(@NotNull T editor) {
        if (editor == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(13);
        }
        Disposer.register((Disposable)this.myTableEditor, editor);
        editor.getColumnModel().addListener(this.myTableEditor::fromModelToUi, this.myTableEditor);
        T t = editor;
        if (t == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(14);
        }
        return t;
    }

    @NotNull
    protected final DatabaseEditorCapabilities.TableColumnEditorCaps getTableColumnCaps(@NotNull DeColumn column) {
        if (column == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(15);
        }
        DasTable table = (DasTable)this.getTable().editedObject;
        DasColumn col = (DasColumn)column.editedObject;
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = DatabaseTableColumnEditor.getTableColumnCaps(this.myCaps, table, col);
        if (tableColumnEditorCaps == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(16);
        }
        return tableColumnEditorCaps;
    }

    @Override
    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myColumnModel, this.getTableModel().getColumns(), this::createColumnEditor);
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(17);
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count2 = this.getTableModel().getColumnsCount();
        String string = "Columns" + (count2 == 0 ? "" : " (" + count2 + ")");
        if (string == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseTableColumnEditor> getColumnsListModel() {
        ListTableModel<DatabaseTableColumnEditor> listTableModel = this.myColumnModel;
        if (listTableModel == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(19);
        }
        return listTableModel;
    }

    @Override
    @Nullable
    public DatabaseTableColumnEditor getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myColumnModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getColumns();
        if (listCapability == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(20);
        }
        return listCapability;
    }

    @Override
    public boolean isMyObject(@NotNull DeObject object) {
        if (object == null) {
            DatabaseTableColumnsEditor.$$$reportNull$$$0(21);
        }
        return object instanceof DeColumn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableWithEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribeAndRegister";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnCaps";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsListModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMaxLength";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createColumnEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "subscribeAndRegister";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnCaps";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isMyObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class NewColumnsObjectAction
    extends DumbAwareAction {
        public NewColumnsObjectAction(@Nullable String text2, @Nullable String description, @Nullable Icon icon) {
            super(text2, description, icon);
        }

        @NotNull
        private static List<DeColumn> getColumns(@NotNull DataContext context) {
            if (context == null) {
                NewColumnsObjectAction.$$$reportNull$$$0(0);
            }
            DatabaseTableEditor editor = (DatabaseTableEditor)TABLE_EDITOR.getData(context);
            JTable table = (JTable)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(context), JTable.class);
            ListTableModel columnsModel = (ListTableModel)TABLE_COLUMNS.getData(context);
            if (table == null || editor == null || columnsModel == null) {
                List<DeColumn> list = Collections.emptyList();
                if (list == null) {
                    NewColumnsObjectAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList columns2 = ContainerUtil.newArrayList();
            for (int i2 : table.getSelectedRows()) {
                if (i2 < 0 || i2 >= columnsModel.getRowCount()) continue;
                DatabaseTableColumnEditor columnEditor = (DatabaseTableColumnEditor)columnsModel.getItem(i2);
                columns2.add(columnEditor.getColumn());
            }
            ArrayList arrayList = columns2;
            if (arrayList == null) {
                NewColumnsObjectAction.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            DatabaseTableEditor editor = (DatabaseTableEditor)TABLE_EDITOR.getData(e.getDataContext());
            DatabaseEditorCapabilities.TableEditorCaps caps = (DatabaseEditorCapabilities.TableEditorCaps)TABLE_CAPS.getData(e.getDataContext());
            List<DeColumn> columns2 = NewColumnsObjectAction.getColumns(e.getDataContext());
            boolean enabled = editor != null && caps != null && this.check(editor, caps, columns2);
            e.getPresentation().setEnabled(enabled);
        }

        protected abstract boolean check(@NotNull DatabaseTableEditor var1, @NotNull DatabaseEditorCapabilities.TableEditorCaps var2, @NotNull List<DeColumn> var3);

        public void actionPerformed(AnActionEvent e) {
            DatabaseTableEditor editor = (DatabaseTableEditor)TABLE_EDITOR.getData(e.getDataContext());
            DatabaseEditorCapabilities.TableEditorCaps caps = (DatabaseEditorCapabilities.TableEditorCaps)TABLE_CAPS.getData(e.getDataContext());
            if (editor == null || caps == null) {
                return;
            }
            List<DeColumn> columns2 = NewColumnsObjectAction.getColumns(e.getDataContext());
            if (!this.check(editor, caps, columns2)) {
                return;
            }
            DeObject exported = this.create(editor.getTableModel(), columns2);
            if (exported == null) {
                return;
            }
            DbRefactoringDialogHelper.runOnceValid(editor.getState(), () -> editor.startItemEditing(exported));
        }

        public abstract DeObject create(@NotNull TableEditorModel var1, @NotNull List<DeColumn> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewColumnsObjectAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewColumnsObjectAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NewForeignKeyAction
    extends NewColumnsObjectAction {
        private static final AnAction INSTANCE = new NewForeignKeyAction();

        public NewForeignKeyAction() {
            super("New &Foreign Key", null, DatabaseIcons.BlueKey);
        }

        @Override
        protected boolean check(@NotNull DatabaseTableEditor editor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull List<DeColumn> columns2) {
            if (editor == null) {
                NewForeignKeyAction.$$$reportNull$$$0(0);
            }
            if (caps == null) {
                NewForeignKeyAction.$$$reportNull$$$0(1);
            }
            if (columns2 == null) {
                NewForeignKeyAction.$$$reportNull$$$0(2);
            }
            return caps.getForeignKeys().canAdd() && columns2.size() > 0;
        }

        @Override
        public DeObject create(@NotNull TableEditorModel model, @NotNull List<DeColumn> columns2) {
            if (model == null) {
                NewForeignKeyAction.$$$reportNull$$$0(3);
            }
            if (columns2 == null) {
                NewForeignKeyAction.$$$reportNull$$$0(4);
            }
            Ref fks = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(model).withForeignKey(""))).addRefRefs(columns2)).addAndGet((Ref<DeForeignKey>)fks)).leave()).commit();
            return (DeObject)fks.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NewIndexAction
    extends NewColumnsObjectAction {
        private static final AnAction INSTANCE = new NewIndexAction();

        public NewIndexAction() {
            super("New &Index", null, DatabaseIcons.Index);
        }

        @Override
        protected boolean check(@NotNull DatabaseTableEditor editor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull List<DeColumn> columns2) {
            if (editor == null) {
                NewIndexAction.$$$reportNull$$$0(0);
            }
            if (caps == null) {
                NewIndexAction.$$$reportNull$$$0(1);
            }
            if (columns2 == null) {
                NewIndexAction.$$$reportNull$$$0(2);
            }
            return caps.getIndices().canAdd() && columns2.size() > 0;
        }

        @Override
        public DeObject create(@NotNull TableEditorModel model, @NotNull List<DeColumn> columns2) {
            if (model == null) {
                NewIndexAction.$$$reportNull$$$0(3);
            }
            if (columns2 == null) {
                NewIndexAction.$$$reportNull$$$0(4);
            }
            Ref index = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(model).withIndex(""))).addColumns(columns2, DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)index)).leave()).commit();
            return (DeObject)index.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewIndexAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NewAltKeyAction
    extends NewColumnsObjectAction {
        private static final AnAction INSTANCE = new NewAltKeyAction();

        public NewAltKeyAction() {
            super("New Table &Key", null, DatabaseIcons.GoldKeyAlt);
        }

        @Override
        protected boolean check(@NotNull DatabaseTableEditor editor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull List<DeColumn> columns2) {
            if (editor == null) {
                NewAltKeyAction.$$$reportNull$$$0(0);
            }
            if (caps == null) {
                NewAltKeyAction.$$$reportNull$$$0(1);
            }
            if (columns2 == null) {
                NewAltKeyAction.$$$reportNull$$$0(2);
            }
            return caps.getAltKeys().canAdd() && columns2.size() > 0;
        }

        @Override
        public DeObject create(@NotNull TableEditorModel model, @NotNull List<DeColumn> columns2) {
            if (model == null) {
                NewAltKeyAction.$$$reportNull$$$0(3);
            }
            if (columns2 == null) {
                NewAltKeyAction.$$$reportNull$$$0(4);
            }
            Ref key2 = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)TableModelBuilder.modify(model).withKey(""))).addColumns(columns2, DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)key2)).leave()).commit();
            return (DeObject)key2.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewAltKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

