/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpDecoder {
    @Nullable
    public static String decodeResponseString(@NotNull ByteBuffer buf) throws SsrpConstants.SsrpException {
        if (buf == null) {
            SsrpDecoder.$$$reportNull$$$0(0);
        }
        buf.order(ByteOrder.LITTLE_ENDIAN);
        byte type = buf.get();
        if (type != 5) {
            return null;
        }
        short len = buf.getShort();
        buf.limit(buf.position() + len);
        return Charset.defaultCharset().decode(buf).toString();
    }

    public static int decodeResponseDAC(@NotNull ByteBuffer buf) throws SsrpConstants.SsrpException {
        if (buf == null) {
            SsrpDecoder.$$$reportNull$$$0(1);
        }
        buf.order(ByteOrder.LITTLE_ENDIAN);
        byte type = buf.get();
        if (type != 5) {
            return -1;
        }
        buf.getShort();
        if (buf.get() != 1) {
            throw new SsrpConstants.SsrpException("Protocol version mismatch");
        }
        return buf.getShort() & 0xFFFF;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "buf";
        objectArray2[1] = "com/intellij/database/vendors/mssql/ssrp/SsrpDecoder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decodeResponseString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "decodeResponseDAC";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

