/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptingOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R@\u0010\u001a\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u0002000/\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"Lcom/intellij/database/scripting/ScriptingContext;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/database/model/basic/BasicModel;)V", "db", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "generated", "", "Lcom/intellij/database/model/basic/BasicElement;", "getGenerated", "()Ljava/util/Set;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "nativeDefinitionsRetriever", "Lkotlin/Function1;", "", "", "", "", "getNativeDefinitionsRetriever", "()Lkotlin/jvm/functions/Function1;", "setNativeDefinitionsRetriever", "(Lkotlin/jvm/functions/Function1;)V", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "getScript", "()Ljava/util/List;", "database-scripting"})
public final class ScriptingContext {
    @Nullable
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private final List<CompositeText> script;
    @NotNull
    private final Set<BasicElement> generated;
    @Nullable
    private Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>> nativeDefinitionsRetriever;
    @NotNull
    private final BasicModel model;

    @NotNull
    public final Rdbms getRdbms() {
        Rdbms rdbms = this.model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        return rdbms;
    }

    @Nullable
    public final BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    public final void setCurrentDatabase(@Nullable BasicDatabase db) {
        if (db != null) {
            boolean bl = Intrinsics.areEqual((Object)db.getModel(), (Object)this.model);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Intrinsics.areEqual((Object)this.currentDatabase, (Object)db) ^ true) {
                this.setCurrentSchema(null);
                this.currentDatabase = db;
            }
        } else {
            this.setCurrentSchema(null);
            this.currentDatabase = null;
        }
    }

    @Nullable
    public final BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public final void setCurrentSchema(@Nullable BasicSchema s) {
        if (s != null) {
            boolean bl = Intrinsics.areEqual((Object)s.getModel(), (Object)this.model);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.setCurrentDatabase(s.getDatabase());
            this.currentSchema = s;
        } else {
            this.currentSchema = null;
        }
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final List<CompositeText> getScript() {
        return this.script;
    }

    @NotNull
    public final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    @Nullable
    public final Function1<List<? extends BasicElement>, Map<BasicElement, String[]>> getNativeDefinitionsRetriever() {
        return this.nativeDefinitionsRetriever;
    }

    public final void setNativeDefinitionsRetriever(@Nullable Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>> function1) {
        this.nativeDefinitionsRetriever = function1;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    public ScriptingContext(@NotNull BasicModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.model = model;
        this.currentDatabase = this.model.getRoot().getCurrentDatabase();
        BasicDatabase basicDatabase = this.model.getRoot().getCurrentDatabase();
        this.currentSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
        this.options = DefaultScriptingOptions.INSTANCE;
        this.script = new ArrayList();
        this.generated = new HashSet();
    }
}

