/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresArgument;
import com.intellij.database.model.postgres.PostgresCollation;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresForeignServer;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresForeignTableColumn;
import com.intellij.database.model.postgres.PostgresLocalTableColumn;
import com.intellij.database.model.postgres.PostgresMatView;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRole;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.postgresbase.PostgresBaseDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseModel;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseEnableDisableGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.PostgresBaseScriptingService;
import com.intellij.database.scripting.PostgresScriptingService;
import com.intellij.database.scripting.PostgresScriptingService$PROVIDER$WhenMappings;
import com.intellij.database.scripting.PostgresScriptingService$PgCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOption;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.postgres.PostgresDropGenerator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J2\u0010\u0011\u001a\u00180\u0012R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService;", "Lcom/intellij/database/scripting/PostgresBaseScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "model", "database", "(Lcom/intellij/database/model/postgres/PostgresModel;Lcom/intellij/database/model/postgres/PostgresDatabase;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "createEnableDisableGenerator", "Lcom/intellij/database/scripting/BaseEnableDisableGenerator;", "createExecuteGenerator", "createRefactoringGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$RefactoringGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "migrated", "", "Lcom/intellij/database/model/basic/BasicElement;", "Companion", "PROVIDER", "PgCreatingGenerator", "PgEnableDisableGenerator", "PgRefactoringGenerator", "database-scripting"})
public final class PostgresScriptingService
extends PostgresBaseScriptingService<PostgresModel, PostgresDatabase, PostgresSchema> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected BaseCreatingGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new PgCreatingGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected BaseEnableDisableGenerator createEnableDisableGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new PgEnableDisableGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new PostgresBaseScriptingService.PgBaseExecuteGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createDropGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new PostgresDropGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractScriptingService.RefactoringGenerator createRefactoringGenerator(@NotNull Map<BasicElement, ? extends BasicElement> migrated) {
        Intrinsics.checkParameterIsNotNull(migrated, (String)"migrated");
        return new PgRefactoringGenerator(migrated);
    }

    public PostgresScriptingService(@NotNull PostgresModel model, @NotNull PostgresDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super((PostgresBaseModel)model, (PostgresBaseDatabase)database);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u001e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 H\u0014J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020)H\u0002J\u0010\u00101\u001a\u00020\f2\u0006\u0010\u0017\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\f2\u0006\u0010\u0017\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010B\u001a\u00020\f2\u0006\u0010<\u001a\u00020CH\u0014J\u0010\u0010D\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020EH\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0014\u0010G\u001a\u0004\u0018\u00010\u000f2\b\u0010H\u001a\u0004\u0018\u00010IH\u0014J\u0012\u0010J\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020#H\u0014J\u0012\u0010K\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0014J\u001a\u0010Q\u001a\u00020\u000f2\b\u0010R\u001a\u0004\u0018\u00010\u000f2\u0006\u0010S\u001a\u00020\u000fH\u0002J\u001e\u0010T\u001a\u00020\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010U\u001a\u00020VH\u0002\u00a8\u0006W"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$PgCreatingGenerator;", "Lcom/intellij/database/scripting/PostgresBaseScriptingService$PgBaseCreatingGenerator;", "Lcom/intellij/database/scripting/PostgresBaseScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/PostgresScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "appendOptions", "", "options", "", "", "appendRoutineAttributes", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "appendViewOptions", "view", "Lcom/intellij/database/model/postgresbase/PostgresBaseView;", "elementKindNameForCreate", "element", "Lcom/intellij/database/model/basic/BasicElement;", "floatAttributeName", "", "s", "gatherSequenceIdentityParameters", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateCollation", "Lcom/intellij/database/model/postgres/PostgresCollation;", "generateColumn", "generateComposite", "struct", "Lcom/intellij/database/model/postgres/PostgresDefType;", "generateDefType", "dt", "generateDomain", "d", "generateElement", "generateEnum", "e", "generateForeignDataWrapper", "Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;", "generateForeignServer", "Lcom/intellij/database/model/postgres/PostgresForeignServer;", "generateOperator", "op", "Lcom/intellij/database/model/postgres/PostgresOperator;", "generatePostgresDefTypeCheck", "check", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "generatePostgresTrigger", "trigger", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "generateRole", "role", "Lcom/intellij/database/model/postgres/PostgresRole;", "generateSequence", "generateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateUserMapping", "Lcom/intellij/database/model/postgres/PostgresUserMapping;", "getVolatilityKind", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "table", "Lcom/intellij/database/model/basic/BasicTable;", "maybeQualified", "schemaName", "name", "optionsToString", "wrap", "", "database-scripting"})
    private final class PgCreatingGenerator
    extends PostgresBaseScriptingService.PgBaseCreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof PostgresRole) {
                this.generateRole((PostgresRole)element);
            } else if (basicElement instanceof PostgresDefType) {
                this.generateDefType((PostgresDefType)element);
            } else if (basicElement instanceof PostgresOperator) {
                this.generateOperator((PostgresOperator)element);
            } else if (basicElement instanceof PostgresDefTypeCheck) {
                this.generatePostgresDefTypeCheck((PostgresDefTypeCheck)element);
            } else if (basicElement instanceof PostgresCollation) {
                this.generateCollation((PostgresCollation)element);
            } else if (basicElement instanceof PostgresForeignDataWrapper) {
                this.generateForeignDataWrapper((PostgresForeignDataWrapper)element);
            } else if (basicElement instanceof PostgresForeignServer) {
                this.generateForeignServer((PostgresForeignServer)element);
            } else if (basicElement instanceof PostgresUserMapping) {
                this.generateUserMapping((PostgresUserMapping)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void appendViewOptions(@NotNull PostgresBaseView view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            if (!(view instanceof PostgresView) || Intrinsics.areEqual((Object)((Object)((PostgresView)view).getCheckOption()), (Object)((Object)PostgresCheckOption.NONE))) {
                return;
            }
            CodeTextBuilder.ensureEoln$default(this.getBuilder(), null, 1, null);
            String string = ((PostgresView)view).getCheckOption().name();
            StringBuilder stringBuilder = new StringBuilder().append("with ");
            CodeTextBuilder codeTextBuilder = this.getBuilder();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string4).append(" check option").toString(), null, false, 6, null);
        }

        private final void generateForeignDataWrapper(PostgresForeignDataWrapper element) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresForeignDataWrapper $element;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    CodeTextBuilder this_$iv;
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = "create foreign data wrapper";
                    String string = this.$element.getName();
                    PgCreatingGenerator pgCreatingGenerator = this.this$0;
                    int n = 1;
                    CharSequence[] charSequenceArray2 = charSequenceArray;
                    CharSequence[] charSequenceArray3 = charSequenceArray;
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)((Object)this_$iv)).nameToScript((String)$receiver$iv);
                    charSequenceArray2[n] = string2;
                    codeTextBuilder.phrase(charSequenceArray3);
                    this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$element.getHandler() != null) {
                            CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                            CharSequence[] charSequenceArray4 = new CharSequence[2];
                            charSequenceArray4[0] = "handler";
                            String string3 = this.$element.getHandlerSchema();
                            String string4 = this.$element.getHandler();
                            if (string4 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"element.handler!!");
                            charSequenceArray4[1] = PgCreatingGenerator.access$maybeQualified(this.this$0, string3, string4);
                            codeTextBuilder2.phrase(charSequenceArray4);
                        }
                        if (this.$element.getValidator() != null) {
                            CodeTextBuilder codeTextBuilder3 = this.this$0.getBuilder();
                            CharSequence[] charSequenceArray5 = new CharSequence[2];
                            charSequenceArray5[0] = "validator";
                            String string5 = this.$element.getValidatorSchema();
                            String string6 = this.$element.getValidator();
                            if (string6 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"element.validator!!");
                            charSequenceArray5[1] = PgCreatingGenerator.access$maybeQualified(this.this$0, string5, string6);
                            codeTextBuilder3.phrase(charSequenceArray5);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    List<String> list = this.$element.getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PgCreatingGenerator.access$appendOptions(this.this$0, list);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$element = postgresForeignDataWrapper;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateForeignServer(PostgresForeignServer element) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresForeignServer $element;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    String $receiver$iv;
                    CodeTextBuilder this_$iv;
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = "create server";
                    String string = this.$element.getName();
                    PgCreatingGenerator pgCreatingGenerator = this.this$0;
                    int n = 1;
                    CharSequence[] charSequenceArray2 = charSequenceArray;
                    CharSequence[] charSequenceArray3 = charSequenceArray;
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)((Object)this_$iv)).nameToScript($receiver$iv);
                    charSequenceArray2[n] = string2;
                    codeTextBuilder.phrase(charSequenceArray3);
                    this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        void this_$iv2;
                        if (this.$element.getType() != null) {
                            this.this$0.getBuilder().phrase("type", '\'' + this.$element.getType() + '\'');
                        }
                        if (this.$element.getVersion() != null) {
                            this.this$0.getBuilder().phrase("version", '\'' + this.$element.getVersion() + '\'');
                        }
                        CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                        CharSequence[] charSequenceArray4 = new CharSequence[2];
                        charSequenceArray4[0] = "foreign data wrapper";
                        BasicElement basicElement = this.$element.getDasParent();
                        if (basicElement == null) {
                            Intrinsics.throwNpe();
                        }
                        $receiver$iv = basicElement.getName();
                        PgCreatingGenerator $i$f$getScr = this.this$0;
                        int n2 = 1;
                        CharSequence[] charSequenceArray5 = charSequenceArray4;
                        CharSequence[] charSequenceArray6 = charSequenceArray4;
                        CodeTextBuilder codeTextBuilder3 = codeTextBuilder2;
                        String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv2).nameToScript($receiver$iv);
                        charSequenceArray5[n2] = string3;
                        codeTextBuilder3.phrase(charSequenceArray6);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    List<String> list = this.$element.getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PgCreatingGenerator.access$appendOptions(this.this$0, list);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$element = postgresForeignServer;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateUserMapping(PostgresUserMapping element) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresUserMapping $element;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final void invoke() {
                    v0 = this.this$0.getBuilder();
                    v1 = new CharSequence[2];
                    v1[0] = "create user mapping for";
                    v2 = v1;
                    v3 = v1;
                    v4 = 1;
                    v5 = this.$element.getUser();
                    if (v5 == null) ** GOTO lbl-1000
                    var2_1 = v5;
                    var1_2 = this.this$0;
                    var16_3 = v4;
                    var15_4 = v2;
                    var14_5 = v3;
                    var13_6 = v0;
                    var17_7 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript($receiver$iv);
                    v0 = var13_6;
                    v3 = var14_5;
                    v2 = var15_4;
                    v4 = var16_3;
                    v5 = var17_7;
                    if (v5 != null) {
                        v6 = v5;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = "public";
                    }
                    v2[v4] = v6;
                    v0.phrase(v3);
                    this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        v7 = this.this$0.getBuilder();
                        v8 = new CharSequence[2];
                        v8[0] = "server";
                        v9 = this.$element.getDasParent();
                        if (v9 == null) {
                            Intrinsics.throwNpe();
                        }
                        $receiver$iv = v9.getName();
                        $i$f$getScr = this.this$0;
                        var4_9 = 1;
                        var5_10 = v8;
                        var6_11 = v8;
                        var7_12 = v7;
                        var8_13 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript($receiver$iv);
                        var5_10[var4_9] = var8_13;
                        var7_12.phrase(var6_11);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    v10 = this.$element.getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(v10, (String)"element.options");
                    PgCreatingGenerator.access$appendOptions(this.this$0, v10);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$element = postgresUserMapping;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void appendOptions(List<String> options) {
            if (options.isEmpty()) {
                return;
            }
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "options (", null, false, 2, null);
            }
            finally {
                this_$iv.unindent();
            }
            Iterable $receiver$iv = options;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void option;
                int n = index$iv++;
                String string = (String)item$iv;
                int idx = n;
                List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                CodeTextBuilder.append$default(this.getBuilder(), (CharSequence)CollectionsKt.first((List)keyValue), null, false, 2, null);
                CodeTextBuilder.append$default(this.getBuilder(), " ", null, false, 2, null);
                CodeTextBuilder.append$default(this.getBuilder(), '\'' + (String)CollectionsKt.last((List)keyValue) + '\'', null, false, 2, null);
                if (idx == options.size() - 1) continue;
                CodeTextBuilder.append$default(this.getBuilder(), ", ", null, false, 2, null);
            }
            CodeTextBuilder.append$default(this.getBuilder(), ")", null, false, 6, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String optionsToString(List<String> options, boolean wrap) {
            if (options.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(wrap ? "\n" : " ");
            sb.append("options (");
            Iterable $receiver$iv = options;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void option;
                int n = index$iv++;
                String string = (String)item$iv;
                int idx = n;
                List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                sb.append((String)CollectionsKt.first((List)keyValue));
                sb.append(" ");
                sb.append('\'' + (String)CollectionsKt.last((List)keyValue) + '\'');
                if (idx == options.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private final String maybeQualified(String schemaName, String name) {
            String string;
            String string2;
            String $receiver$iv;
            PgCreatingGenerator this_$iv;
            StringBuilder stringBuilder;
            if (this.useSchemaName(schemaName)) {
                StringBuilder stringBuilder2 = new StringBuilder();
                String string3 = schemaName;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = string3;
                PgCreatingGenerator pgCreatingGenerator = this;
                stringBuilder = stringBuilder2;
                string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                string = stringBuilder.append(string2).append(".").toString();
            } else {
                string = "";
            }
            String schema = string;
            $receiver$iv = name;
            this_$iv = this;
            stringBuilder = new StringBuilder().append(schema);
            string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            return stringBuilder.append(string2).toString();
        }

        private final void generateCollation(PostgresCollation element) {
            String string = element.getCType();
            if (string == null) {
                return;
            }
            String cType = string;
            String string2 = element.getCollate();
            if (string2 == null) {
                return;
            }
            String collate = string2;
            boolean useLocale = Intrinsics.areEqual((Object)cType, (Object)collate);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element, useLocale, cType, collate){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresCollation $element;
                final /* synthetic */ boolean $useLocale;
                final /* synthetic */ String $cType;
                final /* synthetic */ String $collate;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    charSequenceArray[0] = "create collation";
                    ObjectKind objectKind = ObjectKind.COLLATION;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"COLLATION");
                    charSequenceArray[1] = this.this$0.ifNotExists(objectKind);
                    charSequenceArray[2] = this.this$0.currentScopeName(this.$element);
                    charSequenceArray[3] = "(";
                    codeTextBuilder.phrase(charSequenceArray);
                    if (this.$useLocale) {
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            this.this$0.getBuilder().phrase("locale", "=", '\'' + this.$cType + '\'');
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        this.this$0.getBuilder().phrase("lc_collate", "=", '\'' + this.$collate + '\'');
                        this.this$0.getBuilder().addSuffixToTheLastLine(',');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        this.this$0.getBuilder().phrase("lc_ctype", "=", '\'' + this.$cType + '\'');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$element = postgresCollation;
                    this.$useLocale = bl;
                    this.$cType = string;
                    this.$collate = string2;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void appendRoutineAttributes(@NotNull PostgresBaseRoutine f) {
            Object it;
            Object this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            super.appendRoutineAttributes(f);
            PostgresRoutine postgresRoutine = (PostgresRoutine)f;
            if (postgresRoutine.isLeakproof()) {
                this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "leakproof", null, false, 6, null);
                }
                finally {
                    ((CodeTextBuilder)this_$iv).unindent();
                }
            }
            if (postgresRoutine.isWindow()) {
                this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "window", null, false, 6, null);
                }
                finally {
                    ((CodeTextBuilder)this_$iv).unindent();
                }
            }
            if (postgresRoutine.isStrict()) {
                this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "strict", null, false, 6, null);
                }
                finally {
                    ((CodeTextBuilder)this_$iv).unindent();
                }
            }
            if (postgresRoutine.isSecurityDefiner()) {
                this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "security definer", null, false, 6, null);
                }
                finally {
                    ((CodeTextBuilder)this_$iv).unindent();
                }
            }
            PostgresRoutineConcurrencyKind postgresRoutineConcurrencyKind = postgresRoutine.getConcurrencyKind();
            if (postgresRoutineConcurrencyKind != null && Intrinsics.areEqual((Object)(it = (this_$iv = postgresRoutineConcurrencyKind)), (Object)((Object)PostgresRoutineConcurrencyKind.UNSAFE)) ^ true) {
                CodeTextBuilder this_$iv2 = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv2, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "parallel " + ((PostgresRoutineConcurrencyKind)((Object)it)).getModifier(), null, false, 6, null);
                }
                finally {
                    this_$iv2.unindent();
                }
            }
            if (PostgresModelFun.isCostDefined(postgresRoutine)) {
                this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getCost(), "cost") + ' ' + PostgresModelFun.costAsString(postgresRoutine), null, false, 6, null);
                }
                finally {
                    ((CodeTextBuilder)this_$iv).unindent();
                }
            }
            if (PostgresModelFun.isRowsDefined(postgresRoutine)) {
                this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getRows(), "rows") + ' ' + PostgresModelFun.rowsAsString(postgresRoutine), null, false, 6, null);
                }
                finally {
                    ((CodeTextBuilder)this_$iv).unindent();
                }
            }
            List<String> configurationParameters = postgresRoutine.getConfigurationParameters();
            for (String configurationParameter : configurationParameters) {
                CodeTextBuilder this_$iv3 = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv3, null, 1, null);
                try {
                    this.getBuilder().phrase("SET", configurationParameter);
                }
                finally {
                    this_$iv3.unindent();
                }
            }
        }

        private final String floatAttributeName(float f, String s) {
            float f2 = f;
            StringBuilder stringBuilder = new StringBuilder().append("");
            boolean bl = Float.isInfinite(f2);
            return stringBuilder.append(bl ? "--" : "").append("").append(s).toString();
        }

        @Override
        @Nullable
        protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            if (Intrinsics.areEqual((Object)((Object)f.getVolatilityKind()), (Object)((Object)PostgresVolatilityKind.VOLATILE))) {
                string = null;
            } else {
                Object object = f.getVolatilityKind();
                if (object != null && (object = object.name()) != null) {
                    Object object2;
                    Object object3 = object2 = object;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)object3).toLowerCase();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                } else {
                    string = null;
                }
            }
            return string;
        }

        @Override
        protected void generateSequence(@NotNull BasicSequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            if (!(sequence instanceof PostgresSequence) || !((PostgresSequence)sequence).isBelongsToColumn()) {
                super.generateSequence(sequence);
            }
        }

        @Override
        @Nullable
        protected String elementKindNameForCreate(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            ObjectKind objectKind = element.getKind();
            return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "foreign table" : super.elementKindNameForCreate(element);
        }

        @Override
        protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
            block5: {
                PostgresSequence postgresSequence;
                PostgresSequence $receiver;
                Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
                Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
                BasicSequence basicSequence = sequence;
                if (!(basicSequence instanceof PostgresSequence)) {
                    basicSequence = null;
                }
                PostgresSequence postgresSequence2 = (PostgresSequence)basicSequence;
                if (postgresSequence2 != null && !PostgresModelFun.hasDefaultType($receiver = (postgresSequence = postgresSequence2))) {
                    parameters.add("as " + $receiver.getDataType());
                }
                super.gatherSequenceIdentityParameters(sequence, parameters);
                BasicSequence basicSequence2 = sequence;
                if (!(basicSequence2 instanceof PostgresSequence)) {
                    basicSequence2 = null;
                }
                PostgresSequence postgresSequence3 = (PostgresSequence)basicSequence2;
                if (postgresSequence3 == null) break block5;
                postgresSequence = postgresSequence3;
                $receiver = postgresSequence;
                if (!PostgresModelFun.hasDefaultCacheSize($receiver)) {
                    parameters.add("cache " + $receiver.getCacheSize());
                }
                if ($receiver.isCycled()) {
                    parameters.add("cycle");
                }
            }
        }

        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            HeaderFooter hf = super.makeTableHeaderFooter(table);
            BasicTable basicTable = table;
            if (!(basicTable instanceof PostgresTable)) {
                basicTable = null;
            }
            PostgresTable postgresTable = (PostgresTable)basicTable;
            if (postgresTable == null) {
                return hf;
            }
            PostgresTable t = postgresTable;
            String footer = null;
            Collection collection = t.getAncestorIds();
            if (!collection.isEmpty()) {
                List<PostgresTable> ancestors = PostgresModelFun.getAncestors(t);
                footer = "inherits (" + CollectionsKt.joinToString$default((Iterable)ancestors, null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresTable, String>(this){
                    final /* synthetic */ PgCreatingGenerator this$0;

                    @NotNull
                    public final String invoke(@NotNull PostgresTable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return this.this$0.currentScopeName(it);
                    }
                    {
                        this.this$0 = pgCreatingGenerator;
                        super(1);
                    }
                }), (int)31, null) + ")";
            }
            if (t instanceof PostgresForeignTable) {
                if (footer != null) {
                    footer = footer + "\n";
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string = footer;
                if (string == null) {
                    string = "";
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string).append("server ").append(((PostgresForeignTable)t).getServer()).append("");
                List<String> list = ((PostgresForeignTable)t).getOptions();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.options");
                footer = stringBuilder2.append(this.optionsToString(list, true)).toString();
            }
            return footer == null ? hf : new HeaderFooter(hf.getHeader(), footer);
        }

        @Override
        protected void generateColumn(@NotNull BasicLikeColumn column) {
            PostgresSchema schema;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (column instanceof PostgresTableColumn && ((PostgresTableColumn)column).isInherited()) {
                return;
            }
            super.generateColumn(column);
            if (column instanceof PostgresLocalTableColumn && ((PostgresLocalTableColumn)column).getSequenceName() != null && (schema = ((PostgresLocalTableColumn)column).getSchema()) != null) {
                PostgresSequence sequence;
                NamingIdentifyingFamily<? extends PostgresSequence> namingIdentifyingFamily = schema.getSequences();
                String string = ((PostgresLocalTableColumn)column).getSequenceName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((sequence = (PostgresSequence)namingIdentifyingFamily.get(string)) != null) {
                    PostgresScriptingService.this.getGenerated().add(sequence);
                }
            }
        }

        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return column instanceof PostgresLocalTableColumn && ((PostgresLocalTableColumn)column).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column) : super.makeNormalColumnSpecification(column);
        }

        @Override
        @NotNull
        protected String generalColumnSpecification(@NotNull BasicLikeColumn column) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            StringBuilder stringBuilder = new StringBuilder().append(super.generalColumnSpecification(column));
            if (column instanceof PostgresForeignTableColumn) {
                List<String> list = ((PostgresForeignTableColumn)column).getOptions();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"column.options");
                string = this.optionsToString(list, false);
            } else {
                string = "";
            }
            return stringBuilder.append(string).toString();
        }

        private final String makeSerialColumnSpecification(PostgresTableColumn column) {
            String specification;
            DataType dt = column.getDataType();
            String string = StringsKt.startsWith$default((String)dt.typeName, (String)"small", (boolean)false, (int)2, null) ? "smallserial" : (specification = StringsKt.startsWith$default((String)dt.typeName, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial");
            if (column.isNotNull()) {
                specification = specification + " not null";
            }
            return specification;
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            if (trigger instanceof PostgresTrigger) {
                this.generatePostgresTrigger((PostgresTrigger)trigger);
            } else if (trigger instanceof BasicSourceAware) {
                this.generateUnspecificSourceAwareElement((BasicSourceAware)((Object)trigger));
            }
        }

        private final void generatePostgresTrigger(PostgresTrigger trigger) {
            PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine(trigger);
            if (postgresRoutine == null) {
                return;
            }
            PostgresRoutine routine = postgresRoutine;
            if (Intrinsics.areEqual((Object)((Object)this.getTask()), (Object)((Object)ScriptingTask.CREATE_DEFINITION)) ^ true && (this.getDeck().contains(routine) || !PostgresScriptingService.this.getGenerated().contains(routine))) {
                this.process(routine);
            }
            String triggerName = this.currentScopeName(trigger);
            Object object = trigger.getLikeTable();
            if (object == null || (object = this.currentScopeName((BasicElement)object)) == null) {
                return;
            }
            Object tableName = object;
            String routineName = this.currentScopeName(routine);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger, (String)tableName, routineName){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ PostgresTrigger $trigger;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $routineName;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    this.this$0.getBuilder().phrase("create trigger", this.$triggerName);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ev, null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "on " + this.$tableName, null, false, 6, null);
                        TrigTurn turn = this.$trigger.getTurn();
                        if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "for each row", null, false, 6, null);
                        }
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "execute procedure " + this.$routineName + "()", null, false, 6, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$triggerName = string;
                    this.$trigger = postgresTrigger;
                    this.$tableName = string2;
                    this.$routineName = string3;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        @Nullable
        protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
            return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
        }

        private final void generateRole(PostgresRole role) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresRole $role;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    CodeTextBuilder this_$iv;
                    String string = this.$role.getName();
                    PgCreatingGenerator pgCreatingGenerator = this.this$0;
                    StringBuilder stringBuilder = new StringBuilder().append("create ").append(this.$role.isCanLogin() ? "user" : "role").append(' ');
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)((Object)this_$iv)).nameToScript((String)$receiver$iv);
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string2).toString(), null, false, 6, null);
                    this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$role.isSuperRole()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "superuser", null, false, 6, null);
                        }
                        if (this.$role.isCreateDb()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "createdb", null, false, 6, null);
                        }
                        if (this.$role.isCreateRole()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "createrole", null, false, 6, null);
                        }
                        if (!this.$role.isInherit()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "noinherit", null, false, 6, null);
                        }
                        if (this.$role.isReplication()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "replication", null, false, 6, null);
                        }
                        if (this.$role.isBypassRls()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "bypassrls", null, false, 6, null);
                        }
                        if (this.$role.getConnectionLimit() >= 0L) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "connection limit " + this.$role.getConnectionLimit(), null, false, 6, null);
                        }
                        if (this.$role.getValidUntil() != null) {
                            CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                            StringBuilder stringBuilder2 = new StringBuilder().append("valid until ");
                            String string3 = this.$role.getValidUntil();
                            if (string3 == null) {
                                Intrinsics.throwNpe();
                            }
                            CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(this.this$0.getSqlString(string3)).toString(), null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$role = postgresRole;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateDefType(PostgresDefType dt) {
            switch (PostgresScriptingService$PgCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[dt.getSubKind().ordinal()]) {
                case 1: {
                    this.generateEnum(dt);
                    break;
                }
                case 2: {
                    this.generateDomain(dt);
                    break;
                }
                case 3: {
                    this.generateComposite(dt);
                }
            }
        }

        private final void generateEnum(PostgresDefType e) {
            String name = this.currentScopeName(e);
            String labels2 = CollectionsKt.joinToString$default((Iterable)e.getLabels(), null, null, null, (int)0, null, (Function1)generateEnum.labels.1.INSTANCE, (int)31, null);
            String cmd = "create type " + name + " as enum (" + labels2 + ')';
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateDomain(PostgresDefType d) {
            String name = this.currentScopeName(d);
            String def = d.getDefinition();
            String cmd = "create domain " + name + " as " + def + (d.isNotNull() ? " not null" : "");
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd, d){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;
                final /* synthetic */ PostgresDefType $d;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, 6, null);
                    AbstractCodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateDomain.1 this$0;

                        public final void invoke() {
                            if (this.this$0.$d.getDefaultExpression() != null) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "default " + this.this$0.$d.getDefaultExpression(), null, false, 6, null);
                            }
                            for (PostgresDefTypeCheck postgresDefTypeCheck : this.this$0.$d.getChecks()) {
                                PgCreatingGenerator pgCreatingGenerator = this.this$0.this$0;
                                PostgresDefTypeCheck postgresDefTypeCheck2 = postgresDefTypeCheck;
                                Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeCheck2, (String)"check");
                                PgCreatingGenerator.access$generatePostgresDefTypeCheck(pgCreatingGenerator, postgresDefTypeCheck2);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    this.$d = postgresDefType;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateComposite(PostgresDefType struct) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, struct){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresDefType $struct;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    String name = this.this$0.currentScopeName(this.$struct);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create type " + name + " as", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                    for (PostgresDefTypeAttribute postgresDefTypeAttribute : this.$struct.getAttributes()) {
                        void $receiver$iv;
                        String string = postgresDefTypeAttribute.getName();
                        PgCreatingGenerator this_$iv = this.this$0;
                        String n = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
                        DataType t = postgresDefTypeAttribute.getDataType();
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "" + n + ' ' + t + ',', null, false, 6, null);
                    }
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    this.this$0.getBuilder().unindent();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$struct = postgresDefType;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void generateOperator(PostgresOperator op) {
            ArrayList<String> props = new ArrayList<String>(4);
            if (op.getCallRoutineName() != null) {
                void $receiver$iv;
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder().append("procedure = ");
                String string = op.getCallRoutineName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                PgCreatingGenerator pgCreatingGenerator = this;
                StringBuilder stringBuilder2 = stringBuilder;
                ArrayList<String> arrayList = props;
                String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                arrayList.add(stringBuilder2.append(string3).toString());
            }
            if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
                props.add("leftarg = " + op.getLeftType().getSpecification());
            }
            if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
                props.add("rightarg = " + op.getRightType().getSpecification());
            }
            String specification = CollectionsKt.joinToString$default((Iterable)props, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String cmd = "create operator " + op.getName() + " (" + specification + ')';
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void generatePostgresDefTypeCheck(PostgresDefTypeCheck check) {
            String string;
            String string2 = check.getNaturalName();
            if (string2 != null) {
                void $receiver$iv;
                String string3 = string2;
                PgCreatingGenerator this_$iv = this;
                string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
            } else {
                string = null;
            }
            String name = string;
            String string4 = check.getPredicate();
            if (string4 == null) {
                return;
            }
            String predicate = string4;
            String txt = (name != null ? "constraint " + name + ' ' : "") + "check " + predicate;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, txt){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $txt;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$txt, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$txt = string;
                    super(0);
                }
            }, 3, null);
            PostgresScriptingService.this.getGenerated().add(check);
        }

        public PgCreatingGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }

        @NotNull
        public static final /* synthetic */ String access$maybeQualified(PgCreatingGenerator $this, @Nullable String schemaName, @NotNull String name) {
            return $this.maybeQualified(schemaName, name);
        }

        public static final /* synthetic */ void access$appendOptions(PgCreatingGenerator $this, @NotNull List options) {
            $this.appendOptions(options);
        }

        public static final /* synthetic */ void access$generatePostgresDefTypeCheck(PgCreatingGenerator $this, @NotNull PostgresDefTypeCheck check) {
            $this.generatePostgresDefTypeCheck(check);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$PgEnableDisableGenerator;", "Lcom/intellij/database/scripting/BaseEnableDisableGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/PostgresScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateEnableDisableForTrigger", "", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateTrigger", "database-scripting"})
    private final class PgEnableDisableGenerator
    extends BaseEnableDisableGenerator {
        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            BasicTrigger basicTrigger = trigger;
            if (basicTrigger instanceof PostgresRule) {
                if (PostgresScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_RULES).booleanValue()) {
                    this.generateEnableDisableForTrigger(trigger);
                }
            } else if (basicTrigger instanceof PostgresTrigger && PostgresScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_TRIGGERS).booleanValue()) {
                this.generateEnableDisableForTrigger(trigger);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void generateEnableDisableForTrigger(@NotNull BasicTrigger trigger) {
            String string;
            String string2;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            BasicLikeTable basicLikeTable = trigger.getLikeTable();
            if (basicLikeTable == null) {
                return;
            }
            BasicLikeTable table = basicLikeTable;
            String tableName = this.currentScopeName(table);
            String string3 = trigger.getName();
            PgEnableDisableGenerator this_$iv = this;
            String triggerName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
            String ifExists = Intrinsics.areEqual((Object)((Object)this.getTask()), (Object)((Object)ScriptingTask.DISABLE_CONSTRAINTS)) && PostgresScriptingService.this.getOptions().get(ScriptingOptionStatic.IF_EXISTS) != false ? "if exists" : null;
            BasicLikeTable $i$f$getScr = table;
            if ($i$f$getScr instanceof PostgresTable) {
                string2 = "table";
            } else if ($i$f$getScr instanceof PostgresMatView) {
                string2 = "materialized view";
            } else if ($i$f$getScr instanceof PostgresView) {
                string2 = "view";
            } else {
                return;
            }
            String tableWord = string2;
            BasicTrigger basicTrigger = trigger;
            if (basicTrigger instanceof PostgresRule) {
                string = "rule";
            } else if (basicTrigger instanceof PostgresTrigger) {
                string = "trigger";
            } else {
                return;
            }
            String triggerWord = string;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableWord, ifExists, tableName, triggerWord, triggerName){
                final /* synthetic */ PgEnableDisableGenerator this$0;
                final /* synthetic */ String $tableWord;
                final /* synthetic */ String $ifExists;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $triggerWord;
                final /* synthetic */ String $triggerName;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("alter", this.$tableWord, this.$ifExists, this.$tableName, this.this$0.getActionWord(), this.$triggerWord, this.$triggerName);
                }
                {
                    this.this$0 = pgEnableDisableGenerator;
                    this.$tableWord = string;
                    this.$ifExists = string2;
                    this.$tableName = string3;
                    this.$triggerWord = string4;
                    this.$triggerName = string5;
                    super(0);
                }
            }, 3, null);
        }

        public PgEnableDisableGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0019\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bH\u0014J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J5\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00192\u0006\u0010\u0011\u001a\u0002H\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$PgRefactoringGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$RefactoringGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "migrated", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/scripting/PostgresScriptingService;Ljava/util/Map;)V", "argumentChanged", "", "from", "Lcom/intellij/database/model/postgres/PostgresArgument;", "to", "createRoutine", "", "obj", "Lcom/intellij/database/model/postgres/PostgresRoutine;", "orReplace", "dropRoutine", "generateElement", "element", "migrateRoutine", "nameChanged", "Lcom/intellij/database/model/basic/BasicNamedElement;", "renameRoutine", "renamed", "T", "clazz", "Ljava/lang/Class;", "newName", "", "(Lcom/intellij/database/model/basic/BasicNamedElement;Ljava/lang/Class;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicNamedElement;", "routineAttributesChanged", "signatureChanged", "database-scripting"})
    private final class PgRefactoringGenerator
    extends AbstractScriptingService.RefactoringGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof PostgresRoutine) {
                BasicElement basicElement2 = this.getMigrated().get(element);
                if (basicElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgres.PostgresRoutine");
                }
                this.migrateRoutine((PostgresRoutine)element, (PostgresRoutine)basicElement2);
            } else {
                super.generateElement(element);
            }
        }

        private final void migrateRoutine(PostgresRoutine from, PostgresRoutine to) {
            boolean renamed2 = this.nameChanged(from, to);
            boolean attrChanged = this.routineAttributesChanged(from, to);
            if (this.signatureChanged(from, to) || attrChanged && renamed2) {
                if (renamed2) {
                    this.createRoutine(to, false);
                    this.dropRoutine(from);
                } else {
                    PostgresRoutine tmp = this.renamed((BasicNamedElement)to, PostgresRoutine.class, to.getName() + "-safe-recreate");
                    this.createRoutine(tmp, false);
                    this.dropRoutine(from);
                    this.renameRoutine(tmp, to);
                }
            } else if (attrChanged) {
                this.createRoutine(to, true);
            } else if (renamed2) {
                this.renameRoutine(from, to);
            }
        }

        private final void dropRoutine(PostgresRoutine obj) {
            ScriptingService.DefaultImpls.makeScript$default(PostgresScriptingService.this, ScriptingTask.DROP_COMPLETE, CollectionsKt.listOf((Object)obj), false, 4, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void createRoutine(PostgresRoutine obj, boolean orReplace) {
            ScriptingOptions prev = PostgresScriptingService.this.getOptions();
            PostgresScriptingService.this.setOptions(new ScriptingOptions(orReplace, prev){
                final /* synthetic */ boolean $orReplace;
                final /* synthetic */ ScriptingOptions $prev;

                @Nullable
                public Object getStoredValue(@NotNull ScriptingOption<?> option) {
                    Intrinsics.checkParameterIsNotNull(option, (String)"option");
                    ScriptingOption<?> scriptingOption = option;
                    return Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CREATE_OR_REPLACE) ? Boolean.valueOf(this.$orReplace) : this.$prev.getStoredValue(option);
                }
                {
                    this.$orReplace = $captured_local_variable$0;
                    this.$prev = $captured_local_variable$1;
                }

                @NotNull
                public <O> O get(@NotNull ScriptingOption<O> option) {
                    Intrinsics.checkParameterIsNotNull(option, (String)"option");
                    return ScriptingOptions.DefaultImpls.get(this, option);
                }
            });
            try {
                PostgresScriptingService.this.makeScript(ScriptingTask.CREATE_DEFINITION, CollectionsKt.listOf((Object)obj), false);
            }
            finally {
                PostgresScriptingService.this.setOptions(prev);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean routineAttributesChanged(PostgresRoutine from, PostgresRoutine to) {
            if (from.isSecurityDefiner() != to.isSecurityDefiner()) return true;
            if (from.isStrict() != to.isStrict()) return true;
            if (Intrinsics.areEqual((Object)((Object)from.getVolatilityKind()), (Object)((Object)to.getVolatilityKind())) ^ true) return true;
            if (Intrinsics.areEqual((Object)from.getLanguageName(), (Object)to.getLanguageName()) ^ true) return true;
            if (from.isReturnsSet() != to.isReturnsSet()) return true;
            CharSequence charSequence = from.getOriginalSourceText();
            CharSequence charSequence2 = to.getOriginalSourceText();
            if (!(Intrinsics.areEqual((Object)(charSequence != null ? StringsKt.trim((CharSequence)charSequence) : null), (Object)(charSequence2 != null ? StringsKt.trim((CharSequence)charSequence2) : null)) ^ true)) return false;
            return true;
        }

        private final <T extends BasicNamedElement> T renamed(T obj, Class<T> clazz, String newName) {
            T t = clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(newName, obj){
                final /* synthetic */ String $newName;
                final /* synthetic */ BasicNamedElement $obj;

                @Nullable
                public Object invoke(@Nullable Object proxy, @NotNull Method method, @Nullable Object[] args2) {
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                    if (Intrinsics.areEqual((Object)method.getName(), (Object)"getName") || Intrinsics.areEqual((Object)method.getName(), (Object)"getRealName")) {
                        object = this.$newName;
                    } else {
                        Object[] objectArray = args2;
                        if (args2 == null) {
                            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
                        }
                        object = method.invoke((Object)this.$obj, Arrays.copyOf(objectArray, objectArray.length));
                    }
                    return object;
                }
                {
                    this.$newName = $captured_local_variable$0;
                    this.$obj = $captured_local_variable$1;
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"clazz.cast(Proxy.newProx\u2026RAY))\n        }\n      }))");
            return (T)((BasicNamedElement)t);
        }

        private final void renameRoutine(PostgresRoutine from, PostgresRoutine to) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, from, to){
                final /* synthetic */ PgRefactoringGenerator this$0;
                final /* synthetic */ PostgresRoutine $from;
                final /* synthetic */ PostgresRoutine $to;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    void this_$iv;
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    StringBuilder stringBuilder = new StringBuilder().append("alter function ").append(this.this$0.currentScopeName(this.$from)).append('(');
                    String string = this.$from.getArgumentsDefinition();
                    if (string == null) {
                        string = "";
                    }
                    String string2 = this.$to.getName();
                    PgRefactoringGenerator pgRefactoringGenerator = this.this$0;
                    StringBuilder stringBuilder2 = stringBuilder.append(string).append(") rename to ");
                    CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                    String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(string3).toString(), null, false, 6, null);
                }
                {
                    this.this$0 = pgRefactoringGenerator;
                    this.$from = postgresRoutine;
                    this.$to = postgresRoutine2;
                    super(0);
                }
            }, 3, null);
        }

        private final boolean signatureChanged(PostgresRoutine from, PostgresRoutine to) {
            boolean bl;
            block4: {
                if (Intrinsics.areEqual((Object)from.getRoutineKind(), (Object)to.getRoutineKind()) ^ true || from.getArguments().size() != to.getArguments().size()) {
                    return true;
                }
                Iterable iterable = to.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"to.arguments");
                Iterable $receiver$iv = CollectionsKt.zip((Iterable)from.getArguments(), (Iterable)iterable);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Pair $f_t = (Pair)element$iv;
                        PostgresArgument f = (PostgresArgument)$f_t.component1();
                        PostgresArgument t = (PostgresArgument)$f_t.component2();
                        PostgresArgument postgresArgument = f;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresArgument, (String)"f");
                        PostgresArgument postgresArgument2 = t;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresArgument2, (String)"t");
                        if (!this.argumentChanged(postgresArgument, postgresArgument2)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean argumentChanged(PostgresArgument from, PostgresArgument to) {
            return this.nameChanged(from, to) || Intrinsics.areEqual((Object)from.getDataType(), (Object)to.getDataType()) ^ true || Intrinsics.areEqual((Object)from.getDefaultExpression(), (Object)to.getDefaultExpression()) ^ true || Intrinsics.areEqual((Object)from.getArgumentDirection(), (Object)to.getArgumentDirection()) ^ true;
        }

        private final boolean nameChanged(BasicNamedElement from, BasicNamedElement to) {
            boolean lcFrom = from.isNameScripted() && !from.isNameQuoted();
            boolean lcTo = to.isNameScripted() && !to.isNameQuoted();
            String fromName = from.getName();
            String toName = to.getName();
            if (lcFrom == lcTo) {
                return !Comparing.strEqual((String)fromName, (String)toName, (!lcFrom ? 1 : 0) != 0);
            }
            if (lcFrom) {
                fromName = StringUtil.toLowerCase((String)fromName);
            }
            if (lcTo) {
                toName = StringUtil.toLowerCase((String)toName);
            }
            return Intrinsics.areEqual((Object)fromName, (Object)toName) ^ true;
        }

        public PgRefactoringGenerator(Map<BasicElement, ? extends BasicElement> migrated) {
            Intrinsics.checkParameterIsNotNull(migrated, (String)"migrated");
            super(PostgresScriptingService.this.getContext(), migrated);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$PROVIDER;", "Lcom/intellij/database/scripting/AbstractScriptingService$Provider;", "()V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "create", "Lcom/intellij/database/scripting/PostgresScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "isSupported", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "", "scriptingVersion", "", "database-scripting"})
    public static final class PROVIDER
    implements AbstractScriptingService.Provider {
        private static final PerObjectVersion VERSION;
        public static final PROVIDER INSTANCE;

        @NotNull
        public PostgresScriptingService create(@NotNull BasicModel model, @Nullable BasicDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            BasicDatabase basicDatabase = database;
            if (basicDatabase == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgres.PostgresDatabase");
            }
            return new PostgresScriptingService((PostgresModel)model, (PostgresDatabase)basicDatabase);
        }

        @Override
        public int scriptingVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.get(kind);
        }

        @Override
        public boolean isSupported(@NotNull ScriptingTask task, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            switch (PostgresScriptingService$PROVIDER$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
                case 1: {
                    bl = PostgresDropGenerator.Companion.canDrop(kind, context);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        private PROVIDER() {
        }

        static {
            PROVIDER pROVIDER;
            INSTANCE = pROVIDER = new PROVIDER();
            VERSION = new PerObjectVersion();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$Companion;", "", "()V", "isRefactoringSupported", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "database-scripting"})
    public static final class Companion {
        public final boolean isRefactoringSupported(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROUTINE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

