/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\bH\u0014J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001a\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001e\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)H\u0014J\u001e\u0010%\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)H\u0014J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u000207H\u0014J\u0010\u00108\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00109\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0014J\u0016\u0010:\u001a\u00020\u00102\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00170<H\u0002J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010>\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010C\u001a\u00020\u00102\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010D\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020GH\u0014J\u0010\u0010H\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0014J\u001a\u0010I\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020J2\b\b\u0002\u0010K\u001a\u00020\bH\u0014J\u0010\u0010L\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020JH\u0014J\u0010\u0010M\u001a\u00020\u00102\u0006\u0010N\u001a\u00020OH\u0014J\u0010\u0010P\u001a\u00020\u00102\u0006\u00100\u001a\u000201H\u0014J\u0010\u0010Q\u001a\u00020\u00102\u0006\u00100\u001a\u00020RH\u0014J\u0010\u0010S\u001a\u00020\u00102\u0006\u00100\u001a\u000201H\u0014J\u0010\u0010T\u001a\u00020\u00102\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010U\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020JH\u0014J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00170W2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010X\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\fJ\u0014\u0010Y\u001a\u0004\u0018\u00010\"2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0014J\u0012\u0010\\\u001a\u0004\u0018\u00010\"2\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u0010]\u001a\u0004\u0018\u00010\"2\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u0010^\u001a\u0004\u0018\u00010\"2\u0006\u0010-\u001a\u00020_H\u0014J\u0012\u0010`\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010a\u001a\u00020\"2\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010b\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010c\u001a\u00020\"2\u0006\u0010F\u001a\u00020GH\u0014J\u0012\u0010d\u001a\u0004\u0018\u00010\"2\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u0010e\u001a\u0004\u0018\u00010\"2\u0006\u0010N\u001a\u00020OH\u0014J\u0010\u0010f\u001a\u00020g2\u0006\u00100\u001a\u000201H\u0014J\u0010\u0010h\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010i\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\"H\u0014J\b\u0010j\u001a\u00020\bH\u0014J\u0010\u0010k\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0004R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006l"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "isExact", "", "()Z", "tableElementsApplicableInExactTask", "", "Lcom/intellij/database/model/ObjectKind;", "getTableElementsApplicableInExactTask", "()Ljava/util/Set;", "addInnerConstraintNameAndIndent", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "addOuterConstraintNameAndIndent", "allowReferenceOnPrimaryKeyWithoutColumns", "canCreateInColumn", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canCreateInTable", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "canGenerateInnerElement", "createOrReplace", "", "kind", "elementKindNameForCreate", "gatherSequenceIdentityParameters", "identity", "Lcom/intellij/database/model/SequenceIdentity;", "parameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateAdditionalTableItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateCascadeRules", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateColumn", "generateColumnComment", "generateColumnInnerElements", "singleColumnElementsToGenerate", "", "generateComment", "generateDeferrability", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateElement", "generateForeignKey", "generateIndex", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateSequence", "generateSourceAwareElement", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processChildren", "generateSourceAwareUsingSources", "generateSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateTable", "generateTableComment", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateTableOutsideStuff", "generateTrigger", "generateUnspecificSourceAwareElement", "getSingleColumnElements", "", "ifNotExists", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeColumnDefinition", "makeColumnSpecification", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeDeferrability", "makeForeignKeyReference", "makeIndexWord", "makeKeyWord", "makeNormalColumnSpecification", "makeSynonymTargetSpec", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "processElementChildren", "scriptIndexColumn", "shouldCollectColumnElements", "weDontKnowHowToGenerateThis", "database-scripting"})
public class BaseCreatingGenerator
extends AbstractCodeGenerator {
    private final boolean isExact;
    @NotNull
    private final Set<ObjectKind> tableElementsApplicableInExactTask;

    protected final boolean isExact() {
        return this.isExact;
    }

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicSequence) {
            this.generateSequence((BasicSequence)element);
        } else if (basicElement instanceof BasicTable) {
            this.generateTable((BasicTable)element);
        } else if (basicElement instanceof BasicLikeColumn) {
            this.generateColumn((BasicLikeColumn)element);
        } else if (basicElement instanceof BasicIndex) {
            this.generateIndex((BasicIndex)element);
        } else if (basicElement instanceof BasicKey) {
            this.generateKey((BasicKey)element);
        } else if (basicElement instanceof BasicForeignKey) {
            this.generateForeignKey((BasicForeignKey)element);
        } else if (basicElement instanceof BasicCheck) {
            this.generateCheck((BasicCheck)element);
        } else if (basicElement instanceof BasicTrigger) {
            this.generateTrigger((BasicTrigger)element);
        } else if (basicElement instanceof BasicSourceAware) {
            this.generateSourceAwareElement((BasicSourceAware)element, true);
        } else if (basicElement instanceof BasicSynonym) {
            this.generateSynonym((BasicSynonym)element);
        } else {
            this.weDontKnowHowToGenerateThis(element);
        }
    }

    protected void generateSequence(@NotNull BasicSequence sequence) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        if (sequence instanceof BasicNamedElement && ((BasicNamedElement)((Object)sequence)).isNameSurrogate()) {
            return;
        }
        String name = this.currentScopeName(sequence);
        ArrayList parameters = new ArrayList();
        this.gatherSequenceIdentityParameters(sequence, (List<String>)parameters);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, sequence, name, parameters){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicSequence $sequence;
            final /* synthetic */ String $name;
            final /* synthetic */ ArrayList $parameters;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                CharSequence[] charSequenceArray = new CharSequence[4];
                ObjectKind objectKind = ObjectKind.SEQUENCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SEQUENCE");
                charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                String string = this.this$0.elementKindNameForCreate(this.$sequence);
                charSequenceArray[1] = string != null ? (CharSequence)string : (CharSequence)"sequence";
                ObjectKind objectKind2 = ObjectKind.SEQUENCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.SEQUENCE");
                charSequenceArray[2] = this.this$0.ifNotExists(objectKind2);
                charSequenceArray[3] = this.$name;
                codeTextBuilder.phrase(charSequenceArray);
                Collection collection = this.$parameters;
                if (!collection.isEmpty()) {
                    AbstractCodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateSequence.1 this$0;

                        public final void invoke() {
                            for (String p : this.this$0.$parameters) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), p, null, false, 6, null);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$sequence = basicSequence;
                this.$name = string;
                this.$parameters = arrayList;
                super(0);
            }
        }, 3, null);
    }

    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        SequenceIdentity i2;
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        SequenceIdentity sequenceIdentity = sequence.getSequenceIdentity();
        if (sequenceIdentity == null) {
            return;
        }
        SequenceIdentity sequenceIdentity2 = i2 = sequenceIdentity;
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity2, (String)"i");
        this.gatherSequenceIdentityParameters(sequenceIdentity2, parameters);
    }

    protected void gatherSequenceIdentityParameters(@NotNull SequenceIdentity identity, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        int sign = identity.increment.signum();
        switch (sign) {
            case 1: {
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.min != null && Intrinsics.areEqual((Object)identity.min, (Object)BigInteger.ONE) ^ true) {
                    parameters.add("minvalue " + identity.min);
                }
                if (Intrinsics.areEqual((Object)identity.increment, (Object)BigInteger.ONE) ^ true) {
                    parameters.add("increment by " + identity.increment);
                }
                if (identity.max == null) break;
                parameters.add("maxvalue " + identity.max);
                break;
            }
            case -1: {
                if (identity.next != null && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.max != null) {
                    parameters.add("maxvalue " + identity.max);
                }
                parameters.add("increment by " + identity.increment);
                if (identity.min == null) break;
                parameters.add("minvalue " + identity.min);
                break;
            }
            default: {
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.min != null) {
                    parameters.add("minvalue " + identity.min);
                }
                if (identity.max == null) break;
                parameters.add("maxvalue " + identity.max);
            }
        }
    }

    protected void generateTable(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicTable $table;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void header;
                HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter(this.$table);
                String string = headerFooter.component1();
                String footer = headerFooter.component2();
                CodeTextBuilder.append$default(this.this$0.getBuilder(), (CharSequence)header, null, false, 6, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                this.this$0.coding(ScriptLocus.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ generateTable.1 this$0;

                    public final void invoke() {
                        for (BasicElement element : this.this$0.$table.getChildren()) {
                            if (this.this$0.this$0.getContext().getGenerated().contains(element)) continue;
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                            BasicElement basicElement = element;
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                            if (!baseCreatingGenerator.canCreateInTable(basicElement)) continue;
                            this.this$0.this$0.process(element);
                        }
                        this.this$0.this$0.generateAdditionalTableItems(this.this$0.$table);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), footer, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$table = basicTable;
                super(0);
            }
        }, 3, null);
        if (Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE)) || Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_STATEMENT))) {
            this.generateTableOutsideStuff(table);
        }
    }

    protected void generateAdditionalTableItems(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
    }

    protected void generateTableOutsideStuff(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        for (BasicElement element : table.getChildren()) {
            if (element instanceof BasicLikeColumn || this.getContext().getGenerated().contains(element) || !this.tableElementsApplicableInExactTask.contains(element.getKind()) && this.isExact || !this.canGenerateHere(ScriptLocus.OUTSIDE, element)) continue;
            BasicElement basicElement = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
            this.process(basicElement);
        }
        if (table.getComment() != null) {
            this.generateComment(table);
        }
        for (BasicTableOrViewColumn column : table.getColumns()) {
            if (column.getComment() == null) continue;
            BasicTableOrViewColumn basicTableOrViewColumn = column;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"column");
            this.generateComment(basicTableOrViewColumn);
        }
    }

    protected boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
            case 1: {
                if (!(element instanceof BasicConstraint) || Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (element instanceof BasicTableOrViewColumn || element instanceof BasicConstraint && this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (element instanceof BasicConstraint && Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    protected final Set<ObjectKind> getTableElementsApplicableInExactTask() {
        return this.tableElementsApplicableInExactTask;
    }

    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String name = this.currentScopeName(table);
        String temporary = table.isTemporary() ? "temporary" : null;
        String[] stringArray = new String[5];
        ObjectKind objectKind = table.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
        stringArray[0] = this.createOrReplace(objectKind);
        stringArray[1] = temporary;
        String string = this.elementKindNameForCreate(table);
        if (string == null) {
            string = "table";
        }
        stringArray[2] = string;
        ObjectKind objectKind2 = table.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"table.kind");
        stringArray[3] = this.ifNotExists(objectKind2);
        stringArray[4] = name;
        String h = ScriptingUtilsKt.phrase(stringArray);
        return new HeaderFooter(h, null);
    }

    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? "table" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE) ? "sequence" : null);
    }

    protected final boolean canCreateInColumn(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.canGenerateHere(ScriptLocus.IN_COLUMN, element);
    }

    protected boolean canCreateInTable(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.canGenerateHere(ScriptLocus.IN_TABLE, element);
    }

    protected void generateColumn(@NotNull BasicLikeColumn column) {
        List singleColumnElementsToGenerate;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        if (this.shouldCollectColumnElements()) {
            singleColumnElementsToGenerate = new LinkedList();
            for (BasicElement e : this.getSingleColumnElements(column)) {
                ((LinkedList)singleColumnElementsToGenerate).add(e);
            }
            ListIterator listIterator = ((LinkedList)singleColumnElementsToGenerate).listIterator();
            Intrinsics.checkExpressionValueIsNotNull(listIterator, (String)"singleColumnElementsToGenerate.listIterator()");
            ListIterator it = listIterator;
            while (it.hasNext()) {
                BasicElement e = (BasicElement)it.next();
                if (!this.getContext().getGenerated().contains(e) && this.canGenerateElementRightNow(e)) continue;
                it.remove();
            }
        } else {
            singleColumnElementsToGenerate = CollectionsKt.emptyList();
        }
        String string = this.makeColumnDefinition(column);
        if (string == null) {
            return;
        }
        String line = string;
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$1[this.getLocus().ordinal()]) {
            case 1: {
                CodeTextBuilder.append$default(this.getBuilder(), line, null, false, 6, null);
                this.generateColumnInnerElements(singleColumnElementsToGenerate);
                this.getBuilder().addSuffixToTheLastLine(',');
                break;
            }
            case 2: {
                BasicScriptable basicScriptable;
                BasicLikeColumn basicLikeColumn = column;
                if (!(basicLikeColumn instanceof BasicTableColumn)) {
                    basicLikeColumn = null;
                }
                if ((basicScriptable = (BasicTableColumn)basicLikeColumn) == null || (basicScriptable = basicScriptable.getTable()) == null) {
                    return;
                }
                BasicScriptable table = basicScriptable;
                String tableName = this.currentScopeName(table);
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, line){
                    final /* synthetic */ BaseCreatingGenerator this$0;
                    final /* synthetic */ String $tableName;
                    final /* synthetic */ String $line;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        this.this$0.getBuilder().phrase("alter table", this.$tableName);
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            this.this$0.getBuilder().phrase("add", this.$line);
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    {
                        this.this$0 = baseCreatingGenerator;
                        this.$tableName = string;
                        this.$line = string2;
                        super(0);
                    }
                }, 3, null);
                if (column.getComment() == null) break;
                this.generateColumnComment(column);
                break;
            }
            default: {
                this.getBuilder().phrase("Here should be column", line);
            }
        }
    }

    protected boolean shouldCollectColumnElements() {
        return Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN)) && Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE));
    }

    private final void generateColumnInnerElements(Collection<? extends BasicElement> singleColumnElementsToGenerate) {
        Collection<? extends BasicElement> collection = singleColumnElementsToGenerate;
        if (!collection.isEmpty()) {
            this.coding(ScriptLocus.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this, singleColumnElementsToGenerate){
                final /* synthetic */ BaseCreatingGenerator this$0;
                final /* synthetic */ Collection $singleColumnElementsToGenerate;

                public final void invoke() {
                    for (BasicElement e : this.$singleColumnElementsToGenerate) {
                        this.this$0.process(e);
                    }
                }
                {
                    this.this$0 = baseCreatingGenerator;
                    this.$singleColumnElementsToGenerate = collection;
                    super(0);
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String makeColumnDefinition(@NotNull BasicLikeColumn column) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        String string = column.getName();
        BaseCreatingGenerator this_$iv = this;
        String name = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        String specification = this.makeColumnSpecification(column);
        return ScriptingUtilsKt.concatWithSpace(name, specification);
    }

    @Nullable
    protected String makeColumnSpecification(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return column instanceof BasicTableColumn && ((BasicTableColumn)column).isComputed() && ((BasicTableColumn)column).getDefaultExpression() != null ? this.makeComputedColumnSpecification((BasicTableOrViewColumn)column) : this.makeNormalColumnSpecification(column);
    }

    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        boolean autoInc = column instanceof BasicTableColumn && ((BasicTableColumn)column).isAutoInc();
        String specification = this.generalColumnSpecification(column);
        if (column.getDefaultExpression() != null) {
            specification = specification + " default " + column.getDefaultExpression();
        }
        if (column.isNotNull() && !autoInc) {
            specification = specification + " not null";
        }
        if (!column.isNotNull() && this.getHelper().isNullExplicit(column) && !autoInc) {
            specification = specification + " null";
        }
        return specification;
    }

    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        DataType dataType = column.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        return this.script(dataType);
    }

    @Nullable
    protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return "as " + column.getDefault();
    }

    @NotNull
    protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        BasicLikeTable basicLikeTable = column.getLikeTable();
        if (basicLikeTable == null) {
            return SetsKt.emptySet();
        }
        BasicLikeTable table = basicLikeTable;
        JBIterable jBIterable = table.getChildren().filter(BasicConstraint.class).filter((Condition)new Condition<BasicConstraint>(this, column){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicLikeColumn $column;

            public final boolean value(BasicConstraint it) {
                BasicConstraint basicConstraint = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraint, (String)"it");
                return this.this$0.canCreateInColumn(basicConstraint) && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$column = basicLikeColumn;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.children\n      .fi\u2026.first() == column.name }");
        return (Iterable)jBIterable;
    }

    protected void generateIndex(@NotNull BasicIndex index) {
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        if (!this.canCreateIndexInCurrentContext(index)) {
            throw (Throwable)new AbortException();
        }
        String w = this.makeIndexWord(index);
        String condition = index.getCondition();
        StringBuilder b = new StringBuilder();
        for (String col : index.getColNames()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.append(", ");
            }
            String string = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col");
            b.append(this.scriptIndexColumn(index, string));
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, index, b, condition){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $w;
            final /* synthetic */ BasicIndex $index;
            final /* synthetic */ StringBuilder $b;
            final /* synthetic */ String $condition;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$2[this.this$0.getLocus().ordinal()]) {
                    case 1: {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                        break;
                    }
                    case 2: {
                        String s = this.this$0.getUseName(this.$index) ? "" + this.$w + ' ' + this.$index.getName() + " (" + this.$b + ')' : "" + this.$w + " (" + this.$b + ')';
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                        break;
                    }
                    default: {
                        BasicLikeTable basicLikeTable = this.$index.getLikeTable();
                        String tableName = basicLikeTable != null ? this.this$0.currentScopeName(basicLikeTable) : null;
                        String indexName = this.this$0.currentScopeName(this.$index);
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        CharSequence[] charSequenceArray = new CharSequence[4];
                        ObjectKind objectKind = ObjectKind.INDEX;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
                        charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                        charSequenceArray[1] = this.$w;
                        ObjectKind objectKind2 = ObjectKind.INDEX;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.INDEX");
                        charSequenceArray[2] = this.this$0.ifNotExists(objectKind2);
                        charSequenceArray[3] = indexName;
                        codeTextBuilder.phrase(charSequenceArray);
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            this.this$0.getBuilder().phrase("on " + tableName + " (" + this.$b + ')');
                            this.this$0.getBuilder().phrase(ScriptingUtilsKt.concatIfNotNull("where ", this.$condition));
                            break;
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$w = string;
                this.$index = basicIndex;
                this.$b = stringBuilder;
                this.$condition = string2;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String scriptIndexColumn(@NotNull BasicIndex index, @NotNull String column) {
        String s;
        String string;
        boolean dirs;
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        CharSequence charSequence = column;
        if (charSequence.length() == 0) {
            return "???";
        }
        Set<String> descendants = index.getReverseColNames();
        Collection collection = descendants;
        boolean bl = dirs = !collection.isEmpty();
        if (column.charAt(0) == '\u001b') {
            String string2 = column;
            int n = 1;
            int n2 = column.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            void $receiver$iv;
            String string4 = column;
            BaseCreatingGenerator this_$iv = this;
            string = s = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        }
        if (dirs) {
            s = s + (descendants.contains(column) ? " desc" : " asc");
        }
        return s;
    }

    @NotNull
    protected String makeIndexWord(@NotNull BasicIndex index) {
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        return index.isUnique() ? "unique index" : "index";
    }

    @NotNull
    protected String makeKeyWord(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return key2.isPrimary() ? "primary key" : "unique";
    }

    protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index) {
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        return Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_STATEMENT)) || Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE));
    }

    protected void generateKey(@NotNull BasicKey key2) {
        boolean indexIsExplicit;
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        String w = this.makeKeyWord(key2);
        BasicIndex index = key2.getUnderlyingIndex();
        boolean bl = indexIsExplicit = index != null && this.getUseName(index) && Intrinsics.areEqual((Object)index.getName(), (Object)key2.getName()) ^ true;
        if (indexIsExplicit) {
            Set<BasicElement> set = this.getContext().getGenerated();
            BasicIndex basicIndex = index;
            if (basicIndex == null) {
                Intrinsics.throwNpe();
            }
            if (!set.contains(basicIndex)) {
                this.getPostponed().putValue((Object)index, (Object)key2);
                throw (Throwable)new AbortException();
            }
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, w){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicKey $key;
            final /* synthetic */ String $w;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$3[this.this$0.getLocus().ordinal()]) {
                    case 1: {
                        this.this$0.addInnerConstraintNameAndIndent(this.$key);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                        this.this$0.generateDeferrability(this.$key);
                        break;
                    }
                    case 2: {
                        void this_$iv2;
                        void $receiver$iv2;
                        this.this$0.addInnerConstraintNameAndIndent(this.$key);
                        Iterable iterable = this.$key.getColNames();
                        BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                        StringBuilder stringBuilder = new StringBuilder().append(this.$w).append(" (");
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractCodeGenerator)this_$iv2){
                            final /* synthetic */ AbstractCodeGenerator this$0;

                            @NotNull
                            public final String invoke(@NotNull String it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                String $receiver$iv = it;
                                AbstractCodeGenerator this_$iv = this.this$0;
                                return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                            }
                            {
                                this.this$0 = abstractCodeGenerator;
                                super(1);
                            }
                        }), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(")").toString(), null, false, 6, null);
                        this.this$0.generateDeferrability(this.$key);
                        this.this$0.getBuilder().addSuffixToTheLastLine(',');
                        break;
                    }
                    default: {
                        void this_$iv;
                        void $receiver$iv;
                        String string;
                        String string2;
                        CodeTextBuilder codeTextBuilder;
                        StringBuilder stringBuilder;
                        Object $receiver$iv2;
                        CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                        StringBuilder stringBuilder2 = new StringBuilder().append("alter table ");
                        String string3 = this.$key.getTableName();
                        if (string3 != null) {
                            $receiver$iv2 = string3;
                            BaseCreatingGenerator this_$iv2 = this.this$0;
                            stringBuilder = stringBuilder2;
                            codeTextBuilder = codeTextBuilder2;
                            string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv2).nameToScript((String)$receiver$iv2);
                            codeTextBuilder2 = codeTextBuilder;
                            stringBuilder2 = stringBuilder;
                            string = string2;
                        } else {
                            string = null;
                        }
                        CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(string).toString(), null, false, 6, null);
                        CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                        this.this$0.addOuterConstraintNameAndIndent(this.$key);
                        String w1 = !this.this$0.getUseName(this.$key) ? "add " : "";
                        Iterable $i$f$getScr = this.$key.getColNames();
                        $receiver$iv2 = this.this$0;
                        stringBuilder = new StringBuilder().append(w1).append(this.$w).append(" (");
                        codeTextBuilder = this.this$0.getBuilder();
                        string2 = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string2).append(")").toString(), null, false, 6, null);
                        this.this$0.generateDeferrability(this.$key);
                    }
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$key = basicKey;
                this.$w = string;
                super(0);
            }
        }, 3, null);
        if (index != null) {
            this.getContext().getGenerated().add(index);
        }
    }

    protected void generateForeignKey(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        String reference = this.makeForeignKeyReference(fk);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, fk, reference){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicForeignKey $fk;
            final /* synthetic */ String $reference;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$4[this.this$0.getLocus().ordinal()]) {
                    case 1: {
                        this.this$0.addInnerConstraintNameAndIndent(this.$fk);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$reference, null, false, 6, null);
                        this.this$0.generateCascadeRules(this.$fk);
                        this.this$0.generateDeferrability(this.$fk);
                        break;
                    }
                    case 2: {
                        void this_$iv;
                        void $receiver$iv;
                        this.this$0.addInnerConstraintNameAndIndent(this.$fk);
                        Iterable iterable = this.$fk.getColNames();
                        BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                        StringBuilder stringBuilder = new StringBuilder().append("foreign key (");
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(") ").append(this.$reference).toString(), null, false, 6, null);
                        this.this$0.generateCascadeRules(this.$fk);
                        this.this$0.generateDeferrability(this.$fk);
                        this.this$0.getBuilder().addSuffixToTheLastLine(',');
                        break;
                    }
                    default: {
                        void this_$iv;
                        void $receiver$iv;
                        BaseCreatingGenerator $receiver$iv2;
                        PostgresTable table;
                        Object object;
                        DasTable dasTable = this.$fk.getTable();
                        if (!(dasTable instanceof PostgresTable)) {
                            dasTable = null;
                        }
                        if ((object = (table = (PostgresTable)dasTable)) == null || (object = this.this$0.currentScopeName((BasicElement)object)) == null) {
                            String string = this.$fk.getTableName();
                            if (string != null) {
                                String string2 = string;
                                BaseCreatingGenerator this_$iv2 = this.this$0;
                                object = AbstractCodeGenerator.access$getNaming$p(this_$iv2).nameToScript((String)((Object)$receiver$iv2));
                            } else {
                                object = null;
                            }
                        }
                        Object tableName = object;
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter table " + (String)tableName, null, false, 6, null);
                        CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                        this.this$0.addOuterConstraintNameAndIndent(this.$fk);
                        String w1 = !this.this$0.getUseName(this.$fk) ? "add " : "";
                        Iterable $i$f$getScr = this.$fk.getColNames();
                        $receiver$iv2 = this.this$0;
                        StringBuilder stringBuilder = new StringBuilder().append(w1).append("foreign key (");
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(") ").append(this.$reference).toString(), null, false, 6, null);
                        this.this$0.generateCascadeRules(this.$fk);
                        this.this$0.generateDeferrability(this.$fk);
                    }
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$fk = basicForeignKey;
                this.$reference = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected String makeForeignKeyReference(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        domSchemaName = ModelFun.getSchemaName(fk);
        refSchemaName = fk.getRefSchemaName();
        if (refSchemaName == null) ** GOTO lbl-1000
        if (Intrinsics.areEqual((Object)refSchemaName, (Object)domSchemaName) ^ true) ** GOTO lbl-1000
        v0 = this.getContext().getCurrentSchema();
        if (Intrinsics.areEqual((Object)refSchemaName, (Object)(v0 != null ? v0.getRealName() : null)) ^ true) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = toQualify = false;
        }
        if (toQualify) {
            v2 = new StringBuilder();
            v3 = refSchemaName;
            if (v3 != null) {
                var7_5 = v3;
                var6_6 = this;
                var11_8 = v2;
                var12_9 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                v2 = var11_8;
                v4 = var12_9;
            } else {
                v4 = null;
            }
            v5 = v2.append(v4).append(".");
            v6 = fk.getRefTableName();
            if (v6 != null) {
                $receiver$iv = v6;
                this_$iv = this;
                var11_8 = v5;
                var12_9 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                v5 = var11_8;
                v7 = var12_9;
            } else {
                v7 = null;
            }
            v8 = v5.append(v7).toString();
        } else {
            v9 = fk.getRefTableName();
            if (v9 != null) {
                $receiver$iv = v9;
                this_$iv = this;
                v8 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            } else {
                v8 = null;
            }
        }
        refTableScr = v8;
        omitReferencedColumns = ModelFun.getRefToPrimaryKey(fk) != false && this.allowReferenceOnPrimaryKeyWithoutColumns() != false;
        v10 = new StringBuilder().append("references ").append(refTableScr);
        if (omitReferencedColumns) {
            v11 = "";
        } else {
            var9_11 = fk.getRefColNames();
            $i$f$getScr = this;
            var12_9 = new StringBuilder().append(" (");
            var11_8 = v10;
            var13_13 = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
            v10 = var11_8;
            v11 = var12_9.append(var13_13).append(")").toString();
        }
        reference = v10.append(v11).toString();
        return reference;
    }

    protected boolean allowReferenceOnPrimaryKeyWithoutColumns() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCascadeRules(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        String c1 = ScriptingUtilsKt.concatIfNotNull("on update ", this.makeCascadeRuleKeyword(fk.getOnUpdate()));
        String c2 = ScriptingUtilsKt.concatIfNotNull("on delete ", this.makeCascadeRuleKeyword(fk.getOnDelete()));
        String c = ScriptingUtilsKt.phrase(c1, c2);
        if (c != null) {
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), c, null, false, 6, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        CascadeRule cascadeRule = rule;
        if (cascadeRule == null) return null;
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$5[cascadeRule.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                String string = rule.keyWord;
                return string;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateCheck(@NotNull BasicCheck check) {
        void w1;
        Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
        String def = "check (" + check.getPredicate() + ")";
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "";
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, check, (Ref.ObjectRef)w1, def){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicCheck $check;
            final /* synthetic */ Ref.ObjectRef $w1;
            final /* synthetic */ String $def;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$6[this.this$0.getLocus().ordinal()]) {
                    case 1: 
                    case 2: {
                        this.this$0.addInnerConstraintNameAndIndent(this.$check);
                        break;
                    }
                    default: {
                        CharSequence charSequence;
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        CharSequence[] charSequenceArray = new CharSequence[2];
                        charSequenceArray[0] = "alter table";
                        CharSequence[] charSequenceArray2 = charSequenceArray;
                        CharSequence[] charSequenceArray3 = charSequenceArray;
                        int n = 1;
                        Object object = this.$check.getLikeTable();
                        if (object != null && (object = this.this$0.currentScopeName((BasicElement)object)) != null) {
                            charSequence = (CharSequence)object;
                        } else {
                            String string;
                            String string2 = this.$check.getTableName();
                            if (string2 != null) {
                                void $receiver$iv;
                                void this_$iv;
                                String string3 = string2;
                                BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                                int n2 = n;
                                CharSequence[] charSequenceArray4 = charSequenceArray2;
                                CharSequence[] charSequenceArray5 = charSequenceArray3;
                                CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                                String string4 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                                codeTextBuilder = codeTextBuilder2;
                                charSequenceArray3 = charSequenceArray5;
                                charSequenceArray2 = charSequenceArray4;
                                n = n2;
                                string = string4;
                            } else {
                                string = null;
                            }
                            charSequence = string;
                        }
                        charSequenceArray2[n] = charSequence;
                        codeTextBuilder.phrase(charSequenceArray3);
                        CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                        this.this$0.addOuterConstraintNameAndIndent(this.$check);
                        if (this.this$0.getUseName(this.$check)) break;
                        this.$w1.element = "add ";
                    }
                }
                this.this$0.generateDeferrability(this.$check);
                String text2 = (String)this.$w1.element + this.$def;
                if (Intrinsics.areEqual((Object)((Object)this.this$0.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE))) {
                    text2 = text2 + ',';
                }
                CodeTextBuilder.append$default(this.this$0.getBuilder(), text2, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$check = basicCheck;
                this.$w1 = objectRef;
                this.$def = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDeferrability(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        String dfr = this.makeDeferrability(constraint);
        if (dfr != null) {
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), dfr, null, false, 6, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
    }

    @Nullable
    protected String makeDeferrability(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        return constraint.isDeferrable() ? (constraint.isInitiallyDeferred() ? "deferrable initially deferred" : "deferrable") : null;
    }

    /*
     * WARNING - void declaration
     */
    protected void addInnerConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        if (this.getUseName(constraint)) {
            void $receiver$iv;
            String string = constraint.getName();
            BaseCreatingGenerator this_$iv = this;
            String name = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
            CodeTextBuilder.append$default(this.getBuilder(), "constraint " + name, null, false, 6, null);
            CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
        }
    }

    protected void addOuterConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        if (this.getUseName(constraint)) {
            String name = this.currentScopeName(constraint);
            CodeTextBuilder.append$default(this.getBuilder(), "add constraint " + name, null, false, 6, null);
            CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
        }
    }

    protected void generateTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        if (trigger instanceof BasicSourceAware) {
            this.generateSourceAwareElement((BasicSourceAware)((Object)trigger), false);
            if (trigger.isDisabled()) {
                this.generateDisableTrigger(trigger);
            }
        } else {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
                final /* synthetic */ BaseCreatingGenerator this$0;
                final /* synthetic */ BasicTrigger $trigger;

                public final void invoke() {
                    String triggerName = this.$trigger instanceof BasicSchemaObject ? this.this$0.currentScopeName(this.$trigger) : this.this$0.currentScopeName(this.$trigger);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Unknown how to generate trigger " + triggerName, null, false, 6, null);
                }
                {
                    this.this$0 = baseCreatingGenerator;
                    this.$trigger = basicTrigger;
                    super(0);
                }
            }, 3, null);
        }
    }

    protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String name = trigger instanceof BasicSchemaObject ? this.currentScopeName(trigger) : this.currentScopeName(trigger);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $name;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter trigger " + this.$name + " disable", null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$name = string;
                super(0);
            }
        }, 3, null);
    }

    protected void generateSourceAwareElement(@NotNull BasicSourceAware element, boolean processChildren) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.generateSourceAwareUsingSources(element);
        if (element.getComment() != null) {
            this.generateComment(element);
            if (element instanceof BasicView) {
                PositioningNamingFamily columns2 = ((BasicView)element).getColumns();
                Iterator iterator = columns2.iterator();
                while (iterator.hasNext()) {
                    BasicTableOrViewColumn column;
                    BasicTableOrViewColumn basicTableOrViewColumn = column = (BasicTableOrViewColumn)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"column");
                    this.generateComment(basicTableOrViewColumn);
                }
            }
        }
        if (processChildren) {
            this.processElementChildren(element);
        }
    }

    public static /* bridge */ /* synthetic */ void generateSourceAwareElement$default(BaseCreatingGenerator baseCreatingGenerator, BasicSourceAware basicSourceAware, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateSourceAwareElement");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        baseCreatingGenerator.generateSourceAwareElement(basicSourceAware, bl);
    }

    protected void generateSourceAwareUsingSources(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.generateUnspecificSourceAwareElement(element);
    }

    protected void generateUnspecificSourceAwareElement(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        CompositeText st = element.getSourceText();
        if (st != null) {
            JBIterable jBIterable = JBIterable.from(st.getFragments()).split(JBIterable.Split.OFF, (Condition)generateUnspecificSourceAwareElement.statements.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(st.fragm\u2026eText.Kind.SQL_DELIMITER}");
            JBIterable statements2 = jBIterable;
            for (JBIterable statementFragments : statements2) {
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, statementFragments){
                    final /* synthetic */ BaseCreatingGenerator this$0;
                    final /* synthetic */ JBIterable $statementFragments;

                    public final void invoke() {
                        for (CompositeText.Fragment fragment : this.$statementFragments) {
                            this.this$0.getBuilder().append(fragment);
                        }
                    }
                    {
                        this.this$0 = baseCreatingGenerator;
                        this.$statementFragments = jBIterable;
                        super(0);
                    }
                }, 3, null);
            }
        }
    }

    protected void processElementChildren(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        JBIterable<? extends BasicElement> children = element.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            BasicElement child;
            BasicElement basicElement = child = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
            if (!this.canGenerateInnerElement(basicElement) || this.getContext().getGenerated().contains(child) || this.getDeck().contains(child)) continue;
            this.processElement(child);
        }
    }

    protected boolean canGenerateInnerElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return element instanceof BasicSchemaObject || element instanceof BasicSourceAware;
    }

    protected void generateComment(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicTableOrView) {
            this.generateTableComment((BasicTableOrView)element);
        } else if (basicElement instanceof BasicTableOrViewColumn) {
            this.generateColumnComment((BasicLikeColumn)element);
        }
    }

    protected void generateTableComment(@NotNull BasicTableOrView table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String string = table.getComment();
        if (string == null || (string = this.getSqlString(string)) == null) {
            return;
        }
        String comment = string;
        ObjectKind kind = table.getKind();
        String w = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : kind.code();
        String name = table instanceof BasicSchemaObject ? this.currentScopeName(table) : this.currentScopeName(table);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, name, comment){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $w;
            final /* synthetic */ String $name;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on " + this.$w + ' ' + this.$name + " is " + this.$comment, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$w = string;
                this.$name = string2;
                this.$comment = string3;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void generateColumnComment(@NotNull BasicLikeColumn column) {
        void $receiver$iv;
        BasicSchemaObject parent;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        DasObject dasObject = column.getDbParent();
        if (!(dasObject instanceof BasicSchemaObject)) {
            dasObject = null;
        }
        if ((object = (parent = (BasicSchemaObject)dasObject)) == null || (object = this.currentScopeName((BasicElement)object)) == null) {
            return;
        }
        Object parentName = object;
        String string = column.getName();
        BaseCreatingGenerator this_$iv = this;
        String columnName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        String string2 = column.getComment();
        if (string2 == null || (string2 = this.getSqlString(string2)) == null) {
            return;
        }
        String comment = string2;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (String)parentName, columnName, comment){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $parentName;
            final /* synthetic */ String $columnName;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on column " + this.$parentName + '.' + this.$columnName + " is " + this.$comment, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$parentName = string;
                this.$columnName = string2;
                this.$comment = string3;
                super(0);
            }
        }, 3, null);
    }

    protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof BasicMinorObject && this.getLocus().compareTo((Enum)ScriptLocus.IN_TABLE) < 0) {
            BasicMajorObject majorObject = ((BasicMinorObject)element).getMajorObject();
            return majorObject == null || this.getContext().getGenerated().contains(majorObject);
        }
        return true;
    }

    protected void generateSynonym(@NotNull BasicSynonym synonym) {
        String text2;
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        String targetSpec = this.makeSynonymTargetSpec(synonym);
        String name = this.currentScopeName(synonym);
        if (targetSpec != null) {
            String[] stringArray = new String[5];
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SYNONYM");
            stringArray[0] = this.createOrReplace(objectKind);
            stringArray[1] = "synonym";
            stringArray[2] = name;
            stringArray[3] = "for";
            stringArray[4] = targetSpec;
            String string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            text2 = string;
        } else {
            text2 = "-- unknown what the synonym " + name + " references on :(";
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text2){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $text;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$text = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String makeSynonymTargetSpec(@NotNull BasicSynonym synonym) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        BasicMajorObject targetObject = synonym.getTargetObject();
        if (targetObject != null) {
            return this.currentScopeName(targetObject);
        }
        String schemaName = synonym.getTargetSchemaName();
        String string2 = synonym.getTargetObjectName();
        if (string2 == null) {
            return null;
        }
        String objectName = string2;
        if (schemaName == null) {
            void $receiver$iv;
            String string3 = objectName;
            BaseCreatingGenerator this_$iv = this;
            string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        } else {
            String $receiver$iv = schemaName;
            BaseCreatingGenerator this_$iv = this;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            $receiver$iv = objectName;
            this_$iv = this;
            stringBuilder = stringBuilder.append(string4).append(".");
            string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            string = stringBuilder.append(string4).toString();
        }
        return string;
    }

    protected final void weDontKnowHowToGenerateThis(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        CodeTextBuilder codeTextBuilder = this.getBuilder();
        StringBuilder stringBuilder = new StringBuilder().append("-- we don't know how to generate ").append(element.getKind().code()).append(' ');
        String string = element.getRealName();
        if (string == null) {
            string = "<with-no-name>";
        }
        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(" (class ").append(element.getClass().getSimpleName()).append(") :( --").toString(), null, false, 6, null);
    }

    @NotNull
    public final String createOrReplace(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false && this.getHelper().getSupportsCreateOrReplace().contains(kind) ? "create or replace" : "create";
    }

    @Nullable
    public final String ifNotExists(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) != false && this.getHelper().getSupportsCreateIfNotExists().contains(kind) ? "if not exists" : null;
    }

    public BaseCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
        this.isExact = Intrinsics.areEqual((Object)((Object)this.getTask()), (Object)((Object)ScriptingTask.CREATE_DEFINITION));
        this.tableElementsApplicableInExactTask = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK});
    }
}

