/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.mssql;

import com.intellij.database.dialects.MssqlDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MssqlRenameKIFKOperations {

    private static abstract class RecreateOrRenameOperationBase<T extends DeObject>
    extends DasDdlOperations.DropCreateOperation<T> {
        public RecreateOrRenameOperationBase(@NotNull DdlOperation alter, @Nullable Class<T> clazz, @Nullable ObjectKind kind) {
            if (alter == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(0);
            }
            super(alter, clazz, kind, DdlOperation.DROP, DdlOperation.CREATE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isRenameOnly(@NotNull DeObject from, @NotNull DeObject to) {
            if (from == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(1);
            }
            if (to == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(2);
            }
            if (!Comparing.equal((String)to.name, (String)from.name)) {
                String name = to.name;
                try {
                    to.name = from.name;
                    boolean bl = !to.isAltered(from);
                    return bl;
                }
                finally {
                    to.name = name;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull T object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(3);
            }
            if (object == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(4);
            }
            if (context == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(5);
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            builder.keyword("EXEC").space().identifier("sp_rename").space();
            DdlBuilder refBuilder = builder.copied();
            if (object.getKind() == ObjectKind.INDEX) {
                refBuilder.formatQualification((DasObject)object, ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.INDEX);
            } else {
                refBuilder.formatQualification((DasObject)object, ObjectKind.SCHEMA, object.getKind());
            }
            builder.literal(DbSqlUtil.getSqlDialect(MssqlDialect.INSTANCE).asStringLiteral(refBuilder.getStatement()));
            builder.symbol(",").space().identifier((DasObject)object, to.name).symbol(",").space();
            if (object.getKind() == ObjectKind.INDEX) {
                builder.literal("'INDEX'");
            } else {
                builder.literal("'OBJECT'");
            }
            DdlBuilder ddlBuilder = builder.newStatement();
            if (ddlBuilder == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(6);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T from, @Nullable UserDataHolder data) {
            if (generator == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(7);
            }
            if (builder == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(8);
            }
            if (from == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(9);
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (RecreateOrRenameOperationBase.isRenameOnly(from, to)) {
                DdlGenerator ddlGenerator = this.addSelfToBuilder(generator, builder, from, data);
                if (ddlGenerator == null) {
                    RecreateOrRenameOperationBase.$$$reportNull$$$0(10);
                }
                return ddlGenerator;
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, from, data);
            if (ddlGenerator == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(11);
            }
            return ddlGenerator;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull T object, @Nullable UserDataHolder data) {
            if (object == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(12);
            }
            JBIterable jBIterable = JBIterable.of((Object[])new DdlOperationKey[]{new DdlOperationKey((DeObject)object, DdlOperation.RENAME), new DdlOperationKey((DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data)), DdlOperation.POST_RENAME)});
            if (jBIterable == null) {
                RecreateOrRenameOperationBase.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 10: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 10: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alter";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplemented";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isRenameOnly";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 6: 
                case 10: 
                case 11: 
                case 13: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getImplemented";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 10: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RecreateOrRenameForeignKeyOperation
    extends RecreateOrRenameOperationBase<DeForeignKey> {
        public RecreateOrRenameForeignKeyOperation() {
            super(DasDdlOperations.ALTER_FOREIGN_KEY, DeForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                RecreateOrRenameForeignKeyOperation.$$$reportNull$$$0(0);
            }
            if (obj == null) {
                RecreateOrRenameForeignKeyOperation.$$$reportNull$$$0(1);
            }
            return obj instanceof DeForeignKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "support";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "obj";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameForeignKeyOperation";
            objectArray[2] = "isSupported";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RecreateOrRenameTableKeyOperation
    extends RecreateOrRenameOperationBase<DeTableKey> {
        public RecreateOrRenameTableKeyOperation() {
            super(DasDdlOperations.ALTER_TABLE_KEY, DeTableKey.class, ObjectKind.KEY);
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                RecreateOrRenameTableKeyOperation.$$$reportNull$$$0(0);
            }
            if (obj == null) {
                RecreateOrRenameTableKeyOperation.$$$reportNull$$$0(1);
            }
            return obj instanceof DeTableKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "support";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "obj";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameTableKeyOperation";
            objectArray[2] = "isSupported";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RecreateOrRenameIndexOperation
    extends RecreateOrRenameOperationBase<DeIndex> {
        public RecreateOrRenameIndexOperation() {
            super(DasDdlOperations.ALTER_INDEX, DeIndex.class, ObjectKind.INDEX);
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                RecreateOrRenameIndexOperation.$$$reportNull$$$0(0);
            }
            if (obj == null) {
                RecreateOrRenameIndexOperation.$$$reportNull$$$0(1);
            }
            return obj instanceof DeIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "support";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "obj";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameIndexOperation";
            objectArray[2] = "isSupported";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

