/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.ImplicitDepProvider;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitRenameOrder
extends ImplicitDepProvider {
    @Override
    public void addImplicitDeps(@NotNull DdlGraphBuilder builder, @NotNull MultiMap<DdlOperationKey, DdlOperationKey> deps) {
        if (builder == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(0);
        }
        if (deps == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(1);
        }
        ArrayList operations = ContainerUtil.newArrayList((Iterable)builder.getOperations().filter(key2 -> ImplicitRenameOrder.isRename(key2)));
        MultiMap sense = MultiMap.create((TObjectHashingStrategy)ContainerUtil.canonicalStrategy());
        MultiMap insense = MultiMap.create((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (DdlOperationKey key3 : operations) {
            DeObject from = DasDdlOperations.getAlterFrom(key3, builder);
            Casing casing = builder.getDialect().getCasing(from.getKind(), from);
            (DasUtil.isCaseSensitive((Casing)casing) ? sense : insense).putValue((Object)from.getName(), (Object)key3);
        }
        for (DdlOperationKey key3 : operations) {
            UserDataHolder data = builder.getData(key3);
            DeObject to = DasDdlOperations.getAlterTo(key3.target, data);
            boolean temp1 = DasDdlOperations.TemporaryRenameOperation.TEMPORARY.get(data) == Boolean.TRUE;
            Casing casing = builder.getDialect().getCasing(to.getKind(), to);
            for (DdlOperationKey mayConflict : (DasUtil.isCaseSensitive((Casing)casing) ? sense : insense).get((Object)to.getName())) {
                if (mayConflict.equals(key3) || !ImplicitRenameOrder.conflicts(to, temp1, mayConflict, builder)) continue;
                deps.putValue((Object)key3, (Object)mayConflict);
            }
        }
    }

    public static boolean conflicts(@NotNull DdlOperationKey key1, @NotNull DdlOperationKey key2, @NotNull DdlGraphBuilder builder) {
        UserDataHolder data;
        if (key1 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(2);
        }
        if (key2 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(4);
        }
        boolean temp1 = DasDdlOperations.TemporaryRenameOperation.TEMPORARY.get(data = builder.getData(key1)) == Boolean.TRUE;
        DeObject obj1 = DasDdlOperations.getAlterTo(key1.target, data);
        return ImplicitRenameOrder.conflicts(obj1, temp1, key2, builder);
    }

    private static boolean conflicts(@NotNull DeObject obj1, boolean temp1, @NotNull DdlOperationKey key2, @NotNull DdlGraphBuilder builder) {
        UserDataHolder data;
        if (obj1 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(5);
        }
        if (key2 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(7);
        }
        boolean temp2 = DasDdlOperations.TemporaryRenameOperation.TEMPORARY.get(data = builder.getData(key2)) == Boolean.TRUE;
        DeObject obj2 = DasDdlOperations.getAlterFrom(key2.target, data);
        return ImplicitRenameOrder.conflicts(obj1, temp1, obj2, temp2, builder);
    }

    private static boolean conflicts(@NotNull DeObject obj1, boolean temp1, @NotNull DeObject obj2, boolean temp2, @NotNull DdlGraphBuilder builder) {
        if (obj1 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(8);
        }
        if (obj2 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(10);
        }
        if (obj1 == obj2) {
            return !temp1 || !temp2;
        }
        if (obj1.getKind() != obj2.getKind()) {
            return false;
        }
        if (!DasUtil.nameEqual((DasObject)obj1, (String)obj2.getName(), (CasingProvider)builder.getDialect())) {
            return false;
        }
        return ImplicitRenameOrder.isSameOrRenamed(obj1.getParent(), obj2.getParent(), builder);
    }

    private static boolean isSameOrRenamed(@Nullable DeObject o1, @Nullable DeObject o2, @NotNull DdlGraphBuilder builder) {
        if (builder == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(11);
        }
        if (o1 == o2 || o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1.getKind() != o2.getKind()) {
            return false;
        }
        return ImplicitRenameOrder.getObjectEquivalence(o1, builder).contains(o2) || DasUtil.nameEqual((DasObject)o1, (String)o2.getName(), (CasingProvider)builder.getDialect()) && ImplicitRenameOrder.isSameOrRenamed(o1.getParent(), o2.getParent(), builder);
    }

    @NotNull
    private static Set<DeObject> getObjectEquivalence(@Nullable DeObject o, @NotNull DdlGraphBuilder builder) {
        if (builder == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(12);
        }
        if (o == null) {
            Set<DeObject> set = Collections.emptySet();
            if (set == null) {
                ImplicitRenameOrder.$$$reportNull$$$0(13);
            }
            return set;
        }
        LinkedList toProcess = ContainerUtil.newLinkedList();
        HashSet visited = ContainerUtil.newHashSet();
        visited.add(o);
        toProcess.addAll(builder.getNodes(new DdlOperationKey(o, DdlOperation.RENAME)));
        toProcess.addAll(builder.getNodes(new DdlOperationKey(o, DdlOperation.POST_RENAME)));
        while (!toProcess.isEmpty()) {
            DdlOperationKey key2 = (DdlOperationKey)toProcess.remove(0);
            DeObject from = DasDdlOperations.getAlterFrom(key2, builder);
            DeObject to = DasDdlOperations.getAlterFrom(key2, builder);
            if (!visited.contains(from)) {
                visited.add(from);
                toProcess.addAll(builder.getNodes(new DdlOperationKey(from, DdlOperation.POST_RENAME)));
            }
            if (visited.contains(to)) continue;
            visited.add(to);
            toProcess.addAll(builder.getNodes(new DdlOperationKey(to, DdlOperation.RENAME)));
        }
        HashSet hashSet = visited;
        if (hashSet == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    public static boolean isRename(@NotNull DdlOperationKey key2) {
        if (key2 == null) {
            ImplicitRenameOrder.$$$reportNull$$$0(15);
        }
        return ArrayUtil.contains((Object)DdlOperation.RENAME, (Object[])key2.operation.getInterfaces());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key1";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key2";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj2";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectEquivalence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitDeps";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "conflicts";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrRenamed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getObjectEquivalence";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

