/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.Graph;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlGraph
implements Graph<DdlOperationKey> {
    private final Collection<DdlOperationKey> myNodes;
    private final Map<DdlOperationKey, UserDataHolder> myData;
    private final BidirectionalMultiMap<DdlOperationKey, DdlOperationKey> myEdges;
    private ThreeState myHasCycles;
    public static final Key<DeObject> ALTER_FROM = Key.create((String)"ALTER_FROM");
    public static final Key<DeObject> ALTER_TO = Key.create((String)"ALTER_TO");

    @NotNull
    public static JBIterable<DdlOperationKey> notNullize(@Nullable DdlOperationKey op) {
        JBIterable jBIterable = op == null ? JBIterable.empty() : JBIterable.of((Object)op);
        if (jBIterable == null) {
            DdlGraph.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static <T> boolean visitDfs(@NotNull Graph<T> graph, @NotNull T start, @NotNull DfsVisitor<T> visitor) {
        if (graph == null) {
            DdlGraph.$$$reportNull$$$0(1);
        }
        if (start == null) {
            DdlGraph.$$$reportNull$$$0(2);
        }
        if (visitor == null) {
            DdlGraph.$$$reportNull$$$0(3);
        }
        TObjectIntHashMap colors = new TObjectIntHashMap();
        Stack stack = ContainerUtil.newStack();
        stack.add(start);
        while (!stack.isEmpty()) {
            Object cur = stack.peek();
            if (colors.containsKey(cur)) {
                boolean black;
                boolean bl = black = colors.get(cur) == 1;
                if (!black) {
                    colors.put(cur, 1);
                }
                stack.pop();
                if (black || visitor.visit(cur, DfsVisitor.Reason.LEAVE)) continue;
                return false;
            }
            colors.put(cur, 0);
            if (!visitor.visit(cur, DfsVisitor.Reason.ENTER)) {
                return false;
            }
            Iterator it = graph.getOut(cur);
            while (it.hasNext()) {
                Object next = it.next();
                if (colors.containsKey(next)) {
                    if (colors.get(next) != 0 || visitor.visit(next, DfsVisitor.Reason.CYCLE)) continue;
                    return false;
                }
                stack.push(next);
            }
        }
        return true;
    }

    @NotNull
    public static <T> T selectDfsRoot(@NotNull Graph<T> graph) {
        if (graph == null) {
            DdlGraph.$$$reportNull$$$0(4);
        }
        for (Object n : graph.getNodes()) {
            if (graph.getIn(n).hasNext()) continue;
            Object e = n;
            if (e == null) {
                DdlGraph.$$$reportNull$$$0(5);
            }
            return (T)e;
        }
        Object object = ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)graph.getNodes()));
        if (object == null) {
            DdlGraph.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    public static <T> boolean hasCycles(@NotNull Graph<T> graph) {
        if (graph == null) {
            DdlGraph.$$$reportNull$$$0(7);
        }
        return !DdlGraph.visitDfs(graph, DdlGraph.selectDfsRoot(graph), new DfsVisitor<T>(){

            @Override
            public boolean visit(@NotNull T node, @NotNull DfsVisitor.Reason reason) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reason == null) {
                    1.$$$reportNull$$$0(1);
                }
                return reason != DfsVisitor.Reason.CYCLE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reason";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/generation/DdlGraph$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    DdlGraph(@NotNull Collection<DdlOperationKey> nodes2, Map<DdlOperationKey, UserDataHolder> data, @NotNull BidirectionalMultiMap<DdlOperationKey, DdlOperationKey> edges, @NotNull ThreeState hasCycles) {
        if (nodes2 == null) {
            DdlGraph.$$$reportNull$$$0(8);
        }
        if (edges == null) {
            DdlGraph.$$$reportNull$$$0(9);
        }
        if (hasCycles == null) {
            DdlGraph.$$$reportNull$$$0(10);
        }
        this.myNodes = nodes2;
        this.myData = data;
        this.myEdges = edges;
        this.myHasCycles = hasCycles;
    }

    @NotNull
    public ThreeState hasCycles() {
        ThreeState threeState = this.myHasCycles;
        if (threeState == null) {
            DdlGraph.$$$reportNull$$$0(11);
        }
        return threeState;
    }

    public void setHasCycles(@NotNull ThreeState hasCycles) {
        if (hasCycles == null) {
            DdlGraph.$$$reportNull$$$0(12);
        }
        this.myHasCycles = hasCycles;
    }

    @NotNull
    public JBIterable<DdlOperationKey> getSources() {
        JBIterable jBIterable = JBIterable.from(this.getNodes()).filter(key2 -> !this.getIn((DdlOperationKey)key2).hasNext());
        if (jBIterable == null) {
            DdlGraph.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @Nullable
    public <T> T getData(@NotNull DdlOperationKey op, @NotNull Key<T> key2) {
        if (op == null) {
            DdlGraph.$$$reportNull$$$0(14);
        }
        if (key2 == null) {
            DdlGraph.$$$reportNull$$$0(15);
        }
        return (T)key2.get(this.myData.get(op));
    }

    @Nullable
    public UserDataHolder getData(@NotNull DdlOperationKey op) {
        if (op == null) {
            DdlGraph.$$$reportNull$$$0(16);
        }
        return this.myData.get(op);
    }

    public Collection<DdlOperationKey> getNodes() {
        return this.myNodes;
    }

    public Iterator<DdlOperationKey> getOut(DdlOperationKey n) {
        return this.myEdges.getValues((Object)n).iterator();
    }

    public Iterator<DdlOperationKey> getIn(DdlOperationKey n) {
        return this.myEdges.getKeys((Object)n).iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/generation/DdlGraph";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasCycles";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/generation/DdlGraph";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "selectDfsRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "hasCycles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitDfs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectDfsRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasCycles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHasCycles";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DfsVisitor<T> {
        public boolean visit(@NotNull T var1, @NotNull Reason var2);

        public static enum Reason {
            ENTER,
            LEAVE,
            CYCLE;

        }
    }
}

