/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationGenerator;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlGenerator
implements DdlOperation.DdlOperationSupport {
    private final DdlOperations myGenerators;
    private final SchemaExporters myExporters;
    private final DatabaseEditorContext myContext;

    public DdlGenerator(@NotNull DdlOperations generators, @NotNull SchemaExporters exporters, @NotNull DatabaseEditorContext context) {
        if (generators == null) {
            DdlGenerator.$$$reportNull$$$0(0);
        }
        if (exporters == null) {
            DdlGenerator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DdlGenerator.$$$reportNull$$$0(2);
        }
        this.myGenerators = generators;
        this.myExporters = exporters;
        this.myContext = context;
    }

    @Override
    public boolean isSupported(@NotNull DdlOperation op, @NotNull DeObject das) {
        if (op == null) {
            DdlGenerator.$$$reportNull$$$0(3);
        }
        if (das == null) {
            DdlGenerator.$$$reportNull$$$0(4);
        }
        return this.myGenerators.isSupported(op, das);
    }

    @Override
    public boolean isSupportedLight(@NotNull DdlOperation op, @NotNull ObjectKind kind) {
        if (op == null) {
            DdlGenerator.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            DdlGenerator.$$$reportNull$$$0(6);
        }
        return this.myGenerators.isSupportedLight(op, kind);
    }

    @NotNull
    public DdlGraphBuilder addOperation(@NotNull DdlGraphBuilder builder, @NotNull DdlOperation op, @Nullable DeObject das, @Nullable UserDataHolder data) {
        if (builder == null) {
            DdlGenerator.$$$reportNull$$$0(7);
        }
        if (op == null) {
            DdlGenerator.$$$reportNull$$$0(8);
        }
        if (das == null) {
            DdlGraphBuilder ddlGraphBuilder = builder;
            if (ddlGraphBuilder == null) {
                DdlGenerator.$$$reportNull$$$0(9);
            }
            return ddlGraphBuilder;
        }
        DdlOperationGenerator generator = this.myGenerators.get(op);
        assert (generator != null);
        generator.addToBuilder(this, builder, das, data);
        DdlGraphBuilder ddlGraphBuilder = builder;
        if (ddlGraphBuilder == null) {
            DdlGenerator.$$$reportNull$$$0(10);
        }
        return ddlGraphBuilder;
    }

    public DdlGraphBuilder removeOperation(@NotNull DdlGraphBuilder builder, @NotNull DdlOperation op, @NotNull DeObject das, @Nullable UserDataHolder data) {
        if (builder == null) {
            DdlGenerator.$$$reportNull$$$0(11);
        }
        if (op == null) {
            DdlGenerator.$$$reportNull$$$0(12);
        }
        if (das == null) {
            DdlGenerator.$$$reportNull$$$0(13);
        }
        DdlOperationGenerator generator = this.myGenerators.get(op);
        assert (generator != null);
        generator.removeFromBuilder(this, builder, das, data);
        return builder;
    }

    @NotNull
    public DdlOperations.SchemaState buildState(@NotNull DasModel editedModel) {
        if (editedModel == null) {
            DdlGenerator.$$$reportNull$$$0(14);
        }
        MySchemaState mySchemaState = new MySchemaState(this.myExporters, this.myContext, editedModel);
        if (mySchemaState == null) {
            DdlGenerator.$$$reportNull$$$0(15);
        }
        return mySchemaState;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DdlGraphBuilder graphBuilder, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            DdlGenerator.$$$reportNull$$$0(16);
        }
        if (graphBuilder == null) {
            DdlGenerator.$$$reportNull$$$0(17);
        }
        if (context == null) {
            DdlGenerator.$$$reportNull$$$0(18);
        }
        DdlBuilder ddlBuilder = this.generate(builder, graphBuilder.buildComponents(), context);
        if (ddlBuilder == null) {
            DdlGenerator.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull Iterable<DdlGraph> graphs, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            DdlGenerator.$$$reportNull$$$0(20);
        }
        if (graphs == null) {
            DdlGenerator.$$$reportNull$$$0(21);
        }
        if (context == null) {
            DdlGenerator.$$$reportNull$$$0(22);
        }
        HashSet visited = ContainerUtil.newHashSet();
        for (DdlGraph graph : graphs) {
            this.generate(builder, graph, context, visited);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DdlGenerator.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder generate(final @NotNull DdlBuilder builder, final @NotNull DdlGraph graph, final @NotNull DdlBuildingContext context, final @NotNull Set<DdlOperationKey> visited) {
        if (builder == null) {
            DdlGenerator.$$$reportNull$$$0(24);
        }
        if (graph == null) {
            DdlGenerator.$$$reportNull$$$0(25);
        }
        if (context == null) {
            DdlGenerator.$$$reportNull$$$0(26);
        }
        if (visited == null) {
            DdlGenerator.$$$reportNull$$$0(27);
        }
        if (graph.hasCycles() == ThreeState.UNSURE) {
            graph.setHasCycles(ThreeState.fromBoolean((boolean)DdlGraph.hasCycles(graph)));
        }
        if (graph.hasCycles() == ThreeState.YES) {
            throw new UnsupportedOperationException("Could not resolve circular dependencies");
        }
        DdlOperationKey root2 = DdlGenerator.getRoot(graph);
        DdlGraph.visitDfs(graph, root2, new DdlGraph.DfsVisitor<DdlOperationKey>(){

            @Override
            public boolean visit(@NotNull DdlOperationKey key2, @NotNull DdlGraph.DfsVisitor.Reason reason) {
                if (key2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reason == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (reason != DdlGraph.DfsVisitor.Reason.LEAVE || visited.contains(key2)) {
                    return true;
                }
                visited.add(key2);
                DdlOperationGenerator generator = DdlGenerator.this.myGenerators.get(key2.operation);
                if (generator == null) {
                    throw new UnsupportedOperationException("No generator found: " + key2.operation);
                }
                generator.generate(builder, key2.target, graph.getData(key2), context);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reason";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/generation/DdlGenerator$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DdlGenerator.$$$reportNull$$$0(28);
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlOperationKey getRoot(@NotNull DdlGraph graph) {
        if (graph == null) {
            DdlGenerator.$$$reportNull$$$0(29);
        }
        DdlOperationKey ddlOperationKey = (DdlOperationKey)ObjectUtils.assertNotNull((Object)DdlGenerator.foldl(graph.getSources().iterator(), new PairFunction<DdlOperationKey, DdlOperationKey, DdlOperationKey>(){
            DepthComparator comparator = new DepthComparator();

            public DdlOperationKey fun(DdlOperationKey t, DdlOperationKey v) {
                return this.comparator.compare(t, v) < 0 ? t : v;
            }
        }));
        if (ddlOperationKey == null) {
            DdlGenerator.$$$reportNull$$$0(30);
        }
        return ddlOperationKey;
    }

    private static <T, U> U foldl(U first, @NotNull Iterator<T> it, @NotNull PairFunction<U, T, U> func) {
        if (it == null) {
            DdlGenerator.$$$reportNull$$$0(31);
        }
        if (func == null) {
            DdlGenerator.$$$reportNull$$$0(32);
        }
        while (it.hasNext()) {
            first = func.fun(first, it.next());
        }
        return first;
    }

    @Nullable
    private static <T> T foldl(@NotNull Iterator<T> it, @NotNull PairFunction<T, T, T> func) {
        if (it == null) {
            DdlGenerator.$$$reportNull$$$0(33);
        }
        if (func == null) {
            DdlGenerator.$$$reportNull$$$0(34);
        }
        if (!it.hasNext()) {
            return null;
        }
        return DdlGenerator.foldl(it.next(), it, func);
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            DdlGenerator.$$$reportNull$$$0(35);
        }
        return databaseEditorContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generators";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporters";
                break;
            }
            case 2: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "das";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/generation/DdlGenerator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedModel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphBuilder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphs";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/generation/DdlGenerator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addOperation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildState";
                break;
            }
            case 19: 
            case 23: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedLight";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addOperation";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 35: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeOperation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildState";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "foldl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySchemaState
    implements DdlOperations.SchemaState {
        private MySchemaExportHelper myExporter;
        private Map<DeObject, DeObject> myAltering;
        private Set<DeObject> myRemoved;

        public MySchemaState(@NotNull SchemaExporters exporters, @NotNull DatabaseEditorContext context, @NotNull DasModel model) {
            if (exporters == null) {
                MySchemaState.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MySchemaState.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MySchemaState.$$$reportNull$$$0(2);
            }
            this.myAltering = ContainerUtil.newHashMap();
            this.myRemoved = ContainerUtil.newHashSet();
            this.myExporter = new MySchemaExportHelper(exporters, context, model);
        }

        @Nullable
        private DeObject toAcceptable(@Nullable DeObject object) {
            if (object == null || this.myRemoved.contains(object)) {
                return null;
            }
            if (this.myAltering.containsKey(object)) {
                DeObject alt = this.myAltering.get(object);
                return alt == null ? object : this.toAcceptable(alt);
            }
            if (object.model == this.myExporter.getModel().getModel()) {
                return object;
            }
            return this.toAcceptable((DeObject)ObjectUtils.tryCast((Object)object.editedObject, DeObject.class));
        }

        @NotNull
        private DeObject ensureAcceptable(@NotNull DeObject object) {
            if (object == null) {
                MySchemaState.$$$reportNull$$$0(3);
            }
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)this.toAcceptable(object));
            if (deObject == null) {
                MySchemaState.$$$reportNull$$$0(4);
            }
            return deObject;
        }

        @Override
        @NotNull
        public <De extends DeObject> De get(@NotNull De object, boolean withChildren) {
            if (object == null) {
                MySchemaState.$$$reportNull$$$0(5);
            }
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull(this.myExporter.export(object, withChildren));
            if (deObject == null) {
                MySchemaState.$$$reportNull$$$0(6);
            }
            return (De)deObject;
        }

        @Override
        public void remove(@NotNull DeObject object) {
            if (object == null) {
                MySchemaState.$$$reportNull$$$0(7);
            }
            for (DeObject deObject : object.getChildren()) {
                this.remove(deObject);
            }
            this.myRemoved.add(this.ensureAcceptable(object));
        }

        @Override
        @NotNull
        public <De extends DeObject> De add(@NotNull De object) {
            if (object == null) {
                MySchemaState.$$$reportNull$$$0(8);
            }
            Object De = this.myExporter.add(object, false);
            if (De == null) {
                MySchemaState.$$$reportNull$$$0(9);
            }
            return De;
        }

        @Override
        public <De extends DeObject> void alter(@NotNull De from, @NotNull De to) {
            if (from == null) {
                MySchemaState.$$$reportNull$$$0(10);
            }
            if (to == null) {
                MySchemaState.$$$reportNull$$$0(11);
            }
            this.myAltering.put(to, from);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ensureAcceptable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "ensureAcceptable";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "alter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        class MySchemaExportHelper
        extends SchemaExportHelper {
            public MySchemaExportHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, DasModel model) {
                if (MySchemaState.this == null) {
                    MySchemaExportHelper.$$$reportNull$$$0(0);
                }
                if (exporter == null) {
                    MySchemaExportHelper.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    MySchemaExportHelper.$$$reportNull$$$0(2);
                }
                if (model == null) {
                    MySchemaExportHelper.$$$reportNull$$$0(3);
                }
                super(exporter, context, model);
            }

            @Override
            public <De extends DeObject> De export(@Nullable DasObject object, boolean withChildren) {
                return super.export(MySchemaState.this.toAcceptable((DeObject)object), withChildren);
            }

            public <De extends DeObject> De add(@Nullable DeObject object, boolean withChildren) {
                MySchemaState.this.myAltering.put(object, null);
                return super.export(object, withChildren);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "this$0";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "exporter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState$MySchemaExportHelper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class DepthComparator
    implements Comparator<DdlOperationKey> {
        private final TObjectIntHashMap<DeObject> myDepthCache = new TObjectIntHashMap();

        private DepthComparator() {
        }

        private int getDepth(@Nullable DeObject object) {
            if (object == null) {
                return 0;
            }
            if (this.myDepthCache.contains((Object)object)) {
                return this.myDepthCache.get((Object)object);
            }
            int depth = this.getDepth(object.getParent()) + 1;
            this.myDepthCache.put((Object)object, depth);
            return depth;
        }

        @Override
        public int compare(DdlOperationKey o1, DdlOperationKey o2) {
            return Comparing.compare((int)this.getDepth(o1.target), (int)this.getDepth(o2.target));
        }
    }
}

