/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.fix;

import com.intellij.database.schemaEditor.fix.FixCyclicCreateTableFk;
import com.intellij.database.schemaEditor.fix.FixCyclicRename;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DdlGraphFixing {
    private static final CycleFixer[] CYCLE_FIXERS = new CycleFixer[]{new FixCyclicCreateTableFk(), new FixCyclicRename()};

    public static void fix(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder) {
        if (generator == null) {
            DdlGraphFixing.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DdlGraphFixing.$$$reportNull$$$0(1);
        }
        DdlGraphFixing.fix(generator, builder, CYCLE_FIXERS);
    }

    public static void fix(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull CycleFixer[] cycleFixers) {
        if (generator == null) {
            DdlGraphFixing.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DdlGraphFixing.$$$reportNull$$$0(3);
        }
        if (cycleFixers == null) {
            DdlGraphFixing.$$$reportNull$$$0(4);
        }
        int i2 = 0;
        while (DdlGraphFixing.fixGraphs(generator, builder, cycleFixers)) {
            if (i2 > 50) {
                throw new UnsupportedOperationException("Unable to fix graph");
            }
            ++i2;
        }
    }

    private static boolean fixGraphs(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull CycleFixer[] cycleFixers) {
        if (generator == null) {
            DdlGraphFixing.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            DdlGraphFixing.$$$reportNull$$$0(6);
        }
        if (cycleFixers == null) {
            DdlGraphFixing.$$$reportNull$$$0(7);
        }
        boolean changed = false;
        for (DdlGraph graph : ContainerUtil.newArrayList(builder.buildComponents())) {
            changed |= DdlGraphFixing.fixGraph(generator, builder, graph, cycleFixers);
        }
        return changed;
    }

    private static boolean fixGraph(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DdlGraph graph, @NotNull CycleFixer[] cycleFixers) {
        if (generator == null) {
            DdlGraphFixing.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            DdlGraphFixing.$$$reportNull$$$0(9);
        }
        if (graph == null) {
            DdlGraphFixing.$$$reportNull$$$0(10);
        }
        if (cycleFixers == null) {
            DdlGraphFixing.$$$reportNull$$$0(11);
        }
        final Stack cycle = ContainerUtil.newStack();
        if (graph.hasCycles() == ThreeState.NO) {
            return false;
        }
        boolean noCycle = DdlGraph.visitDfs(graph, DdlGraph.selectDfsRoot(graph), new DdlGraph.DfsVisitor<DdlOperationKey>(){

            @Override
            public boolean visit(@NotNull DdlOperationKey node, @NotNull DdlGraph.DfsVisitor.Reason reason) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reason == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (reason == DdlGraph.DfsVisitor.Reason.CYCLE) {
                    int i2;
                    for (i2 = 0; i2 < cycle.size() && cycle.get(i2) != node; ++i2) {
                    }
                    assert (i2 < cycle.size());
                    cycle.subList(0, i2).clear();
                    return false;
                }
                if (reason == DdlGraph.DfsVisitor.Reason.ENTER) {
                    cycle.push((Object)node);
                } else if (reason == DdlGraph.DfsVisitor.Reason.LEAVE) {
                    cycle.pop();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reason";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/fix/DdlGraphFixing$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        graph.setHasCycles(ThreeState.fromBoolean((!noCycle ? 1 : 0) != 0));
        if (noCycle) {
            return false;
        }
        for (CycleFixer fixer : cycleFixers) {
            if (!fixer.fixCycle(generator, builder, graph, (List<DdlOperationKey>)cycle)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycleFixers";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/fix/DdlGraphFixing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fixGraphs";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fixGraph";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface CycleFixer {
        public boolean fixCycle(@NotNull DdlGenerator var1, @NotNull DdlGraphBuilder var2, @NotNull DdlGraph var3, @NotNull List<DdlOperationKey> var4);
    }
}

