/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.editors.BitStringEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBlobEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBooleanEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultDateEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultNumericEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultRangeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.PostgresHstoreEditorFactory;
import com.intellij.database.run.ui.grid.editors.TimeZonedTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.TimeZonedTimestampEditorFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorFactories
implements GridCellEditorFactoryProvider {
    private static final GridCellEditorFactories INSTANCE = new GridCellEditorFactories();
    private final List<? extends GridCellEditorFactory> myDefaultFactories = ContainerUtil.list((Object[])new GridCellEditorFactory[]{new DefaultNumericEditorFactory(), new DefaultDateEditorFactory(), new DefaultTimestampEditorFactory(), new DefaultTimeEditorFactory(), new DefaultTextEditorFactory(), new DefaultBlobEditorFactory(), new DefaultBooleanEditorFactory(), new PostgresHstoreEditorFactory(), new TimeZonedTimestampEditorFactory(), new TimeZonedTimeEditorFactory(), new DefaultRangeEditorFactory(), new BitStringEditorFactory()});

    public static GridCellEditorFactories getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public GridCellEditorFactory getEditorFactory(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            GridCellEditorFactories.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorFactories.$$$reportNull$$$0(1);
        }
        if (column == null) {
            GridCellEditorFactories.$$$reportNull$$$0(2);
        }
        int maxSuitability = 0;
        GridCellEditorFactory bestMatchingFactory = null;
        for (GridCellEditorFactory gridCellEditorFactory : this.myDefaultFactories) {
            int suitability = gridCellEditorFactory.getSuitability(grid, row, column);
            if (suitability <= maxSuitability) continue;
            maxSuitability = suitability;
            bestMatchingFactory = gridCellEditorFactory;
        }
        return bestMatchingFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "row";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorFactories";
        objectArray[2] = "getEditorFactory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

