/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatBasedGridCellEditorFactory
implements GridCellEditorFactory {
    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(2);
        }
        Project project = DataGridUtil.getProject(grid);
        Formatter baseFormatter = this.getFormat(grid, row, column);
        Formatter formatter = this.makeFormatterLenient(grid) ? new LenientFormatter(baseFormatter) : baseFormatter;
        TextCompletionProvider provider = GridCellEditorsUtil.createCompletionProvider(grid, column);
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column);
        FormatBasedGridCellEditor formatBasedGridCellEditor = this.createEditorImpl(project, grid, formatter, object, nullValue, initiator, provider, column);
        if (formatBasedGridCellEditor == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(3);
        }
        return formatBasedGridCellEditor;
    }

    @NotNull
    protected abstract Formatter getFormat(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    protected boolean makeFormatterLenient(@NotNull DataGrid grid) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(4);
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        return dialect.getFamilyId().isSqlite();
    }

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(6);
        }
        if (format == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(7);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(8);
        }
        FormatBasedGridCellEditor formatBasedGridCellEditor = new FormatBasedGridCellEditor(project, grid, format, value, nullValue, initiator, provider);
        if (formatBasedGridCellEditor == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(9);
        }
        return formatBasedGridCellEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatterLenient";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LenientFormatter
    extends Formatter.Wrapper {
        LenientFormatter(@NotNull Formatter formatter) {
            if (formatter == null) {
                LenientFormatter.$$$reportNull$$$0(0);
            }
            super(formatter);
        }

        @Override
        public Object parse(String value) {
            try {
                return super.parse(value);
            }
            catch (ParseException parseException) {
                return value;
            }
        }

        @Override
        public Object parse(String value, ParsePosition position) {
            Object parsed = super.parse(value, position);
            if (parsed == null || position.getErrorIndex() != -1) {
                position.setErrorIndex(-1);
                return value;
            }
            return parsed;
        }

        @Override
        public String format(Object value) {
            try {
                return super.format(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return value == null ? null : value.toString();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$LenientFormatter", "<init>"));
        }
    }
}

